/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseInfo;
import com.kingdee.eas.fm.edraf.ECDSCommunicationStatusEnum;
import com.kingdee.eas.fm.edraf.FCOperateStateEnum;
import com.kingdee.eas.fm.edraf.OverClewtApplyReqBillInfo;
import com.kingdee.eas.fm.edrafent.AbstractDraftStockBillInfo;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DrafentApplyBillBaseInfo;
import com.kingdee.eas.fm.edrafent.DraftApplyTypeEnum;
import com.kingdee.eas.fm.edrafent.DraftOverdueClewPaymentBillCollection;
import com.kingdee.eas.fm.edrafent.DraftOverdueClewPaymentBillFactory;
import com.kingdee.eas.fm.edrafent.DraftOverdueClewPaymentBillInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillFactory;
import com.kingdee.eas.fm.edrafent.DraftStockBillInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillOperateEnum;
import com.kingdee.eas.fm.edrafent.OperateStateEnum;
import com.kingdee.eas.fm.edrafent.app.AbstractDraftOverdueClewPaymentBillControllerBean;
import com.kingdee.eas.fm.edrafent.util.EdrafentUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class DraftOverdueClewPaymentBillControllerBean
extends AbstractDraftOverdueClewPaymentBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edrafent.app.DraftOverdueClewPaymentBillControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    protected void afterAddNew(Context ctx, IObjectPK returnPK, IObjectValue model) throws BOSException, EASBizException {
        DraftOverdueClewPaymentBillInfo billInfo = (DraftOverdueClewPaymentBillInfo)model;
        String stockId = billInfo.getSourceBillId();
        AbstractDraftStockBillInfo stockInfo = null;
        if (stockId != null) {
            stockInfo = DraftStockBillFactory.getLocalInstance(ctx).getDraftStockBillInfo((IObjectPK)new ObjectUuidPK(stockId));
            EdrafentUtil.saveBotpRelation(ctx, stockId, returnPK.toString());
        }
        if (stockInfo != null) {
            stockInfo.setPresent(true);
            stockInfo.setDraftStockOperate(DraftStockBillOperateEnum.PAYMENT);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("present"));
            sic.add(new SelectorItemInfo("draftStockOperate"));
            DraftStockBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)stockInfo, sic);
        }
    }

    @Override
    protected void _submitToECDS(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)OperateStateEnum.AUDIT, CompareType.EQUALS));
        env.setFilter(filter);
        DraftOverdueClewPaymentBillCollection billCol = DraftOverdueClewPaymentBillFactory.getLocalInstance(ctx).getDraftOverdueClewPaymentBillCollection(env);
        DraftOverdueClewPaymentBillInfo billInfo = new DraftOverdueClewPaymentBillInfo();
        billInfo.setSubmitDate(DateHelper.getTime());
        if (billCol.size() > 0) {
            HashSet<BOSUuid> set = new HashSet<BOSUuid>();
            int n = billCol.size();
            for (int i = 0; i < n; ++i) {
                set.add(billCol.get(i).getId());
            }
            if (set.size() > 0) {
                String sql = "update T_EDT_DraftOverdue set FOperateState=?,FSubmitDate=?,FSubmitterID=?,FSubmitCompanyID=? where " + FMHelper.buildIn((String)"FID", (Object[])set.toArray());
                CompanyOrgUnitInfo companyName = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
                UserInfo userName = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(3), billInfo.getSubmitDate(), userName.getId().toString(), companyName.getId().toString()});
            }
        }
    }

    @Override
    protected void _audit(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)OperateStateEnum.SUBMIT, CompareType.EQUALS));
        env.getSelector().add(new SelectorItemInfo("id"));
        env.setFilter(filter);
        DraftOverdueClewPaymentBillCollection billCol = DraftOverdueClewPaymentBillFactory.getLocalInstance(ctx).getDraftOverdueClewPaymentBillCollection(env);
        if (billCol.size() > 0) {
            int n = billCol.size();
            for (int i = 0; i < n; ++i) {
                DraftOverdueClewPaymentBillInfo billInfo = billCol.get(i);
                this.audit4WF(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()), billInfo);
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u5df2\u63d0\u4ea4\u7684\u63d0\u793a\u4ed8\u6b3e\u5355\u624d\u53ef\u4ee5\u5ba1\u6279\uff01"});
        }
    }

    @Override
    protected void _unAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        Object[] idArray;
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)OperateStateEnum.AUDIT, CompareType.EQUALS));
        env.getSelector().add(new SelectorItemInfo("id"));
        env.setFilter(filter);
        DraftOverdueClewPaymentBillCollection billCol = DraftOverdueClewPaymentBillFactory.getLocalInstance(ctx).getDraftOverdueClewPaymentBillCollection(env);
        if (billCol.size() > 0) {
            idArray = new String[billCol.size()];
            int n = billCol.size();
            for (int i = 0; i < n; ++i) {
                idArray[i] = billCol.get(i).getId().toString();
                this.unAudit4WF(ctx, billCol.get(i));
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u5df2\u5ba1\u6279\u7684\u903e\u671f\u63d0\u793a\u4ed8\u6b3e\u5355\u624d\u53ef\u4ee5\u53cd\u5ba1\u6279\uff01"});
        }
        String sql = "update T_EDT_DraftOverdue set FOperateState=?,FAuditDate=? where " + FMHelper.buildIn((String)"FID", (Object[])idArray);
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(0), null});
    }

    @Override
    protected void _draftSubmit(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)new Integer(0), CompareType.EQUALS));
        env.setFilter(filter);
        DraftOverdueClewPaymentBillCollection col = DraftOverdueClewPaymentBillFactory.getLocalInstance(ctx).getDraftOverdueClewPaymentBillCollection(env);
        if (col.size() > 0) {
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                this.submit(ctx, (CoreBaseInfo)col.get(i));
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u4fdd\u5b58\u72b6\u6001\u7684\u63d0\u793a\u4ed8\u6b3e\u5355\u624d\u5141\u8bb8\u63d0\u4ea4\uff01"});
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("operateState"));
        sic.add(new SelectorItemInfo("draftStockBill.*"));
        DraftOverdueClewPaymentBillInfo info = DraftOverdueClewPaymentBillFactory.getLocalInstance(ctx).getDraftOverdueClewPaymentBillInfo(pk);
        if (info.getOperateState().equals((Object)OperateStateEnum.SAVE) || info.getOperateState().equals((Object)OperateStateEnum.SUBMIT)) {
            DraftStockBillInfo stockInfo = info.getDraftStockBill();
            if (stockInfo != null) {
                stockInfo.setPresent(false);
                stockInfo.setDraftStockOperate(DraftStockBillOperateEnum.REGISTER);
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("present"));
                sic.add(new SelectorItemInfo("draftStockOperate"));
                DraftStockBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)stockInfo, sic);
            }
            super._delete(ctx, pk);
        }
    }

    protected void initInfo(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected void _unLoginAccount(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filters = filter.getFilterItems();
        filters.add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        view.setSelector(selectors);
        view.setFilter(filter);
        DraftOverdueClewPaymentBillCollection coll = DraftOverdueClewPaymentBillFactory.getLocalInstance(ctx).getDraftOverdueClewPaymentBillCollection(view);
        StringBuffer sb = new StringBuffer();
        for (int a = 0; a < coll.size(); ++a) {
            DraftOverdueClewPaymentBillInfo info = coll.get(a);
            if (info.isTally()) continue;
            sb.append("\u5355\u636e:").append(info.getNumber()).append("\u4e3a\u672a\u767b\u5e10\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u53cd\u767b\u5e10!\n");
        }
        if (sb.length() != 0) {
            NumericExceptionSubItem item = new NumericExceptionSubItem("{0}", "{0}");
            EASBizException exec = new EASBizException(item, (Object[])new String[]{sb.toString()});
            throw exec;
        }
        int size = coll.size();
        StringBuffer oql = new StringBuffer();
        oql.append("where billId in (");
        if (size > 0) {
            oql.append("'").append(coll.get(0).getId().toString()).append("'");
        }
        for (int i = 1; i < coll.size(); ++i) {
            oql.append(",'").append(coll.get(i).getId().toString()).append("'");
        }
        oql.append(")");
        JournalFactory.getLocalInstance((Context)ctx).delete(oql.toString());
        this.updateTallyStatus(ctx, coll, 0);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DraftOverdueClewPaymentBillInfo info = (DraftOverdueClewPaymentBillInfo)model;
        OperateStateEnum state = info.getOperateState();
        if (state == null) {
            info.setOperateState(OperateStateEnum.SAVE);
        }
        return super._save(ctx, (IObjectValue)info);
    }

    @Override
    protected void _loginAccount(Context ctx, Set billList) throws BOSException, EASBizException {
        DraftOverdueClewPaymentBillInfo info;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filters = filter.getFilterItems();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)billList, CompareType.INCLUDE));
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("commercialDraft.id");
        selectors.add("commercialDraft.number");
        selectors.add("commercialDraft.draftECDSStatus");
        selectors.add("acceptorAccount.id");
        selectors.add("acceptorAccount.number");
        selectors.add("acceptorAccount.name");
        selectors.add("acceptorAccount.isBank");
        selectors.add("acceptorAccount.isCash");
        selectors.add("acceptorAccount.account.id");
        selectors.add("acceptorAccount.account.number");
        selectors.add("acceptorAccount.account.name");
        selectors.add("acceptorAccount.currency.id");
        selectors.add("acceptorAccount.currency.number");
        selectors.add("acceptorAccount.currency.name");
        view.setSelector(selectors);
        view.setFilter(filter);
        DraftOverdueClewPaymentBillCollection coll = DraftOverdueClewPaymentBillFactory.getLocalInstance(ctx).getDraftOverdueClewPaymentBillCollection(view);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (info.isTally()) {
                sb.append("\u5355\u636e:").append(info.getNumber()).append("\u4e3a\u5df2\u767b\u5e10\u72b6\u6001!\n");
                continue;
            }
            if (info.getDraftStockBill().getCommercialDraft() != null && !ECDSBillStatusEnum.PJYJQ.equals((Object)info.getDraftStockBill().getCommercialDraft().getDraftECDSStatus())) continue;
            if (info.getDraftStockBill().getCommercialDraft() == null) {
                sb.append("\u5355\u636e:").append(info.getNumber()).append("\u7968\u636e\u5151\u4ed8\u4fe1\u606f\u4e3a\u7a7a!\n");
                continue;
            }
            sb.append("\u5355\u636e:").append(info.getNumber()).append("\u7968\u636e\u5151\u4ed8\u4fe1\u606f\u7684\u7535\u7968\u72b6\u6001\u4e0d\u4e3a\u7968\u636e\u5df2\u7ed3\u6e05!\n");
        }
        if (sb.length() != 0) {
            NumericExceptionSubItem item = new NumericExceptionSubItem("{0}", "{0}");
            EASBizException exec = new EASBizException(item, (Object[])new String[]{sb.toString()});
            throw exec;
        }
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            Date date;
            Date now;
            info = (DraftOverdueClewPaymentBillInfo)it.next();
            JournalInfo journalInfo = new JournalInfo();
            PeriodInfo peroid = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)info.getCompany());
            Date bizDate = now = new Date();
            if (peroid != null && (date = peroid.getBeginDate()).compareTo(now) > 0) {
                bizDate = date;
            }
            journalInfo.setCompany(info.getCompany());
            journalInfo.setBizDate(bizDate);
            journalInfo.setBillNumber(info.getNumber());
            journalInfo.setBillId(info.getId().toString());
            journalInfo.setCreditAmount(info.getPayAccount());
            journalInfo.setCreateDate(bizDate);
            journalInfo.setType(JournalTypeEnum.BANK);
            journalInfo.setAccountBank(info.getAcceptorAccount());
            journalInfo.setAccountView(info.getAcceptorAccount().getAccount());
            journalInfo.setCurrency(info.getAcceptorAccount().getCurrency());
            journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
            journalInfo.setSource(JournalSourceEnum.BYBILL);
            journalInfo.setPeriod(peroid);
            journalInfo.setDescription(info.getHolderRamark());
            JournalFactory.getLocalInstance((Context)ctx).addnew(journalInfo);
        }
        this.updateTallyStatus(ctx, coll, 1);
    }

    private void updateTallyStatus(Context ctx, DraftOverdueClewPaymentBillCollection coll, int status) throws BOSException {
        int size = coll.size();
        if (size <= 0) {
            return;
        }
        StringBuffer updateTally = new StringBuffer();
        updateTally.append("update T_EDT_DraftOverdue set FTally=").append(status).append(" where FID in(");
        if (size > 0) {
            updateTally.append("'").append(coll.get(0).getId().toString()).append("'");
        }
        for (int i = 1; i < size; ++i) {
            updateTally.append(" ,'").append(coll.get(i).getId().toString()).append("'");
        }
        updateTally.append(")");
        DbUtil.execute((Context)ctx, (String)updateTally.toString());
    }

    @Override
    protected void checkCanBeCancelled(Context ctx, IObjectValue model, DraftApplyTypeEnum cancelType) throws EASBizException, BOSException {
        DraftOverdueClewPaymentBillInfo info = (DraftOverdueClewPaymentBillInfo)model;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("draftStockBill.commercialDraft.*"));
        sic.add(new SelectorItemInfo("operateState"));
        DraftOverdueClewPaymentBillInfo billInfo = DraftOverdueClewPaymentBillFactory.getLocalInstance(ctx).getDraftOverdueClewPaymentBillInfo((IObjectPK)new ObjectUuidPK(info.getId()), sic);
        if (!billInfo.getDraftStockBill().getCommercialDraft().getDraftECDSStatus().equals((Object)ECDSBillStatusEnum.YQTSFKDQS) || !info.getOperateState().equals((Object)OperateStateEnum.SUBMITGATEWAY) || info.isIsCancelDraft()) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u64cd\u4f5c\u72b6\u6001\u4e3a\u5df2\u63d0\u4ea4\u7f51\u5173\u4e14\u7535\u7968\u72b6\u6001\u4e3a\u903e\u671f\u63d0\u793a\u4ed8\u6b3e\u5f85\u7b7e\u6536\u7684\u903e\u671f\u63d0\u793a\u4ed8\u6b3e\u53ef\u64a4\u9500\uff01"});
        }
    }

    @Override
    protected String getApplyBillClassName(DraftApplyTypeEnum cancelType) {
        return OverClewtApplyReqBillInfo.class.getName();
    }

    @Override
    protected String getBankBillClassName(DraftApplyTypeEnum cancelType) {
        return null;
    }

    @Override
    public DraftApplyBillBaseInfo getApplyBillBaseInfo(DrafentApplyBillBaseInfo baseInfo, DraftApplyTypeEnum applyType) {
        OverClewtApplyReqBillInfo hintInfo = null;
        if (baseInfo instanceof DraftOverdueClewPaymentBillInfo) {
            DraftOverdueClewPaymentBillInfo paymentBillInfo = (DraftOverdueClewPaymentBillInfo)baseInfo;
            hintInfo = new OverClewtApplyReqBillInfo();
            CommercialDraftInfo commInfo = paymentBillInfo.getDraftStockBill().getCommercialDraft();
            hintInfo.setCommercialDraft(commInfo);
            hintInfo.setStartECDSState(commInfo.getDraftECDSStatus());
            hintInfo.setEndECDSState(commInfo.getDraftECDSStatus());
            hintInfo.setSourceBillId(paymentBillInfo.getId().toString());
            hintInfo.setHolderName(paymentBillInfo.getHolderName());
            hintInfo.setHolderAccount(paymentBillInfo.getHolderAccount());
            hintInfo.setHolderBankNumber(paymentBillInfo.getHolderBankNumber());
            hintInfo.setOrgCode(commInfo.getHolderOrgCode());
            hintInfo.setPayAccount(paymentBillInfo.getPayAccount());
            hintInfo.setIsFinace(paymentBillInfo.isIsFinace());
            hintInfo.setIsSeft(paymentBillInfo.isIsSeft());
            hintInfo.setIsSeft(paymentBillInfo.isIsSeft());
            hintInfo.setPayBizDate(paymentBillInfo.getPayBizDate());
            hintInfo.setApplyDate(paymentBillInfo.getPayBizDate());
            hintInfo.setIsCancelDraft(false);
            hintInfo.setOverDueReson(paymentBillInfo.getOverdueReason());
            hintInfo.setHolderRamark(paymentBillInfo.getOverdueClewMark());
            hintInfo.setOperateState(FCOperateStateEnum.save);
            hintInfo.setCommunicationStatus(ECDSCommunicationStatusEnum.SUBMIT_READY);
        }
        return hintInfo;
    }

    @Override
    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("draftStockBill.commercialDraft.*");
        return sic;
    }
}

