/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseInfo;
import com.kingdee.eas.fm.edraf.ECDSCommunicationStatusEnum;
import com.kingdee.eas.fm.edraf.FCOperateStateEnum;
import com.kingdee.eas.fm.edraf.RecourseApplyBillInfo;
import com.kingdee.eas.fm.edrafent.DrafentApplyBillBaseCollection;
import com.kingdee.eas.fm.edrafent.DrafentApplyBillBaseInfo;
import com.kingdee.eas.fm.edrafent.DraftApplyTypeEnum;
import com.kingdee.eas.fm.edrafent.DraftRecourseBillCollection;
import com.kingdee.eas.fm.edrafent.DraftRecourseBillInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillFactory;
import com.kingdee.eas.fm.edrafent.DraftStockBillInfo;
import com.kingdee.eas.fm.edrafent.OperateStateEnum;
import com.kingdee.eas.fm.edrafent.app.AbstractDraftRecourseBillControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class DraftRecourseBillControllerBean
extends AbstractDraftRecourseBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edrafent.app.DraftRecourseBillControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._addnew(ctx, model);
        return pk;
    }

    protected void afterAddNew(Context ctx, IObjectPK returnPK, IObjectValue model) throws BOSException, EASBizException {
        super.afterAddNew(ctx, returnPK, model);
    }

    @Override
    protected void _audit(Context ctx, Set set) throws BOSException, EASBizException {
        DraftRecourseBillInfo info;
        EntityViewInfo envi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        envi.setFilter(filter);
        DraftRecourseBillCollection coll = this.getDraftRecourseBillCollection(ctx, envi);
        if (coll.size() == 1 && (info = coll.get(0)).getOperateState().getValue() != 1) {
            throw new EASBizException(new NumericExceptionSubItem("811341", "\u63d0\u4ea4\u72b6\u6001\u7684\u8ffd\u7d22\u5355\u53ef\u5ba1\u6279\uff01"));
        }
        for (int i = 0; i < coll.size(); ++i) {
            DraftRecourseBillInfo info2 = coll.get(i);
            if (info2.getOperateState().getValue() != 1) continue;
            this.audit4WF(ctx, (IObjectPK)new ObjectUuidPK(info2.getId()), info2);
        }
    }

    @Override
    protected void _bankCorporate(Context ctx, Set set) throws BOSException, EASBizException {
    }

    @Override
    protected void _financeCompany(Context ctx, Set set) throws BOSException, EASBizException {
        super._batchSubmitFC(ctx, set, DraftApplyTypeEnum.ZHUISUO);
    }

    @Override
    protected void _submit(Context ctx, Set set) throws BOSException, EASBizException {
        DraftRecourseBillInfo info;
        EntityViewInfo envi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        envi.setFilter(filter);
        DraftRecourseBillCollection coll = this.getDraftRecourseBillCollection(ctx, envi);
        if (coll.size() == 1 && (info = coll.get(0)).getOperateState().getValue() != 0) {
            throw new EASBizException(new NumericExceptionSubItem("8118541", "\u5355\u636e\u5df2\u63d0\u4ea4\uff0c\u4e0d\u53ef\u91cd\u590d\u63d0\u4ea4\uff01"));
        }
        for (int i = 0; i < coll.size(); ++i) {
            DraftRecourseBillInfo info2 = coll.get(i);
            if (info2.getOperateState().getValue() != 0) continue;
            SelectorItemCollection selColl = new SelectorItemCollection();
            selColl.add(new SelectorItemInfo("operateState"));
            info2.setOperateState(OperateStateEnum.SUBMIT);
            this.updatePartial(ctx, (CoreBaseInfo)info2, selColl);
            super.submit(ctx, (CoreBaseInfo)info2);
        }
    }

    @Override
    protected void _unAudit(Context ctx, Set set) throws BOSException, EASBizException {
        DraftRecourseBillInfo info;
        EntityViewInfo envi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        envi.setFilter(filter);
        DraftRecourseBillCollection coll = this.getDraftRecourseBillCollection(ctx, envi);
        if (coll.size() == 1 && (info = coll.get(0)).getOperateState().getValue() != 2) {
            throw new EASBizException(new NumericExceptionSubItem("811341", "\u5ba1\u6279\u72b6\u6001\u7684\u8ffd\u7d22\u5355\u53ef\u53cd\u5ba1\u6279\uff01"));
        }
        for (int i = 0; i < coll.size(); ++i) {
            DraftRecourseBillInfo info2 = coll.get(i);
            if (info2.getOperateState().getValue() != 2) continue;
            SelectorItemCollection selColl = new SelectorItemCollection();
            selColl.add(new SelectorItemInfo("operateState"));
            selColl.add(new SelectorItemInfo("auditDate"));
            selColl.add(new SelectorItemInfo("auditor"));
            info2.setOperateState(OperateStateEnum.SAVE);
            info2.setAuditDate(null);
            info2.setAuditor(null);
            this.updatePartial(ctx, (CoreBaseInfo)info2, selColl);
            this.unAudit4WF(ctx, info2);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String draftStockBillID = this.getDraftRecourseBillInfo(ctx, pk).getSourceBillId();
        super._delete(ctx, pk);
        EntityViewInfo envi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)draftStockBillID));
        envi.setFilter(filter);
        DraftRecourseBillCollection coll = this.getDraftRecourseBillCollection(ctx, envi);
        if (coll != null && coll.size() == 0) {
            DraftStockBillInfo stockInfo = DraftStockBillFactory.getLocalInstance(ctx).getDraftStockBillInfo((IObjectPK)new ObjectUuidPK(draftStockBillID));
            SelectorItemCollection selColl = new SelectorItemCollection();
            selColl.add(new SelectorItemInfo("recourse"));
            stockInfo.setRecourse(false);
            DraftStockBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)stockInfo, selColl);
        }
    }

    @Override
    protected void _registerAccount(Context ctx, Set set) throws BOSException, EASBizException {
        EntityViewInfo envi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        envi.setFilter(filter);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("commercialDraft.*");
        selectors.add("company.*");
        selectors.add("recourserName.*");
        selectors.add("recourseAccount.*");
        selectors.add("recourseBankNum.*");
        envi.setSelector(selectors);
        envi.setFilter(filter);
        DraftRecourseBillCollection billList = this.getDraftRecourseBillCollection(ctx, envi);
        if (billList.size() > 0) {
            HashSet<BOSUuid> sets = new HashSet<BOSUuid>();
            DraftRecourseBillInfo info = null;
            int n = billList.size();
            for (int i = 0; i < n; ++i) {
                info = billList.get(i);
                if (info.getCommercialDraft().getDraftECDSStatus() == ECDSBillStatusEnum.PJYJQ && !info.isRegisterAccount()) {
                    Date date;
                    Date now;
                    sets.add(info.getId());
                    JournalInfo journalInfo = new JournalInfo();
                    PeriodInfo peroid = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)info.getCompany());
                    Date bizDate = now = new Date();
                    if (peroid != null && (date = peroid.getBeginDate()).compareTo(now) > 0) {
                        bizDate = date;
                    }
                    journalInfo.setCompany(info.getCompany());
                    journalInfo.setBizDate(bizDate);
                    journalInfo.setBillNumber(info.getNumber());
                    journalInfo.setBillId(info.getId().toString());
                    journalInfo.setCreditAmount(info.getRecourseAmt());
                    journalInfo.setCreateDate(bizDate);
                    journalInfo.setType(JournalTypeEnum.BANK);
                    journalInfo.setAccountBank(info.getRecourseAccount());
                    journalInfo.setAccountView(info.getRecourseAccount().getAccount());
                    journalInfo.setCurrency(info.getRecourseAccount().getCurrency());
                    journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
                    journalInfo.setSource(JournalSourceEnum.BYBILL);
                    journalInfo.setPeriod(peroid);
                    journalInfo.setDescription(info.getRemark());
                    JournalFactory.getLocalInstance((Context)ctx).addnew(journalInfo);
                    sets.add(info.getId());
                }
                if (sets == null || sets.size() <= 0) {
                    throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u672a\u767b\u8d26\u5e76\u4e14\u5df2\u7ed3\u6e05\u7684\u8ffd\u7d22\u5355\u624d\u5141\u8bb8\u767b\u8d26\uff01"});
                }
                String sql = "update T_EDT_DraftRecourseBill set FregisterAccount=? where " + FMHelper.buildIn((String)"FID", (Object[])sets.toArray());
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Boolean(true)});
            }
        }
    }

    @Override
    protected void _unRegisterAccount(Context ctx, Set set) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("registerAccount", (Object)Boolean.TRUE, CompareType.EQUALS));
        view.setFilter(filter);
        DraftRecourseBillCollection coll = this.getDraftRecourseBillCollection(ctx, view);
        if (coll.size() > 0) {
            HashSet<BOSUuid> sets = new HashSet<BOSUuid>();
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                DraftRecourseBillInfo info = coll.get(0);
                sets.add(info.getId());
                JournalFactory.getLocalInstance((Context)ctx).delete("where billId='" + info.getId().toString() + "'");
            }
            if (sets.size() > 0) {
                String sql = "update T_EDT_DraftRecourseBill set FregisterAccount=? where " + FMHelper.buildIn((String)"FID", (Object[])sets.toArray());
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Boolean(false)});
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u5df2\u767b\u8d26\u7684\u8ffd\u7d22\u5355\u624d\u5141\u8bb8\u53cd\u767b\u8d26\uff01"});
        }
    }

    @Override
    protected String getApplyBillClassName(DraftApplyTypeEnum cancelType) {
        return RecourseApplyBillInfo.class.getName();
    }

    @Override
    protected String getBankBillClassName(DraftApplyTypeEnum cancelType) {
        return null;
    }

    @Override
    protected void checkCanBeCancelled(Context ctx, IObjectValue model, DraftApplyTypeEnum cancelType) throws EASBizException, BOSException {
        SelectorItemCollection selColl = new SelectorItemCollection();
        selColl.add("*");
        selColl.add("commercialDraft.draftECDSStatus");
        DraftRecourseBillInfo info = this.getDraftRecourseBillInfo(ctx, (IObjectPK)new ObjectUuidPK(model.get("id").toString()), selColl);
        if (info.getCommercialDraft().getDraftECDSStatus() != ECDSBillStatusEnum.JFZSDQC && info.getCommercialDraft().getDraftECDSStatus() != ECDSBillStatusEnum.FJFZSDQC || info.getOperateState() != OperateStateEnum.SUBMITGATEWAY) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u5f85\u6e05\u507f\u7684\u8ffd\u7d22\u5355\u624d\u5141\u8bb8\u64a4\u9500\uff01"});
        }
    }

    @Override
    public DraftApplyBillBaseInfo getApplyBillBaseInfo(DrafentApplyBillBaseInfo baseInfo, DraftApplyTypeEnum applyType) {
        RecourseApplyBillInfo newBillInfo = new RecourseApplyBillInfo();
        DraftRecourseBillInfo info = (DraftRecourseBillInfo)baseInfo;
        newBillInfo.setRecourseDate(info.getRecourseDate());
        newBillInfo.setRecourseType(info.getRecourseType());
        newBillInfo.setRecourserName(info.getRecourserName());
        newBillInfo.setRecourseAccount(info.getRecourseAccount());
        newBillInfo.setRecourseBankNum(info.getRecourseBankNum());
        newBillInfo.setRecourseOrgCode(info.getRecourseOrgCode());
        newBillInfo.setByRecourseName(info.getByRecourseName());
        newBillInfo.setByRecourseAccou(info.getByRecourseAccou());
        newBillInfo.setByRecouBankNum(info.getByRecouBankNum());
        newBillInfo.setByRecourOrgCode(info.getByRecourOrgCode());
        newBillInfo.setRecourseReason(info.getRecourseReason());
        newBillInfo.setRecourseAmt(info.getRecourseAmt());
        newBillInfo.setRemark(info.getRemark());
        newBillInfo.setStartECDSState(info.getCommercialDraft().getDraftECDSStatus());
        newBillInfo.setEndECDSState(info.getCommercialDraft().getDraftECDSStatus());
        newBillInfo.setCommercialDraft(info.getCommercialDraft());
        newBillInfo.setOperateState(FCOperateStateEnum.save);
        newBillInfo.setCommunicationStatus(ECDSCommunicationStatusEnum.SUBMIT_READY);
        newBillInfo.setSourceBillId(info.getId().toString());
        newBillInfo.setIsCancelDraft(false);
        newBillInfo.setApplyDate(info.getRecourseDate());
        return newBillInfo;
    }

    @Override
    public DrafentApplyBillBaseCollection getBillBaseCollection(Context ctx, Set idSet, DraftApplyTypeEnum applyType) throws BOSException, EASBizException {
        EntityViewInfo envi = new EntityViewInfo();
        SelectorItemCollection selColls = new SelectorItemCollection();
        selColls.add(new SelectorItemInfo("*"));
        selColls.add(new SelectorItemInfo("commercialDraft.*"));
        envi.setSelector(selColls);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        envi.setFilter(filter);
        DrafentApplyBillBaseCollection coll = this.getDrafentApplyBillBaseCollection(ctx, envi);
        return coll;
    }
}

