/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IBank;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.edraf.IOrgUnitCode;
import com.kingdee.eas.fm.edraf.OrgUnitCodeCollection;
import com.kingdee.eas.fm.edraf.OrgUnitCodeFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import java.util.Calendar;
import java.util.Date;

public class EdrafentUtil {
    public static String setOrgCode(Context ctx, String compayId) throws BOSException {
        OrgUnitCodeCollection code = null;
        IOrgUnitCode iorgUnitCode = null;
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)compayId));
        filter.getFilterItems().add(new FilterItemInfo("isUsing", (Object)Boolean.TRUE));
        env.getSelector().add("*");
        env.setFilter(filter);
        iorgUnitCode = ctx == null ? OrgUnitCodeFactory.getRemoteInstance() : OrgUnitCodeFactory.getLocalInstance((Context)ctx);
        code = iorgUnitCode.getOrgUnitCodeCollection(env);
        if (code.size() > 0) {
            return code.get(0).getOrgCode();
        }
        return null;
    }

    public static BankInfo getBankByBeBank(Context ctx, String beBankId) throws BOSException {
        BankInfo bankInfo = null;
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)beBankId, CompareType.EQUALS));
        env.setFilter(filter);
        IBank ibank = null;
        ibank = ctx == null ? BankFactory.getRemoteInstance() : BankFactory.getLocalInstance((Context)ctx);
        BankCollection bankCol = ibank.getBankCollection(env);
        if (bankCol.size() > 0) {
            bankInfo = bankCol.get(0);
        }
        return bankInfo;
    }

    public static BEBankInfo getBEBankByBankId(String bankId) throws EASBizException, BOSException {
        BEBankInfo beBank = null;
        BankInfo bank = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(bankId));
        if (bank.getAccountBank() != null) {
            String beId = bank.getAccountBank().getId().toString();
            beBank = BEBankFactory.getRemoteInstance().getBEBankInfo((IObjectPK)new ObjectUuidPK(beId));
        }
        return beBank;
    }

    public static void saveBotpRelation(Context ctx, CoreBillBaseInfo srcBill, CoreBillBaseInfo destBill, String srcBillId, String destBillId) throws BOSException {
        IBOTRelation iBOTRelation = null;
        iBOTRelation = ctx == null ? BOTRelationFactory.getRemoteInstance() : BOTRelationFactory.getLocalInstance((Context)ctx);
        BOTRelationInfo relateInfo = new BOTRelationInfo();
        relateInfo.setSrcEntityID(srcBill.getBOSType().toString());
        relateInfo.setDestEntityID(destBill.getBOSType().toString());
        relateInfo.setSrcObjectID(srcBillId);
        relateInfo.setDestObjectID(destBillId);
        relateInfo.setDate(new Date());
        relateInfo.setOperatorID("unknown");
        relateInfo.setIsEffected(true);
        relateInfo.setType(0);
        iBOTRelation.addnew(relateInfo);
    }

    public static void saveBotpRelation(Context ctx, String srcBillId, String destBillId) throws BOSException {
        if (srcBillId == null || srcBillId.equals("") || destBillId == null || destBillId.equals("")) {
            return;
        }
        IBOTRelation iBOTRelation = null;
        iBOTRelation = ctx == null ? BOTRelationFactory.getRemoteInstance() : BOTRelationFactory.getLocalInstance((Context)ctx);
        BOTRelationInfo relateInfo = new BOTRelationInfo();
        relateInfo.setSrcEntityID(BOSUuid.read((String)srcBillId).getType().toString());
        relateInfo.setDestEntityID(BOSUuid.read((String)destBillId.toString()).getType().toString());
        relateInfo.setSrcObjectID(srcBillId);
        relateInfo.setDestObjectID(destBillId.toString());
        relateInfo.setDate(new Date());
        relateInfo.setOperatorID("unknown");
        relateInfo.setIsEffected(true);
        relateInfo.setType(0);
        iBOTRelation.addnew(relateInfo);
    }

    public static CurrencyInfo getRMBCurrency(Context ctx) throws BOSException, EASBizException {
        CurrencyInfo currInfo = null;
        ICurrency icurr = null;
        String id = "dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC";
        icurr = ctx == null ? CurrencyFactory.getRemoteInstance() : CurrencyFactory.getLocalInstance((Context)ctx);
        currInfo = icurr.getCurrencyInfo((IObjectPK)new ObjectUuidPK(id));
        return currInfo;
    }

    public static void initNumber(CoreBaseInfo info, KDTextField txtField, String companyId) {
        boolean rst = FMClientHelper.hasNumber((CoreBaseInfo)info, (String)companyId);
        if (rst) {
            txtField.setEditable(false);
            txtField.setEnabled(false);
            txtField.setRequired(false);
            if (FMHelper.isEmpty((String)info.getString("number")) && FMClientHelper.isModifiable((CoreBaseInfo)info, (String)companyId)) {
                txtField.setEditable(true);
                txtField.setEnabled(true);
                txtField.setRequired(true);
            }
        } else {
            txtField.setEnabled(true);
            txtField.setEditable(true);
            txtField.setRequired(true);
        }
    }

    public static String getDispNumber(CoreBaseInfo info, String companyId) {
        String number = null;
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            if (codingRuleManager.isAddView((IObjectValue)info, companyId) && !codingRuleManager.isUseIntermitNumber((IObjectValue)info, companyId)) {
                number = codingRuleManager.getNumber((IObjectValue)info, companyId);
            }
        }
        catch (BOSException bOSException) {
        }
        catch (CodingRuleException codingRuleException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return number;
    }

    public static Date truncateDate(Date time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time.getTime());
        cal.set(10, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }
}

