/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.erec;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.be.EReceiptIsMatchEnum;
import com.kingdee.eas.fm.be.TransDetailRecedEnum;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import java.util.Date;
import java.util.Set;

public class TransDetailMatchFilterParam
implements FilterParam {
    private static final long serialVersionUID = -6448257276554200415L;
    private Date beginDate;
    private Date endDate;
    private String currencyId;
    private String[] bankAcctId;
    private String bankInterface;
    private EReceiptIsMatchEnum isMatch;
    private Set mainOrgCollIDSet;
    private TransDetailRecedEnum isReced;
    private boolean isDataImport;
    private int transType;
    private static final int ALL_TYPE = 3;
    private static final int REC_TYPE = 2;
    private static final int PAY_TYPE = 1;

    public EReceiptIsMatchEnum getIsMatch() {
        return this.isMatch;
    }

    public void setIsMatch(EReceiptIsMatchEnum isMatch) {
        this.isMatch = isMatch;
    }

    public Set getMainOrgCollIDSet() {
        return this.mainOrgCollIDSet;
    }

    public void setMainOrgCollIDSet(Set mainOrgCollIDSet) {
        this.mainOrgCollIDSet = mainOrgCollIDSet;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public String[] getBankAcctId() {
        return this.bankAcctId;
    }

    public void setBankAcctId(String[] bankAcctId) {
        this.bankAcctId = bankAcctId;
    }

    public String getBankInterface() {
        return this.bankInterface;
    }

    public void setBankInterface(String bankInterface) {
        this.bankInterface = bankInterface;
    }

    public TransDetailRecedEnum getIsReced() {
        return this.isReced;
    }

    public void setIsReced(TransDetailRecedEnum isReced) {
        this.isReced = isReced;
    }

    public boolean isDataImport() {
        return this.isDataImport;
    }

    public void setDataImport(boolean isDataImport) {
        this.isDataImport = isDataImport;
    }

    public int getTransType() {
        return this.transType;
    }

    public void setTransType(int transType) {
        this.transType = transType;
    }

    public FilterInfo getFilter() {
        FilterInfo filter = new FilterInfo();
        if (this.beginDate != null) {
            filter.getFilterItems().add(new FilterItemInfo("bizTime", (Object)FMConstants.FORMAT_DAY.format(this.beginDate), CompareType.GREATER_EQUALS));
        }
        if (this.endDate != null) {
            filter.getFilterItems().add(new FilterItemInfo("bizTime", (Object)FMConstants.FORMAT_DAY.format(DateUtil.getNextDay((Date)this.endDate)), CompareType.LESS));
        }
        if (this.getMainOrgCollIDSet() == null || this.getMainOrgCollIDSet().size() == 0) {
            CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentCompany.getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.getMainOrgCollIDSet(), CompareType.INCLUDE));
        }
        if (this.currencyId != null) {
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.currencyId));
        }
        if (this.bankAcctId != null) {
            filter.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)FMHelper.asSet((String[])this.bankAcctId), CompareType.INCLUDE));
        }
        if (this.getIsMatch() != null) {
            filter.getFilterItems().add(new FilterItemInfo("isMatchEReceipt", (Object)new Integer(this.getIsMatch().getValue())));
        }
        if (this.getIsReced() != null) {
            filter.getFilterItems().add(new FilterItemInfo("isReced", (Object)new Integer(this.getIsReced().getValue())));
        }
        if (!this.isDataImport()) {
            filter.getFilterItems().add(new FilterItemInfo("isDataImport", (Object)new Integer(0)));
        }
        if (this.getTransType() == 2) {
            filter.getFilterItems().add(new FilterItemInfo("isDebit", (Object)new Integer(0)));
        } else if (this.getTransType() == 1) {
            filter.getFilterItems().add(new FilterItemInfo("isDebit", (Object)new Integer(1)));
        }
        return filter;
    }

    public SorterItemCollection getSorterItems() {
        return null;
    }
}

