/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.erec.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kds.model.util.DateHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.EReceiptCollection;
import com.kingdee.eas.fm.be.EReceiptFactory;
import com.kingdee.eas.fm.be.EReceiptInfo;
import com.kingdee.eas.fm.be.EReceiptIsMatchEnum;
import com.kingdee.eas.fm.be.TransDetailCollection;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.fm.be.app.EReceiptDBUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.erec.EDMatchResultCollection;
import com.kingdee.eas.fm.erec.EDMatchResultFactory;
import com.kingdee.eas.fm.erec.EDMatchResultInfo;
import com.kingdee.eas.fm.erec.app.AbstractERecDetailMatchFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ERecDetailMatchFacadeControllerBean
extends AbstractERecDetailMatchFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.erec.app.ERecDetailMatchFacadeControllerBean");
    private final String ERECEIPT = "com.kingdee.eas.fm.be.app.EReceipt";
    private final String TRANSDETAIL = "com.kingdee.eas.fm.be.app.TransDetail";
    private final String BYMANUAL = "byManual";
    private static final String resourcePath = "com.kingdee.eas.fm.erec.ERecResources";

    @Override
    protected Map _erecDetailMatch(Context ctx, IObjectValue erecModel, IObjectValue detailModel, EReceiptIsMatchEnum matchEnum) throws BOSException, EASBizException {
        EDMatchResultCollection edMatchResultColl = new EDMatchResultCollection();
        CoreBaseCollection edMColl = new CoreBaseCollection();
        String key = null;
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        EReceiptInfo ereceiptInfo = (EReceiptInfo)erecModel;
        TransDetailInfo detailInfo = (TransDetailInfo)detailModel;
        detailInfo.setIsMatchEReceipt(matchEnum);
        ereceiptInfo.setIsMatch(matchEnum);
        ereceiptInfo.setTransDetailId(detailInfo.getId().toString());
        if (ereceiptInfo.getCurrency() == null) {
            ereceiptInfo.setCurrency(detailInfo.getCurrency());
        }
        ereceiptInfo.setOppBank(detailInfo.getOppBank());
        ereceiptInfo.setOppBankNumber(detailInfo.getOppBankNumber());
        ereceiptInfo.setOppUnit(detailInfo.getOppUnit());
        ereceiptInfo.setExplanation(detailInfo.getDescription());
        ereceiptInfo.setCreditAmount(detailInfo.getCreditAmount());
        ereceiptInfo.setDebitAmount(detailInfo.getDebitAmount());
        if (detailInfo.getDebitAmount() != null && detailInfo.getDebitAmount().compareTo(Constants.ZERO) != 0) {
            ereceiptInfo.setAmount(detailInfo.getDebitAmount());
        } else if (detailInfo.getCreditAmount() != null && detailInfo.getCreditAmount().compareTo(Constants.ZERO) != 0) {
            ereceiptInfo.setAmount(detailInfo.getCreditAmount());
        }
        ereceiptInfo.setBank(detailInfo.getBankAccount().getBank());
        ereceiptInfo.setNumber(detailInfo.getNumber());
        long currentTimeMillis = System.currentTimeMillis();
        if (matchEnum.equals((Object)EReceiptIsMatchEnum.manual)) {
            key = ereceiptInfo.getTransDate() + "+" + ereceiptInfo.getBankNumber() + currentTimeMillis;
        } else if (matchEnum.equals((Object)EReceiptIsMatchEnum.AutoMatic)) {
            key = ereceiptInfo.getDetailNo() + currentTimeMillis;
        }
        if (ereceiptInfo.getDetailNo() == null && detailInfo.getReceiptNo() != null) {
            ereceiptInfo.setDetailNo("byManual-" + detailInfo.getReceiptNo() + "-detailNotNull");
        } else if (ereceiptInfo.getDetailNo() != null && detailInfo.getReceiptNo() == null) {
            detailInfo.setReceiptNo("byManual-" + detailInfo.getReceiptNo() + "-receiptNotNull");
        } else if (ereceiptInfo.getDetailNo() == null && detailInfo.getReceiptNo() == null) {
            ereceiptInfo.setDetailNo("byManual-" + currentTimeMillis + "-allNull");
            detailInfo.setReceiptNo("byManual-" + currentTimeMillis + "-allNull");
        }
        EDMatchResultCollection coll = this.unionEDMatchResultColl(ereceiptInfo, detailInfo, key);
        edMatchResultColl.addCollection(coll);
        if (edMatchResultColl != null) {
            int count = edMatchResultColl.size();
            for (int index = 0; index < count; ++index) {
                EDMatchResultInfo edmInfo = edMatchResultColl.get(index);
                edMColl.add((CoreBaseInfo)edmInfo);
            }
        }
        try {
            EDMatchResultFactory.getLocalInstance(ctx).addnewBatchData(edMColl);
            TransDetailFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(detailInfo.getId().toString()), (CoreBaseInfo)detailInfo);
            EReceiptFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(ereceiptInfo.getId().toString()), (CoreBaseInfo)ereceiptInfo);
            returnMap.put("matchResultColl", (Object)edMatchResultColl);
            returnMap.put("manualSuccessCount", Constants.ONE);
        }
        catch (Exception e) {
            returnMap.put("errorMsg", e.getMessage());
        }
        return returnMap;
    }

    @Override
    protected Map _erecDetailMatchBatch(Context ctx, List erecIdList, List detailIdList) throws BOSException, EASBizException {
        int index;
        EDMatchResultCollection edMatchResultColl = new EDMatchResultCollection();
        CoreBaseCollection allCoreBaseColl = new CoreBaseCollection();
        int matchCodeSucCount = 0;
        int manualSuccessCount = 0;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        EReceiptCollection erecColl = this.getEReceiptColl(ctx, FMHelper.list2Set((List)erecIdList));
        Iterator erecIt = erecColl.iterator();
        while (erecIt.hasNext()) {
            EReceiptInfo erecInfo = (EReceiptInfo)erecIt.next();
            if (EReceiptIsMatchEnum.UnMatch.equals((Object)erecInfo.getIsMatch())) continue;
            erecIt.remove();
        }
        TransDetailCollection detailColl = this.getDetailColl(ctx, FMHelper.list2Set((List)detailIdList));
        Iterator detailIt = detailColl.iterator();
        while (detailIt.hasNext()) {
            TransDetailInfo detailInfo = (TransDetailInfo)detailIt.next();
            if (EReceiptIsMatchEnum.UnMatch.equals((Object)detailInfo.getIsMatchEReceipt())) continue;
            detailIt.remove();
        }
        if (erecColl.size() == 0 || detailColl.size() == 0) {
            String msg = ResourceBase.getString((String)resourcePath, (String)"40_noMatch", (Locale)ctx.getLocale());
            resultMap.put("noMatch", msg);
            return resultMap;
        }
        logger.error((Object)"------------\u6784\u9020\u56de\u5355\u7801\u5339\u914dMap\u5f00\u59cb--------------");
        HashMap<String, EReceiptInfo> matchCodeMap = new HashMap<String, EReceiptInfo>();
        int erecCount = erecColl.size();
        for (int index2 = 0; index2 < erecCount; ++index2) {
            EReceiptInfo erecInfo = erecColl.get(index2);
            String matchCode = erecInfo.getDetailNo();
            if (matchCode == null || matchCodeMap.containsKey(matchCode)) continue;
            matchCodeMap.put(matchCode, erecInfo);
        }
        HashMap autoMatchMap = new HashMap();
        int detailCount = detailColl.size();
        for (int index3 = 0; index3 < detailCount; ++index3) {
            HashMap<EReceiptInfo, TransDetailInfo> codeEDMap = new HashMap<EReceiptInfo, TransDetailInfo>();
            TransDetailInfo detailInfo = detailColl.get(index3);
            String receiptNo = detailInfo.getReceiptNo();
            if (receiptNo == null || !matchCodeMap.containsKey(receiptNo)) continue;
            EReceiptInfo erecInfo = (EReceiptInfo)matchCodeMap.get(receiptNo);
            codeEDMap.put(erecInfo, detailInfo);
            autoMatchMap.put(receiptNo, codeEDMap);
        }
        logger.error((Object)("------------\u6784\u9020\u56de\u5355\u7801\u5339\u914dMap\u7ed3\u675f--------------" + autoMatchMap.size()));
        logger.error((Object)"------------\u7535\u5b50\u56de\u5355\u7801\u5339\u914d\u5f00\u59cb---------------");
        EReceiptCollection deteleEReceiptCol = new EReceiptCollection();
        if (autoMatchMap.size() > 0) {
            Iterator it = autoMatchMap.keySet().iterator();
            CoreBaseCollection erecCoreColl = new CoreBaseCollection();
            CoreBaseCollection detailCoreColl = new CoreBaseCollection();
            while (it.hasNext()) {
                String key = (String)it.next();
                Map innerMap = (Map)autoMatchMap.get(key);
                for (Map.Entry codeMap : innerMap.entrySet()) {
                    EReceiptInfo ereceiptInfo = (EReceiptInfo)codeMap.getKey();
                    TransDetailInfo detailInfo = (TransDetailInfo)codeMap.getValue();
                    ereceiptInfo.setTransDetailId(detailInfo.getId().toString());
                    ereceiptInfo.setIsMatch(EReceiptIsMatchEnum.AutoMatic);
                    detailInfo.setIsMatchEReceipt(EReceiptIsMatchEnum.AutoMatic);
                    if (ereceiptInfo.getCurrency() == null) {
                        ereceiptInfo.setCurrency(detailInfo.getCurrency());
                    }
                    ereceiptInfo.setOppBank(detailInfo.getOppBank());
                    ereceiptInfo.setOppBankNumber(detailInfo.getOppBankNumber());
                    ereceiptInfo.setOppUnit(detailInfo.getOppUnit());
                    ereceiptInfo.setExplanation(detailInfo.getDescription());
                    ereceiptInfo.setCreditAmount(detailInfo.getCreditAmount());
                    ereceiptInfo.setDebitAmount(detailInfo.getDebitAmount());
                    ereceiptInfo.setBank(detailInfo.getBankAccount().getBank());
                    ereceiptInfo.setNumber(detailInfo.getNumber());
                    ereceiptInfo.setAmount(detailInfo.getTransBalance());
                    EDMatchResultCollection coll = this.unionEDMatchResultColl(ereceiptInfo, detailInfo, key);
                    edMatchResultColl.addCollection(coll);
                    erecCoreColl.add((CoreBaseInfo)ereceiptInfo);
                    deteleEReceiptCol.add(ereceiptInfo);
                    detailCoreColl.add((CoreBaseInfo)detailInfo);
                    ++matchCodeSucCount;
                }
            }
            if (edMatchResultColl != null) {
                int count = edMatchResultColl.size();
                for (int index4 = 0; index4 < count; ++index4) {
                    EDMatchResultInfo edmInfo = edMatchResultColl.get(index4);
                    allCoreBaseColl.add((CoreBaseInfo)edmInfo);
                }
            }
            EReceiptFactory.getLocalInstance((Context)ctx).updateBatchData(erecCoreColl);
            TransDetailFactory.getLocalInstance((Context)ctx).updateBatchData(detailCoreColl);
        }
        resultMap.put("matchCodeSucCount", matchCodeSucCount);
        logger.error((Object)"------------\u7535\u5b50\u56de\u5355\u7801\u5339\u914d\u7ed3\u675f---------------");
        logger.error((Object)"------------\u6784\u9020\u624b\u5de5\u5339\u914dMap\u5f00\u59cb---------------");
        HashMap<String, EReceiptInfo> ereceiptMap = new HashMap<String, EReceiptInfo>();
        long currentTimeMillis = System.currentTimeMillis();
        for (index = 0; index < deteleEReceiptCol.size(); ++index) {
            erecColl.remove(deteleEReceiptCol.get(index));
        }
        int erecCount2 = erecColl.size();
        for (index = 0; index < erecCount2; ++index) {
            EReceiptInfo erecInfo = erecColl.get(index);
            String ereceiptKey = erecInfo.getTransDate() + erecInfo.getBankNumber() + erecInfo.getCreditAmount() + erecInfo.getDebitAmount() + erecInfo.getOppBankNumber() + currentTimeMillis;
            if (EmptyUtil.isEmpty((String)ereceiptKey) || ereceiptMap.containsKey(ereceiptKey)) continue;
            ereceiptMap.put(ereceiptKey, erecInfo);
        }
        HashMap manualMatchMap = new HashMap();
        int detailCount2 = detailColl.size();
        for (int index5 = 0; index5 < detailCount2; ++index5) {
            TransDetailInfo detailInfo = detailColl.get(index5);
            HashMap<EReceiptInfo, TransDetailInfo> manualEDMap = new HashMap<EReceiptInfo, TransDetailInfo>();
            String detailKey = detailInfo.getBizDate() + detailInfo.getBankAccount().getBankAccountNumber() + detailInfo.getCreditAmount() + detailInfo.getDebitAmount() + detailInfo.getOppBankNumber() + currentTimeMillis;
            if (!ereceiptMap.containsKey(detailKey)) continue;
            EReceiptInfo erecInfo = (EReceiptInfo)ereceiptMap.get(detailKey);
            manualEDMap.put(erecInfo, detailInfo);
            manualMatchMap.put(detailKey, manualEDMap);
        }
        logger.error((Object)("------------\u6784\u9020\u624b\u5de5\u5339\u914dmanualMatchMap\u7ed3\u675f---------------" + manualMatchMap.size()));
        if (manualMatchMap.size() > 0) {
            CoreBaseCollection erecCoreColl = new CoreBaseCollection();
            CoreBaseCollection detailCoreColl = new CoreBaseCollection();
            EDMatchResultCollection manualResultColl = new EDMatchResultCollection();
            HashSet idSet = new HashSet();
            for (String key : manualMatchMap.keySet()) {
                Map innerMap = (Map)manualMatchMap.get(key);
                for (Map.Entry manulMap : innerMap.entrySet()) {
                    EReceiptInfo ereceiptInfo = (EReceiptInfo)manulMap.getKey();
                    TransDetailInfo detailInfo = (TransDetailInfo)manulMap.getValue();
                    ereceiptInfo.setTransDetailId(detailInfo.getId().toString());
                    ereceiptInfo.setIsMatch(EReceiptIsMatchEnum.manual);
                    detailInfo.setIsMatchEReceipt(EReceiptIsMatchEnum.manual);
                    if (ereceiptInfo.getCurrency() == null) {
                        ereceiptInfo.setCurrency(detailInfo.getCurrency());
                    }
                    ereceiptInfo.setOppBank(detailInfo.getOppBank());
                    ereceiptInfo.setOppBankNumber(detailInfo.getOppBankNumber());
                    ereceiptInfo.setOppUnit(detailInfo.getOppUnit());
                    ereceiptInfo.setExplanation(detailInfo.getDescription());
                    ereceiptInfo.setCreditAmount(detailInfo.getCreditAmount());
                    ereceiptInfo.setDebitAmount(detailInfo.getDebitAmount());
                    ereceiptInfo.setBank(detailInfo.getBankAccount().getBank());
                    ereceiptInfo.setNumber(detailInfo.getNumber());
                    ereceiptInfo.setAmount(detailInfo.getTransBalance());
                    if (ereceiptInfo.getDetailNo() == null && detailInfo.getReceiptNo() != null) {
                        ereceiptInfo.setDetailNo("byManual-" + detailInfo.getReceiptNo() + "-detailNotNull");
                    } else if (ereceiptInfo.getDetailNo() != null && detailInfo.getReceiptNo() == null) {
                        detailInfo.setReceiptNo("byManual-" + detailInfo.getReceiptNo() + "-receiptNotNull");
                    } else if (ereceiptInfo.getDetailNo() == null && detailInfo.getReceiptNo() == null) {
                        ereceiptInfo.setDetailNo("byManual-" + currentTimeMillis + "-allNull");
                        detailInfo.setReceiptNo("byManual-" + currentTimeMillis + "-allNull");
                    }
                    manualResultColl = this.unionEDMatchResultColl(ereceiptInfo, detailInfo, key);
                    edMatchResultColl.addCollection(manualResultColl);
                    erecCoreColl.add((CoreBaseInfo)ereceiptInfo);
                    detailCoreColl.add((CoreBaseInfo)detailInfo);
                    ++manualSuccessCount;
                }
            }
            if (edMatchResultColl != null) {
                int count = edMatchResultColl.size();
                for (int index6 = 0; index6 < count; ++index6) {
                    EDMatchResultInfo edmInfo = edMatchResultColl.get(index6);
                    allCoreBaseColl.add((CoreBaseInfo)edmInfo);
                }
            }
            EReceiptFactory.getLocalInstance((Context)ctx).updateBatchData(erecCoreColl);
            TransDetailFactory.getLocalInstance((Context)ctx).updateBatchData(detailCoreColl);
        }
        resultMap.put("manualSuccessCount", manualSuccessCount);
        resultMap.put("matchResultColl", (Object)edMatchResultColl);
        EDMatchResultFactory.getLocalInstance(ctx).addnewBatchData(allCoreBaseColl);
        return resultMap;
    }

    private EDMatchResultCollection unionEDMatchResultColl(EReceiptInfo ereceiptInfo, TransDetailInfo detailInfo, String key) {
        EDMatchResultCollection coll = new EDMatchResultCollection();
        EDMatchResultInfo erecMatResultInfo = this.parseEDMatchResultInfo(ereceiptInfo, null, key);
        coll.add(erecMatResultInfo);
        EDMatchResultInfo detailMatResultInfo = this.parseEDMatchResultInfo(null, detailInfo, key);
        coll.add(detailMatResultInfo);
        return coll;
    }

    private EDMatchResultInfo parseEDMatchResultInfo(EReceiptInfo ereceiptInfo, TransDetailInfo tansDetailInfo, String detailNo) {
        EDMatchResultInfo edMatchResultInfo = new EDMatchResultInfo();
        edMatchResultInfo.setId(BOSUuid.create((BOSObjectType)edMatchResultInfo.getBOSType()));
        edMatchResultInfo.setCreateDate(DateHelper.truncateDate((Date)new Date()));
        edMatchResultInfo.setKey(detailNo);
        if (ereceiptInfo != null) {
            edMatchResultInfo.setCompany(ereceiptInfo.getCompany());
            edMatchResultInfo.setAccountBank(ereceiptInfo.getBankAccount());
            edMatchResultInfo.setNumber(ereceiptInfo.getNumber());
            edMatchResultInfo.setTransDate(ereceiptInfo.getTransDate());
            edMatchResultInfo.setDescription(ereceiptInfo.getExplanation());
            edMatchResultInfo.setCurrency(ereceiptInfo.getCurrency());
            edMatchResultInfo.setDebitAmount(ereceiptInfo.getDebitAmount());
            edMatchResultInfo.setCreditAmount(ereceiptInfo.getCreditAmount());
            edMatchResultInfo.setOppBank(ereceiptInfo.getOppBank());
            edMatchResultInfo.setOppBankNumber(ereceiptInfo.getOppBankNumber());
            edMatchResultInfo.setOppUnit(ereceiptInfo.getOppUnit());
            edMatchResultInfo.setBizObjectId(ereceiptInfo.getId().toString());
            edMatchResultInfo.setBizObjectFullName("com.kingdee.eas.fm.be.app.EReceipt");
        } else {
            edMatchResultInfo.setCompany(tansDetailInfo.getCompany());
            edMatchResultInfo.setAccountBank(tansDetailInfo.getBankAccount());
            edMatchResultInfo.setNumber(tansDetailInfo.getNumber());
            edMatchResultInfo.setTransDate(tansDetailInfo.getBizDate());
            edMatchResultInfo.setDescription(tansDetailInfo.getDescription());
            edMatchResultInfo.setCurrency(tansDetailInfo.getCurrency());
            edMatchResultInfo.setDebitAmount(tansDetailInfo.getDebitAmount());
            edMatchResultInfo.setCreditAmount(tansDetailInfo.getCreditAmount());
            edMatchResultInfo.setOppBank(tansDetailInfo.getOppBank());
            edMatchResultInfo.setOppBankNumber(tansDetailInfo.getOppBankNumber());
            edMatchResultInfo.setOppUnit(tansDetailInfo.getOppUnit());
            edMatchResultInfo.setRecedBillType(tansDetailInfo.getRecedBillType());
            edMatchResultInfo.setRecedBillNumber(tansDetailInfo.getRecedBillNumber());
            edMatchResultInfo.setBizObjectId(tansDetailInfo.getId().toString());
            edMatchResultInfo.setBizObjectFullName("com.kingdee.eas.fm.be.app.TransDetail");
        }
        return edMatchResultInfo;
    }

    @Override
    protected Map _erecDetailAntiMatch(Context ctx, Set keyIdSet) throws BOSException, EASBizException {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        HashSet<String> erecIdSet = new HashSet<String>();
        HashSet<String> detailIdSet = new HashSet<String>();
        EntityViewInfo resultView = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("bizObjectId"));
        selector.add(new SelectorItemInfo("bizObjectFullName"));
        FilterInfo resultFilter = new FilterInfo();
        resultFilter.getFilterItems().add(new FilterItemInfo("key", (Object)keyIdSet, CompareType.INCLUDE));
        resultView.setSelector(selector);
        resultView.setFilter(resultFilter);
        EDMatchResultCollection resultColl = EDMatchResultFactory.getLocalInstance(ctx).getEDMatchResultCollection(resultView);
        int count = resultColl.size();
        for (int index = 0; index < count; ++index) {
            EDMatchResultInfo resultInfo = resultColl.get(index);
            if (resultInfo.getBizObjectFullName().equals("com.kingdee.eas.fm.be.app.EReceipt")) {
                erecIdSet.add(resultInfo.getBizObjectId());
                continue;
            }
            if (!resultInfo.getBizObjectFullName().equals("com.kingdee.eas.fm.be.app.TransDetail")) continue;
            detailIdSet.add(resultInfo.getBizObjectId());
        }
        EReceiptCollection erecColl = this.getEReceiptColl(ctx, erecIdSet);
        TransDetailCollection detailColl = this.getDetailColl(ctx, detailIdSet);
        List<Map<String, String>> list = this.getBizTypeAndNumber4Ereceipt(ctx, erecColl);
        CoreBaseCollection newErecCore = this.parseEReceiptCore(ctx, erecColl);
        CoreBaseCollection newdetailCore = this.parseDetailCore(ctx, detailColl);
        try {
            EReceiptFactory.getLocalInstance((Context)ctx).updateBatchData(newErecCore);
            TransDetailFactory.getLocalInstance((Context)ctx).updateBatchData(newdetailCore);
            this.batchDisposeSrounceBill(ctx, list);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("key", (Object)keyIdSet, CompareType.INCLUDE));
            EDMatchResultFactory.getLocalInstance(ctx).delete(filter);
        }
        catch (Exception e) {
            String msg = ResourceBase.getString((String)resourcePath, (String)"41_antiMatchFail", (Locale)ctx.getLocale());
            returnMap.put("antiMatchFail", msg);
            logger.error((Object)e);
        }
        return returnMap;
    }

    private void batchDisposeSrounceBill(Context ctx, List<Map<String, String>> list) throws BOSException {
        EReceiptDBUtils eReceiptDBUtil = new EReceiptDBUtils();
        for (int i = 0; i < list.size(); ++i) {
            Map<String, String> matchBillMap = list.get(i);
            if (matchBillMap == null) continue;
            eReceiptDBUtil.disposeSrounceBill(ctx, matchBillMap);
        }
    }

    private List<Map<String, String>> getBizTypeAndNumber4Ereceipt(Context ctx, EReceiptCollection erecColl) throws BOSException {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (int i = 0; i < erecColl.size(); ++i) {
            EReceiptInfo eReceiptInfo = erecColl.get(i);
            HashMap<String, String> matchBillMap = new HashMap<String, String>();
            matchBillMap.put("srcBillNumber", eReceiptInfo.getBillNumber());
            matchBillMap.put("srcBillBizType", eReceiptInfo.getBizType());
            matchBillMap.put("companyId", eReceiptInfo.getCompany().getId().toString());
            list.add(matchBillMap);
        }
        return list;
    }

    private EReceiptCollection getEReceiptColl(Context ctx, Set<String> erecIdSet) throws BOSException {
        EReceiptCollection erecColl = null;
        EntityViewInfo eReceiptView = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("bankAccount.bankAccountNumber"));
        selector.add(new SelectorItemInfo("company.id"));
        selector.add(new SelectorItemInfo("currency.id"));
        eReceiptView.setSelector(selector);
        FilterInfo eReceiptFilter = new FilterInfo();
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("id", erecIdSet, CompareType.INCLUDE));
        eReceiptView.setFilter(eReceiptFilter);
        erecColl = EReceiptFactory.getLocalInstance((Context)ctx).getEReceiptCollection(eReceiptView);
        return erecColl;
    }

    private TransDetailCollection getDetailColl(Context ctx, Set<String> detailIdSet) throws BOSException {
        TransDetailCollection detailColl = null;
        EntityViewInfo detailView = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("bankAccount.bankAccountNumber"));
        selector.add(new SelectorItemInfo("bankAccount.bank"));
        selector.add(new SelectorItemInfo("company.id"));
        selector.add(new SelectorItemInfo("currency.id"));
        selector.add(new SelectorItemInfo("oppBank"));
        detailView.setSelector(selector);
        FilterInfo detailFilter = new FilterInfo();
        detailFilter.getFilterItems().add(new FilterItemInfo("id", detailIdSet, CompareType.INCLUDE));
        detailView.setFilter(detailFilter);
        detailColl = TransDetailFactory.getLocalInstance((Context)ctx).getTransDetailCollection(detailView);
        return detailColl;
    }

    private CoreBaseCollection parseEReceiptCore(Context ctx, EReceiptCollection erecColl) {
        CoreBaseCollection erecCoreColl = new CoreBaseCollection();
        int count = erecColl.size();
        for (int index = 0; index < count; ++index) {
            EReceiptInfo ereceiptInfo = erecColl.get(index);
            ereceiptInfo.setTransDetailId(null);
            ereceiptInfo.setIsMatch(EReceiptIsMatchEnum.UnMatch);
            ereceiptInfo.setOppUnit(null);
            ereceiptInfo.setOppBank(null);
            ereceiptInfo.setOppBankNumber(null);
            ereceiptInfo.setDebitAmount(null);
            ereceiptInfo.setCreditAmount(null);
            ereceiptInfo.setCurrency(null);
            ereceiptInfo.setExplanation(null);
            ereceiptInfo.setOppUnit(null);
            ereceiptInfo.setAmount(null);
            ereceiptInfo.setBank(null);
            ereceiptInfo.setNumber(null);
            ereceiptInfo.setBizType(null);
            ereceiptInfo.setBillNumber(null);
            ereceiptInfo.setIsMatchBiz(false);
            if (ereceiptInfo.getDetailNo() != null && (ereceiptInfo.getDetailNo().contains("detailNotNull") || ereceiptInfo.getDetailNo().contains("allNull"))) {
                ereceiptInfo.setDetailNo("");
            } else if (ereceiptInfo.getDetailNo() != null && ereceiptInfo.getDetailNo().contains("receiptNotNull")) {
                String[] oldDetailNo = ereceiptInfo.getDetailNo().split("-");
                ereceiptInfo.setDetailNo(oldDetailNo[1]);
            }
            erecCoreColl.add((CoreBaseInfo)ereceiptInfo);
        }
        return erecCoreColl;
    }

    private CoreBaseCollection parseDetailCore(Context ctx, TransDetailCollection detailColl) {
        CoreBaseCollection detailcoreColl = new CoreBaseCollection();
        int count = detailColl.size();
        for (int index = 0; index < count; ++index) {
            TransDetailInfo detailInfo = detailColl.get(index);
            detailInfo.setIsMatchEReceipt(EReceiptIsMatchEnum.UnMatch);
            if (detailInfo.getReceiptNo() != null && (detailInfo.getReceiptNo().contains("receiptNotNull") || detailInfo.getReceiptNo().contains("allNull"))) {
                detailInfo.setReceiptNo("");
            } else if (detailInfo.getReceiptNo() != null && detailInfo.getReceiptNo().contains("receiptNotNull")) {
                String[] oldDetailNo = detailInfo.getReceiptNo().split("-");
                detailInfo.setReceiptNo(oldDetailNo[1]);
            }
            detailcoreColl.add((CoreBaseInfo)detailInfo);
        }
        return detailcoreColl;
    }
}

