/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.erec.app;

import com.jcraft.jsch.ChannelSftp;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.be.EBGException;
import com.kingdee.eas.fm.be.EReceiptCollection;
import com.kingdee.eas.fm.be.EReceiptFactory;
import com.kingdee.eas.fm.be.EReceiptInfo;
import com.kingdee.eas.fm.be.EReceiptIsMatchEnum;
import com.kingdee.eas.fm.be.EReceiptLogTypeEnum;
import com.kingdee.eas.fm.be.IBankFacade;
import com.kingdee.eas.fm.be.IEReceipt;
import com.kingdee.eas.fm.be.LevelEnum;
import com.kingdee.eas.fm.be.TransDetailCollection;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.fm.be.app.EReceiptDBUtils;
import com.kingdee.eas.fm.be.app.EReceiptLogUtils;
import com.kingdee.eas.fm.be.app.EReceiptPDFUtilNews;
import com.kingdee.eas.fm.be.app.service.EReceiptService;
import com.kingdee.eas.fm.erec.app.AbstractHisEreceiptFacadeControllerBean;
import com.kingdee.eas.fm.erec.app.HisEreceiptUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class HisEreceiptFacadeControllerBean
extends AbstractHisEreceiptFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.erec.app.HisEreceiptFacadeControllerBean");
    private EReceiptService eReceiptService = new EReceiptService();
    private EReceiptDBUtils eReceiptDBUtils = new EReceiptDBUtils();
    private EReceiptLogUtils eReceiptLogUtils = new EReceiptLogUtils();
    SimpleDateFormat dft = new SimpleDateFormat("yyyyMMdd");

    private AccountBankCollection getBankNumberHasInterFace(Context ctx, String banktype) throws BOSException {
        EntityViewInfo bankView = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("bankAccountNumber"));
        FilterInfo bankFilter = new FilterInfo();
        bankFilter.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)true));
        bankFilter.getFilterItems().add(new FilterItemInfo("isEReceipt", (Object)true));
        bankFilter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)false));
        if (!EmptyUtil.isEmpty((String)banktype)) {
            bankFilter.getFilterItems().add(new FilterItemInfo("bankInterFace", (Object)banktype, CompareType.INCLUDE));
        }
        bankView.setFilter(bankFilter);
        bankView.setSelector(sic);
        AccountBankCollection bankColls = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(bankView);
        return bankColls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _runJoinTrans(Context ctx, String banktype, String beginDate, String endDate) throws BOSException, EASBizException {
        logger.error((Object)"--------------\u5386\u53f2\u7535\u5b50\u56de\u5355\u548c\u4ea4\u6613\u660e\u7ec6\u5339\u914d\u4e0b\u8f7d-----------");
        SimpleDateFormat dft = new SimpleDateFormat("yyyy-MM-dd");
        Date begin = Date.valueOf(beginDate);
        Date end = Date.valueOf(endDate);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Connection con = null;
        try {
            AccountBankCollection bankColls = this.getBankNumberHasInterFace(ctx, banktype);
            logger.error((Object)("\u83b7\u53d6\u5230\u5f00\u901a\u7535\u5b50\u56de\u5355\u7684\u94f6\u4f01\u8d26\u6237\u6570\u91cf\uff1a" + bankColls.size()));
            for (int i = 0; i < bankColls.size(); ++i) {
                String bankNumber = bankColls.get(i).getBankAccountNumber();
                try {
                    iMutex.requestObjIDForUpdate(bankNumber + "ereceipt");
                    logger.error((Object)("\u5f00\u59cb\u5339\u914d\u7b2c\u3010" + i + "\u3011\u4e2a\u94f6\u884c\u8d26\u53f7\u7684\u56de\u5355"));
                    this.runJoinTransDetailByBankNumber(ctx, bankNumber, begin, end);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                finally {
                    iMutex.releaseObjIDForUpdate(bankNumber + "ereceipt");
                }
            }
            con = this.getConnection(ctx);
            this.eReceiptDBUtils.cleanEASPDFBefore10Days(ctx, con);
            this.eReceiptLogUtils.deleteEReceiptLog(ctx);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                this.eReceiptLogUtils.addReceiptLog(ctx, null, this.eReceiptService.getNowTime(), "\u7535\u5b50\u56de\u5355\u5339\u914d\u4ea4\u6613\u660e\u7ec6\u4e8b\u52a1\u6267\u884c\u5f02\u5e38\uff01\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage(), "\u8bf7\u8054\u7cfb\u73b0\u573a\u5b9e\u65bd \u6216 \u603b\u90e8\u7814\u53d1\u4eba\u5458\uff01", this.eReceiptLogUtils.getStackTrace((Throwable)e), EReceiptLogTypeEnum.JOINTRANSDETAIL, LevelEnum.ERROR);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)con);
        logger.error((Object)"--------------\u5386\u53f2\u7535\u5b50\u56de\u5355\u548c\u4ea4\u6613\u660e\u7ec6\u5339\u914d\u4e0b\u8f7d\u7ed3\u675f-----------");
    }

    private Set<String> setEReceiptByTransDetail(Context ctx, EReceiptCollection eReceiptInfoCollection, HashMap<String, TransDetailCollection> transDetailMap) {
        HashSet<String> transDetailIdSet = new HashSet<String>();
        SimpleDateFormat dft = new SimpleDateFormat("yyyyMMdd");
        ArrayList<EReceiptInfo> noMatchEReceiptList = new ArrayList<EReceiptInfo>();
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        String companyId = companyInfo.getId().toString();
        int days = 0;
        days = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("EREC003", (IObjectPK)new ObjectUuidPK(companyId));
        if (days > 10) {
            days = 10;
        }
        for (int i = 0; i < eReceiptInfoCollection.size(); ++i) {
            EReceiptInfo eReceiptInfo = eReceiptInfoCollection.get(i);
            logger.error((Object)("\u5f00\u59cb\u5339\u914d\u7b2c\u3010" + i + "\u3011\u6761\u7535\u5b50\u56de\u5355  id:" + eReceiptInfo.getId() + "  \u94f6\u884c\u8d26\u53f7\u4e3a\uff1a" + eReceiptInfo.getBankNumber() + " \u4ea4\u6613\u65e5\u671f\u4e3a\uff1a" + eReceiptInfo.getTransDate() + " detailNo:" + eReceiptInfo.getDetailNo()));
            if (transDetailMap.get(eReceiptInfo.getDetailNo()) != null) {
                TransDetailCollection transDetailColls = transDetailMap.get(eReceiptInfo.getDetailNo());
                boolean isMatch = false;
                for (int m = 0; m < transDetailColls.size(); ++m) {
                    TransDetailInfo transDetailInfo = transDetailColls.get(m);
                    logger.error((Object)("\u83b7\u53d6\u5230\u5bf9\u5e94\u4ea4\u6613\u660e\u7ec6id:" + transDetailInfo.getId() + " \u4ea4\u6613\u65e5\u671f\u4e3a\uff1a" + dft.format(transDetailInfo.getBizTime()) + "\u94f6\u884c\u8d26\u6237:" + transDetailInfo.getBankAccount()));
                    if (transDetailInfo.getIsMatchEReceipt() == EReceiptIsMatchEnum.AutoMatic) {
                        logger.error((Object)("\u8be5\u4ea4\u6613\u660e\u7ec6\u5df2\u5339\u914d\u7535\u5b50\u56de\u5355,\u4e0d\u80fd\u91cd\u590d\u5339\u914d\uff0c\u8be5\u7535\u5b50\u56de\u5355\u672a\u5339\u914d,\u7535\u5b50\u56de\u5355id\u4e3a\uff1a" + eReceiptInfo.getId()));
                        continue;
                    }
                    if (eReceiptInfo.getBankAccount() == null || transDetailInfo.getBankAccount() == null || transDetailInfo.getBankAccount().getBankAccountNumber() == null || !eReceiptInfo.getBankNumber().equals(transDetailInfo.getBankAccount().getBankAccountNumber())) {
                        logger.error((Object)("\u4ea4\u6613\u660e\u7ec6\u7684\u94f6\u884c\u8d26\u53f7\u548c\u7535\u5b50\u56de\u5355\u94f6\u884c\u8d26\u53f7\u4e0d\u4e00\u81f4\uff0c\u8be5\u7535\u5b50\u56de\u5355\u672a\u5339\u914d,\u7535\u5b50\u56de\u5355id\u4e3a\uff1a" + eReceiptInfo.getId()));
                        continue;
                    }
                    String transDetailBizDate = dft.format(transDetailInfo.getBizTime());
                    String ereceiptTransDate = dft.format(eReceiptInfo.getTransDate());
                    if (days == 0) {
                        if (!transDetailBizDate.equals(ereceiptTransDate)) {
                            logger.error((Object)("\u4ea4\u6613\u660e\u7ec6\u4e0e\u7535\u5b50\u56de\u5355\u5173\u8054\u53f7" + eReceiptInfo.getDetailNo() + "\u76f8\u540c\uff0c\u4ea4\u6613\u65e5\u671f\u4e0d\u4e00\u81f4\uff0c\u4e0d\u8fdb\u884c\u5339\u914d"));
                            continue;
                        }
                    } else {
                        GregorianCalendar cal = new GregorianCalendar();
                        cal.setTime(eReceiptInfo.getTransDate());
                        ((Calendar)cal).add(5, -days);
                        java.util.Date beginDate = cal.getTime();
                        cal.setTime(eReceiptInfo.getTransDate());
                        ((Calendar)cal).add(5, days);
                        java.util.Date endDate = cal.getTime();
                        if (transDetailInfo.getBizDate().before(beginDate) || transDetailInfo.getBizDate().after(endDate)) {
                            logger.error((Object)("\u4ea4\u6613\u660e\u7ec6\u4e0e\u7535\u5b50\u56de\u5355\u5173\u8054\u53f7" + eReceiptInfo.getDetailNo() + "\u76f8\u540c\uff0c\u4ea4\u6613\u65e5\u671f\u4e0d\u5728\u8bbe\u5b9a\u8303\u56f4\u5185\uff0c\u4e0d\u8fdb\u884c\u5339\u914d"));
                            continue;
                        }
                    }
                    transDetailIdSet.add(transDetailInfo.getId().toString());
                    eReceiptInfo.setCompany(transDetailInfo.getCompany());
                    BigDecimal amout = Constants.ZERO;
                    if (transDetailInfo.getDebitAmount() != null && transDetailInfo.getDebitAmount().compareTo(Constants.ZERO) != 0) {
                        eReceiptInfo.setDebitAmount(transDetailInfo.getDebitAmount());
                        amout = transDetailInfo.getDebitAmount();
                        eReceiptInfo.setCreditDebitFlag("1");
                    } else if (transDetailInfo.getCreditAmount() != null && transDetailInfo.getCreditAmount().compareTo(Constants.ZERO) != 0) {
                        eReceiptInfo.setCreditAmount(transDetailInfo.getCreditAmount());
                        amout = transDetailInfo.getCreditAmount();
                        eReceiptInfo.setCreditDebitFlag("2");
                    }
                    eReceiptInfo.setAmount(amout);
                    if (eReceiptInfo.getCurrency() == null) {
                        eReceiptInfo.setCurrency(transDetailInfo.getCurrency());
                    }
                    eReceiptInfo.setDescription(transDetailInfo.getDescription());
                    eReceiptInfo.setBankAccount(transDetailInfo.getBankAccount());
                    eReceiptInfo.setBank(transDetailInfo.getBankAccount().getBank());
                    eReceiptInfo.setOppUnit(transDetailInfo.getOppUnit());
                    eReceiptInfo.setTransDetailId(transDetailInfo.getId().toString());
                    eReceiptInfo.setOppBankNumber(transDetailInfo.getOppBankNumber());
                    eReceiptInfo.setOppBank(transDetailInfo.getOppBank());
                    eReceiptInfo.setNumber(transDetailInfo.getNumber());
                    eReceiptInfo.setIsMatch(EReceiptIsMatchEnum.AutoMatic);
                    transDetailInfo.setIsMatchEReceipt(EReceiptIsMatchEnum.AutoMatic);
                    isMatch = true;
                    break;
                }
                if (!isMatch) {
                    noMatchEReceiptList.add(eReceiptInfo);
                }
            } else {
                noMatchEReceiptList.add(eReceiptInfo);
            }
            logger.error((Object)"\u5339\u914d\u7ed3\u675f");
        }
        for (int m = 0; m < noMatchEReceiptList.size(); ++m) {
            eReceiptInfoCollection.remove((EReceiptInfo)noMatchEReceiptList.get(m));
        }
        return transDetailIdSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runJoinTransDetailByBankNumber(Context ctx, String bankNumber, Date begin, Date end) throws BOSException, EASBizException {
        logger.error((Object)("\u5f00\u59cb\u5339\u914d\u94f6\u884c\u8d26\u53f7\u3010" + bankNumber + begin + end + "\u3011\u7684\u4ea4\u6613\u660e\u7ec6"));
        EReceiptCollection eReceiptInfoCollection = HisEreceiptUtil.getNoMatchEReceiptCollectionByBankNumber(ctx, bankNumber, begin, end);
        if (eReceiptInfoCollection.size() == 0) {
            return;
        }
        logger.error((Object)("\u67e5\u8be2\u5230\u672a\u5173\u8054\u4ea4\u6613\u660e\u7ec6\u7684\u7535\u5b50\u56de\u5355\u6570\u91cf\u4e3a\uff1a" + eReceiptInfoCollection.size()));
        HashSet<String> detailNoSet = new HashSet<String>();
        for (int i = 0; i < eReceiptInfoCollection.size(); ++i) {
            EReceiptInfo eReceiptInfo = eReceiptInfoCollection.get(i);
            String detailNo = eReceiptInfo.getDetailNo();
            detailNoSet.add(detailNo);
        }
        HashMap<String, TransDetailCollection> transDetailMap = HisEreceiptUtil.getDetailMapByDate(ctx, detailNoSet);
        if (transDetailMap.keySet().size() == 0) {
            return;
        }
        logger.error((Object)("\u7535\u5b50\u56de\u5355\u5173\u8054\u4ea4\u6613\u660e\u7ec6\u4efb\u52a1:\u7535\u5b50\u56de\u5355\u672a\u5173\u8054\u4ea4\u6613\u660e\u7ec6\u7684\u603b\u6570\u4e3a" + transDetailMap.keySet().size()));
        Set<String> transDetailIdSet = this.setEReceiptByTransDetail(ctx, eReceiptInfoCollection, transDetailMap);
        logger.error((Object)("\u5339\u914d\u5230\u4ea4\u6613\u660e\u7ec6\u7684\u6570\u91cf\uff1a" + transDetailIdSet.size()));
        if (transDetailIdSet.size() == 0) {
            return;
        }
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            HisEreceiptUtil.batchUpdateEReceipt(ctx, eReceiptInfoCollection, con);
            this.eReceiptService.updateEReceiptPayBankName(ctx, eReceiptInfoCollection, transDetailMap, con);
            HisEreceiptUtil.batchUpdateTransDetail(ctx, transDetailIdSet, con);
        }
        catch (Exception e) {
            if (!(e instanceof BEException)) {
                this.eReceiptLogUtils.addReceiptLog(ctx, bankNumber, this.eReceiptService.getNowTime(), "\u3010\u7535\u5b50\u56de\u5355\u5339\u914d\u4ea4\u6613\u660e\u7ec6\u4e8b\u52a1\u5f02\u5e38\uff01\u3011\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage(), "\u8bf7\u8054\u7cfb\u73b0\u573a\u5b9e\u65bd \u6216\u603b\u90e8\u7814\u53d1\u4eba\u5458\uff01", this.eReceiptLogUtils.getStackTrace((Throwable)e), EReceiptLogTypeEnum.JOINTRANSDETAIL, LevelEnum.ERROR);
                e.printStackTrace();
            }
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        logger.error((Object)("\u5339\u914d\u94f6\u884c\u8d26\u53f7\u3010" + bankNumber + "\u3011\u7684\u4ea4\u6613\u660e\u7ec6\u7ed3\u675f"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _getHisEreceiptByBankType(Context ctx, String user, String bankType, String begin, String end) throws BOSException, EASBizException {
        logger.error((Object)"--------------\u5386\u53f2\u7535\u5b50\u56de\u5355\u5f00\u59cb\u4e0b\u8f7d-----------");
        SimpleDateFormat dft = new SimpleDateFormat("yyyy-MM-dd");
        String fBankAccountNumber = "";
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        IRowSet rowSet = this.getAccountBanksByBankType(ctx, bankType);
        String bankSizeMsg = "" + bankType + "\u83b7\u53d6\u5f00\u542f\u94f6\u4f01\u7684\u94f6\u884c\u8d26\u6237\u5927\u5c0f\u4e3a" + rowSet.size();
        logger.error((Object)bankSizeMsg);
        try {
            Date beginDate = Date.valueOf(begin);
            Date endDate = Date.valueOf(end);
            while (rowSet.next()) {
                String id = rowSet.getString("fid");
                String companyid = rowSet.getString("fcompanyid");
                String bankinterface = rowSet.getString("FBankInterFace");
                String bankAccountNumber = rowSet.getString("FbankAccountNumber");
                logger.error((Object)("-------\u67e5\u8be2\u94f6\u884c\u8d26\u6237" + bankAccountNumber + "------"));
                Map filter = this.getHisMap(beginDate, endDate, id, bankAccountNumber, companyid, bankinterface);
                fBankAccountNumber = rowSet.getString("FBankAccountNumber");
                try {
                    iMutex.requestObjIDForUpdate(fBankAccountNumber + "ereceipt");
                    Map result = EReceiptFactory.getLocalInstance((Context)ctx).downEReceiptByManual(filter);
                    String error = (String)result.get("errMsg");
                    logger.error((Object)("--------------\u67e5\u8be2\u94f6\u884c\u8d26\u6237\u7ed3\u675f\uff0c\u9519\u8bef\u4fe1\u606f\u662f\uff1a" + error));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    iMutex.releaseObjIDForUpdate(fBankAccountNumber + "ereceipt");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage());
        }
        logger.error((Object)"--------------\u5386\u53f2\u7535\u5b50\u56de\u5355\u5f00\u59cb\u7ed3\u675f-----------");
    }

    private IRowSet getAccountBanksByBankType(Context ctx, String bankType) throws BOSException {
        String filters = new String();
        if (!EmptyUtil.isEmpty((String)bankType)) {
            FilterInfo filter = new FilterInfo();
            IBankFacade iBankFacade = BankFacadeFactory.getLocalInstance((Context)ctx);
            String[] banktypes = bankType.split(",");
            HashSet<String> banktypeSet = new HashSet<String>();
            int length = banktypes.length;
            for (int i = 0; i < length; ++i) {
                try {
                    Object[] bankCert = iBankFacade.getBankCert(banktypes[i], "");
                    if (EmptyUtil.isEmpty((Object[])bankCert)) continue;
                    int count = bankCert.length;
                    for (int j = 0; j < count; ++j) {
                        banktypeSet.add(((BankInterface)bankCert[j]).getNumber());
                    }
                    continue;
                }
                catch (Exception e) {
                    if (!(e instanceof EBGException)) continue;
                    e.printStackTrace();
                    throw new BOSException((Throwable)e);
                }
            }
            if (!EmptyUtil.isEmpty(banktypeSet)) {
                filter.getFilterItems().add(new FilterItemInfo("bank.FbankInterFaceId", banktypeSet, CompareType.INCLUDE));
                filters = filter.toString();
            } else {
                filters = " 1 = 2 ";
            }
        } else {
            filters = " bank.FbankInterFaceId is not null ";
        }
        StringBuffer sqlStr = new StringBuffer("SELECT");
        sqlStr.append(" distinct FBankAccountNumber,FName_L2 ,FAcctName,  FBankInterFace, FcompanyId, Fid  from T_BD_AccountBanks bank where " + filters + "and bank.FIsClosed = 0 and bank.FIsSetBankInterface = 1 and  bank.FIsEReceipt = 1  order by bank.FBankInterFace");
        logger.error((Object)("\u83b7\u53d6\u5f00\u901a\u8be5\u94f6\u4f01\u63a5\u53e3\u7684\u94f6\u884c\u8d26\u6237\u7ed3\u679c\u96c6SQL:" + sqlStr));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr.toString());
        return rowSet;
    }

    private Map getHisMap(Date begin, Date end, String id, String bankAccountNumber, String companyid, String bankinterface) {
        HashMap<String, Object> filter = new HashMap<String, Object>();
        filter.put("beginDateValue", begin);
        filter.put("endDateValue", end);
        filter.put("accountBank", id);
        filter.put("bankNumber", bankAccountNumber);
        filter.put("companyValue", companyid);
        filter.put("bankInterface", bankinterface);
        return filter;
    }

    @Override
    protected void _downPDFByBankType(Context ctx, String bankType, String begin, String end) throws BOSException, EASBizException {
        logger.error((Object)"-------------------------------------------\u5f00\u59cb\u4e0b\u8f7d \u7535\u5b50\u56de\u5355pdf ------------------------------------------------------------------------------------");
        Date beginDate = Date.valueOf(begin);
        Date endDate = Date.valueOf(end);
        try {
            IRowSet rowSet = this.getAccountBanksByBankType(ctx, bankType);
            logger.error((Object)("\u83b7\u53d6\u5230\u5f00\u901a\u94f6\u4f01\u7684\u8d26\u6237\u6570\u91cf\uff1a" + Integer.toString(rowSet.size())));
            while (rowSet.next()) {
                String bankNumber = rowSet.getString("FBankAccountNumber");
                try {
                    logger.error((Object)("\u5f00\u59cb\u4e0b\u8f7d\u8d26\u6237" + bankNumber + "\u7684PDF"));
                    EReceiptCollection coll = HisEreceiptUtil.getNoPDFEreceiptCollection(ctx, beginDate, endDate, bankNumber);
                    logger.error((Object)("\u83b7\u53d6\u5230\u672a\u4e0b\u8f7d\u7535\u5b50\u56de\u5355\u7684\u6570\u91cf\uff1a" + coll.size()));
                    for (int i = 0; i < coll.size(); ++i) {
                        logger.error((Object)("\u5f00\u59cb\u4e0b\u8f7d\u7b2c\u3010" + (i + 1) + "\u3011\u6761\u7535\u5b50\u56de\u5355\u7684PDF"));
                        try {
                            this.eReceiptLogUtils.addReceiptLog(ctx, null, this.eReceiptService.getNowTime(), "\u4e8b\u52a1\u5f00\u59cb\u4e0b\u8f7d\u7b2c\u3010" + (i + 1) + "\u3011\u6761\u7535\u5b50\u56de\u5355\u7684PDF", null, null, EReceiptLogTypeEnum.DOWNPDF, LevelEnum.NORMAL);
                            EReceiptInfo eReceiptInfo = coll.get(i);
                            if (!eReceiptInfo.getFileFlag().equals("0") || eReceiptInfo.getIsMatch() == EReceiptIsMatchEnum.AutoMatic) {
                                EReceiptFactory.getLocalInstance((Context)ctx).downPDFValues(eReceiptInfo);
                            }
                            logger.error((Object)("\u7ed3\u675f\u4e0b\u8f7d\u7b2c\u3010" + (i + 1) + "\u3011\u6761\u7535\u5b50\u56de\u5355\u7684PDF"));
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            logger.error((Object)("\u4e0b\u8f7d\u7b2c\u3010" + (i + 1) + "\u3011\u6761\u7535\u5b50\u56de\u5355\u7684PDF,\u53d1\u751f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage()));
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error((Object)("\u5f00\u59cb\u4e0b\u8f7d\u8d26\u6237" + bankNumber + "\u7684PDF,\u53d1\u751f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage()));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        logger.error((Object)"------------------------------------------\u4e0b\u8f7d \u7535\u5b50\u56de\u5355pdf\u4e8b\u52a1 \u7ed3\u675f---------------------------------------------------------------------------------");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downPDFValues(Context ctx, EReceiptInfo eReceiptInfo, ChannelSftp channel) throws BOSException, EASBizException {
        String msg = "\u94f6\u884c\u8d26\u53f7\uff1a" + eReceiptInfo.getBankNumber() + " \u4ea4\u6613\u65e5\u671f\uff1a" + this.dft.format(eReceiptInfo.getTransDate()) + " detailNO:" + eReceiptInfo.getDetailNo();
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            con.setAutoCommit(false);
            EReceiptPDFUtilNews eReceiptPDFUtils = new EReceiptPDFUtilNews(channel);
            byte[] fileValue = eReceiptPDFUtils.getPDFByteAarryPdf(ctx, eReceiptInfo);
            if (fileValue == null || fileValue.length == 0) {
                this.eReceiptLogUtils.addReceiptLog(ctx, eReceiptInfo.getBankNumber(), eReceiptInfo.getTransDate(), "\u4e0b\u8f7dPDF\u7684\u5927\u5c0f\u4e3a0\uff01", "\u8bf7\u8054\u7cfb\u73b0\u573a\u5b9e\u65bd\u4eba\u5458\uff01", null, EReceiptLogTypeEnum.DOWNPDF, LevelEnum.ERROR);
                throw new BEException(null);
            }
            eReceiptInfo.setFileValue(fileValue);
            logger.error((Object)("\u5f00\u59cb\u4fdd\u5b58PDF\u5230\u6570\u636e\u5e93\uff1a" + msg));
            this.eReceiptService.savePDFValues(ctx, eReceiptInfo, con);
            logger.error((Object)"\u4fdd\u5b58PDF\u5230\u6570\u636e\u5e93\u6210\u529f");
            con.commit();
        }
        catch (Exception e) {
            try {
                con.rollback();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            if (!(e instanceof BEException)) {
                this.eReceiptLogUtils.addReceiptLog(ctx, eReceiptInfo.getBankNumber(), eReceiptInfo.getTransDate(), "\u4e0b\u8f7d\u7535\u5b50\u56de\u5355PDF\u5f02\u5e38\uff01\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage(), "\u8bf7\u8054\u7cfb\u73b0\u573a\u5b9e\u65bd \u6216 EAS\u7535\u5b50\u56de\u5355\u7ef4\u62a4\u4eba\u5458\uff01", this.eReceiptLogUtils.getStackTrace((Throwable)e), EReceiptLogTypeEnum.DOWNPDF, LevelEnum.ERROR);
                e.printStackTrace();
            }
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downPDFValuesTemplate(Context ctx, EReceiptInfo eReceiptInfo) throws BOSException, EASBizException {
        String msg = "\u94f6\u884c\u8d26\u53f7\uff1a" + eReceiptInfo.getBankNumber() + " \u4ea4\u6613\u65e5\u671f\uff1a" + this.dft.format(eReceiptInfo.getTransDate()) + " detailNO:" + eReceiptInfo.getDetailNo();
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            con.setAutoCommit(false);
            EReceiptPDFUtilNews eReceiptPDFUtils = new EReceiptPDFUtilNews(null);
            byte[] fileValue = eReceiptPDFUtils.getPDFByteAarryTemplate(ctx, eReceiptInfo);
            if (fileValue == null || fileValue.length == 0) {
                this.eReceiptLogUtils.addReceiptLog(ctx, eReceiptInfo.getBankNumber(), eReceiptInfo.getTransDate(), "\u4e0b\u8f7dPDF\u7684\u5927\u5c0f\u4e3a0\uff01", "\u8bf7\u8054\u7cfb\u73b0\u573a\u5b9e\u65bd\u4eba\u5458\uff01", null, EReceiptLogTypeEnum.DOWNPDF, LevelEnum.ERROR);
                throw new BEException(null);
            }
            eReceiptInfo.setFileValue(fileValue);
            logger.error((Object)("\u5f00\u59cb\u4fdd\u5b58PDF\u5230\u6570\u636e\u5e93\uff1a" + msg));
            this.eReceiptService.savePDFValues(ctx, eReceiptInfo, con);
            logger.error((Object)"\u4fdd\u5b58PDF\u5230\u6570\u636e\u5e93\u6210\u529f");
            con.commit();
        }
        catch (Exception e) {
            try {
                con.rollback();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            if (!(e instanceof BEException)) {
                this.eReceiptLogUtils.addReceiptLog(ctx, eReceiptInfo.getBankNumber(), eReceiptInfo.getTransDate(), "\u4e0b\u8f7d\u7535\u5b50\u56de\u5355PDF\u5f02\u5e38\uff01\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage(), "\u8bf7\u8054\u7cfb\u73b0\u573a\u5b9e\u65bd \u6216 EAS\u7535\u5b50\u56de\u5355\u7ef4\u62a4\u4eba\u5458\uff01", this.eReceiptLogUtils.getStackTrace((Throwable)e), EReceiptLogTypeEnum.DOWNPDF, LevelEnum.ERROR);
                e.printStackTrace();
            }
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    @Override
    protected void _removeMultErec(Context ctx, String bankType, String begin, String end) throws BOSException, EASBizException {
        logger.error((Object)"-------------------------------------------\u5220\u9664\u91cd\u590d\u7535\u5b50\u56de\u5355\u5f00\u59cb ------------------------------------------------------------------------------------");
        Date beginDate = Date.valueOf(begin);
        Date endDate = Date.valueOf(end);
        AccountBankCollection bankColls = this.getBankNumberHasInterFace(ctx, bankType);
        logger.error((Object)("\u83b7\u53d6\u5230\u5f00\u901a\u7535\u5b50\u56de\u5355\u7684\u94f6\u4f01\u8d26\u6237\u6570\u91cf\uff1a" + bankColls.size()));
        for (int i = 0; i < bankColls.size(); ++i) {
            AccountBankInfo bankInfo = bankColls.get(i);
            StringBuffer sqlStr = new StringBuffer("SELECT");
            sqlStr.append(" FDETAILNO   from T_BE_Ereceipt  where FTRANSDATE  >={" + begin + "}  and FTRANSDATE < {" + end + "} and  FBANKNUMBER = '" + bankInfo.getBankAccountNumber() + "'  group by FDETAILNO having count(FDETAILNO)>1 ");
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr.toString());
                while (rowSet.next()) {
                    String detailNo = rowSet.getString("FDETAILNO");
                    String erec = "select  fid , FDETAILNO ,FISMATCH ,FTRANSDETAILID  from T_BE_Ereceipt where FTRANSDATE  >={" + begin + "}  and FTRANSDATE < {" + end + "} and  FDETAILNO = '" + detailNo + "' ";
                    IRowSet erecRowset = DbUtil.executeQuery((Context)ctx, (String)erec);
                    ArrayList<String> matchList = new ArrayList<String>();
                    ArrayList<String> noMatchList = new ArrayList<String>();
                    while (erecRowset.next()) {
                        String fid = erecRowset.getString("fid");
                        String detail = erecRowset.getString("FDETAILNO");
                        boolean isMatch = erecRowset.getBoolean("FISMATCH");
                        String transdetailId = erecRowset.getString("FTRANSDETAILID");
                        if (isMatch) {
                            matchList.add(fid);
                            continue;
                        }
                        noMatchList.add(fid);
                    }
                    if (matchList.size() != 0) continue;
                }
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        logger.error((Object)"-------------------------------------------\u5220\u9664\u91cd\u590d\u7535\u5b50\u56de\u5355\u7ed3\u675f ------------------------------------------------------------------------------------");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _matchErecBillNumberAndType(Context ctx, String bankNumber, java.util.Date beginDate, java.util.Date endDate) throws BOSException, EASBizException {
        logger.error((Object)"-----------------\u5f00\u59cb\u5386\u53f2\u7535\u5b50\u56de\u5355\u7684\u63a5\u6536\u5355\u636e\u7f16\u53f7\u548c\u63a5\u6536\u5355\u636e\u7c7b\u578b\u8d4b\u503c\u7684\u540e\u53f0\u4e8b\u52a1--------------------");
        if (beginDate == null || endDate == null || beginDate.after(endDate)) {
            logger.error((Object)"-----------------\u7ed3\u675f\u5386\u53f2\u7535\u5b50\u56de\u5355\u7684\u63a5\u6536\u5355\u636e\u7f16\u53f7\u548c\u63a5\u6536\u5355\u636e\u7c7b\u578b\u8d4b\u503c\u7684\u540e\u53f0\u4e8b\u52a1\uff1a\u5f00\u59cb\u65e5\u671f\u6216\u7ed3\u675f\u4e3a\u7a7a\uff0c\u6216\u8005\u5f00\u59cb\u65e5\u671f\u5927\u4e8e\u7ed3\u675f\u65e5\u671f--------------------");
            return;
        }
        String[] fBankAccountNumber = new String[1];
        if (EmptyUtil.isEmpty((String)bankNumber) && bankNumber.split(",").length <= 0) {
            AccountBankCollection bankColls = this.getBankNumberHasInterFace(ctx, null);
            fBankAccountNumber = new String[bankColls.size()];
            for (int i = 0; i < bankColls.size(); ++i) {
                fBankAccountNumber[i] = bankColls.get(i).getBankAccountNumber();
            }
        } else {
            fBankAccountNumber = bankNumber.split(",");
        }
        int total = 0;
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        IEReceipt iEReceipt = EReceiptFactory.getLocalInstance((Context)ctx);
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        start.setTime(beginDate);
        end.setTime(endDate);
        for (int i = 0; i < fBankAccountNumber.length; ++i) {
            String bankAccountNumber = fBankAccountNumber[i];
            if (!iMutex.requestObjIDForUpdate(bankAccountNumber + "matchErecBill")) continue;
            try {
                while (start.before(end)) {
                    logger.error((Object)(bankAccountNumber + "\u5728 " + start.getTime().toGMTString() + " \u7684\u5386\u53f2\u56de\u5355\u5f00\u59cb\u5339\u914d\u7684\u4e1a\u52a1\u7c7b\u578b"));
                    Map map = iEReceipt.matchErecBillNumberAndTypeByBank(bankAccountNumber, start.getTime(), start.getTime());
                    if (map != null && map.get("count") != null) {
                        int count = Integer.parseInt(map.get("count").toString());
                        logger.error((Object)(bankAccountNumber + "\u5728 " + start.getTime().toGMTString() + " \u5171\u6709" + count + "\u5386\u53f2\u56de\u5355\u5f00\u59cb\u5339\u914d\u7684\u4e1a\u52a1\u7c7b\u578b"));
                        total += count;
                    }
                    start.add(5, 1);
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)(bankAccountNumber + "\u5386\u53f2\u56de\u5355\u5339\u914d\u7684\u4e1a\u52a1\u7c7b\u578b\u5f02\u5e38\uff0c\u6d88\u606f\u5f02\u5e38\uff1a"), (Throwable)e);
                continue;
            }
            finally {
                iMutex.releaseObjIDForUpdate(bankAccountNumber + "matchErecBill");
            }
        }
        logger.error((Object)("-----------------\u7ed3\u675f\u7ed9\u5386\u53f2\u7535\u5b50\u56de\u5355\u7684\u63a5\u6536\u5355\u636e\u7f16\u53f7\u548c\u63a5\u6536\u5355\u636e\u7c7b\u578b\u8d4b\u503c\u7684\u540e\u53f0\u4e8b\u52a1\uff0c\u5b8c\u6210\u5339\u914d\u7684\u5386\u53f2\u56de\u5355\u5171 " + total + "\u6761---------------------"));
    }
}

