/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.erec.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.EReceiptCollection;
import com.kingdee.eas.fm.be.EReceiptFactory;
import com.kingdee.eas.fm.be.EReceiptInfo;
import com.kingdee.eas.fm.be.TransDetailCollection;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HisEreceiptUtil {
    public static void batchUpdateEReceipt(Context ctx, EReceiptCollection eReceiptInfoCollection, Connection conn) throws BOSException, EASBizException {
        PreparedStatement stmtUpdate = null;
        try {
            String sql = "Update T_BE_EReceipt set FCompanyID = ?, FAmount = ? ,FCurrencyID = ? ,FBankAccountID= ? ,FBankID= ? ,FOppUnit=? ,FTransDetailId =? ,FTransDate = ? ,FOppBankNumber = ?,FOppBank = ? ,FIsMatch = ? ,FNumber = ? , FDescription = ? , FDebitAmount = ? ,FCreditAmount = ? ,FCreditDebitFlag = ?, FEXPLANATION = ? where FId= ? ";
            stmtUpdate = conn.prepareStatement(sql);
            for (int i = 0; i < eReceiptInfoCollection.size(); ++i) {
                EReceiptInfo eReceiptInfo = eReceiptInfoCollection.get(i);
                if (eReceiptInfo.getTransDetailId() == null || eReceiptInfo.getTransDetailId().equals("")) continue;
                stmtUpdate.setString(1, eReceiptInfo.getCompany().getId().toString());
                stmtUpdate.setBigDecimal(2, eReceiptInfo.getAmount());
                stmtUpdate.setString(3, eReceiptInfo.getCurrency().getId().toString());
                stmtUpdate.setString(4, eReceiptInfo.getBankAccount().getId().toString());
                stmtUpdate.setString(5, eReceiptInfo.getBank().getId().toString());
                stmtUpdate.setString(6, eReceiptInfo.getOppUnit());
                stmtUpdate.setString(7, eReceiptInfo.getTransDetailId());
                java.util.Date utilDate = eReceiptInfo.getTransDate();
                Date sqlDate = new Date(utilDate.getTime());
                stmtUpdate.setDate(8, sqlDate);
                stmtUpdate.setString(9, eReceiptInfo.getOppBankNumber());
                stmtUpdate.setString(10, eReceiptInfo.getOppBank());
                stmtUpdate.setString(11, "1");
                stmtUpdate.setString(12, eReceiptInfo.getNumber());
                stmtUpdate.setString(13, eReceiptInfo.getDescription());
                stmtUpdate.setBigDecimal(14, eReceiptInfo.getDebitAmount());
                stmtUpdate.setBigDecimal(15, eReceiptInfo.getCreditAmount());
                stmtUpdate.setString(16, eReceiptInfo.getCreditDebitFlag());
                stmtUpdate.setString(17, eReceiptInfo.getDescription());
                DbUtil.prepareVarcharParam((PreparedStatement)stmtUpdate, (int)18, (String)eReceiptInfo.getId().toString());
                stmtUpdate.addBatch();
            }
            stmtUpdate.executeBatch();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new BEException(null);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmtUpdate);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmtUpdate);
    }

    public static void batchUpdateTransDetail(Context ctx, Set<String> transDetailIdSet, Connection conn) throws BOSException {
        PreparedStatement stmtUpdateTransDetail = null;
        try {
            String updateSql = "Update T_BE_TransDetail set FIsMatchEReceipt = ? where FId= ? ";
            stmtUpdateTransDetail = conn.prepareStatement(updateSql);
            for (String transDetailId : transDetailIdSet) {
                stmtUpdateTransDetail.setString(1, "1");
                DbUtil.prepareVarcharParam((PreparedStatement)stmtUpdateTransDetail, (int)2, (String)transDetailId);
                stmtUpdateTransDetail.addBatch();
            }
            stmtUpdateTransDetail.executeBatch();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmtUpdateTransDetail);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmtUpdateTransDetail);
    }

    protected static HashMap<String, TransDetailCollection> getDetailMapByDate(Context ctx, HashSet<String> detailNoSet) throws BOSException {
        EntityViewInfo transDetailView = new EntityViewInfo();
        SelectorItemCollection transDetailSic = new SelectorItemCollection();
        transDetailSic.add(new SelectorItemInfo("*"));
        transDetailSic.add(new SelectorItemInfo("currency.*"));
        transDetailSic.add(new SelectorItemInfo("bankAccount.*"));
        transDetailSic.add(new SelectorItemInfo("bankAccount.bank.*"));
        transDetailSic.add(new SelectorItemInfo("conmpay.*"));
        transDetailView.setSelector(transDetailSic);
        TransDetailCollection transDetailColl = new TransDetailCollection();
        if (detailNoSet.size() > 1000) {
            HashSet<String> curDetailNoSet = new HashSet<String>();
            while (detailNoSet.size() != 0) {
                for (String detailNo : detailNoSet) {
                    if (curDetailNoSet.size() == 900) break;
                    curDetailNoSet.add(detailNo);
                }
                FilterInfo transDetailFilter = new FilterInfo();
                transDetailFilter.getFilterItems().add(new FilterItemInfo("isMatchEReceipt", (Object)0, CompareType.EQUALS));
                transDetailFilter.getFilterItems().add(new FilterItemInfo("receiptNo", curDetailNoSet, CompareType.INCLUDE));
                transDetailView.setFilter(transDetailFilter);
                TransDetailCollection curTransColls = TransDetailFactory.getLocalInstance((Context)ctx).getTransDetailCollection(transDetailView);
                transDetailColl.addCollection(curTransColls);
                detailNoSet.removeAll(curDetailNoSet);
                curDetailNoSet.clear();
            }
        } else {
            FilterInfo transDetailFilter = new FilterInfo();
            transDetailFilter.getFilterItems().add(new FilterItemInfo("isMatchEReceipt", (Object)0, CompareType.EQUALS));
            transDetailFilter.getFilterItems().add(new FilterItemInfo("receiptNo", detailNoSet, CompareType.INCLUDE));
            transDetailView.setFilter(transDetailFilter);
            transDetailColl = TransDetailFactory.getLocalInstance((Context)ctx).getTransDetailCollection(transDetailView);
        }
        TransDetailInfo info = null;
        HashMap<String, TransDetailCollection> transDetailMap = new HashMap<String, TransDetailCollection>();
        for (int i = 0; i < transDetailColl.size(); ++i) {
            info = transDetailColl.get(i);
            TransDetailCollection tempTransDetailColls = transDetailMap.get(info.getReceiptNo());
            if (tempTransDetailColls != null) {
                tempTransDetailColls.add(info);
                continue;
            }
            tempTransDetailColls = new TransDetailCollection();
            tempTransDetailColls.add(info);
            transDetailMap.put(info.getReceiptNo(), tempTransDetailColls);
        }
        return transDetailMap;
    }

    protected static Map<String, EReceiptInfo> getNoMatchEReceMapByBankNumber(Context ctx, String bankNumber, Date begin, Date end) throws BOSException {
        HashMap<String, EReceiptInfo> erecMap = new HashMap<String, EReceiptInfo>();
        EntityViewInfo eReceiptView = new EntityViewInfo();
        SelectorItemCollection eReceiptSic = new SelectorItemCollection();
        eReceiptSic.add(new SelectorItemInfo("id"));
        eReceiptSic.add(new SelectorItemInfo("detailNo"));
        eReceiptSic.add(new SelectorItemInfo("transDate"));
        eReceiptSic.add(new SelectorItemInfo("bankAccount"));
        eReceiptSic.add(new SelectorItemInfo("bankNumber"));
        eReceiptView.setSelector(eReceiptSic);
        FilterInfo eReceiptFilter = new FilterInfo();
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("transDetailId", null));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("isMatch", (Object)"1", CompareType.NOTEQUALS));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("bankNumber", (Object)bankNumber, CompareType.EQUALS));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("transDate", (Object)begin, CompareType.GREATER_EQUALS));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("transDate", (Object)end, CompareType.LESS_EQUALS));
        eReceiptView.setFilter(eReceiptFilter);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("transDate");
        sorter.add(sorterItem);
        eReceiptView.setSorter(sorter);
        EReceiptInfo info = null;
        EReceiptCollection coll = EReceiptFactory.getLocalInstance((Context)ctx).getEReceiptCollection(eReceiptView);
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (EmptyUtil.isEmpty((String)info.getDetailNo())) continue;
            erecMap.put(info.getDetailNo(), info);
        }
        return erecMap;
    }

    protected static EReceiptCollection getNoMatchEReceiptCollectionByBankNumber(Context ctx, String bankNumber, Date begin, Date end) throws BOSException {
        HashMap erecMap = new HashMap();
        EntityViewInfo eReceiptView = new EntityViewInfo();
        SelectorItemCollection eReceiptSic = new SelectorItemCollection();
        eReceiptSic.add(new SelectorItemInfo("*"));
        eReceiptView.setSelector(eReceiptSic);
        FilterInfo eReceiptFilter = new FilterInfo();
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("transDetailId", null));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("isMatch", (Object)"1", CompareType.NOTEQUALS));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("bankNumber", (Object)bankNumber, CompareType.EQUALS));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("transDate", (Object)begin, CompareType.GREATER_EQUALS));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("transDate", (Object)end, CompareType.LESS_EQUALS));
        eReceiptView.setFilter(eReceiptFilter);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("transDate");
        sorter.add(sorterItem);
        eReceiptView.setSorter(sorter);
        EReceiptCollection coll = EReceiptFactory.getLocalInstance((Context)ctx).getEReceiptCollection(eReceiptView);
        return coll;
    }

    public static EReceiptCollection getNoPDFEreceiptCollection(Context ctx, Date startDate, Date endDate, String bankNumber) throws BOSException {
        EntityViewInfo eReceiptView = new EntityViewInfo();
        SelectorItemCollection eReceiptSic = new SelectorItemCollection();
        eReceiptSic.add(new SelectorItemInfo("id"));
        eReceiptSic.add(new SelectorItemInfo("filePath"));
        eReceiptSic.add(new SelectorItemInfo("fileName"));
        eReceiptSic.add(new SelectorItemInfo("detailNo"));
        eReceiptSic.add(new SelectorItemInfo("bankNumber"));
        eReceiptSic.add(new SelectorItemInfo("transDate"));
        eReceiptSic.add(new SelectorItemInfo("ip"));
        eReceiptSic.add(new SelectorItemInfo("password"));
        eReceiptSic.add(new SelectorItemInfo("port"));
        eReceiptSic.add(new SelectorItemInfo("proxy"));
        eReceiptSic.add(new SelectorItemInfo("username"));
        eReceiptSic.add(new SelectorItemInfo("isMatch"));
        eReceiptSic.add(new SelectorItemInfo("fileFlag"));
        eReceiptView.setSelector(eReceiptSic);
        FilterInfo eReceiptFilter = new FilterInfo();
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("fileSource", (Object)"3"));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("fileFlag", (Object)"1"));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("fileFlag", (Object)"0"));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("isMatch", (Object)"1"));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("bankNumber", (Object)bankNumber));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("transDate", (Object)startDate, CompareType.GREATER_EQUALS));
        eReceiptFilter.getFilterItems().add(new FilterItemInfo("transDate", (Object)endDate, CompareType.LESS_EQUALS));
        eReceiptFilter.setMaskString("#0 AND (#1 OR (#2 ANd #3)) AND #4 AND #5 AND #6");
        eReceiptView.setFilter(eReceiptFilter);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("transDate");
        sorter.add(sorterItem);
        eReceiptView.setSorter(sorter);
        EReceiptCollection coll = EReceiptFactory.getLocalInstance((Context)ctx).getEReceiptCollection(eReceiptView);
        return coll;
    }

    private IRowSet getAccountBanksByBankType(Context ctx, String bankType, Date begin, Date end) throws BOSException {
        String filters = new String();
        StringBuffer sqlStr = new StringBuffer("SELECT");
        sqlStr.append(" FDETAILNO   from T_BE_Ereceipt  where FTRANSDATE  >={" + begin + "}  and FTRANSDATE < {" + end + "}  group by FDETAILNO having count(FDETAILNO)>1 ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr.toString());
        return rowSet;
    }
}

