/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.erec.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.EReceiptLogTypeEnum;
import com.kingdee.eas.fm.be.LevelEnum;
import com.kingdee.eas.fm.be.app.EReceiptLogUtils;
import com.kingdee.eas.fm.erec.DownLoadInnerEreceiptParam;
import com.kingdee.eas.fm.erec.app.AbstractInnerEreceiptDownFacadeControllerBean;
import com.kingdee.eas.fm.erec.app.service.inner.IInnerEreceiptService;
import com.kingdee.eas.fm.erec.app.service.inner.InnerEreceiptFactory;
import com.kingdee.eas.fm.erec.app.util.EreceiptHelper;
import com.kingdee.eas.fm.fs.SubsidiaryBillTypeEnum;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InnerEreceiptDownFacadeControllerBean
extends AbstractInnerEreceiptDownFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.erec.app.InnerEreceiptDownFacadeControllerBean");
    private EReceiptLogUtils eReceiptLogUtils = new EReceiptLogUtils();
    private final int count = 50;

    @Override
    public void _downInnerEreceipt(Context ctx, int days) throws BOSException, EASBizException {
        logger.error((Object)"\u540e\u53f0\u4e8b\u52a1-\u4e0b\u8f7d\u5185\u90e8\u56de\u5355\u5f00\u59cb ");
        BankCollection coll = this.getClearingHouseColl(ctx);
        for (int i = 0; i < coll.size(); ++i) {
            if (coll.get(i).getRelatedCompany().getId() != null) {
                String clearingHouseId = coll.get(i).getRelatedCompany().getId().toString();
                logger.error((Object)("\u540e\u53f0\u4e8b\u52a1-\u6309\u7167\u7ed3\u7b97\u4e2d\u5fc3\u4e0b\u8f7d\u5185\u90e8\u56de\u5355\u5f00\u59cb\uff1a\u7ed3\u7b97\u4e2d\u5fc3\u540d\u79f0" + coll.get(i).getName()));
                this.eReceiptLogUtils.saveReceiptLog(ctx, "innerEreceipt", EreceiptHelper.getRelativeDate(new Date(), days, 0), "\u3010\u5185\u90e8\u56de\u5355\u540e\u53f0\u4e8b\u52a1\uff1a\u7ed3\u7b97\u4e2d\u5fc3\u2018" + coll.get(i).getName() + "\u2019 \u4e0b\u8f7d\u5185\u90e8\u56de\u5355\u5f00\u59cb\u3011 ", "", "", EReceiptLogTypeEnum.INNEREREC, LevelEnum.NORMAL);
                this.downInnerErecByClearingHouse(ctx, days, clearingHouseId);
                this.eReceiptLogUtils.saveReceiptLog(ctx, "innerEreceipt", EreceiptHelper.getRelativeDate(new Date(), days, 0), "\u3010\u5185\u90e8\u56de\u5355\u540e\u53f0\u4e8b\u52a1\uff1a\u7ed3\u7b97\u4e2d\u5fc3\u2018" + coll.get(i).getName() + "\u2019 \u4e0b\u8f7d\u5185\u90e8\u56de\u5355\u7ed3\u675f\u3011 ", "", "", EReceiptLogTypeEnum.INNEREREC, LevelEnum.NORMAL);
                continue;
            }
            logger.error((Object)("\u540e\u53f0\u4e8b\u52a1-\u6309\u7167\u7ed3\u7b97\u4e2d\u5fc3\u4e0b\u8f7d\u5185\u90e8\u56de\u5355\u5f00\u59cb\uff1a\u7ed3\u7b97\u4e2d\u5fc3\u540d\u79f0" + coll.get(i).getName() + "\u6ca1\u6709\u5bf9\u5e94\u516c\u53f8"));
        }
        logger.error((Object)"\u540e\u53f0\u4e8b\u52a1-\u4e0b\u8f7d\u5185\u90e8\u56de\u5355\u7ed3\u675f ");
    }

    private BankCollection getClearingHouseColl(Context ctx) throws BOSException, EASBizException {
        logger.error((Object)"\u83b7\u53d6\u6240\u6709\u7ed3\u7b97\u4e2d\u5fc3\u5f00\u59cb");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("inGroup", (Object)new Boolean(true)));
        evi.setFilter(filterInfo);
        BankCollection coll = BankFactory.getLocalInstance((Context)ctx).getBankCollection(evi);
        if (coll == null || coll.size() == 0) {
            this.eReceiptLogUtils.saveReceiptLog(ctx, "innerEreceipt", new Date(), "\u3010\u5185\u90e8\u56de\u5355\u540e\u53f0\u4e8b\u7269\uff1a\u83b7\u53d6\u7ed3\u7b97\u4e2d\u5fc3\u5931\u8d25\uff01\u3011 \u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a\u83b7\u53d6\u5230\u7ed3\u7b97\u4e2d\u5fc3\u4e3a\u7a7a", "\u4e0b\u8f7d\u5185\u90e8\u56de\u5355\u9700\u8981\u8bbe\u7f6e\u5185\u90e8\u7ed3\u7b97\u4e2d\u5fc3\uff0c\u8bf7\u8054\u7cfb\u73b0\u573a\u5b9e\u65bd\u4eba\u5458\u8bbe\u7f6e\u6b63\u786e\u7684\u7ed3\u7b97\u4e2d\u5fc3\uff01", "", EReceiptLogTypeEnum.INNEREREC, LevelEnum.ERROR);
            throw new BOSException("\u83b7\u53d6\u5185\u90e8\u94f6\u884c\u96c6\u5408\u5931\u8d25");
        }
        logger.error((Object)("\u83b7\u53d6\u6240\u6709\u7ed3\u7b97\u4e2d\u5fc3\u7ed3\u675f\uff0c \u5171\u83b7\u53d6\u5230\u5185\u90e8\u94f6\u884c\u4e2a\u6570\u4e3a\uff1a" + coll.size()));
        return coll;
    }

    @Override
    public void _downInnerErecByClearingHouse(Context ctx, int days, String clearingHouseId) throws BOSException, EASBizException {
        logger.error((Object)("\u540e\u53f0\u4e8b\u52a1-\u6309\u7167\u7ed3\u7b97\u4e2d\u5fc3\u4e0b\u8f7d\u5185\u90e8\u56de\u5355\u5f00\u59cb\uff1a\u7ed3\u7b97\u4e2d\u5fc3ID" + clearingHouseId));
        SubsidiaryLedgerCollection coll = this.getUnDownedSubsByCompany(ctx, days, clearingHouseId);
        if (coll != null && coll.size() > 0) {
            this.downInnerErecBySubColl(ctx, coll);
        }
        logger.error((Object)("\u540e\u53f0\u4e8b\u52a1-\u6309\u7167\u7ed3\u7b97\u4e2d\u5fc3\u4e0b\u8f7d\u5185\u90e8\u56de\u5355\u7ed3\u675f\uff1a\u7ed3\u7b97\u4e2d\u5fc3ID" + clearingHouseId));
    }

    protected void downInnerErecBySubColl(Context ctx, SubsidiaryLedgerCollection coll) throws BOSException, EASBizException {
        logger.error((Object)("\u540e\u53f0\u4e8b\u52a1-\u6839\u636e\u5185\u90e8\u8d26\u6237\u660e\u7ec6\u8d26\u8f6c\u5316\u5185\u90e8\u56de\u5355\u7ed3\u675f\uff0c\u6570\u91cf\uff1a" + coll.size()));
        Map<SubsidiaryBillTypeEnum, List> typeMap = this.getBillTypeMap(coll);
        Iterator<SubsidiaryBillTypeEnum> it = typeMap.keySet().iterator();
        logger.error((Object)("\u540e\u53f0\u4e8b\u52a1-\u6839\u636e\u5185\u90e8\u8d26\u6237\u660e\u7ec6\u8d26 -\u6309\u7167\u5355\u636e\u7c7b\u578b\u5206\u7ec4\u540e\u5206\u522b\u8f6c\u5316\u5185\u90e8\u56de\u5355\u5f00\u59cb\uff0c\u6570\u91cf\uff1a" + coll.size()));
        while (it.hasNext()) {
            SubsidiaryBillTypeEnum type = it.next();
            List subsIdList = typeMap.get(type);
            logger.error((Object)("\u540e\u53f0\u4e8b\u52a1--" + type + "--\u8f6c\u5316\u5185\u90e8\u56de\u5355\u5f00\u59cb\uff0c\u6570\u91cf\uff1a" + subsIdList.size()));
            this.eReceiptLogUtils.saveReceiptLog(ctx, "innerEreceipt", new Date(), "\u3010\u5185\u90e8\u56de\u5355\u540e\u53f0\u4e8b\u52a1\uff1a\u5355\u636e\u7c7b\u578b\u2018" + type + "\u2019 \u4e0b\u8f7d\u5185\u90e8\u56de\u5355\u5f00\u59cb\u3011 ", "", "", EReceiptLogTypeEnum.INNEREREC, LevelEnum.NORMAL);
            IInnerEreceiptService service = InnerEreceiptFactory.getInnerEreceiptService(ctx, type);
            List<List> newSubsLists = this.split(subsIdList, 50);
            for (int i = 0; i < newSubsLists.size(); ++i) {
                try {
                    service.batchTransPDF(ctx, newSubsLists.get(i), type);
                    this.eReceiptLogUtils.saveReceiptLog(ctx, "innerEreceipt", new Date(), "\u3010\u5185\u90e8\u56de\u5355\u540e\u53f0\u4e8b\u52a1\uff1a\u5355\u636e\u7c7b\u578b\u2018" + type + "\u2019 \u7b2c" + i + "\u6b21\u4e0b\u8f7d\u5185\u90e8\u56de\u5355\u7ed3\u675f\u3011 ", "", "", EReceiptLogTypeEnum.INNEREREC, LevelEnum.NORMAL);
                    logger.error((Object)("\u540e\u53f0\u4e8b\u52a1--" + type + "--\u8f6c\u5316\u5185\u90e8\u56de\u5355\u5f00\u59cb\uff0c\u6570\u91cf\uff1a" + newSubsLists.get(i).size()));
                    continue;
                }
                catch (Exception e) {
                    this.eReceiptLogUtils.saveReceiptLog(ctx, "innerEreceipt", new Date(), "\u3010\u5185\u90e8\u56de\u5355\u540e\u53f0\u4e8b\u52a1\uff1a\u5355\u636e\u7c7b\u578b\u2018" + type + "\u2019 \u7b2c" + i + "\u6b21\u4e0b\u8f7d\u5185\u90e8\u56de\u5355\u5f02\u5e38\u3002\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage() + "\u3011 ", "", "", EReceiptLogTypeEnum.INNEREREC, LevelEnum.ERROR);
                    e.printStackTrace();
                }
            }
        }
        logger.error((Object)("\u540e\u53f0\u4e8b\u52a1-\u6839\u636e\u5185\u90e8\u8d26\u6237\u660e\u7ec6\u8d26\u8f6c\u5316\u5185\u90e8\u56de\u5355\u7ed3\u675f\uff0c\u6570\u91cf\uff1a" + coll.size()));
    }

    private List<List> split(List resList, int count) {
        if (resList == null || count < 1) {
            return null;
        }
        ArrayList<List> ret = new ArrayList<List>();
        int size = resList.size();
        if (size <= count) {
            ret.add(resList);
        } else {
            int pre = size / count;
            int last = size % count;
            for (int i = 0; i < pre; ++i) {
                ArrayList itemList = new ArrayList();
                for (int j = 0; j < count; ++j) {
                    itemList.add(resList.get(i * count + j));
                }
                ret.add(itemList);
            }
            if (last > 0) {
                ArrayList itemList = new ArrayList();
                for (int i = 0; i < last; ++i) {
                    itemList.add(resList.get(pre * count + i));
                }
                ret.add(itemList);
            }
        }
        return ret;
    }

    private Map<SubsidiaryBillTypeEnum, List> getBillTypeMap(SubsidiaryLedgerCollection coll) {
        logger.error((Object)"\u5f00\u59cb\u8fdb\u884c\u5206\u7ec4");
        HashMap<SubsidiaryBillTypeEnum, List> billTypeMap = new HashMap<SubsidiaryBillTypeEnum, List>();
        for (int i = 0; i < coll.size(); ++i) {
            SubsidiaryLedgerInfo info = coll.get(i);
            if (billTypeMap.containsKey(info.getBizType())) {
                ((List)billTypeMap.get(info.getBizType())).add(info.getId().toString());
                continue;
            }
            ArrayList<String> billIdList = new ArrayList<String>();
            billIdList.add(info.getId().toString());
            billTypeMap.put(info.getBizType(), billIdList);
        }
        logger.error((Object)"\u7ed3\u675f\u5206\u7ec4");
        return billTypeMap;
    }

    private SubsidiaryLedgerCollection getUnDownedSubsByCompany(Context ctx, int days, String companyId) throws BOSException, EASBizException {
        logger.error((Object)"\u540e\u53f0\u4e8b\u52a1-\u4e0b\u8f7d\u5185\u90e8\u56de\u5355\uff0c\u83b7\u53d6\u672a\u4e0b\u8f7d\u7684\u5185\u90e8\u8d26\u6237\u660e\u7ec6\u8d26\u96c6\u5408\u5f00\u59cb");
        Date startDate = EreceiptHelper.getRelativeDate(new Date(), days, 0);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = this.getSelectorsForGroup();
        view.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isCreateInnerEReceipt", (Object)Boolean.FALSE));
        filterInfo.getFilterItems().add(new FilterItemInfo("date", (Object)startDate, CompareType.GREATER_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("date", (Object)new Date(), CompareType.LESS));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        SorterItemCollection sortColl = new SorterItemCollection();
        sortColl.add(new SorterItemInfo("date"));
        view.setSorter(sortColl);
        view.setFilter(filterInfo);
        view.setTopCount(3000);
        SubsidiaryLedgerCollection coll = SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).getSubsidiaryLedgerCollection(view);
        logger.error((Object)("\u540e\u53f0\u4e8b\u52a1-\u4e0b\u8f7d\u5185\u90e8\u56de\u5355\uff0c\u83b7\u53d6\u672a\u4e0b\u8f7d\u7684\u5185\u90e8\u8d26\u6237\u660e\u7ec6\u8d26\u96c6\u5408\u7ed3\u675f\uff0c\u5171\u4e0b\u8f7d\u6761\u6570\uff1a" + coll.size()));
        if (coll.size() > 0) {
            this.eReceiptLogUtils.saveReceiptLog(ctx, "innerEreceipt", EreceiptHelper.getRelativeDate(new Date(), days, 0), "\u3010\u7ed3\u7b97\u4e2d\u5fc3\u2018" + coll.get(0).getCompany().getName() + "\u2019 \u83b7\u53d6\u5230\u5185\u90e8\u8d26\u6237\u660e\u7ec6\u8d26\u4e2a\u6570\u4e3a" + coll.size() + "\u3011 ", "", "", EReceiptLogTypeEnum.INNEREREC, LevelEnum.NORMAL);
        }
        return coll;
    }

    private SelectorItemCollection getSelectorsForGroup() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("billId"));
        sic.add(new SelectorItemInfo("bizType"));
        sic.add(new SelectorItemInfo("company.name"));
        return sic;
    }

    @Override
    public void _downInnerErecBySubs(Context ctx, List ids) throws BOSException, EASBizException {
        SubsidiaryLedgerCollection coll = this.getUnDownedSubsByIds(ctx, ids);
        this.downInnerErecBySubColl(ctx, coll);
    }

    private SubsidiaryLedgerCollection getUnDownedSubsByIds(Context ctx, List idList) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = this.getSelectorsForGroup();
        view.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isCreateInnerEReceipt", (Object)Boolean.FALSE));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idList, CompareType.INCLUDE));
        SorterItemCollection sortColl = new SorterItemCollection();
        sortColl.add(new SorterItemInfo("date"));
        view.setSorter(sortColl);
        return SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).getSubsidiaryLedgerCollection(view);
    }

    private SubsidiaryLedgerCollection getUnDownedSubsByCompany(Context ctx, Date beginDate, Date endDate, String companyId) throws BOSException, EASBizException {
        logger.error((Object)"\u540e\u53f0\u4e8b\u52a1-\u4e0b\u8f7d\u5185\u90e8\u56de\u5355\uff0c\u83b7\u53d6\u672a\u4e0b\u8f7d\u7684\u5185\u90e8\u8d26\u6237\u660e\u7ec6\u8d26\u96c6\u5408\u5f00\u59cb");
        Date startDate = beginDate;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = this.getSelectorsForGroup();
        view.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isCreateInnerEReceipt", (Object)Boolean.FALSE));
        filterInfo.getFilterItems().add(new FilterItemInfo("date", (Object)startDate, CompareType.GREATER_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("date", (Object)endDate, CompareType.LESS_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        SorterItemCollection sortColl = new SorterItemCollection();
        sortColl.add(new SorterItemInfo("date"));
        view.setSorter(sortColl);
        view.setFilter(filterInfo);
        view.setTopCount(3000);
        SubsidiaryLedgerCollection coll = SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).getSubsidiaryLedgerCollection(view);
        logger.error((Object)("\u540e\u53f0\u4e8b\u52a1-\u6307\u5b9a\u671f\u95f4\u5185\u4e0b\u8f7d\u5185\u90e8\u56de\u5355\uff0c\u83b7\u53d6\u672a\u4e0b\u8f7d\u7684\u5185\u90e8\u8d26\u6237\u660e\u7ec6\u8d26\u96c6\u5408\u7ed3\u675f\uff0c\u5171\u4e0b\u8f7d\u6761\u6570\uff1a" + coll.size()));
        if (coll.size() > 0) {
            this.eReceiptLogUtils.saveReceiptLog(ctx, "innerEreceipt", beginDate, "\u3010\u7ed3\u7b97\u4e2d\u5fc3\u2018" + coll.get(0).getCompany().getName() + "\u2019 \u83b7\u53d6\u5230\u5185\u90e8\u8d26\u6237\u660e\u7ec6\u8d26\u4e2a\u6570\u4e3a" + coll.size() + "\u3011 ", "", "", EReceiptLogTypeEnum.INNEREREC, LevelEnum.NORMAL);
        }
        return coll;
    }

    public void downInnerErecByClearingHouse(Context ctx, Date beginDate, Date endDate, String clearingHouseId) throws BOSException, EASBizException {
        logger.error((Object)("\u540e\u53f0\u4e8b\u52a1-\u6309\u7167\u7ed3\u7b97\u4e2d\u5fc3\u548c\u65e5\u671f\u671f\u95f4\u4e0b\u8f7d\u5185\u90e8\u56de\u5355\u5f00\u59cb\uff1a\u7ed3\u7b97\u4e2d\u5fc3ID" + clearingHouseId));
        SubsidiaryLedgerCollection coll = this.getUnDownedSubsByCompany(ctx, beginDate, endDate, clearingHouseId);
        if (coll != null && coll.size() > 0) {
            this.downInnerErecBySubColl(ctx, coll);
        }
        logger.error((Object)("\u540e\u53f0\u4e8b\u52a1-\u6309\u7167\u7ed3\u7b97\u4e2d\u5fc3\u548c\u65e5\u671f\u671f\u95f4\u4e0b\u8f7d\u5185\u90e8\u56de\u5355\u7ed3\u675f\uff1a\u7ed3\u7b97\u4e2d\u5fc3ID" + clearingHouseId));
    }

    @Override
    protected void _downInnerErecsByPeriod(Context ctx, String begin, String end) throws BOSException, EASBizException {
        logger.error((Object)"\u540e\u53f0\u4e8b\u52a1-\u6839\u636e\u65e5\u671f\u671f\u95f4\u4e0b\u8f7d\u5185\u90e8\u56de\u5355\u5f00\u59cb ");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date beginDate = new Date();
        Date endDate = new Date();
        if (EmptyUtil.isEmpty((String)begin) || EmptyUtil.isEmpty((String)end)) {
            logger.error((Object)"\u540e\u53f0\u4e8b\u52a1-\u6839\u636e\u65e5\u671f\u671f\u95f4\u4e0b\u8f7d\u5185\u90e8\u56de\u5355\u5f00\u59cb\u65e5\u6216\u7ed3\u675f\u65e5\u4e0d\u5b8c\u6574");
        } else {
            try {
                beginDate = df.parse(begin);
                endDate = df.parse(end);
            }
            catch (Exception e) {
                logger.error((Object)("\u65e5\u671f\u89e3\u6790\u9519\u8bef\uff0c\u5f00\u59cb\u65e5\uff1a " + begin + "\u7ed3\u675f\u65e5\uff1a " + end));
            }
        }
        if (EmptyUtil.isEmpty((Object)beginDate) || EmptyUtil.isEmpty((Object)endDate)) {
            logger.error((Object)("\u65e5\u671f\u89e3\u6790\u9519\u8bef\uff0c\u5f00\u59cb\u65e5\uff1a " + begin + "\u7ed3\u675f\u65e5\uff1a " + end));
            return;
        }
        if (beginDate.after(endDate)) {
            logger.error((Object)"\u65e5\u671f\u8f93\u5165\u9519\u8bef\uff0c\u5f00\u59cb\u65e5\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65e5");
            return;
        }
        if (DateUtil.getDiffDays((Date)beginDate, (Date)endDate) > 31) {
            logger.error((Object)"\u5f00\u59cb\u65e5\u4e0e\u7ed3\u675f\u65e5\u4e4b\u95f4\u95f4\u9694\u4e0d\u80fd\u5927\u4e8e31\u5929");
            return;
        }
        BankCollection coll = this.getClearingHouseColl(ctx);
        for (int i = 0; i < coll.size(); ++i) {
            if (coll.get(i).getRelatedCompany().getId() != null) {
                String clearingHouseId = coll.get(i).getRelatedCompany().getId().toString();
                logger.error((Object)("\u540e\u53f0\u4e8b\u52a1-\u6309\u7167\u7ed3\u7b97\u4e2d\u5fc3\u4e0b\u8f7d\u5185\u90e8\u56de\u5355\u5f00\u59cb\uff1a\u7ed3\u7b97\u4e2d\u5fc3\u540d\u79f0" + coll.get(i).getName()));
                this.eReceiptLogUtils.saveReceiptLog(ctx, "innerEreceipt", beginDate, "\u3010\u5185\u90e8\u56de\u5355\u540e\u53f0\u4e8b\u52a1\uff1a\u7ed3\u7b97\u4e2d\u5fc3\u2018" + coll.get(i).getName() + "\u2019 \u4e0b\u8f7d\u5185\u90e8\u56de\u5355\u5f00\u59cb\u3011 ", "", "", EReceiptLogTypeEnum.INNEREREC, LevelEnum.NORMAL);
                this.downInnerErecByClearingHouse(ctx, beginDate, endDate, clearingHouseId);
                this.eReceiptLogUtils.saveReceiptLog(ctx, "innerEreceipt", beginDate, "\u3010\u5185\u90e8\u56de\u5355\u540e\u53f0\u4e8b\u52a1\uff1a\u7ed3\u7b97\u4e2d\u5fc3\u2018" + coll.get(i).getName() + "\u2019 \u4e0b\u8f7d\u5185\u90e8\u56de\u5355\u7ed3\u675f\u3011 ", "", "", EReceiptLogTypeEnum.INNEREREC, LevelEnum.NORMAL);
                continue;
            }
            logger.error((Object)("\u540e\u53f0\u4e8b\u52a1-\u6309\u7167\u7ed3\u7b97\u4e2d\u5fc3\u4e0b\u8f7d\u5185\u90e8\u56de\u5355\u5f00\u59cb\uff1a\u7ed3\u7b97\u4e2d\u5fc3\u540d\u79f0" + coll.get(i).getName() + "\u6ca1\u6709\u5bf9\u5e94\u516c\u53f8"));
        }
        logger.error((Object)"\u540e\u53f0\u4e8b\u52a1-\u6839\u636e\u65e5\u671f\u671f\u95f4\u4e0b\u8f7d\u5185\u90e8\u56de\u5355\u7ed3\u675f ");
    }

    @Override
    protected int _downInnerErecByHand(Context ctx, DownLoadInnerEreceiptParam param) throws BOSException, EASBizException {
        int size = 0;
        if (param == null) {
            return size;
        }
        Set innerAccountIdSet = param.getInnerAccountIdSet();
        if (innerAccountIdSet == null) {
            return 0;
        }
        for (String innerAccountId : innerAccountIdSet) {
            SubsidiaryLedgerCollection coll = this.getUnDownedSubsByInnerAccount(ctx, param.getBeginDate(), param.getEndDate(), param.getBillStatus(), innerAccountId);
            if (coll == null || coll.size() <= 0) continue;
            size += this.downInnerErecBySubCollNew(ctx, coll);
        }
        return size;
    }

    protected int downInnerErecBySubCollNew(Context ctx, SubsidiaryLedgerCollection coll) throws BOSException, EASBizException {
        logger.error((Object)("\u540e\u53f0\u4e8b\u52a1-\u6839\u636e\u5185\u90e8\u8d26\u6237\u660e\u7ec6\u8d26\u8f6c\u5316\u5185\u90e8\u56de\u5355\u7ed3\u675f\uff0c\u6570\u91cf\uff1a" + coll.size()));
        int count = coll.size();
        Map<SubsidiaryBillTypeEnum, List> typeMap = this.getBillTypeMap(coll);
        Iterator<SubsidiaryBillTypeEnum> it = typeMap.keySet().iterator();
        logger.error((Object)("\u540e\u53f0\u4e8b\u52a1-\u6839\u636e\u5185\u90e8\u8d26\u6237\u660e\u7ec6\u8d26 -\u6309\u7167\u5355\u636e\u7c7b\u578b\u5206\u7ec4\u540e\u5206\u522b\u8f6c\u5316\u5185\u90e8\u56de\u5355\u5f00\u59cb\uff0c\u6570\u91cf\uff1a" + coll.size()));
        while (it.hasNext()) {
            SubsidiaryBillTypeEnum type = it.next();
            List subsIdList = typeMap.get(type);
            logger.error((Object)("\u540e\u53f0\u4e8b\u52a1--" + type + "--\u8f6c\u5316\u5185\u90e8\u56de\u5355\u5f00\u59cb\uff0c\u6570\u91cf\uff1a" + subsIdList.size()));
            this.eReceiptLogUtils.saveReceiptLog(ctx, "innerEreceipt", new Date(), "\u3010\u5185\u90e8\u56de\u5355\u540e\u53f0\u4e8b\u52a1\uff1a\u5355\u636e\u7c7b\u578b\u2018" + type + "\u2019 \u4e0b\u8f7d\u5185\u90e8\u56de\u5355\u5f00\u59cb\u3011 ", "", "", EReceiptLogTypeEnum.INNEREREC, LevelEnum.NORMAL);
            IInnerEreceiptService service = InnerEreceiptFactory.getInnerEreceiptService(ctx, type);
            List<List> newSubsLists = this.split(subsIdList, count);
            for (int i = 0; i < newSubsLists.size(); ++i) {
                try {
                    service.batchTransPDF(ctx, newSubsLists.get(i), type);
                    this.eReceiptLogUtils.saveReceiptLog(ctx, "innerEreceipt", new Date(), "\u3010\u5185\u90e8\u56de\u5355\u540e\u53f0\u4e8b\u52a1\uff1a\u5355\u636e\u7c7b\u578b\u2018" + type + "\u2019 \u7b2c" + i + "\u6b21\u4e0b\u8f7d\u5185\u90e8\u56de\u5355\u7ed3\u675f\u3011 ", "", "", EReceiptLogTypeEnum.INNEREREC, LevelEnum.NORMAL);
                    logger.error((Object)("\u540e\u53f0\u4e8b\u52a1--" + type + "--\u8f6c\u5316\u5185\u90e8\u56de\u5355\u5f00\u59cb\uff0c\u6570\u91cf\uff1a" + newSubsLists.get(i).size()));
                    continue;
                }
                catch (Exception e) {
                    count -= newSubsLists.get(i).size();
                    this.eReceiptLogUtils.saveReceiptLog(ctx, "innerEreceipt", new Date(), "\u3010\u5185\u90e8\u56de\u5355\u540e\u53f0\u4e8b\u52a1\uff1a\u5355\u636e\u7c7b\u578b\u2018" + type + "\u2019 \u7b2c" + i + "\u6b21\u4e0b\u8f7d\u5185\u90e8\u56de\u5355\u5f02\u5e38\u3002\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage() + "\u3011 ", "", "", EReceiptLogTypeEnum.INNEREREC, LevelEnum.ERROR);
                    e.printStackTrace();
                }
            }
        }
        logger.error((Object)("\u540e\u53f0\u4e8b\u52a1-\u6839\u636e\u5185\u90e8\u8d26\u6237\u660e\u7ec6\u8d26\u8f6c\u5316\u5185\u90e8\u56de\u5355\u7ed3\u675f\uff0c\u6570\u91cf\uff1a" + coll.size()));
        return count;
    }

    private SubsidiaryLedgerCollection getUnDownedSubsByInnerAccount(Context ctx, Date beginDate, Date endDate, int billType, String innerAccountId) throws BOSException, EASBizException {
        logger.error((Object)"\u540e\u53f0\u4e8b\u52a1-\u4e0b\u8f7d\u5185\u90e8\u56de\u5355\uff0c\u83b7\u53d6\u672a\u4e0b\u8f7d\u7684\u5185\u90e8\u8d26\u6237\u660e\u7ec6\u8d26\u96c6\u5408\u5f00\u59cb");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        beginDate = DateUtil.getDayBegin((Date)beginDate);
        try {
            endDate = DateUtil.getNextDay((Date)df.parse(df.format(endDate)));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = this.getSelectorsForGroup();
        view.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isCreateInnerEReceipt", (Object)Boolean.FALSE));
        filterInfo.getFilterItems().add(new FilterItemInfo("date", (Object)beginDate, CompareType.GREATER_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("date", (Object)endDate, CompareType.LESS));
        filterInfo.getFilterItems().add(new FilterItemInfo("innerAccount.id", (Object)innerAccountId));
        if (billType != 999) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bizType", (Object)billType, CompareType.EQUALS));
        }
        SorterItemCollection sortColl = new SorterItemCollection();
        sortColl.add(new SorterItemInfo("date"));
        view.setSorter(sortColl);
        view.setFilter(filterInfo);
        view.setTopCount(3000);
        SubsidiaryLedgerCollection coll = SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).getSubsidiaryLedgerCollection(view);
        logger.error((Object)("\u540e\u53f0\u4e8b\u52a1-\u6307\u5b9a\u671f\u95f4\u5185\u4e0b\u8f7d\u5185\u90e8\u56de\u5355\uff0c\u83b7\u53d6\u672a\u4e0b\u8f7d\u7684\u5185\u90e8\u8d26\u6237\u660e\u7ec6\u8d26\u96c6\u5408\u7ed3\u675f\uff0c\u5171\u4e0b\u8f7d\u6761\u6570\uff1a" + coll.size()));
        if (coll.size() > 0) {
            this.eReceiptLogUtils.saveReceiptLog(ctx, "innerEreceipt", beginDate, "\u3010\u7ed3\u7b97\u4e2d\u5fc3\u2018" + coll.get(0).getCompany().getName() + "\u2019 \u83b7\u53d6\u5230\u5185\u90e8\u8d26\u6237\u660e\u7ec6\u8d26\u4e2a\u6570\u4e3a" + coll.size() + "\u3011 ", "", "", EReceiptLogTypeEnum.INNEREREC, LevelEnum.NORMAL);
        }
        return coll;
    }
}

