/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.erec.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.erec.EreceiptTypeEnum;
import com.kingdee.eas.fm.erec.app.service.EreceiptBillHelper;
import com.kingdee.eas.fm.erec.app.service.EreceiptDetailService;
import com.kingdee.eas.fm.erec.app.service.IEreceiptBillService;
import com.kingdee.eas.fm.erec.app.util.EreceiptHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractEreceiptBillService
implements IEreceiptBillService {
    private static Logger logger = Logger.getLogger((String)AbstractEreceiptBillService.class.getName());
    private EreceiptDetailService detailService = new EreceiptDetailService();

    @Override
    public Map<String, List<String>> getErecIdMap(Context ctx, List billIdList) throws BOSException, EASBizException {
        Map<String, List<String>> transIdMap = this.getDetailIdMapByBillIdList(ctx, billIdList);
        List<String> transDetailIdList = EreceiptBillHelper.getMapValueList(transIdMap);
        logger.error((Object)("\u4e1a\u52a1\u5355\u636e\u5bf9\u5e94\u7684\u4ea4\u6613\u660e\u7ec6\u6570\u91cf\uff1a" + transDetailIdList.size()));
        if (EmptyUtil.isEmpty(transDetailIdList)) {
            throw new BEException(BEException.COMMON, (Object[])new String[]{"\u6240\u9009\u4e1a\u52a1\u5355\u636e\u672a\u5173\u8054\u4ea4\u6613\u660e\u7ec6\uff0c\u65e0\u6cd5\u8054\u67e5\u94f6\u884c\u7535\u5b50\u56de\u5355\uff01"});
        }
        Map<String, String> erecIdMap = this.getErecIdMapByTransIds(ctx, transDetailIdList);
        Map<String, List<String>> idMap = EreceiptBillHelper.getIdMapByBillIds(transIdMap, erecIdMap);
        List<String> erecIdList = EreceiptBillHelper.getBillIdList4Map(billIdList, idMap);
        if (EmptyUtil.isEmpty(erecIdList)) {
            throw new BEException(BEException.COMMON, (Object[])new String[]{"\u4e1a\u52a1\u5355\u636e\u5173\u8054\u7684\u4ea4\u6613\u660e\u7ec6\u8fd8\u672a\u4e0e\u7535\u5b50\u56de\u5355\u8fdb\u884c\u5339\u914d\uff0c\u65e0\u6cd5\u8054\u67e5\u94f6\u884c\u7535\u5b50\u56de\u5355\uff0c\u8bf7\u5148\u5b8c\u6210\u4ea4\u6613\u660e\u7ec6\u4e0e\u56de\u5355\u4e4b\u95f4\u7684\u5339\u914d\uff01"});
        }
        return EreceiptBillHelper.getIdMapByBillIds(transIdMap, erecIdMap);
    }

    @Override
    public Map<String, List<byte[]>> getPDFMap(Context ctx, List billIdList) throws BOSException, EASBizException {
        HashMap<String, List<String>> idMap = new HashMap();
        try {
            idMap = this.getErecIdMap(ctx, billIdList);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        List<String> erecIdList = EreceiptBillHelper.getMapValueList(idMap);
        Map<String, byte[]> pdfMapByErec = this.getPDFMapByErecIds(ctx, erecIdList);
        return EreceiptBillHelper.getPDFMap(idMap, pdfMapByErec);
    }

    @Override
    public List<byte[]> getPDFMap(Context ctx, List billIdList, Map sortIems) throws BOSException, EASBizException {
        HashMap<String, List<String>> idMap = new HashMap();
        try {
            idMap = this.getErecIdMap(ctx, billIdList);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        List<String> erecIdList = EreceiptBillHelper.getMapValueList(idMap);
        return this.getPDFMapByErecIds(ctx, erecIdList, sortIems);
    }

    public Map<String, byte[]> getPDFMapByErecIds(Context ctx, List erecIdList) throws BOSException, EASBizException {
        return this.detailService.getPDFMapByErecIds(ctx, erecIdList);
    }

    public Map<String, String> getErecIdMapByTransIds(Context ctx, List transDetailIdList) throws BOSException, EASBizException {
        return this.detailService.getErecIdMapByTransIds(ctx, transDetailIdList);
    }

    public abstract Map<String, List<String>> getDetailIdMapByBillIdList(Context var1, List<String> var2) throws BOSException, EASBizException;

    @Override
    public Map<String, List<byte[]>> getPDFMap(Context ctx, List billIdList, EreceiptTypeEnum type, boolean isPrint) throws BOSException, EASBizException {
        if (type.equals((Object)EreceiptTypeEnum.EREC)) {
            return this.getBankPDFMap(ctx, billIdList, isPrint);
        }
        if (type.equals((Object)EreceiptTypeEnum.INNER)) {
            return this.getInnerPDFMap(ctx, billIdList, isPrint);
        }
        Map<String, List<byte[]>> bankPDFMap = this.getBankPDFMap(ctx, billIdList, isPrint);
        Map<String, List<byte[]>> innerPDFMap = this.getInnerPDFMap(ctx, billIdList, isPrint);
        return EreceiptHelper.mergeByteMaps(bankPDFMap, innerPDFMap);
    }

    @Override
    public Map<String, List<String>> getErecIdMap(Context ctx, List billIdList, EreceiptTypeEnum type, boolean isPrint) throws BOSException, EASBizException {
        if (type.equals((Object)EreceiptTypeEnum.EREC)) {
            return this.getBankErecIdMap(ctx, billIdList, isPrint);
        }
        if (type.equals((Object)EreceiptTypeEnum.INNER)) {
            return this.getInnerErecIdMap(ctx, billIdList, isPrint);
        }
        Map<String, List<String>> bankErecMap = this.getBankErecIdMap(ctx, billIdList, isPrint);
        Map<String, List<String>> innerErecMap = this.getInnerErecIdMapByBillIds(ctx, billIdList, isPrint);
        return EreceiptHelper.mergeMaps(bankErecMap, innerErecMap);
    }

    public Map<String, List<byte[]>> getBankPDFMap(Context ctx, List billIdList, boolean isPrint) throws BOSException, EASBizException {
        List<String> erecIdList;
        Map<String, byte[]> pdfMapByErec;
        Map<String, List<String>> idMap = this.getBankErecIdMap(ctx, billIdList, isPrint);
        if (idMap != null && idMap.size() > 0 && (pdfMapByErec = this.getPDFMapByErecIds(ctx, erecIdList = EreceiptBillHelper.getMapValueList(idMap), EreceiptTypeEnum.EREC)) != null && pdfMapByErec.size() > 0) {
            return EreceiptBillHelper.getPDFMap(idMap, pdfMapByErec);
        }
        return new HashMap<String, List<byte[]>>();
    }

    public Map<String, List<String>> getBankErecIdMap(Context ctx, List billIdList, boolean isPrint) throws BOSException, EASBizException {
        Map<String, List<String>> transIdMap = this.getDetailIdMapByBillIdList(ctx, billIdList, isPrint);
        if (transIdMap != null && transIdMap.size() > 0) {
            List<String> transDetailIdList = EreceiptBillHelper.getMapValueList(transIdMap);
            Map<String, String> erecIdMap = this.getErecIdMapByTransIds(ctx, transDetailIdList);
            return EreceiptBillHelper.getIdMapByBillIds(transIdMap, erecIdMap);
        }
        return new HashMap<String, List<String>>();
    }

    public abstract Map<String, List<String>> getDetailIdMapByBillIdList(Context var1, List<String> var2, boolean var3) throws BOSException, EASBizException;

    public List<byte[]> getPDFMapByErecIds(Context ctx, List erecIdList, Map sortIems) throws BOSException, EASBizException {
        return this.detailService.getPDFMapByErecIds(ctx, erecIdList, sortIems);
    }

    public Map<String, byte[]> getPDFMapByErecIds(Context ctx, List erecIdList, EreceiptTypeEnum type) throws BOSException, EASBizException {
        return this.detailService.getPDFMapByErecIds(ctx, erecIdList, type);
    }

    public Map<String, List<byte[]>> getInnerPDFMap(Context ctx, List billIdList, boolean isPrint) throws BOSException, EASBizException {
        Map<String, List<String>> idMap = this.getInnerErecIdMap(ctx, billIdList, isPrint);
        List<String> erecIdList = EreceiptBillHelper.getMapValueList(idMap);
        Map<String, byte[]> pdfMapByErec = this.getPDFMapByErecIds(ctx, erecIdList, EreceiptTypeEnum.INNER);
        return EreceiptBillHelper.getPDFMap(idMap, pdfMapByErec);
    }

    public Map<String, List<String>> getInnerErecIdMap(Context ctx, List billIdList, boolean isPrint) throws BOSException, EASBizException {
        return this.getInnerErecIdMapByBillIds(ctx, billIdList, isPrint);
    }

    public abstract Map<String, List<String>> getInnerErecIdMapByBillIds(Context var1, List<String> var2, boolean var3) throws BOSException, EASBizException;
}

