/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.erec.app.service;

import com.enterprisedt.util.debug.Logger;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.EReceiptCollection;
import com.kingdee.eas.fm.be.EReceiptFactory;
import com.kingdee.eas.fm.be.EReceiptInfo;
import com.kingdee.eas.fm.be.EReceiptLogTypeEnum;
import com.kingdee.eas.fm.be.LevelEnum;
import com.kingdee.eas.fm.be.app.EReceiptCloundDriveUtils;
import com.kingdee.eas.fm.be.app.util.KingDeeCloundDriveApiUtils;
import com.kingdee.eas.fm.erec.EreceiptTypeEnum;
import com.kingdee.eas.fm.erec.app.service.EreceiptBatchService;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DriveEreceiptBatchService
extends EreceiptBatchService {
    private static Logger logger = Logger.getLogger((String)DriveEreceiptBatchService.class.getName());

    @Override
    protected Map<String, byte[]> getBatchStorePDFMap(Context ctx, List idList) throws BOSException, EASBizException {
        byte[] fileValue = null;
        HashMap<String, byte[]> pdfMap = new HashMap<String, byte[]>();
        EReceiptCollection coll = this.getEreceiptColl(ctx, idList);
        try {
            for (int i = 0; i < coll.size(); ++i) {
                EReceiptInfo info = coll.get(i);
                logger.error("\u7535\u5b50\u56de\u5355\u6570\u636e " + info.getFileId() + "\u4e3a\u6570\u636e\u5b58\u653e\u5728\u91d1\u8776\u4e91\u76d8  ");
                fileValue = KingDeeCloundDriveApiUtils.getFileValue((String)info.getFileId(), (String)this.storageSetting.getOrgAccessToken(), (String)this.eReceiptStorageSettingInfo.getDriveUserId());
                pdfMap.put(info.getId().toString(), fileValue);
                logger.error(info.getFileId() + "\u4e91\u76d8\u8fd4\u56de\u7535\u5b50\u56de\u5355PDF\u6d41  \u5b8c\u6210 ,\u83b7\u53d6\u5230PDF\u5927\u5c0f\u4e3a\uff1a " + fileValue.length);
            }
            return pdfMap;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private EReceiptCollection getEreceiptColl(Context ctx, List idList) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("fileId"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(sic);
        return EReceiptFactory.getLocalInstance((Context)ctx).getEReceiptCollection(view);
    }

    @Override
    public void batchSavePDFs(Context ctx, EReceiptCollection coll) throws BOSException, EASBizException {
    }

    @Override
    protected Map<String, byte[]> getBatchStorePDFMap(Context ctx, List idList, EreceiptTypeEnum type) throws BOSException, EASBizException {
        byte[] fileValue = null;
        HashMap<String, byte[]> pdfMap = new HashMap<String, byte[]>();
        EReceiptCollection coll = this.getEreceiptColl(ctx, idList);
        try {
            for (int i = 0; i < coll.size(); ++i) {
                EReceiptInfo info = coll.get(i);
                logger.error("\u7535\u5b50\u56de\u5355\u6570\u636e " + info.getFileId() + "\u4e3a\u6570\u636e\u5b58\u653e\u5728\u91d1\u8776\u4e91\u76d8  ");
                fileValue = KingDeeCloundDriveApiUtils.getFileValue((String)info.getFileId(), (String)this.storageSetting.getOrgAccessToken(), (String)this.eReceiptStorageSettingInfo.getDriveUserId());
                pdfMap.put(info.getId().toString(), fileValue);
                logger.error(info.getFileId() + "\u4e91\u76d8\u8fd4\u56de\u7535\u5b50\u56de\u5355PDF\u6d41  \u5b8c\u6210 ,\u83b7\u53d6\u5230PDF\u5927\u5c0f\u4e3a\uff1a " + fileValue.length);
            }
            return pdfMap;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected CoreBaseCollection upLoadPDFs(Context ctx, EReceiptCollection coll, EreceiptTypeEnum type) throws BOSException, EASBizException {
        return this.upLoadToDrive(ctx, coll);
    }

    private CoreBaseCollection upLoadToDrive(Context ctx, EReceiptCollection coll) throws BOSException, EASBizException, BEException {
        CoreBaseCollection savedColl = new CoreBaseCollection();
        for (int i = 0; i < coll.size(); ++i) {
            EReceiptInfo eReceiptInfo = coll.get(i);
            try {
                String fileId = EReceiptCloundDriveUtils.uploadFileToDrive((Context)ctx, (EReceiptInfo)eReceiptInfo, (String)this.storageSetting.getOrgAccessToken(), (String)this.storageSetting.getStorageSettingInfo().getDriveUserId(), (Map)this.storageSetting.getFolderIdMap());
                logger.error("\u4e0a\u4f20PDF \u5230\u91d1\u8776\u4e91\u76d8  ok,\u6587\u4ef6id\u4e3a\uff1a" + fileId);
                if (fileId == null) {
                    throw new BOSException("\u4e0a\u4f20\u6587\u4ef6\u5230\u4e91\u76d8\uff0c\u8fd4\u56de\u6587\u4ef6id\u4e3a null\uff01");
                }
                logger.error("\u66f4\u65b0\u4e91\u76d8\u6587\u4ef6Id\u5230\u6570\u636e\u5e93  start");
                eReceiptInfo.setFileId(fileId);
                eReceiptInfo.setFileSource("0");
                savedColl.add((CoreBaseInfo)eReceiptInfo);
                logger.error("\u66f4\u65b0\u4e91\u76d8\u6587\u4ef6Id\u5230\u6570\u636e\u5e93  ok");
                continue;
            }
            catch (Exception e) {
                eReceiptLogUtils.addReceiptLog(ctx, eReceiptInfo.getBankNumber(), eReceiptInfo.getTransDate(), "\u4e0a\u4f20\u56de\u5355PDF\u5230\u4e91\u76d8\u5f02\u5e38\uff01", "\u8bf7\u5728web\u9875\u9762\u3010\u7535\u5b50\u56de\u5355\u5b58\u50a8\u8bbe\u7f6e\u3011\u6d4b\u8bd5\u4e91\u76d8\u8fde\u63a5\u662f\u5426\u6b63\u5e38  \u6216  \u8054\u7cfb\u73b0\u573a\u5b9e\u65bd", e.getMessage(), EReceiptLogTypeEnum.DOWNPDF, LevelEnum.ERROR);
                e.printStackTrace();
            }
        }
        return savedColl;
    }
}

