/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.erec.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.EReceiptCollection;
import com.kingdee.eas.fm.be.EReceiptFactory;
import com.kingdee.eas.fm.be.EReceiptInfo;
import com.kingdee.eas.fm.be.EReceiptStorageSettingInfo;
import com.kingdee.eas.fm.be.StorageSettingInstance;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.erec.EreceiptTypeEnum;
import com.kingdee.eas.fm.erec.SortItem;
import com.kingdee.eas.fm.erec.app.service.IEreceiptBatchService;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.util.ofd.OfdUtil;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class EreceiptBatchService
implements IEreceiptBatchService {
    private static Logger logger = Logger.getLogger((String)EreceiptBatchService.class.getName());
    protected Context ctx;
    private final String EAS_HOME = System.getProperty("EAS_HOME");
    private final String EAS_WEB_TMP_PATH = this.EAS_HOME + File.separator + "server" + File.separator + "deploy" + File.separator + "easweb.ear" + File.separator + "tmp";
    EReceiptStorageSettingInfo eReceiptStorageSettingInfo;
    StorageSettingInstance storageSetting;

    @Override
    public void initService(Context ctx) throws BOSException, EASBizException {
        logger.error((Object)"---------\u5f00\u59cb\u3010\u521d\u59cb\u5316\u3011\u57fa\u7840\u7535\u5b50\u56de\u5355\u5b58\u50a8\u8bbe\u7f6e\u6570\u636e--------------");
        this.ctx = ctx;
        try {
            StorageSettingInstance.init((Context)ctx);
            this.storageSetting = StorageSettingInstance.getInstance((Context)ctx);
            logger.error((Object)"-----------\u521d\u59cb\u5316\u57fa\u7840\u7535\u5b50\u56de\u5355\u5b58\u50a8\u8bbe\u7f6e\u6570\u636e------------");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        this.eReceiptStorageSettingInfo = this.storageSetting.getStorageSettingInfo();
        if (this.eReceiptStorageSettingInfo == null) {
            throw new BOSException("\u8bf7\u7ef4\u62a4 \u7535\u5b50\u56de\u5355 \u5b58\u50a8\u8bbe\u7f6e\u6570\u636e\uff01");
        }
    }

    private EReceiptCollection getEreceiptColl(Context ctx, List idList) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("fileId"));
        sic.add(new SelectorItemInfo("fileSource"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("fileValue"));
        sic.add(new SelectorItemInfo("fileName"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.list2Set((List)idList), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(sic);
        logger.error((Object)("\u7535\u5b50\u56de\u5355\u6253\u5370\u6216\u67e5\u770bSQL \uff1a " + view.toString()));
        return EReceiptFactory.getLocalInstance((Context)ctx).getEReceiptCollection(view);
    }

    private EReceiptCollection getEreceiptColl(Context ctx, List idList, Map sortIems) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("fileId"));
        sic.add(new SelectorItemInfo("fileSource"));
        sic.add(new SelectorItemInfo("fileValue"));
        sic.add(new SelectorItemInfo("fileName"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("transDate"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("explanation"));
        sic.add(new SelectorItemInfo("bizType"));
        sic.add(new SelectorItemInfo("billNumber"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("bankAccount.bankAccountNumber"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.list2Set((List)idList), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(sic);
        if (!EmptyUtil.isEmpty(sortIems.get("sortItems"))) {
            SorterItemCollection sorter = new SorterItemCollection();
            SortItem[] sortItems = (SortItem[])sortIems.get("sortItems");
            for (int i = 0; i < sortItems.length; ++i) {
                if (EmptyUtil.isEmpty((String)sortItems[i].getFiled())) continue;
                SorterItemInfo sorterItem = new SorterItemInfo(sortItems[i].getFiled());
                sorterItem.setSortType(sortItems[i].getSortType());
                sorter.add(sorterItem);
            }
            view.setSorter(sorter);
        }
        logger.error((Object)("\u7535\u5b50\u56de\u5355\u6253\u5370\u6216\u67e5\u770bSQL \uff1a " + view.toString()));
        return EReceiptFactory.getLocalInstance((Context)ctx).getEReceiptCollection(view);
    }

    public Map<String, byte[]> getPdfMapsByErecIds(Context ctx, List erecIdList) throws BOSException, EASBizException {
        byte[] str;
        HashMap<String, byte[]> pdfMap = new HashMap<String, byte[]>();
        logger.info((Object)"\u5df2\u7ecf\u83b7\u53d6\u5230\u7535\u5b50\u56de\u5355id\u96c6\u5408\uff0c\u6839\u636e\u7535\u5b50\u56de\u5355Id\u96c6\u5408\u83b7\u53d6\u56de\u5355PDFvalue");
        EReceiptCollection coll = this.getEreceiptColl(ctx, erecIdList);
        ArrayList<String> storeList = new ArrayList<String>();
        ArrayList<String> localList = new ArrayList<String>();
        ArrayList<String> noDownList = new ArrayList<String>();
        HashMap<String, String> imageMap = new HashMap<String, String>();
        HashMap<String, String> ofdMap = new HashMap<String, String>();
        for (int i = 0; i < coll.size(); ++i) {
            String fileType;
            String[] strSplit;
            String fileName;
            EReceiptInfo info = coll.get(i);
            if (info.getFileSource().equals("1") || info.getFileSource().equals("2")) {
                storeList.add(info.getId().toString());
                fileName = info.getFileName();
                strSplit = fileName.split("\\.");
                fileType = strSplit[strSplit.length - 1];
                if (fileType.equals("jpg") || fileType.equals("png") || fileType.equals("bmp") || fileType.equals("jpeg")) {
                    logger.error((Object)("**********the ereceipt is ." + fileType + " ; filename is " + fileName + " ; start convert"));
                    imageMap.put(info.getId().toString(), fileName);
                    continue;
                }
                if (!fileType.equals("ofd")) continue;
                logger.error((Object)("**********the ereceipt is ." + fileType + " ; filename is " + fileName + " ; start convert"));
                ofdMap.put(info.getId().toString(), fileName);
                continue;
            }
            if (info.getFileSource().equals("0")) {
                fileName = info.getFileName();
                strSplit = fileName.split("\\.");
                fileType = strSplit[strSplit.length - 1];
                if (fileType.equals("jpg") || fileType.equals("png") || fileType.equals("bmp") || fileType.equals("jpeg")) {
                    logger.error((Object)("**********the ereceipt is ." + fileType + " ; filename is " + fileName + " ; start convert"));
                    pdfMap.put(info.getId().toString(), this.convertImageToPdfByte(fileName, info.getFileValue()));
                    continue;
                }
                if (fileType.equals("ofd")) {
                    logger.error((Object)("**********the ereceipt is ." + fileType + " ; filename is " + fileName + " ; start convert"));
                    pdfMap.put(info.getId().toString(), info.getFileValue());
                    continue;
                }
                pdfMap.put(info.getId().toString(), info.getFileValue());
                continue;
            }
            if (info.getFileSource().equals("4")) {
                localList.add(info.getId().toString());
                fileName = info.getFileName();
                strSplit = fileName.split("\\.");
                fileType = strSplit[strSplit.length - 1];
                if (fileType.equals("jpg") || fileType.equals("png") || fileType.equals("bmp") || fileType.equals("jpeg")) {
                    logger.error((Object)("**********the ereceipt is ." + fileType + " ; filename is " + fileName + " ; start convert"));
                    imageMap.put(info.getId().toString(), fileName);
                    continue;
                }
                if (!fileType.equals("ofd")) continue;
                logger.error((Object)("**********the ereceipt is ." + fileType + " ; filename is " + fileName + " ; start convert"));
                ofdMap.put(info.getId().toString(), fileName);
                continue;
            }
            if (!info.getFileSource().equals("3")) continue;
            noDownList.add(info.getId().toString());
        }
        if (storeList != null && storeList.size() > 0) {
            this.initService(ctx);
            Map<String, byte[]> storePdfMap = this.getBatchStorePDFMap(ctx, storeList);
            for (String id : storePdfMap.keySet()) {
                str = storePdfMap.get(id);
                if (imageMap.containsKey(id)) {
                    str = this.convertImageToPdfByte((String)imageMap.get(id), str);
                } else if (ofdMap.containsKey(id)) {
                    str = OfdUtil.convertToPdfNew((byte[])str);
                }
                pdfMap.put(id, str);
            }
        }
        if (localList != null && localList.size() > 0) {
            logger.error((Object)("-------------\u7535\u5b50\u56de\u5355\u5e93\u5b58\u50a8\u7684\u6587\u4ef6\u6570\u4e3a\uff1a" + localList.size()));
            this.initService(ctx);
            Map<String, byte[]> storePdfMap = this.getBatchStorePDFMap(ctx, localList);
            logger.error((Object)("-------------\u4ece\u56de\u5355\u5e93\u83b7\u53d6\u7684\u7535\u5b50\u56de\u5355\u6587\u4ef6\u6570\u91cf\uff1a" + storePdfMap.size()));
            for (String id : storePdfMap.keySet()) {
                str = storePdfMap.get(id);
                if (imageMap.containsKey(id)) {
                    str = this.convertImageToPdfByte((String)imageMap.get(id), str);
                } else if (ofdMap.containsKey(id)) {
                    // empty if block
                }
                pdfMap.put(id, str);
            }
        }
        logger.error((Object)("\u56de\u5355PDF\u6587\u4ef6\u6570\u91cf\uff1a" + pdfMap.size()));
        return pdfMap;
    }

    public Map<String, byte[]> getPdfMapsByErecIds(Context ctx, List erecIdList, boolean isConvertPDF) throws BOSException, EASBizException {
        byte[] str;
        HashMap<String, byte[]> pdfMap = new HashMap<String, byte[]>();
        logger.info((Object)"\u5df2\u7ecf\u83b7\u53d6\u5230\u7535\u5b50\u56de\u5355id\u96c6\u5408\uff0c\u6839\u636e\u7535\u5b50\u56de\u5355Id\u96c6\u5408\u83b7\u53d6\u56de\u5355PDFvalue");
        EReceiptCollection coll = this.getEreceiptColl(ctx, erecIdList);
        ArrayList<String> storeList = new ArrayList<String>();
        ArrayList<String> localList = new ArrayList<String>();
        ArrayList<String> noDownList = new ArrayList<String>();
        HashMap<String, String> imageMap = new HashMap<String, String>();
        HashMap<String, String> ofdMap = new HashMap<String, String>();
        for (int i = 0; i < coll.size(); ++i) {
            String fileType;
            String[] strSplit;
            String fileName;
            EReceiptInfo info = coll.get(i);
            if (info.getFileSource().equals("1") || info.getFileSource().equals("2")) {
                storeList.add(info.getId().toString());
                fileName = info.getFileName();
                strSplit = fileName.split("\\.");
                fileType = strSplit[strSplit.length - 1];
                if (fileType.equals("jpg") || fileType.equals("png") || fileType.equals("bmp") || fileType.equals("jpeg")) {
                    logger.error((Object)("**********the ereceipt is ." + fileType + " ; filename is " + fileName + " ; start convert"));
                    imageMap.put(info.getId().toString(), fileName);
                    continue;
                }
                if (!fileType.equals("ofd")) continue;
                ofdMap.put(info.getId().toString(), fileName);
                continue;
            }
            if (info.getFileSource().equals("0")) {
                fileName = info.getFileName();
                strSplit = fileName.split("\\.");
                fileType = strSplit[strSplit.length - 1];
                if (fileType.equals("jpg") || fileType.equals("png") || fileType.equals("bmp") || fileType.equals("jpeg")) {
                    logger.error((Object)("**********the ereceipt is ." + fileType + " ; filename is " + fileName + " ; start convert"));
                    pdfMap.put(info.getId().toString(), this.convertImageToPdfByte(fileName, info.getFileValue()));
                    continue;
                }
                if (fileType.equals("ofd")) {
                    if (!isConvertPDF) {
                        pdfMap.put(info.getId().toString(), info.getFileValue());
                        continue;
                    }
                    pdfMap.put(info.getId().toString(), OfdUtil.convertToPdfNew((byte[])info.getFileValue()));
                    continue;
                }
                pdfMap.put(info.getId().toString(), info.getFileValue());
                continue;
            }
            if (info.getFileSource().equals("4")) {
                localList.add(info.getId().toString());
                fileName = info.getFileName();
                strSplit = fileName.split("\\.");
                fileType = strSplit[strSplit.length - 1];
                if (fileType.equals("jpg") || fileType.equals("png") || fileType.equals("bmp") || fileType.equals("jpeg")) {
                    logger.error((Object)("**********the ereceipt is ." + fileType + " ; filename is " + fileName + " ; start convert"));
                    imageMap.put(info.getId().toString(), fileName);
                    continue;
                }
                if (!fileType.equals("ofd")) continue;
                logger.error((Object)("**********the ereceipt is ." + fileType + " ; filename is " + fileName + " ; start convert"));
                ofdMap.put(info.getId().toString(), fileName);
                continue;
            }
            if (!info.getFileSource().equals("3")) continue;
            noDownList.add(info.getId().toString());
        }
        if (storeList != null && storeList.size() > 0) {
            this.initService(ctx);
            Map<String, byte[]> storePdfMap = this.getBatchStorePDFMap(ctx, storeList);
            for (String id : storePdfMap.keySet()) {
                str = storePdfMap.get(id);
                if (imageMap.containsKey(id)) {
                    str = this.convertImageToPdfByte((String)imageMap.get(id), str);
                } else if (ofdMap.containsKey(id) && isConvertPDF) {
                    str = OfdUtil.convertToPdfNew((byte[])str);
                }
                pdfMap.put(id, str);
            }
        }
        if (localList != null && localList.size() > 0) {
            logger.error((Object)("-------------\u7535\u5b50\u56de\u5355\u5e93\u5b58\u50a8\u7684\u6587\u4ef6\u6570\u4e3a\uff1a" + localList.size()));
            this.initService(ctx);
            Map<String, byte[]> storePdfMap = this.getBatchStorePDFMap(ctx, localList);
            logger.error((Object)("-------------\u4ece\u56de\u5355\u5e93\u83b7\u53d6\u7684\u7535\u5b50\u56de\u5355\u6587\u4ef6\u6570\u91cf\uff1a" + storePdfMap.size()));
            for (String id : storePdfMap.keySet()) {
                str = storePdfMap.get(id);
                if (imageMap.containsKey(id)) {
                    str = this.convertImageToPdfByte((String)imageMap.get(id), str);
                } else if (isConvertPDF && ofdMap.containsKey(id)) {
                    str = OfdUtil.convertToPdfNew((byte[])str);
                }
                pdfMap.put(id, str);
            }
        }
        logger.error((Object)("\u56de\u5355PDF\u6587\u4ef6\u6570\u91cf\uff1a" + pdfMap.keySet() != null ? pdfMap.keySet().size() : 0));
        return pdfMap;
    }

    public List<byte[]> getPdfMapsByErecIds(Context ctx, List erecIdList, Map sortIems) throws BOSException, EASBizException {
        byte[] str;
        logger.info((Object)"\u5df2\u7ecf\u83b7\u53d6\u5230\u7535\u5b50\u56de\u5355id\u96c6\u5408\uff0c\u6839\u636e\u7535\u5b50\u56de\u5355Id\u96c6\u5408\u83b7\u53d6\u56de\u5355PDFvalue");
        EReceiptCollection coll = this.getEreceiptColl(ctx, erecIdList, sortIems);
        ArrayList<String> storeList = new ArrayList<String>();
        ArrayList<String> localList = new ArrayList<String>();
        ArrayList<String> noDownList = new ArrayList<String>();
        HashMap<String, String> imageMap = new HashMap<String, String>();
        HashMap<String, String> ofdMap = new HashMap<String, String>();
        HashMap<String, byte[]> pdfMap = new HashMap<String, byte[]>();
        ArrayList<String> downloadList = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            String fileType;
            String[] strSplit;
            String fileName;
            EReceiptInfo info = coll.get(i);
            if (info.getFileSource().equals("1") || info.getFileSource().equals("2")) {
                storeList.add(info.getId().toString());
                downloadList.add(info.getId().toString());
                fileName = info.getFileName();
                strSplit = fileName.split("\\.");
                fileType = strSplit[strSplit.length - 1];
                if (fileType.equals("jpg") || fileType.equals("png") || fileType.equals("bmp") || fileType.equals("jpeg")) {
                    logger.error((Object)("**********the ereceipt is ." + fileType + " ; filename is " + fileName + " ; start convert"));
                    imageMap.put(info.getId().toString(), fileName);
                    continue;
                }
                if (!fileType.equals("ofd")) continue;
                ofdMap.put(info.getId().toString(), fileName);
                continue;
            }
            if (info.getFileSource().equals("0")) {
                downloadList.add(info.getId().toString());
                fileName = info.getFileName();
                strSplit = fileName.split("\\.");
                fileType = strSplit[strSplit.length - 1];
                if (fileType.equals("jpg") || fileType.equals("png") || fileType.equals("bmp") || fileType.equals("jpeg")) {
                    logger.error((Object)("**********the ereceipt is ." + fileType + " ; filename is " + fileName + " ; start convert"));
                    pdfMap.put(info.getId().toString(), this.convertImageToPdfByte(fileName, info.getFileValue()));
                    continue;
                }
                if (fileType.equals("ofd")) {
                    pdfMap.put(info.getId().toString(), OfdUtil.convertToPdfNew((byte[])info.getFileValue()));
                    continue;
                }
                pdfMap.put(info.getId().toString(), info.getFileValue());
                continue;
            }
            if (info.getFileSource().equals("4")) {
                localList.add(info.getId().toString());
                downloadList.add(info.getId().toString());
                fileName = info.getFileName();
                strSplit = fileName.split("\\.");
                fileType = strSplit[strSplit.length - 1];
                if (fileType.equals("jpg") || fileType.equals("png") || fileType.equals("bmp") || fileType.equals("jpeg")) {
                    logger.error((Object)("**********the ereceipt is ." + fileType + " ; filename is " + fileName + " ; start convert"));
                    imageMap.put(info.getId().toString(), fileName);
                    continue;
                }
                if (!fileType.equals("ofd")) continue;
                logger.error((Object)("**********the ereceipt is ." + fileType + " ; filename is " + fileName + " ; start convert"));
                ofdMap.put(info.getId().toString(), fileName);
                continue;
            }
            if (!info.getFileSource().equals("3")) continue;
            noDownList.add(info.getId().toString());
        }
        if (storeList != null && storeList.size() > 0) {
            this.initService(ctx);
            Map<String, byte[]> storePdfMap = this.getBatchStorePDFMap(ctx, storeList);
            for (String id : storePdfMap.keySet()) {
                str = storePdfMap.get(id);
                if (imageMap.containsKey(id)) {
                    str = this.convertImageToPdfByte((String)imageMap.get(id), str);
                } else if (ofdMap.containsKey(id)) {
                    str = OfdUtil.convertToPdfNew((byte[])str);
                }
                pdfMap.put(id, str);
            }
        }
        if (localList != null && localList.size() > 0) {
            logger.error((Object)("-------------\u7535\u5b50\u56de\u5355\u5e93\u5b58\u50a8\u7684\u6587\u4ef6\u6570\u4e3a\uff1a" + localList.size()));
            this.initService(ctx);
            Map<String, byte[]> storePdfMap = this.getBatchStorePDFMap(ctx, localList);
            logger.error((Object)("-------------\u4ece\u56de\u5355\u5e93\u83b7\u53d6\u7684\u7535\u5b50\u56de\u5355\u6587\u4ef6\u6570\u91cf\uff1a" + storePdfMap.size()));
            for (String id : storePdfMap.keySet()) {
                str = storePdfMap.get(id);
                if (imageMap.containsKey(id)) {
                    str = this.convertImageToPdfByte((String)imageMap.get(id), str);
                } else if (ofdMap.containsKey(id)) {
                    str = OfdUtil.convertToPdfNew((byte[])str);
                }
                pdfMap.put(id, str);
            }
        }
        ArrayList<byte[]> pdfList = new ArrayList<byte[]>();
        for (int i = 0; i < downloadList.size(); ++i) {
            String id;
            id = (String)downloadList.get(i);
            if (EmptyUtil.isEmpty((String)id) || !pdfMap.containsKey(id)) continue;
            pdfList.add((byte[])pdfMap.get(id));
        }
        pdfMap = null;
        logger.error((Object)("\u56de\u5355PDF\u6587\u4ef6\u6570\u91cf\uff1a" + pdfList.size()));
        return pdfList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] convertImageToPdfByte(String payNumber, byte[] imageData) throws BOSException {
        logger.error((Object)"**********convertImageToPdfByte start **********");
        String pdfFilePath = this.convertImageToPdf(payNumber, imageData);
        File file = new File(pdfFilePath);
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)file.length());
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            byte[] b = new byte[1024];
            int len = -1;
            while ((len = fis.read(b)) != -1) {
                bos.write(b, 0, len);
            }
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                EreceiptBatchService.closeInputStream(fis);
                EreceiptBatchService.closeOutStream(bos);
                EreceiptBatchService.delFile(file);
                throw throwable;
            }
            EreceiptBatchService.closeInputStream(fis);
            EreceiptBatchService.closeOutStream(bos);
            EreceiptBatchService.delFile(file);
        }
        EreceiptBatchService.closeInputStream(fis);
        EreceiptBatchService.closeOutStream(bos);
        EreceiptBatchService.delFile(file);
        logger.error((Object)"**********convertImageToPdfByte end **********");
        return bos.toByteArray();
    }

    private static void closeInputStream(FileInputStream fis) throws BOSException {
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new BOSException(e.getMessage());
            }
        }
    }

    private static void closeOutStream(OutputStream fos) throws BOSException {
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new BOSException(e.getMessage());
            }
        }
    }

    public static void delFile(File file) {
        if (!file.exists()) {
            System.out.println("the file " + file.getName() + " is not exist !");
            return;
        }
        boolean rs = file.delete();
        if (rs) {
            System.out.println("the file " + file.getName() + " has been deleted !");
        } else {
            System.out.println("the file " + file.getName() + " delete failed !");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertImageToPdf(String payNumber, byte[] imageData) throws BOSException {
        logger.error((Object)"**********convertImageToPdf start **********");
        String pdfFilePath = this.assemblePDFFile(payNumber);
        logger.error((Object)("**********pdfFilePath is :" + pdfFilePath));
        Document document = new Document(PageSize.A4);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(pdfFilePath);
            PdfWriter.getInstance((Document)document, (OutputStream)fileOutputStream);
            document.open();
            Image image = Image.getInstance((byte[])imageData);
            float heigth = image.getHeight();
            float width = image.getWidth();
            int percent = EreceiptBatchService.getPercent(heigth, width);
            image.setAlignment(1);
            image.scalePercent((float)(percent + 3));
            document.add((Element)image);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            document.close();
            EreceiptBatchService.closeOutStream(fileOutputStream);
        }
        logger.error((Object)"**********convertImageToPdf end **********");
        return pdfFilePath;
    }

    public static int getPercent(float h, float w) {
        int p = 0;
        float p2 = 0.0f;
        p2 = 530.0f / w * 100.0f;
        p = Math.round(p2);
        return p;
    }

    private String assemblePDFFile(String payNumber) {
        String pattern = "{0}{1}{2}";
        return MessageFormat.format(pattern, this.getTempFilePath(), payNumber, ".pdf");
    }

    private String getTempFilePath() {
        return this.EAS_WEB_TMP_PATH;
    }

    @Override
    public List<byte[]> getPDFsByErecIds(Context ctx, List erecIdList) throws BOSException, EASBizException {
        ArrayList<byte[]> pdfs = new ArrayList<byte[]>();
        Map<String, byte[]> pdfMap = this.getPdfMapsByErecIds(ctx, erecIdList);
        if (pdfMap != null && !pdfMap.isEmpty()) {
            Iterator<String> it = pdfMap.keySet().iterator();
            while (it.hasNext()) {
                pdfs.add(pdfMap.get(it.next()));
            }
        }
        return pdfs;
    }

    @Override
    public Map<String, byte[]> getPDFMapByErecIds(Context ctx, List erecIdList) throws BOSException, EASBizException {
        return this.getPdfMapsByErecIds(ctx, erecIdList);
    }

    @Override
    public List<byte[]> getPDFMapByErecIds(Context ctx, List erecIdList, Map sortIems) throws BOSException, EASBizException {
        return this.getPdfMapsByErecIds(ctx, erecIdList, sortIems);
    }

    @Override
    public Map<String, byte[]> getPDFMapByErecIds(Context ctx, List erecIdList, boolean isConvertPDF) throws BOSException, EASBizException {
        return this.getPdfMapsByErecIds(ctx, erecIdList, isConvertPDF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws BOSException {
        System.out.println("===");
        logger.error((Object)"**********convertImageToPdf start **********");
        byte[] imageData = EreceiptBatchService.getBytes("d:/test.jpg");
        Document document = new Document(PageSize.A4);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream("d:/test5.pdf");
            PdfWriter.getInstance((Document)document, (OutputStream)fileOutputStream);
            document.open();
            Image image = Image.getInstance((byte[])imageData);
            float heigth = image.getHeight();
            float width = image.getWidth();
            float scalePercentage = 60.000004f;
            image.scalePercent(scalePercentage, scalePercentage);
            document.add((Element)image);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            document.close();
            EreceiptBatchService.closeOutStream(fileOutputStream);
        }
    }

    private static byte[] getBytes(String filePath) {
        byte[] buffer = null;
        try {
            int n;
            File file = new File(filePath);
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    @Override
    public Map<String, byte[]> getPDFMapByErecIds(Context ctx, List erecIdList, EreceiptTypeEnum type) throws BOSException, EASBizException {
        return this.getPdfMapsByErecIds(ctx, erecIdList, type);
    }

    @Override
    public List<byte[]> getPDFMapByErecIds(Context ctx, List erecIdList, Map sortIems, EreceiptTypeEnum type) throws BOSException, EASBizException {
        return this.getPdfMapsByErecIds(ctx, erecIdList, sortIems, type);
    }

    public Map<String, byte[]> getPdfMapsByErecIds(Context ctx, List erecIdList, EreceiptTypeEnum type) throws BOSException, EASBizException {
        byte[] str;
        HashMap<String, byte[]> pdfMap = new HashMap<String, byte[]>();
        logger.info((Object)"\u5df2\u7ecf\u83b7\u53d6\u5230\u7535\u5b50\u56de\u5355id\u96c6\u5408\uff0c\u6839\u636e\u7535\u5b50\u56de\u5355Id\u96c6\u5408\u83b7\u53d6\u56de\u5355PDFvalue");
        EReceiptCollection coll = this.getEreceiptColl(ctx, erecIdList);
        ArrayList<String> storeList = new ArrayList<String>();
        ArrayList<String> localList = new ArrayList<String>();
        ArrayList<String> noDownList = new ArrayList<String>();
        HashMap<String, String> imageMap = new HashMap<String, String>();
        HashMap<String, String> ofdMap = new HashMap<String, String>();
        for (int i = 0; i < coll.size(); ++i) {
            String fileType;
            String[] strSplit;
            String fileName;
            EReceiptInfo info = coll.get(i);
            if (info.getFileSource().equals("1") || info.getFileSource().equals("2")) {
                storeList.add(info.getId().toString());
                fileName = info.getFileName();
                strSplit = fileName.split("\\.");
                fileType = strSplit[strSplit.length - 1];
                if (fileType.equals("jpg") || fileType.equals("png") || fileType.equals("bmp") || fileType.equals("jpeg")) {
                    logger.error((Object)("**********the ereceipt is ." + fileType + " ; filename is " + fileName + " ; start convert"));
                    imageMap.put(info.getId().toString(), fileName);
                    continue;
                }
                if (!fileType.equals("ofd")) continue;
                logger.error((Object)("**********the ereceipt is ." + fileType + " ; filename is " + fileName + " ; start convert"));
                ofdMap.put(info.getId().toString(), fileName);
                continue;
            }
            if (info.getFileSource().equals("0")) {
                fileName = info.getFileName();
                strSplit = fileName.split("\\.");
                fileType = strSplit[strSplit.length - 1];
                if (fileType.equals("jpg") || fileType.equals("png") || fileType.equals("bmp") || fileType.equals("jpeg")) {
                    logger.error((Object)("**********the ereceipt is ." + fileType + " ; filename is " + fileName + " ; start convert"));
                    pdfMap.put(info.getId().toString(), this.convertImageToPdfByte(fileName, info.getFileValue()));
                    continue;
                }
                if (fileType.equals("ofd")) {
                    pdfMap.put(info.getId().toString(), OfdUtil.convertToPdfNew((byte[])info.getFileValue()));
                    continue;
                }
                pdfMap.put(info.getId().toString(), info.getFileValue());
                continue;
            }
            if (info.getFileSource().equals("4")) {
                localList.add(info.getId().toString());
                fileName = info.getFileName();
                strSplit = fileName.split("\\.");
                fileType = strSplit[strSplit.length - 1];
                if (fileType.equals("jpg") || fileType.equals("png") || fileType.equals("bmp") || fileType.equals("jpeg")) {
                    logger.error((Object)("**********the ereceipt is ." + fileType + " ; filename is " + fileName + " ; start convert"));
                    imageMap.put(info.getId().toString(), fileName);
                    continue;
                }
                if (!fileType.equals("ofd")) continue;
                logger.error((Object)("**********the ereceipt is ." + fileType + " ; filename is " + fileName + " ; start convert"));
                ofdMap.put(info.getId().toString(), fileName);
                continue;
            }
            if (!info.getFileSource().equals("3")) continue;
            noDownList.add(info.getId().toString());
        }
        if (storeList != null && storeList.size() > 0) {
            this.initService(ctx);
            Map<String, byte[]> storePdfMap = this.getBatchStorePDFMap(ctx, storeList, type);
            for (String id : storePdfMap.keySet()) {
                str = storePdfMap.get(id);
                if (imageMap.containsKey(id)) {
                    str = this.convertImageToPdfByte((String)imageMap.get(id), str);
                } else if (ofdMap.containsKey(id)) {
                    str = OfdUtil.convertToPdfNew((byte[])str);
                }
                pdfMap.put(id, str);
            }
        }
        if (localList != null && localList.size() > 0) {
            logger.error((Object)("-------------\u7535\u5b50\u56de\u5355\u5e93\u5b58\u50a8\u7684\u6587\u4ef6\u6570\u4e3a\uff1a" + localList.size()));
            this.initService(ctx);
            Map<String, byte[]> storePdfMap = this.getBatchStorePDFMap(ctx, localList, type);
            logger.error((Object)("-------------\u4ece\u56de\u5355\u5e93\u83b7\u53d6\u7684\u7535\u5b50\u56de\u5355\u6587\u4ef6\u6570\u91cf\uff1a" + storePdfMap.size()));
            for (String id : storePdfMap.keySet()) {
                str = storePdfMap.get(id);
                if (imageMap.containsKey(id)) {
                    str = this.convertImageToPdfByte((String)imageMap.get(id), str);
                } else if (ofdMap.containsKey(id)) {
                    str = OfdUtil.convertToPdfNew((byte[])str);
                }
                pdfMap.put(id, str);
            }
        }
        return pdfMap;
    }

    public List<byte[]> getPdfMapsByErecIds(Context ctx, List erecIdList, Map sortIems, EreceiptTypeEnum type) throws BOSException, EASBizException {
        byte[] str;
        logger.info((Object)"\u5df2\u7ecf\u83b7\u53d6\u5230\u7535\u5b50\u56de\u5355id\u96c6\u5408\uff0c\u6839\u636e\u7535\u5b50\u56de\u5355Id\u96c6\u5408\u83b7\u53d6\u56de\u5355PDFvalue");
        EReceiptCollection coll = this.getEreceiptColl(ctx, erecIdList, sortIems);
        logger.error((Object)("-------------\u7535\u5b50\u56de\u5355\u7ed3\u6784\u5316\u6570\u636e\u6570\u91cf\u4e3a\uff1a" + coll.size()));
        ArrayList<String> storeList = new ArrayList<String>();
        ArrayList<String> localList = new ArrayList<String>();
        ArrayList<String> noDownList = new ArrayList<String>();
        HashMap<String, Iterator<String>> imageMap = new HashMap<String, Iterator<String>>();
        HashMap<String, Iterator<String>> ofdMap = new HashMap<String, Iterator<String>>();
        HashMap<String, byte[]> pdfMap = new HashMap<String, byte[]>();
        ArrayList<String> downloadList = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            String fileType;
            String[] strSplit;
            Iterator<String> fileName;
            EReceiptInfo info = coll.get(i);
            if (info.getFileSource().equals("1") || info.getFileSource().equals("2")) {
                storeList.add(info.getId().toString());
                downloadList.add(info.getId().toString());
                fileName = info.getFileName();
                strSplit = ((String)((Object)fileName)).split("\\.");
                fileType = strSplit[strSplit.length - 1];
                if (fileType.equals("jpg") || fileType.equals("png") || fileType.equals("bmp") || fileType.equals("jpeg")) {
                    logger.error((Object)("**********the ereceipt is ." + fileType + " ; filename is " + fileName + " ; start convert"));
                    imageMap.put(info.getId().toString(), fileName);
                    continue;
                }
                if (!fileType.equals("ofd")) continue;
                ofdMap.put(info.getId().toString(), fileName);
                continue;
            }
            if (info.getFileSource().equals("0")) {
                downloadList.add(info.getId().toString());
                fileName = info.getFileName();
                strSplit = ((String)((Object)fileName)).split("\\.");
                fileType = strSplit[strSplit.length - 1];
                if (fileType.equals("jpg") || fileType.equals("png") || fileType.equals("bmp") || fileType.equals("jpeg")) {
                    logger.error((Object)("**********the ereceipt is ." + fileType + " ; filename is " + fileName + " ; start convert"));
                    pdfMap.put(info.getId().toString(), this.convertImageToPdfByte((String)((Object)fileName), info.getFileValue()));
                    continue;
                }
                if (fileType.equals("ofd")) {
                    pdfMap.put(info.getId().toString(), OfdUtil.convertToPdfNew((byte[])info.getFileValue()));
                    continue;
                }
                pdfMap.put(info.getId().toString(), info.getFileValue());
                continue;
            }
            if (info.getFileSource().equals("4")) {
                localList.add(info.getId().toString());
                downloadList.add(info.getId().toString());
                fileName = info.getFileName();
                strSplit = ((String)((Object)fileName)).split("\\.");
                fileType = strSplit[strSplit.length - 1];
                if (fileType.equals("jpg") || fileType.equals("png") || fileType.equals("bmp") || fileType.equals("jpeg")) {
                    logger.error((Object)("**********the ereceipt is ." + fileType + " ; filename is " + fileName + " ; start convert"));
                    imageMap.put(info.getId().toString(), fileName);
                    continue;
                }
                if (!fileType.equals("ofd")) continue;
                logger.error((Object)("**********the ereceipt is ." + fileType + " ; filename is " + fileName + " ; start convert"));
                ofdMap.put(info.getId().toString(), fileName);
                continue;
            }
            if (!info.getFileSource().equals("3")) continue;
            noDownList.add(info.getId().toString());
        }
        if (storeList != null && storeList.size() > 0) {
            logger.error((Object)("-------------\u7535\u5b50\u56de\u5355\u5e93\u5b58\u50a8\u7684\u6587\u4ef6\u6570\u4e3a\uff1a" + storeList.size()));
            this.initService(ctx);
            Map<String, byte[]> storePdfMap = this.getBatchStorePDFMap(ctx, storeList, type);
            logger.error((Object)("-------------\u4ece\u56de\u5355\u5e93\u83b7\u53d6\u7684\u7535\u5b50\u56de\u5355\u6587\u4ef6\u6570\u91cf\uff1a" + storePdfMap.size()));
            for (String id : storePdfMap.keySet()) {
                str = storePdfMap.get(id);
                if (imageMap.containsKey(id)) {
                    str = this.convertImageToPdfByte((String)imageMap.get(id), str);
                } else if (ofdMap.containsKey(id)) {
                    str = OfdUtil.convertToPdfNew((byte[])str);
                }
                pdfMap.put(id, str);
            }
        }
        if (localList != null && localList.size() > 0) {
            logger.error((Object)("-------------\u7535\u5b50\u56de\u5355\u5e93\u5b58\u50a8\u7684\u6587\u4ef6\u6570\u4e3a\uff1a" + localList.size()));
            this.initService(ctx);
            Map<String, byte[]> storePdfMap = this.getBatchStorePDFMap(ctx, localList, type);
            logger.error((Object)("-------------\u4ece\u56de\u5355\u5e93\u83b7\u53d6\u7684\u7535\u5b50\u56de\u5355\u6587\u4ef6\u6570\u91cf\uff1a" + storePdfMap.size()));
            for (String id : storePdfMap.keySet()) {
                str = storePdfMap.get(id);
                if (imageMap.containsKey(id)) {
                    str = this.convertImageToPdfByte((String)imageMap.get(id), str);
                } else if (ofdMap.containsKey(id)) {
                    str = OfdUtil.convertToPdfNew((byte[])str);
                }
                pdfMap.put(id, str);
            }
        }
        ArrayList<byte[]> pdfList = new ArrayList<byte[]>();
        for (int i = 0; i < downloadList.size(); ++i) {
            String id;
            id = (String)downloadList.get(i);
            if (EmptyUtil.isEmpty((String)id) || !pdfMap.containsKey(id)) continue;
            pdfList.add((byte[])pdfMap.get(id));
        }
        pdfMap = null;
        logger.error((Object)("-------------\u7535\u5b50\u56de\u5355PDF\u6587\u4ef6\u6570\u4e3a\uff1a" + pdfList.size()));
        return pdfList;
    }

    protected abstract Map<String, byte[]> getBatchStorePDFMap(Context var1, List var2, EreceiptTypeEnum var3) throws BOSException, EASBizException;

    protected abstract Map<String, byte[]> getBatchStorePDFMap(Context var1, List var2) throws BOSException, EASBizException;

    @Override
    public void batchSavePDFs(Context ctx, EReceiptCollection coll, EreceiptTypeEnum type) throws BOSException, EASBizException {
        this.initService(ctx);
        CoreBaseCollection savedColl = this.upLoadPDFs(ctx, coll, type);
        EReceiptFactory.getLocalInstance((Context)ctx).saveBatchData(savedColl);
    }

    protected abstract CoreBaseCollection upLoadPDFs(Context var1, EReceiptCollection var2, EreceiptTypeEnum var3) throws BOSException, EASBizException;
}

