/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.erec.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.erec.app.service.EreceiptServiceBillType;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.fm.fs.TransDownBillCollection;
import com.kingdee.eas.fm.fs.TransDownBillFactory;
import com.kingdee.eas.fm.fs.TransDownBillInfo;
import com.kingdee.eas.fm.fs.TransUpBillCollection;
import com.kingdee.eas.fm.fs.TransUpBillFactory;
import com.kingdee.eas.fm.fs.TransUpBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class EreceiptBillHelper {
    public static Map getSrcIdsByDestIds(Context ctx, List destObjectIds, String srcBosType, String destBosType) throws BOSException {
        HashMap<String, List> map = new HashMap<String, List>();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)FMHelper.list2Set((List)destObjectIds), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)destBosType));
        filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)srcBosType));
        viewInfo.setFilter(filter);
        ArrayList<String> srcIds = new ArrayList<String>();
        ArrayList<String> destIds = new ArrayList<String>();
        List leftDestIds = destObjectIds;
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.bos.metadata.bot.app.BotRelationQuery"));
        exec.setObjectView(viewInfo);
        try {
            IRowSet rs = exec.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    destIds.add(rs.getString("destObjectID"));
                    leftDestIds.remove(rs.getString("destObjectID"));
                    srcIds.add(rs.getString("srcObjectID"));
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        map.put("destObjectID", destIds);
        map.put("srcObjectID", srcIds);
        map.put("leftDestObjectID", leftDestIds);
        return map;
    }

    public static Map<String, List<String>> getTransIdsByBankCheckFlag(Context ctx, List leftBillIds, String table, String column) throws BOSException {
        HashMap<String, List<String>> billIdMap = new HashMap<String, List<String>>();
        ArrayList leftIdList = new ArrayList();
        String sql = "SELECT PAY.FID BILLID, DETAIL.FID DETAILID FROM " + table + " PAY, T_BE_TRANSDETAIL DETAIL WHERE PAY." + column + " = DETAIL.FBANKCHECKFLAG AND PAY.FID IN " + FMHelper.setTran2String((Set)FMHelper.list2Set((List)leftBillIds));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList payIdList = new ArrayList();
        ArrayList detailIdList = new ArrayList();
        try {
            while (rs.next()) {
                String billId = rs.getString("BILLID");
                String detailId = rs.getString("DETAILID");
                EreceiptBillHelper.putIdMap(billIdMap, billId, detailId);
            }
            return billIdMap;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static Vector<String> getDestBillIdsBySrcIds(Context ctx, List srcIdList, String srcBosType, String destBosType) throws BOSException {
        EntityViewInfo viewInfo = EreceiptBillHelper.getEntityViewInfoBySrcIds(srcIdList, srcBosType, destBosType);
        Vector<String> relateBills = new Vector<String>();
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.bos.metadata.bot.app.BotRelationQuery"));
        exec.setObjectView(viewInfo);
        try {
            IRowSet rs = exec.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    relateBills.add(rs.getString("destObjectId"));
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return relateBills;
    }

    public static Map<String, List<String>> getSrcIdMapBySrcIds(Context ctx, List srcIdList, String srcBosType, String destBosType) throws BOSException {
        HashMap<String, List<String>> srcIdMap = new HashMap<String, List<String>>();
        Vector relateBills = new Vector();
        EntityViewInfo viewInfo = EreceiptBillHelper.getEntityViewInfoBySrcIds(srcIdList, srcBosType, destBosType);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.bos.metadata.bot.app.BotRelationQuery"));
        exec.setObjectView(viewInfo);
        try {
            IRowSet rs = exec.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    String srcid = rs.getString("srcObjectId");
                    String destid = rs.getString("destObjectId");
                    EreceiptBillHelper.putIdMap(srcIdMap, srcid, destid);
                }
            }
            return srcIdMap;
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    public static Map<String, String> getDestIdMapByDestIdsForOne(Context ctx, List destIdList, String srcBosType, String destBosType) throws BOSException {
        HashMap<String, String> destIdMap = new HashMap<String, String>();
        EntityViewInfo viewInfo = EreceiptBillHelper.getEntityViewInfoByDestIds(destIdList, srcBosType, destBosType);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.bos.metadata.bot.app.BotRelationQuery"));
        exec.setObjectView(viewInfo);
        try {
            IRowSet rs = exec.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    String srcid = rs.getString("srcObjectId");
                    String destid = rs.getString("destObjectId");
                    destIdMap.put(srcid, destid);
                }
            }
            return destIdMap;
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    public static Map<String, Map<String, List<String>>> getIdMapByDestIds(Context ctx, List destIdList, String srcBosType, String destBosType) throws BOSException {
        HashMap<String, Map<String, List<String>>> result = new HashMap<String, Map<String, List<String>>>();
        HashMap<String, List<String>> destIdMap = new HashMap<String, List<String>>();
        HashMap<String, List<String>> srcIdMap = new HashMap<String, List<String>>();
        EntityViewInfo viewInfo = EreceiptBillHelper.getEntityViewInfoByDestIds(destIdList, srcBosType, destBosType);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.bos.metadata.bot.app.BotRelationQuery"));
        exec.setObjectView(viewInfo);
        try {
            IRowSet rs = exec.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    String srcid = rs.getString("srcObjectId");
                    String destid = rs.getString("destObjectId");
                    EreceiptBillHelper.putIdMap(destIdMap, destid, srcid);
                    EreceiptBillHelper.putIdMap(srcIdMap, srcid, destid);
                }
                result.put("srcIdMap", srcIdMap);
                result.put("destIdMap", destIdMap);
            }
            return result;
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    public static Map<String, List<String>> getDestIdMapByDestIds(Context ctx, List destIdList, String srcBosType, String destBosType) throws BOSException {
        HashMap<String, List<String>> destIdMap = new HashMap<String, List<String>>();
        EntityViewInfo viewInfo = EreceiptBillHelper.getEntityViewInfoByDestIds(destIdList, srcBosType, destBosType);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.bos.metadata.bot.app.BotRelationQuery"));
        exec.setObjectView(viewInfo);
        try {
            IRowSet rs = exec.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    String srcid = rs.getString("srcObjectId");
                    String destid = rs.getString("destObjectId");
                    EreceiptBillHelper.putIdMap(destIdMap, destid, srcid);
                }
            }
            return destIdMap;
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    private static void putIdMap(Map<String, List<String>> IdMap, String key, String value) {
        if (IdMap.containsKey(key)) {
            List<String> idMapList = IdMap.get(key);
            idMapList.add(value);
        } else {
            ArrayList<String> idMapList = new ArrayList<String>();
            idMapList.add(value);
            IdMap.put(key, idMapList);
        }
    }

    private static EntityViewInfo getEntityViewInfoBySrcIds(List srcIdList, String srcBosType, String destBosType) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcObjectId", (Object)FMHelper.list2Set((List)srcIdList), CompareType.INCLUDE));
        if (!EmptyUtil.isEmpty((String)srcBosType)) {
            filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)srcBosType));
        }
        if (!EmptyUtil.isEmpty((String)destBosType)) {
            filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)destBosType));
        }
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private static EntityViewInfo getEntityViewInfoByDestIds(List destIdList, String srcBosType, String destBosType) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("destObjectId", (Object)FMHelper.list2Set((List)destIdList), CompareType.INCLUDE));
        if (!EmptyUtil.isEmpty((String)srcBosType)) {
            filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)srcBosType));
        }
        if (!EmptyUtil.isEmpty((String)destBosType)) {
            filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)destBosType));
        }
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    public static Map<String, Map> getSrcTypeMapBydestIds(Context ctx, List destIdList, String destBosType) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("destObjectId", (Object)FMHelper.list2Set((List)destIdList), CompareType.INCLUDE));
        if (!EmptyUtil.isEmpty((String)destBosType)) {
            filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)destBosType));
        }
        viewInfo.setFilter(filter);
        Vector relateBills = new Vector();
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.bos.metadata.bot.app.BotRelationQuery"));
        exec.setObjectView(viewInfo);
        HashMap<String, Vector> bosTypeMap = new HashMap<String, Vector>();
        HashMap<String, Map<String, Vector<String>>> destIdMap = new HashMap<String, Map<String, Vector<String>>>();
        HashMap<String, Map> result = new HashMap<String, Map>();
        try {
            IRowSet rs = exec.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    Vector bosTypeList;
                    Vector<String> srcTypeIdList;
                    Map<String, Vector<String>> srcTypeMap;
                    String srcId = rs.getString("srcObjectId");
                    String destId = rs.getString("destObjectId");
                    if (destIdMap.containsKey(destId)) {
                        srcTypeMap = (Map)destIdMap.get(destId);
                        srcTypeIdList = (Vector<String>)srcTypeMap.get(BOSUuid.read((String)srcId).getType().toString());
                        if (srcTypeIdList != null) {
                            srcTypeIdList.add(srcId);
                        } else {
                            srcTypeIdList = new Vector<String>();
                            srcTypeIdList.add(srcId);
                            srcTypeMap.put(BOSUuid.read((String)srcId).getType().toString(), srcTypeIdList);
                            destIdMap.put(destId, srcTypeMap);
                        }
                    } else {
                        srcTypeMap = new HashMap();
                        srcTypeIdList = new Vector<String>();
                        srcTypeMap.put(BOSUuid.read((String)srcId).getType().toString(), srcTypeIdList);
                        srcTypeIdList.add(srcId);
                        destIdMap.put(destId, srcTypeMap);
                    }
                    if (bosTypeMap.containsKey(BOSUuid.read((String)srcId).getType().toString())) {
                        bosTypeList = (Vector)bosTypeMap.get(BOSUuid.read((String)srcId).getType().toString());
                        bosTypeList.add(srcId);
                        continue;
                    }
                    bosTypeList = new Vector();
                    bosTypeList.add(srcId);
                    bosTypeMap.put(BOSUuid.read((String)srcId).getType().toString(), bosTypeList);
                }
                result.put("bosTypeMap", bosTypeMap);
                result.put("destIdMap", destIdMap);
            }
            return result;
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    public static List<String> getMapValueList(Map<String, List<String>> idMap) {
        Iterator<String> it = idMap.keySet().iterator();
        ArrayList<String> vallueList = new ArrayList<String>();
        while (it.hasNext()) {
            String sourceId = it.next();
            vallueList.addAll((Collection<String>)idMap.get(sourceId));
        }
        return vallueList;
    }

    public static List<String> getMapValueListForOne(Map<String, String> idMap) {
        Iterator<String> it = idMap.keySet().iterator();
        ArrayList<String> valueList = new ArrayList<String>();
        while (it.hasNext()) {
            String sourceId = it.next();
            valueList.add(idMap.get(sourceId));
        }
        return valueList;
    }

    public static List<byte[]> getPDFsListForOne(Map<String, byte[]> pdfMap) {
        Iterator<String> it = pdfMap.keySet().iterator();
        ArrayList<byte[]> valueList = new ArrayList<byte[]>();
        while (it.hasNext()) {
            String sourceId = it.next();
            valueList.add(pdfMap.get(sourceId));
        }
        return valueList;
    }

    public static List getLeftIdList(List<String> billIdList, Map<String, List<String>> transIdMap) {
        ArrayList<String> leftList = new ArrayList<String>();
        leftList.addAll(billIdList);
        for (int i = 0; i < billIdList.size(); ++i) {
            String billId = billIdList.get(i);
            if (!transIdMap.containsKey(billId)) continue;
            leftList.remove(billId);
        }
        return leftList;
    }

    public static List getLeftIdListForPay(Context ctx, List<String> billIdList, Map transIdMap) {
        ArrayList<String> leftList = new ArrayList<String>();
        HashSet<String> removeSet = new HashSet<String>();
        leftList.addAll(billIdList);
        for (int i = 0; i < billIdList.size(); ++i) {
            String billId = billIdList.get(i);
            if (!transIdMap.containsKey(billId)) continue;
            leftList.remove(billId);
            removeSet.add(billId);
        }
        if (removeSet != null && removeSet.size() > 0) {
            PaymentBillCollection paymentBillCollection = null;
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", removeSet, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("isRefundmentPay", (Object)new Boolean(true)));
            viewInfo.setFilter(filterInfo);
            try {
                paymentBillCollection = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillCollection(viewInfo);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (paymentBillCollection != null && paymentBillCollection.size() > 0) {
                String payId = "";
                for (int j = 0; j < paymentBillCollection.size(); ++j) {
                    payId = paymentBillCollection.get(j).getId().toString();
                    leftList.add(payId);
                    if (!transIdMap.containsKey(payId)) continue;
                    transIdMap.remove(payId);
                }
            }
        }
        return leftList;
    }

    public static Map<String, List<byte[]>> getPDFMap(Map<String, List<String>> idMap, Map<String, byte[]> pdfMapByErec) {
        HashMap<String, List<byte[]>> pdfMap = new HashMap<String, List<byte[]>>();
        Iterator<String> it = idMap.keySet().iterator();
        List pdfList = null;
        while (it.hasNext()) {
            String billId = it.next();
            List<String> erecIds = idMap.get(billId);
            pdfList = pdfMap.containsKey(billId) ? (List)pdfMap.get(billId) : new ArrayList();
            for (int i = 0; i < erecIds.size(); ++i) {
                String erecId = erecIds.get(i);
                if (!pdfMapByErec.containsKey(erecId)) continue;
                pdfList.add(pdfMapByErec.get(erecId));
                pdfMap.put(billId, pdfList);
            }
        }
        return pdfMap;
    }

    public static Map<String, byte[]> getPDFMapByTransMap(Map<String, String> transIdMap, Map<String, byte[]> pdfMapByErec) {
        HashMap<String, byte[]> pdfMap = new HashMap<String, byte[]>();
        for (String transId : transIdMap.keySet()) {
            String erecId = transIdMap.get(transId);
            if (!pdfMapByErec.containsKey(erecId)) continue;
            pdfMap.put(transId, pdfMapByErec.get(erecId));
        }
        return pdfMap;
    }

    public static Map<String, List<String>> getIdMapByBillIds(Map<String, List<String>> transIdMap, Map<String, String> erecIdMap) {
        HashMap<String, List<String>> idMap = new HashMap<String, List<String>>();
        for (String billId : transIdMap.keySet()) {
            List<String> erecIdList;
            if (!transIdMap.containsKey(billId)) continue;
            if (idMap.containsKey(billId)) {
                erecIdList = (List)idMap.get(billId);
            } else {
                erecIdList = new ArrayList();
                idMap.put(billId, erecIdList);
            }
            List<String> transIdList = transIdMap.get(billId);
            for (int i = 0; i < transIdList.size(); ++i) {
                String transId = transIdList.get(i);
                if (!erecIdMap.containsKey(transId)) continue;
                String erecId = erecIdMap.get(transId);
                erecIdList.add(erecId);
            }
        }
        return idMap;
    }

    public static Map<String, List<String>> getidMapBySourceIds(Map<String, List<String>> billIdMap, Map<String, List<String>> idMapByBill) {
        HashMap<String, List<String>> idMap = new HashMap<String, List<String>>();
        for (String sourceId : billIdMap.keySet()) {
            List erecIds;
            if (idMap.containsKey(sourceId)) {
                erecIds = (List)idMap.get(sourceId);
            } else {
                erecIds = new ArrayList();
                idMap.put(sourceId, erecIds);
            }
            List<String> billIds = billIdMap.get(sourceId);
            for (int i = 0; i < billIds.size(); ++i) {
                String billId = billIds.get(i);
                if (!idMapByBill.containsKey(billId)) continue;
                erecIds.addAll(idMapByBill.get(billId));
            }
        }
        return idMap;
    }

    public static void changeKeyEntry2Parent(Map<String, String> entryParentIdMap, Map<String, List<String>> entryDetailIdMap, Map<String, List<String>> result) {
        for (String entryId : entryDetailIdMap.keySet()) {
            List<Object> parentDetailIdList;
            List<String> entryDetailIdList = entryDetailIdMap.get(entryId);
            if (!entryParentIdMap.containsKey(entryId)) continue;
            String parentId = entryParentIdMap.get(entryId);
            if (result.containsKey(parentId)) {
                parentDetailIdList = result.get(parentId);
                parentDetailIdList.addAll(entryDetailIdList);
                continue;
            }
            parentDetailIdList = new ArrayList();
            parentDetailIdList.addAll(entryDetailIdList);
            result.put(parentId, parentDetailIdList);
        }
    }

    public static Map<String, String> getOppIdMapBySrcIdsForOne(Context ctx, List srcIdList, String srcBosType, String destBosType) throws BOSException {
        HashMap<String, String> destIdMap = new HashMap<String, String>();
        EntityViewInfo viewInfo = EreceiptBillHelper.getEntityViewInfoBySrcIds(srcIdList, srcBosType, destBosType);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.bos.metadata.bot.app.BotRelationQuery"));
        exec.setObjectView(viewInfo);
        try {
            IRowSet rs = exec.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    destIdMap.put(rs.getString("destObjectId"), rs.getString("srcObjectId"));
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return destIdMap;
    }

    public static Map<String, List<String>> getDetailIdByPayIdList(Context ctx, List billIdList) throws BOSException {
        Map<String, List<String>> transIdMap = EreceiptBillHelper.getDestIdMapByDestIds(ctx, billIdList, EreceiptServiceBillType.getBosType("transDetail"), EreceiptServiceBillType.getBosType("paymentBill"));
        List leftIdList = EreceiptBillHelper.getLeftIdListForPay(ctx, billIdList, transIdMap);
        Map<String, List<String>> flagMap = EreceiptBillHelper.getTransIdsByBankCheckFlag(ctx, leftIdList, "T_CAS_PAYMENTBILL", "FBANKCHECKFLAG");
        transIdMap.putAll(flagMap);
        return transIdMap;
    }

    public static Map<String, List<String>> getDetailIdBySettIdList(Context ctx, List<String> billIdList) throws BOSException {
        Map<String, List<String>> transIdMap = EreceiptBillHelper.getDestIdMapByDestIds(ctx, billIdList, EreceiptServiceBillType.getBosType("transDetail"), EreceiptServiceBillType.getBosType("settlementBill"));
        List leftIdList = EreceiptBillHelper.getLeftIdList(billIdList, transIdMap);
        Map<String, List<String>> flagMap = EreceiptBillHelper.getTransIdsByBankCheckFlag(ctx, leftIdList, "T_FS_SETTLEMENTBILL", "FREQSEQNO");
        transIdMap.putAll(flagMap);
        return transIdMap;
    }

    public static Map<String, List<String>> getInnerErecIdMapByBillIds(Context ctx, List<String> billIdList) throws BOSException {
        HashMap<String, List<String>> innerErecIdMap = new HashMap<String, List<String>>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)FMHelper.list2Set(billIdList), CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("innerEReceiptId"));
        sic.add(new SelectorItemInfo("billId"));
        view.setFilter(filter);
        view.setSelector(sic);
        SubsidiaryLedgerCollection coll = SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).getSubsidiaryLedgerCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            List<String> value;
            SubsidiaryLedgerInfo info = coll.get(i);
            if (info.getInnerEReceiptId() == null) continue;
            String billId = info.getBillId().toString();
            if (innerErecIdMap.containsKey(billId)) {
                value = (List)innerErecIdMap.get(billId);
                value.add(info.getInnerEReceiptId());
                continue;
            }
            value = new ArrayList();
            value.add(info.getInnerEReceiptId());
            innerErecIdMap.put(billId, value);
        }
        return innerErecIdMap;
    }

    public static Map<String, List<String>> getInnerErecIdMapByBillIdSet(Context ctx, Set<String> billIdSet) throws BOSException {
        HashMap<String, List<String>> innerErecIdMap = new HashMap<String, List<String>>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", billIdSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("innerEReceiptId"));
        sic.add(new SelectorItemInfo("billId"));
        view.setFilter(filter);
        view.setSelector(sic);
        SubsidiaryLedgerCollection coll = SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).getSubsidiaryLedgerCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            List<String> value;
            SubsidiaryLedgerInfo info = coll.get(i);
            String billId = info.getBillId().toString();
            if (innerErecIdMap.containsKey(billId)) {
                value = (List)innerErecIdMap.get(billId);
                value.add(info.getInnerEReceiptId());
                continue;
            }
            value = new ArrayList();
            value.add(info.getInnerEReceiptId());
            innerErecIdMap.put(billId, value);
        }
        return innerErecIdMap;
    }

    public static List getMapValueColl(Map<String, String> map) {
        ArrayList<String> valueList = new ArrayList<String>();
        Iterator<String> it = map.keySet().iterator();
        while (it.hasNext()) {
            valueList.add(map.get(it.next()));
        }
        return valueList;
    }

    public static List<String> getBillIdList4Map(List<String> billIdList, Map<String, List<String>> idMap) {
        ArrayList<String> erecIds = new ArrayList<String>();
        for (int i = 0; i < billIdList.size(); ++i) {
            List<String> erecIdList;
            String billId = billIdList.get(i).toString();
            if (!idMap.containsKey(billId) || EmptyUtil.isEmpty(erecIdList = idMap.get(billId))) continue;
            erecIds.addAll(erecIdList);
        }
        return erecIds;
    }

    public static Map<String, String> getEntryParentIdMap(Context ctx, List billIdList) throws EASBizException, BOSException {
        if (billIdList != null || billIdList.size() > 0) {
            HashMap<String, String> result = new HashMap<String, String>();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.list2Set((List)billIdList), CompareType.INCLUDE));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("entrys.id"));
            view.setFilter(filter);
            view.setSelector(sic);
            if (BOSUuid.read((String)billIdList.get(0).toString()).getType().equals((Object)new TransUpBillInfo().getBOSType())) {
                TransUpBillCollection coll = TransUpBillFactory.getLocalInstance((Context)ctx).getTransUpBillCollection(view);
                for (int i = 0; i < coll.size(); ++i) {
                    TransUpBillInfo info = coll.get(i);
                    result.put(info.getEntrys().get(0).getId().toString(), info.getId().toString());
                }
                return result;
            }
            if (BOSUuid.read((String)billIdList.get(0).toString()).getType().equals((Object)new TransDownBillInfo().getBOSType())) {
                TransDownBillCollection coll = TransDownBillFactory.getLocalInstance((Context)ctx).getTransDownBillCollection(view);
                for (int i = 0; i < coll.size(); ++i) {
                    TransDownBillInfo info = coll.get(i);
                    result.put(info.getEntrys().get(0).getId().toString(), info.getId().toString());
                }
                return result;
            }
        }
        return null;
    }

    public static Map<String, List<String>> getTransIdsByBankCheckFlagSet(Context ctx, Set billIdSet, String table, String column) throws BOSException {
        HashMap<String, List<String>> billIdMap = new HashMap<String, List<String>>();
        ArrayList leftIdList = new ArrayList();
        String sql = "SELECT PAY.FID BILLID, DETAIL.FID DETAILID FROM " + table + " PAY, T_BE_TRANSDETAIL DETAIL WHERE PAY." + column + " = DETAIL.FBANKCHECKFLAG AND PAY.FID IN " + FMHelper.setTran2String((Set)billIdSet);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList payIdList = new ArrayList();
        ArrayList detailIdList = new ArrayList();
        try {
            while (rs.next()) {
                String billId = rs.getString("BILLID");
                String detailId = rs.getString("DETAILID");
                EreceiptBillHelper.putIdMap(billIdMap, billId, detailId);
            }
            return billIdMap;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

