/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.erec.app.service.inner;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.report.forapp.kdnote.webserver.IContextProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.webserver.KDNoteWebServerHelper;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.IBizContext;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.fm.be.EReceiptCollection;
import com.kingdee.eas.fm.be.EReceiptInfo;
import com.kingdee.eas.fm.be.EReceiptLogTypeEnum;
import com.kingdee.eas.fm.be.EReceiptStorageSettingCollection;
import com.kingdee.eas.fm.be.EReceiptStorageSettingFactory;
import com.kingdee.eas.fm.be.EReceiptStorageSettingInfo;
import com.kingdee.eas.fm.be.LevelEnum;
import com.kingdee.eas.fm.be.app.EReceiptLogUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.erec.EreceiptTypeEnum;
import com.kingdee.eas.fm.erec.InnerEReceiptTemplateCollection;
import com.kingdee.eas.fm.erec.InnerEReceiptTemplateFactory;
import com.kingdee.eas.fm.erec.InnerEReceiptTemplateInfo;
import com.kingdee.eas.fm.erec.app.service.EreceiptBatchServiceFactory;
import com.kingdee.eas.fm.erec.app.service.inner.IInnerEreceiptService;
import com.kingdee.eas.fm.erec.app.service.inner.provider.InnerDataProviderFactory;
import com.kingdee.eas.fm.erec.app.util.EreceiptHelper;
import com.kingdee.eas.fm.fs.SubsidiaryBillTypeEnum;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.fm.fs.TransDownBillEntryFactory;
import com.kingdee.eas.fm.fs.TransDownBillEntryInfo;
import com.kingdee.eas.fm.fs.TransUpBillEntryFactory;
import com.kingdee.eas.fm.fs.TransUpBillEntryInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class InnerEreceiptService
implements IInnerEreceiptService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.erec.app.service.inner.InnerEreceiptDownService");
    private EReceiptLogUtils eReceiptLogUtils = new EReceiptLogUtils();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void batchTransPDF(Context ctx, List subsIdList, SubsidiaryBillTypeEnum bizType) throws BOSException, EASBizException {
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        List appliedList = null;
        WebContextUtil.initRpcConfig((Context)ctx);
        try {
            appliedList = EreceiptHelper.batchRequestMutex(subsIdList, iMutex);
            logger.error((Object)("\u7533\u8bf7\u4e92\u65a5\u9501\u7684\u5185\u90e8\u8d26\u6237\u660e\u7ec6\u8d26\u4e2a\u6570\u4e3a\uff1a" + subsIdList.size() + ", \u6210\u529f\u7533\u8bf7\u5230\u9501\u7684\u660e\u7ec6\u8d26\u4e2a\u6570\u4e3a\uff1a" + appliedList.size()));
            CoreBaseCollection subColl = this.getUnDownedSubsByIdList(ctx, appliedList, bizType);
            EReceiptCollection coll = this.genErecColl(ctx, subColl, bizType);
            EreceiptBatchServiceFactory.getEreceiptBatchService(ctx).batchSavePDFs(ctx, coll, EreceiptTypeEnum.INNER);
            this.eReceiptLogUtils.saveReceiptLog(ctx, "innerEreceipt", new Date(), "\u3010\u4e1a\u52a1\u7c7b\u578b\uff1a" + bizType.getAlias() + "\u6210\u529f\u4e0a\u4f20\u5230\u56de\u5355\u5e93\uff0c\u56de\u5355\u6570\u91cf\u4e3a\uff1a" + coll.size(), "", "", EReceiptLogTypeEnum.INNEREREC, LevelEnum.NORMAL);
            SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).update(subColl);
            this.eReceiptLogUtils.saveReceiptLog(ctx, "innerEreceipt", new Date(), "\u3010\u4e1a\u52a1\u7c7b\u578b\uff1a" + bizType.getAlias() + "\u6210\u529f\u53cd\u5199\u5185\u90e8\u8d26\u6237\u660e\u7ec6\u8d26", "", "", EReceiptLogTypeEnum.INNEREREC, LevelEnum.NORMAL);
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(appliedList);
        }
    }

    protected Map<String, byte[]> parsePDFByIdList(Context ctx, Map<String, String> idMap, String companyId, SubsidiaryBillTypeEnum bizType) throws EASBizException, BOSException {
        logger.error((Object)"\u8f6c\u6362PDF\u5f00\u59cb");
        this.eReceiptLogUtils.saveReceiptLog(ctx, "innerEreceipt", new Date(), "\u3010" + bizType.getAlias() + "\u7c7b\u578b\u8f6c\u5316PDF\u5f00\u59cb\u3011 ", "", "", EReceiptLogTypeEnum.INNEREREC, LevelEnum.NORMAL);
        HashMap<String, byte[]> pdfMap = new HashMap<String, byte[]>();
        String templatePath = this.getTemplatePath(ctx, bizType, companyId);
        logger.error((Object)("\u83b7\u53d6\u5230\u5957\u6253\u6a21\u677f\u8def\u5f84\uff1a" + templatePath));
        this.eReceiptLogUtils.saveReceiptLog(ctx, "innerEreceipt", new Date(), "\u3010" + bizType.getAlias() + "\u7c7b\u578b\uff0c\u83b7\u53d6\u5230\u7684\u5957\u6253\u6a21\u677f\u4e3a\uff1a" + templatePath + "\u3011 ", "", "", EReceiptLogTypeEnum.INNEREREC, LevelEnum.NORMAL);
        KDNoteWebServerHelper webHelper = this.getKDNoteHelper(ctx);
        Iterator<String> it = idMap.keySet().iterator();
        while (it.hasNext()) {
            ByteArrayOutputStream bospdf = new ByteArrayOutputStream();
            String subId = it.next();
            ArrayList<String> idList = new ArrayList<String>();
            String billId = idMap.get(subId);
            idList.add(billId);
            IInnerEreceiptService service = InnerDataProviderFactory.getInnerEreceiptService(ctx, bizType);
            Object provider = service.getDataProvider(idList);
            logger.error((Object)("\u5355\u636e\u8f6c\u6362PDF\u5f00\u59cb" + billId));
            boolean exportSuccess = webHelper.exportPDF(templatePath, provider, (OutputStream)bospdf);
            if (exportSuccess) {
                byte[] fileValue = bospdf.toByteArray();
                logger.error((Object)("\u5355\u636e\u8f6c\u6362PDF\u7ed3\u675f" + billId));
                pdfMap.put(subId, fileValue);
                this.eReceiptLogUtils.saveReceiptLog(ctx, "innerEreceipt", new Date(), "\u3010\u4e1a\u52a1\u5355\u636e\uff1a" + billId + " \u8f6c\u5316\u4e3aPDF\u6210\u529f\uff1a", "", "", EReceiptLogTypeEnum.INNEREREC, LevelEnum.NORMAL);
                continue;
            }
            this.eReceiptLogUtils.saveReceiptLog(ctx, "innerEreceipt", new Date(), "\u3010\u4e1a\u52a1\u5355\u636e\uff1a" + billId + " \u8f6c\u5316\u4e3aPDF\u5931\u8d25\uff1a", "", "", EReceiptLogTypeEnum.INNEREREC, LevelEnum.ERROR);
        }
        logger.error((Object)"\u8f6c\u6362PDF\u5b8c\u6210");
        return pdfMap;
    }

    private KDNoteWebServerHelper getKDNoteHelper(Context ctx) {
        KDNoteWebServerHelper webHelper = new KDNoteWebServerHelper();
        final Context ctxTd = ctx;
        webHelper.setContextProvider(new IContextProvider(){

            public IBizContext getBizContext(Context bosCtx) {
                IBizContext ctx = null;
                try {
                    ctx = KDNoteHelper.makeContext((Context)ctxTd);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
                return ctx;
            }
        });
        return webHelper;
    }

    protected String getTemplatePath(Context ctx, SubsidiaryBillTypeEnum bizType, String companyId) throws EASBizException, BOSException {
        String templateName = "";
        Object templateNameMap = null;
        if (templateNameMap != null) {
            templateName = templateNameMap;
            return templateName;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("templateID"));
        selectorItemCollection.add(new SelectorItemInfo("templateName"));
        view.setSelector(selectorItemCollection);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billType", (Object)bizType, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
        view.setFilter(filter);
        InnerEReceiptTemplateCollection colls = InnerEReceiptTemplateFactory.getLocalInstance(ctx).getInnerEReceiptTemplateCollection(view);
        if (colls.size() <= 0) {
            throw new BOSException("\u8bf7\u914d\u7f6e\u3010" + bizType + "(" + companyId + ")\u3011  \u7535\u5b50\u56de\u5355\u5957\u6253\u6a21\u677f\uff01");
        }
        InnerEReceiptTemplateInfo templateInfo = colls.get(0);
        templateName = templateInfo.getTemplateID();
        return templateName;
    }

    @Override
    public abstract Object getDataProvider(List var1);

    public EReceiptCollection genErecColl(Context ctx, CoreBaseCollection coll, SubsidiaryBillTypeEnum bizType) throws BOSException, EASBizException {
        String companyId = ((SubsidiaryLedgerInfo)coll.get(0)).getCompany().getId().toString();
        ArrayList billIdList = new ArrayList();
        HashMap<String, String> subBillidMap = new HashMap<String, String>();
        Map<String, EReceiptInfo> erecInfoMap = this.parseErecInfoMap(ctx, coll, subBillidMap);
        Map<String, byte[]> pdfMap = this.parsePDFByIdList(ctx, subBillidMap, companyId, bizType);
        EReceiptCollection erecColl = this.setPDFValues(erecInfoMap, pdfMap);
        return erecColl;
    }

    private EReceiptCollection setPDFValues(Map<String, EReceiptInfo> erecInfoMap, Map<String, byte[]> pdfMap) {
        EReceiptCollection erecColl = new EReceiptCollection();
        for (String billId : pdfMap.keySet()) {
            byte[] pdfValue = pdfMap.get(billId);
            EReceiptInfo ereceiptInfo = erecInfoMap.get(billId);
            ereceiptInfo.setFileValue(pdfValue);
            erecColl.add(ereceiptInfo);
        }
        return erecColl;
    }

    private Map<String, EReceiptInfo> parseErecInfoMap(Context ctx, CoreBaseCollection coll, Map<String, String> idMap) {
        EntityViewInfo View = new EntityViewInfo();
        SelectorItemCollection Sic = new SelectorItemCollection();
        Sic.add(new SelectorItemInfo("*"));
        View.setSelector(Sic);
        EReceiptStorageSettingCollection StorageColls = null;
        try {
            StorageColls = EReceiptStorageSettingFactory.getLocalInstance((Context)ctx).getEReceiptStorageSettingCollection(View);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        EReceiptStorageSettingInfo StorageInfo = StorageColls.get(0);
        HashMap<String, EReceiptInfo> erecInfoMap = new HashMap<String, EReceiptInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            AccountBankCollection payecollection;
            AccountBankCollection payeecollection;
            EReceiptInfo erecInfo = new EReceiptInfo();
            SubsidiaryLedgerInfo info = (SubsidiaryLedgerInfo)coll.get(i);
            erecInfo.setId(BOSUuid.create((BOSObjectType)erecInfo.getBOSType()));
            info.setIsCreateInnerEReceipt(true);
            info.setInnerEReceiptId(erecInfo.getId().toString());
            erecInfo.setCompany(info.getCompany());
            erecInfo.setInnerAccount(info.getInnerAccount());
            erecInfo.setCompany(info.getCompany());
            erecInfo.setBillNumber(info.getBillNumber());
            if (info.getBizType() != null) {
                erecInfo.setBizType(info.getBizType().getAlias());
            }
            erecInfo.setBizDate(info.getDate());
            erecInfo.setAmount(info.getDebitAmount() == BigDecimal.ZERO ? info.getCreditAmount() : info.getDebitAmount());
            erecInfo.setCreditAmount(info.getDebitAmount());
            erecInfo.setDebitAmount(info.getCreditAmount());
            erecInfo.setFileValue(null);
            erecInfo.setCurrency(info.getCurrency());
            erecInfo.setTransDate(info.getDate());
            erecInfo.setDescription(info.getDescription());
            erecInfo.setBankAccount(info.getDebitAmount() == BigDecimal.ZERO ? info.getPayeeBankAccount() : info.getPayerBankAccount());
            if (info.getPayerBankAccount() != null) {
                erecInfo.setBank(info.getPayerBankAccount().getBank());
            }
            if ((payeecollection = this.getAccountBankCollectionByAccNum(ctx, info.getPayeeBankAcct())).size() > 0) {
                erecInfo.setIncomeBankAccount(payeecollection.get(0));
            }
            if ((payecollection = this.getAccountBankCollectionByAccNum(ctx, info.getPayerBankAcct())).size() > 0) {
                erecInfo.setPayBankAccount(payecollection.get(0));
            }
            erecInfo.setExplanation(info.getDescription());
            erecInfo.setFileName(info.getBillNumber() + ".pdf");
            erecInfo.setOppBankNumber(info.getDebitAmount() == BigDecimal.ZERO ? info.getPayerBankAcct() : info.getPayeeBankAcct());
            if (info.getDebitAmount() == BigDecimal.ZERO && info.getPayerBankAccount() != null && info.getPayerBankAccount().getBank() != null) {
                erecInfo.setOppBank(info.getPayerBankAccount().getBank().getName());
            } else if (info.getDebitAmount() != BigDecimal.ZERO && info.getPayeeBankAccount() != null && info.getPayeeBankAccount().getBank() != null) {
                erecInfo.setOppBank(info.getPayeeBankAccount().getBank().getName());
            }
            erecInfo.setNumber(info.getSettleNumber());
            erecInfo.setCpInnerAccount(info.getInnerAccount());
            erecInfo.setIsInnerEReceipt(true);
            String receiptStampPath = null;
            SimpleDateFormat y = new SimpleDateFormat("yyyy");
            String eRYear = y.format(erecInfo.getTransDate());
            SimpleDateFormat m = new SimpleDateFormat("MM");
            String eRMonth = m.format(erecInfo.getTransDate());
            SimpleDateFormat d = new SimpleDateFormat("dd");
            String eRDay = d.format(erecInfo.getTransDate());
            receiptStampPath = StorageInfo.isUseMapping() ? StorageInfo.getMappingFinalPath() + "InnerEreceipt/" + eRYear + "/" + eRMonth + "/" + eRDay : StorageInfo.getLocalPath() + "/InnerEreceipt/" + eRYear + "/" + eRMonth + "/" + eRDay;
            erecInfo.setReceiptStampPath(receiptStampPath);
            erecInfoMap.put(info.getId().toString(), erecInfo);
            idMap.put(info.getId().toString(), this.changeTransBillId(ctx, info.getBillId().toString()));
        }
        return erecInfoMap;
    }

    private AccountBankCollection getAccountBankCollectionByAccNum(Context ctx, String fbankAccountNumber) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("*"));
        selectorItemCollection.add(new SelectorItemInfo("company.*"));
        selectorItemCollection.add(new SelectorItemInfo("bank.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)fbankAccountNumber, CompareType.EQUALS));
        entityViewInfo.setFilter(filter);
        AccountBankCollection collection = new AccountBankCollection();
        try {
            collection = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(entityViewInfo);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return collection;
    }

    private String changeTransBillId(Context ctx, String id) {
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("parent.id"));
            if (BOSUuid.read((String)id).getType().equals((Object)new TransUpBillEntryInfo().getBOSType())) {
                TransUpBillEntryInfo info = TransUpBillEntryFactory.getLocalInstance((Context)ctx).getTransUpBillEntryInfo((IObjectPK)new ObjectUuidPK(id), sic);
                id = info.getParent().getId().toString();
            } else if (BOSUuid.read((String)id).getType().equals((Object)new TransDownBillEntryInfo().getBOSType())) {
                TransDownBillEntryInfo info = TransDownBillEntryFactory.getLocalInstance((Context)ctx).getTransDownBillEntryInfo((IObjectPK)new ObjectUuidPK(id), sic);
                id = info.getParent().getId().toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)"\u6ca1\u6709\u4e0a\u5212\u5355\u6216\u8005\u4e0b\u62e8\u5355\uff01");
        }
        return id;
    }

    private CoreBaseCollection getUnDownedSubsByIdList(Context ctx, List idList, SubsidiaryBillTypeEnum bizType) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("innerAccount.*"));
        sic.add(new SelectorItemInfo("payeeBankAccount.*"));
        sic.add(new SelectorItemInfo("payerBankAccount.*"));
        sic.add(new SelectorItemInfo("cpInnerAccount.*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.list2Set((List)idList), CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("bizType", (Object)bizType));
        SorterItemCollection sortColl = new SorterItemCollection();
        sortColl.add(new SorterItemInfo("date"));
        view.setSelector(sic);
        view.setSorter(sortColl);
        view.setFilter(filterInfo);
        CoreBaseCollection coll = SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).getCollection(view);
        return coll;
    }
}

