/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.erec.app.service.inner.provider;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.fm.erec.app.service.inner.provider.DataProviderHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccrualBillTDDataProvider
implements BOSQueryDelegate {
    private static final Logger logger = LogUtil.getPackageLogger(AccrualBillTDDataProvider.class);
    private Set ids = null;
    public static final IMetaDataPK qpk = new MetaDataPK("com.kingdee.eas.fm.im.AccrualBillTDQuery");
    public static final IMetaDataPK qpkHead = new MetaDataPK("com.kingdee.eas.fm.im.AccrualBillTDHeadQuery");

    public AccrualBillTDDataProvider(Set id) {
        this.ids = id;
    }

    public AccrualBillTDDataProvider(List id) {
        this.ids = new HashSet(id);
    }

    public static void main(String[] args) throws BOSException {
        DataProviderHelper.printTDMetaDataField(ConfigMDUtil.getContext(), qpk.getFullName());
        DataProviderHelper.printTDMetaDataField(ConfigMDUtil.getContext(), qpkHead.getFullName());
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet iRowSet = null;
        String name = ds.getID();
        if (name.endsWith("IMHead")) {
            try {
                IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ConfigMDUtil.getContext(), (IMetaDataPK)qpkHead);
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.ids, CompareType.INCLUDE));
                ev.setFilter(filter);
                ev.getSorter().add(new SorterItemInfo("innerAccount.number"));
                exec.setObjectView(ev);
                logger.info((Object)exec.getSQL());
                iRowSet = exec.executeQuery();
                while (iRowSet.next()) {
                    BigDecimal overDraftAccrua;
                    BigDecimal overDraftAccuAm;
                    BigDecimal balanceAmt;
                    BigDecimal netAmt;
                    BigDecimal taxAmt;
                    BigDecimal feeAmt;
                    BigDecimal accrualAmt;
                    BigDecimal arrearAmt;
                    int precision = iRowSet.getInt("currency.precision");
                    BigDecimal accuAmt = iRowSet.getBigDecimal("accuAmt");
                    if (accuAmt == null) {
                        accuAmt = Constants.ZERO;
                    }
                    if ((arrearAmt = iRowSet.getBigDecimal("arrearAmt")) == null) {
                        arrearAmt = Constants.ZERO;
                    }
                    if ((accrualAmt = iRowSet.getBigDecimal("accrualAmt")) == null) {
                        accrualAmt = Constants.ZERO;
                    }
                    if ((feeAmt = iRowSet.getBigDecimal("feeAmt")) == null) {
                        feeAmt = Constants.ZERO;
                    }
                    if ((taxAmt = iRowSet.getBigDecimal("taxAmt")) == null) {
                        taxAmt = Constants.ZERO;
                    }
                    if ((netAmt = iRowSet.getBigDecimal("netAmt")) == null) {
                        netAmt = Constants.ZERO;
                    }
                    if ((balanceAmt = iRowSet.getBigDecimal("balanceAmt")) == null) {
                        balanceAmt = Constants.ZERO;
                    }
                    if ((overDraftAccuAm = iRowSet.getBigDecimal("overDraftAccuAm")) == null) {
                        overDraftAccuAm = Constants.ZERO;
                    }
                    if ((overDraftAccrua = iRowSet.getBigDecimal("overDraftAccrua")) == null) {
                        overDraftAccrua = Constants.ZERO;
                    }
                    iRowSet.updateBigDecimal("accuAmt", accuAmt.setScale(precision, 4));
                    iRowSet.updateBigDecimal("arrearAmt", arrearAmt.setScale(precision, 4));
                    iRowSet.updateBigDecimal("accrualAmt", accrualAmt.setScale(precision, 4));
                    iRowSet.updateBigDecimal("overDraftAccuAm", overDraftAccuAm.setScale(precision, 4));
                    iRowSet.updateBigDecimal("overDraftAccrua", overDraftAccrua.setScale(precision, 4));
                    iRowSet.updateBigDecimal("feeAmt", feeAmt.setScale(precision, 4));
                    iRowSet.updateBigDecimal("taxAmt", taxAmt.setScale(precision, 4));
                    iRowSet.updateBigDecimal("netAmt", netAmt.setScale(precision, 4));
                    iRowSet.updateBigDecimal("balanceAmt", balanceAmt.setScale(precision, 4));
                }
                iRowSet.beforeFirst();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else {
            try {
                IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ConfigMDUtil.getContext(), (IMetaDataPK)qpk);
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.ids, CompareType.INCLUDE));
                ev.setFilter(filter);
                ev.getSorter().add(new SorterItemInfo("innerAccount.number"));
                filter.getFilterItems().add(new FilterItemInfo("entries.accrualAmt", (Object)Constants.ZERO, CompareType.NOTEQUALS));
                exec.setObjectView(ev);
                iRowSet = exec.executeQuery();
                DecimalFormat df = new DecimalFormat("###0.###########");
                while (iRowSet.next()) {
                    int precision = iRowSet.getInt("currency.precision");
                    BigDecimal accuAmt = iRowSet.getBigDecimal("accuAmt");
                    BigDecimal arrearAmt = iRowSet.getBigDecimal("arrearAmt");
                    BigDecimal accrualAmt = iRowSet.getBigDecimal("accrualAmt");
                    BigDecimal feeAmt = iRowSet.getBigDecimal("feeAmt");
                    BigDecimal taxAmt = iRowSet.getBigDecimal("taxAmt");
                    BigDecimal netAmt = iRowSet.getBigDecimal("netAmt");
                    BigDecimal balanceAmt = iRowSet.getBigDecimal("balanceAmt");
                    BigDecimal entries_yearRate = iRowSet.getBigDecimal("entries.yearRate");
                    BigDecimal entries_accuAmt = iRowSet.getBigDecimal("entries.accuAmt");
                    BigDecimal entries_arrearAmt = iRowSet.getBigDecimal("entries.arrearAmt");
                    BigDecimal entries_accrualAmt = iRowSet.getBigDecimal("entries.accrualAmt");
                    BigDecimal entries_taxRate = iRowSet.getBigDecimal("entries.taxRate");
                    BigDecimal entries_taxAmt = iRowSet.getBigDecimal("entries.taxAmt");
                    BigDecimal entries_feeRate = iRowSet.getBigDecimal("entries.feeRate");
                    BigDecimal entries_feeAmt = iRowSet.getBigDecimal("entries.feeAmt");
                    BigDecimal entries_netAmt = iRowSet.getBigDecimal("entries.netAmt");
                    iRowSet.updateBigDecimal("accuAmt", accuAmt.setScale(precision, 4));
                    iRowSet.updateBigDecimal("arrearAmt", arrearAmt.setScale(precision, 4));
                    iRowSet.updateBigDecimal("accrualAmt", accrualAmt.setScale(precision, 4));
                    iRowSet.updateBigDecimal("feeAmt", feeAmt.setScale(precision, 4));
                    iRowSet.updateBigDecimal("taxAmt", taxAmt.setScale(precision, 4));
                    iRowSet.updateBigDecimal("netAmt", netAmt.setScale(precision, 4));
                    iRowSet.updateBigDecimal("balanceAmt", balanceAmt.setScale(precision, 4));
                    iRowSet.updateBigDecimal("entries.yearRate", new BigDecimal(df.format(entries_yearRate)));
                    iRowSet.updateBigDecimal("entries.accuAmt", entries_accuAmt.setScale(precision, 4));
                    iRowSet.updateBigDecimal("entries.arrearAmt", entries_arrearAmt.setScale(precision, 4));
                    iRowSet.updateBigDecimal("entries.accrualAmt", entries_accrualAmt.setScale(precision, 4));
                    iRowSet.updateBigDecimal("entries.taxRate", new BigDecimal(df.format(entries_taxRate)));
                    iRowSet.updateBigDecimal("entries.taxAmt", entries_taxAmt.setScale(precision, 4));
                    iRowSet.updateBigDecimal("entries.feeRate", new BigDecimal(df.format(entries_feeRate)));
                    iRowSet.updateBigDecimal("entries.feeAmt", entries_feeAmt.setScale(precision, 4));
                    iRowSet.updateBigDecimal("entries.netAmt", entries_netAmt.setScale(precision, 4));
                }
                iRowSet.beforeFirst();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return iRowSet;
    }
}

