/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.erec.app.service.inner.provider;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.erec.app.service.inner.provider.ChLoanDataAdapter;
import com.kingdee.eas.fm.ivt.ChLoanHelper;
import com.kingdee.eas.fm.ivt.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.ivt.PenAccrualTypeEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Date;
import java.sql.SQLException;
import java.util.List;

public class ChLoanDataProvider
extends ChLoanDataAdapter {
    private static final String queryPK = "com.kingdee.eas.fm.ivt.app.ChLoanTDQuery";

    public ChLoanDataProvider(List idList) {
        this.ids = FMHelper.list2Set((List)idList);
        this.setQueryPKStr(queryPK);
    }

    @Override
    protected void processBillBody(IRowSet rowSet, int precision) throws SQLException {
        rowSet.updateBigDecimal("loanTotalAmt", rowSet.getBigDecimal("loanTotalAmt").setScale(precision, 4));
        rowSet.updateBigDecimal("floorAmt", rowSet.getBigDecimal("floorAmt").setScale(precision, 4));
        if (rowSet.getDate("startDate") != null) {
            rowSet.updateDate("startDate", DateUtil.truncateSqlDate((Date)rowSet.getDate("startDate")));
        }
        if (rowSet.getDate("endDate") != null) {
            rowSet.updateDate("endDate", DateUtil.truncateSqlDate((Date)rowSet.getDate("endDate")));
        }
        String printeExcutor = ContextHelperFactory.getLocalInstance((Context)ConfigMDUtil.getContext()).getCurrentUser().getName();
        rowSet.updateString("printer", printeExcutor);
        String rateExpressionStr = rowSet.getString("intRateTypeExpression");
        String tmpYearRate = "";
        if (rateExpressionStr.equals(IntRateTypeExpressionEnum.YEAR.getAlias())) {
            tmpYearRate = rowSet.getBigDecimal("yearRate").toString() + "%";
            tmpYearRate = ChLoanHelper.getInstance().trimZero(tmpYearRate, "%");
        } else {
            tmpYearRate = rowSet.getBigDecimal("yearRate").toString() + "\u2030";
            tmpYearRate = ChLoanHelper.getInstance().trimZero(tmpYearRate, "\u2030");
        }
        String tmpPenaRate = "";
        String penaType = rowSet.getString("penAccrualType");
        if (penaType.equals(PenAccrualTypeEnum.ADD_PERCENT.getAlias())) {
            tmpPenaRate = rowSet.getBigDecimal("penAccrualRate").toString() + "%";
            tmpPenaRate = ChLoanHelper.getInstance().trimZero(tmpPenaRate, "%");
        } else {
            tmpPenaRate = rowSet.getBigDecimal("penAccrualRate").toString() + "\u2030";
            tmpPenaRate = ChLoanHelper.getInstance().trimZero(tmpPenaRate, "\u2030");
        }
        rowSet.updateString("yearRateDis", tmpYearRate);
        rowSet.updateString("punishIntRateDis", tmpPenaRate);
    }
}

