/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.erec.app.service.inner.provider;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.server.IVirtualModeDataAccess;
import com.kingdee.bos.dao.query.server.VirtualModeDataAccessFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.multiapprove.MultiApproveCollection;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.noteprint.util.NotePrtRecordUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.erec.app.util.EreceiptHelper;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SettleBillDataProvider
implements BOSQueryDelegate {
    private static IMetaDataPK qpk = new MetaDataPK("com.kingdee.eas.fm.fs.SettlementBillTDQuery");
    KDNoteHelper currentHelper = null;
    private Set ids = null;
    private static final Logger logger = CoreUIObject.getLogger(SettleBillDataProvider.class);
    SettlementBillPrintListener listener = new SettlementBillPrintListener();

    public SettleBillDataProvider(Set id) {
        this.ids = id;
    }

    public SettleBillDataProvider(List id) {
        this.ids = new HashSet(id);
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet iRowSet = null;
        try {
            IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ConfigMDUtil.getContext(), (IMetaDataPK)qpk);
            exec.option().isAutoTranslateEnum = true;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"NONE"));
            String maskString = "#0";
            int index = 1;
            Iterator iter = this.ids.iterator();
            while (iter.hasNext()) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)((String)iter.next())));
                maskString = maskString + " OR #" + index;
                ++index;
            }
            filter.setMaskString(maskString);
            ArrayList param = ds.getParams();
            EreceiptHelper.addDataFilter(filter, param);
            ev.setFilter(filter);
            ev.getSorter().add(new SorterItemInfo("number"));
            exec.setObjectView(ev);
            Map doAllQueryTask = exec.doAllQueryTask(null, 0, Integer.MAX_VALUE, null, false);
            iRowSet = (IRowSet)doAllQueryTask.get("rowSet");
            IVirtualModeDataAccess virtualDataAccess = VirtualModeDataAccessFactory.getLocalInstance((Context)ConfigMDUtil.getContext());
            Uuid uuid = (Uuid)doAllQueryTask.get("uuid");
            virtualDataAccess.closeQuery(uuid);
            CompanyOrgUnitInfo company = ContextHelperFactory.getLocalInstance((Context)ConfigMDUtil.getContext()).getCurrentCompany();
            int localPrec = FMHelper.getPrecOfCurrency((Context)ConfigMDUtil.getContext(), (String)company.getBaseCurrency().getId().toString());
            iRowSet.beforeFirst();
            while (iRowSet.next()) {
                NotePrtRecordUtil.setQueryPK((String)"com.kingdee.eas.base.noteprint.app.PrtRecordQuery");
                int precision = iRowSet.getInt("currency.precision");
                iRowSet.updateBigDecimal("amount", iRowSet.getBigDecimal("amount").setScale(precision, 4));
                iRowSet.updateBigDecimal("localAmount", iRowSet.getBigDecimal("localAmount").setScale(localPrec, 4));
                CurrencyInfo srcCurr = new CurrencyInfo();
                srcCurr.setId(BOSUuid.read((String)iRowSet.getString("currency.id")));
                Date bizDate = iRowSet.getDate("bizDate");
                ExchangeRateInfo exRate = FMHelper.getExRateInfo(null, (CurrencyInfo)srcCurr, (CurrencyInfo)company.getBaseCurrency(), (CompanyOrgUnitInfo)company, (java.util.Date)bizDate);
                int exRatePrec = 3;
                if (exRate != null) {
                    exRatePrec = exRate.getPrecision();
                }
                iRowSet.updateBigDecimal("exchange", iRowSet.getBigDecimal("exchange").setScale(exRatePrec, 4));
                String billId = iRowSet.getString("id");
                MultiApproveCollection col = EreceiptHelper.getMutiApprove(billId);
                for (int i = 1; i <= col.size() && i <= 5; ++i) {
                    MultiApproveInfo info = col.get(i - 1);
                    iRowSet.updateString("censor" + i, info.getCreator().getName());
                }
                if (iRowSet.getDate("acceptedDate") != null) {
                    iRowSet.updateDate("acceptedDate", DateUtil.truncateSqlDate((Date)iRowSet.getDate("acceptedDate")));
                }
                if (iRowSet.getDate("settleDate") != null) {
                    iRowSet.updateDate("settleDate", DateUtil.truncateSqlDate((Date)iRowSet.getDate("settleDate")));
                }
                if (iRowSet.getDate("createTime") != null) {
                    iRowSet.updateDate("createTime", DateUtil.truncateSqlDate((Date)iRowSet.getDate("createTime")));
                }
                iRowSet.updateString("souceBillNumber", EreceiptHelper.getBillNumber(iRowSet.getString("souceBillNumber")));
                iRowSet.getString("id");
                StringBuffer voucherNumber = new StringBuffer("");
                StringBuffer stringBuffer = new StringBuffer("");
            }
            iRowSet.beforeFirst();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return iRowSet;
    }

    public void setCurrentHelper(KDNoteHelper currentHelper) {
        this.currentHelper = currentHelper;
    }

    private boolean updatePrintCount(Set ids, int times) {
        boolean result = true;
        try {
            result = SettlementBillFactory.getLocalInstance((Context)ConfigMDUtil.getContext()).updatePrintCount(ids, times);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    class SettlementBillPrintListener
    implements IPrintActionListener {
        public void beforePrintOrPreview() {
        }

        public void beforePreview() {
        }

        public void beforePrint() {
        }

        public void closePreview() {
        }
    }
}

