/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.erec.app.util;

import com.enterprisedt.util.debug.Logger;
import com.kingdee.bos.BOSException;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.apache.commons.io.FilenameUtils;

public class EreceiptConvertUtil {
    private static Logger logger = Logger.getLogger((String)EreceiptConvertUtil.class.getName());
    private static final String EAS_HOME = System.getProperty("EAS_HOME");
    private static final String EAS_WEB_TMP_PATH = EAS_HOME + File.separator + "server" + File.separator + "deploy" + File.separator + "easweb.ear" + File.separator + "tmp";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] convertImageToPdfByte(String payNumber, byte[] imageData) throws BOSException {
        logger.error("**********convertImageToPdfByte start **********");
        String pdfFilePath = EreceiptConvertUtil.convertImageToPdf(payNumber, imageData);
        File file = new File(FilenameUtils.normalize((String)pdfFilePath));
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)file.length());
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            byte[] b = new byte[1024];
            int len = -1;
            while ((len = fis.read(b)) != -1) {
                bos.write(b, 0, len);
            }
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                EreceiptConvertUtil.closeInputStream(fis);
                EreceiptConvertUtil.closeOutStream(bos);
                EreceiptConvertUtil.delFile(file);
                throw throwable;
            }
            EreceiptConvertUtil.closeInputStream(fis);
            EreceiptConvertUtil.closeOutStream(bos);
            EreceiptConvertUtil.delFile(file);
        }
        EreceiptConvertUtil.closeInputStream(fis);
        EreceiptConvertUtil.closeOutStream(bos);
        EreceiptConvertUtil.delFile(file);
        logger.error("**********convertImageToPdfByte end **********");
        return bos.toByteArray();
    }

    private static void closeInputStream(FileInputStream fis) throws BOSException {
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new BOSException(e.getMessage());
            }
        }
    }

    public static void delFile(File file) {
        if (!file.exists()) {
            System.out.println("the file " + file.getName() + " is not exist !");
            return;
        }
        boolean rs = file.delete();
        if (rs) {
            System.out.println("the file " + file.getName() + " has been deleted !");
        } else {
            System.out.println("the file " + file.getName() + " delete failed !");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertImageToPdf(String payNumber, byte[] imageData) throws BOSException {
        logger.error("**********convertImageToPdf start **********");
        String pdfFilePath = EreceiptConvertUtil.assemblePDFFile(payNumber);
        logger.error("**********pdfFilePath is :" + pdfFilePath);
        Document document = new Document(PageSize.A4.rotate());
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(FilenameUtils.normalize((String)pdfFilePath));
            PdfWriter.getInstance((Document)document, (OutputStream)fileOutputStream);
            document.open();
            Image image = Image.getInstance((byte[])imageData);
            document.add((Element)image);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            document.close();
            EreceiptConvertUtil.closeOutStream(fileOutputStream);
        }
        logger.error("**********convertImageToPdf end **********");
        return pdfFilePath;
    }

    private static void closeOutStream(OutputStream fos) throws BOSException {
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new BOSException(e.getMessage());
            }
        }
    }

    public static String assemblePDFFile(String payNumber) {
        String pattern = "{0}{1}{2}";
        return MessageFormat.format(pattern, EreceiptConvertUtil.getTempFilePath(), payNumber, ".pdf");
    }

    public static String getTempFilePath() {
        return EAS_WEB_TMP_PATH;
    }
}

