/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.erec.app.util;

import com.enterprisedt.util.debug.Logger;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.DSParam;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveCollection;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class EreceiptHelper {
    private static Logger logger = Logger.getLogger((String)EreceiptHelper.class.getName());
    public static final int DEFAULT_EXCHANGERATE_PREC = 3;

    public static Date getRelativeDate(Date baseDate, int days, int type) throws BOSException {
        Date returnDate = null;
        if (baseDate == null) {
            baseDate = new Date();
        }
        Calendar date = Calendar.getInstance();
        date.setTime(baseDate);
        if (type == 0) {
            date.set(5, date.get(5) - days);
        } else {
            date.set(5, date.get(5) + days);
        }
        SimpleDateFormat dft = new SimpleDateFormat("yyyyMMdd");
        try {
            returnDate = dft.parse(dft.format(date.getTime()));
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        return returnDate;
    }

    public static List batchRequestMutex(List requestIdList, IMutexServiceControl iMutex) throws BOSException {
        ArrayList appliedList = new ArrayList();
        Map resultRequest = iMutex.batchRequestObjIDForUpdate(requestIdList);
        for (int i = 0; i < requestIdList.size(); ++i) {
            Boolean boolResult = (Boolean)resultRequest.get(requestIdList.get(i));
            if (!boolResult.booleanValue()) continue;
            appliedList.add(requestIdList.get(i));
        }
        return appliedList;
    }

    public static MultiApproveCollection getMutiApprove(String billId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billId", (Object)billId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("IsPass", (Object)Boolean.TRUE, CompareType.EQUALS));
        IMultiApprove iMutiApprove = MultiApproveFactory.getRemoteInstance();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("creator.name"));
        SorterItemInfo dsf = new SorterItemInfo("CreateTime");
        dsf.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(dsf);
        MultiApproveCollection col = iMutiApprove.getMultiApproveCollection(viewInfo);
        return col;
    }

    public static String getBillNumber(String id) throws Exception {
        if (id == null || id.trim().length() == 0) {
            return null;
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        BOSUuid bosId = BOSUuid.read((String)id);
        IObjectValue info = DynamicObjectFactory.getRemoteInstance().getValue(bosId.getType(), (IObjectPK)pk);
        return info.getString("number");
    }

    public static VoucherCollection getVoucherCollection(String billId) throws BOSException, EASBizException {
        String[] srcEntriesID = new String[]{billId};
        IBTPManager iBTPManager = BTPManagerFactory.getRemoteInstance();
        BOSObjectType voucherBosType = new VoucherInfo().getBOSType();
        BOTRelationCollection relationColl = iBTPManager.getDestRelation(billId);
        VoucherCollection colVoucher = null;
        if (relationColl != null && !relationColl.isEmpty()) {
            HashSet<String> voucherIds = new HashSet<String>();
            BOTRelationInfo relationInfo = null;
            int size = relationColl.size();
            for (int i = 0; i < size; ++i) {
                relationInfo = relationColl.get(i);
                if (!relationInfo.getDestEntityID().equals(voucherBosType.toString())) continue;
                voucherIds.add(relationInfo.getDestObjectID());
            }
            if (voucherIds != null && voucherIds.size() != 0) {
                IVoucher iVoucher = VoucherFactory.getRemoteInstance();
                SelectorItemCollection cel = new SelectorItemCollection();
                cel.add("*");
                cel.add("creator.*");
                EntityViewInfo view = new EntityViewInfo();
                view.getSelector().addObjectCollection((IObjectCollection)cel);
                FilterInfo filter = new FilterInfo();
                FilterItemInfo filterItem = new FilterItemInfo("id", voucherIds, CompareType.INCLUDE);
                filter.getFilterItems().add(filterItem);
                view.setFilter(filter);
                colVoucher = iVoucher.getVoucherCollection(view);
            }
        }
        if (colVoucher == null) {
            colVoucher = new VoucherCollection();
        }
        return colVoucher;
    }

    public static void addDataFilter(FilterInfo filter, ArrayList param) throws BOSException {
        DSParam dp;
        String s;
        if (filter == null || filter.getFilterItems().size() == 0) {
            return;
        }
        if (param == null || param.size() == 0) {
            return;
        }
        FilterInfo datafilter = null;
        if (param != null && param.size() > 0 && (s = (dp = (DSParam)param.get(0)).getColName()) != null && s.equalsIgnoreCase("datafilter")) {
            String f = dp.getAssociateField();
            try {
                datafilter = new FilterInfo(f);
            }
            catch (Exception e) {
                logger.info(f);
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (datafilter != null && datafilter.getFilterItems().size() > 0) {
            filter.mergeFilter(datafilter, "AND");
        }
    }

    public static Map<String, List<byte[]>> mergeByteMaps(Map<String, List<byte[]>> erecPDFMap, Map<String, List<byte[]>> innerPDFMap) {
        if (erecPDFMap.isEmpty()) {
            return innerPDFMap;
        }
        if (innerPDFMap.isEmpty()) {
            return erecPDFMap;
        }
        for (String key : erecPDFMap.keySet()) {
            List<byte[]> outerValue = erecPDFMap.get(key);
            if (!innerPDFMap.containsKey(key)) continue;
            outerValue.addAll((Collection<byte[]>)innerPDFMap.get(key));
            innerPDFMap.remove(key);
        }
        for (String key : innerPDFMap.keySet()) {
            erecPDFMap.put(key, innerPDFMap.get(key));
        }
        return erecPDFMap;
    }

    public static Map<String, List<String>> mergeMaps(Map<String, List<String>> erecMap, Map<String, List<String>> innerErecMap) {
        if (erecMap.isEmpty()) {
            return innerErecMap;
        }
        if (innerErecMap.isEmpty()) {
            return erecMap;
        }
        for (String key : erecMap.keySet()) {
            List<String> outerValue = erecMap.get(key);
            if (!innerErecMap.containsKey(key)) continue;
            outerValue.addAll((Collection<String>)innerErecMap.get(key));
            innerErecMap.remove(key);
        }
        for (String key : innerErecMap.keySet()) {
            erecMap.put(key, innerErecMap.get(key));
        }
        return erecMap;
    }
}

