/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fee;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fee.BusinessFeeFactory;
import com.kingdee.eas.fm.fee.BusinessFeeInfo;
import com.kingdee.eas.fm.fs.ISubsidiaryBookProvider;
import com.kingdee.eas.fm.fs.SubsidiaryBillTypeEnum;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;

public class BusinessFeeSubsidiaryBookProvider
implements ISubsidiaryBookProvider {
    public SubsidiaryLedgerCollection getCollection(Context ctx, String billId) throws BOSException, EASBizException {
        BusinessFeeInfo feeInfo = BusinessFeeFactory.getLocalInstance(ctx).getBusinessFeeInfo((IObjectPK)new ObjectUuidPK(billId));
        SubsidiaryLedgerCollection coll = new SubsidiaryLedgerCollection();
        SubsidiaryLedgerInfo slInfo1 = this.createBaseLedger(ctx, feeInfo);
        slInfo1.setInnerAccount(feeInfo.getInnerAccount());
        slInfo1.setApplyUnit(feeInfo.getCompany());
        slInfo1.setCreditAmount(feeInfo.getFeeAmount());
        slInfo1.setLocalAmount(feeInfo.getFeeLocalCurAmt());
        coll.add(slInfo1);
        return coll;
    }

    private SubsidiaryLedgerInfo createBaseLedger(Context ctx, BusinessFeeInfo feeInfo) {
        SubsidiaryLedgerInfo slInfo = new SubsidiaryLedgerInfo();
        slInfo.setDate(feeInfo.getBizDate());
        slInfo.setCurrency(feeInfo.getCurrency());
        slInfo.setBillId(feeInfo.getId());
        slInfo.setBillNumber(feeInfo.getNumber());
        slInfo.setExchangeRate(feeInfo.getFeeRate());
        slInfo.setIsDownLoad(false);
        slInfo.setBookkeeper(feeInfo.getCreator());
        String des = "";
        if (ctx != null) {
            des = ResourceBase.getString((String)"com.kingdee.eas.fm.fee.FeeResource", (String)"feeBook", (Locale)ctx.getLocale());
        }
        slInfo.setDescription(des);
        slInfo.setBizType(SubsidiaryBillTypeEnum.FEEBILL);
        slInfo.setCompany(feeInfo.getCompany());
        return slInfo;
    }
}

