/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fee;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fm.fee.FeeBillCollection;
import com.kingdee.eas.fm.fee.FeeBillInfo;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;

public final class FeeAcceptHelper {
    private static final BigDecimal ONE = Constants.ONE;
    public static final String RES = "com.kingdee.eas.fm.common.client.FMCommonClientResource";

    public static SubsidiaryLedgerCollection convert2Subsidiaries(FeeBillCollection bills, UserInfo userInfo, Date acceptDate) throws EASBizException, BOSException {
        SubsidiaryLedgerCollection subLedgers = null;
        if (bills == null || bills.size() == 0) {
            return null;
        }
        subLedgers = new SubsidiaryLedgerCollection();
        int n = bills.size();
        for (int i = 0; i < n; ++i) {
            FeeBillInfo feeInfo = bills.get(i);
            if (feeInfo.getNet().signum() == 0 || feeInfo.getType().getValue() != 1) continue;
            SubsidiaryLedgerInfo subLedgerDpstInfo = FeeAcceptHelper.convert2Subsidiary(feeInfo, userInfo, acceptDate);
            subLedgers.add(subLedgerDpstInfo);
        }
        return subLedgers;
    }

    private static SubsidiaryLedgerInfo convert2Subsidiary(FeeBillInfo feeInfo, UserInfo userInfo, Date acceptDate) throws EASBizException, BOSException {
        SubsidiaryLedgerInfo subLedgerInfo = new SubsidiaryLedgerInfo();
        subLedgerInfo.setBillId(feeInfo.getId());
        subLedgerInfo.setCurrency(feeInfo.getCurrency());
        subLedgerInfo.setCpCurrency(feeInfo.getCurrency());
        subLedgerInfo.setDate(acceptDate);
        String desc = "";
        if (feeInfo.getPeriod() != null) {
            DateFormat df = DateFormat.getDateInstance();
            desc = desc + df.format(feeInfo.getPeriod()) + "  ";
        }
        if (feeInfo.getDescription() != null) {
            desc = desc + feeInfo.getDescription();
        }
        subLedgerInfo.setDescription(desc);
        subLedgerInfo.setExchangeRate(ONE);
        subLedgerInfo.setBookkeeper(userInfo);
        subLedgerInfo.setLocalAmount(SysConstant.BIGZERO);
        subLedgerInfo.setCreditAmount(SysConstant.BIGZERO);
        subLedgerInfo.setDebitAmount(SysConstant.BIGZERO);
        subLedgerInfo.setBillNumber(feeInfo.getNumber());
        if (feeInfo.getType().getValue() == 1) {
            subLedgerInfo.setCompany(feeInfo.getInnerAccount().getCompany());
            subLedgerInfo.setInnerAccount(feeInfo.getInnerAccount());
            subLedgerInfo.setCreditAmount(feeInfo.getNet());
        }
        return subLedgerInfo;
    }

    public static void isSettleCenter(Component comp) throws EASBizException, BOSException {
        BankInfo clrHouseInfo;
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (companyInfo == null) {
            MsgBox.showWarning((Component)comp, (String)EASResource.getString((String)RES, (String)"Company_Null"));
            SysUtil.abort();
        }
        if ((clrHouseInfo = FSClientHelper.getClearingHouse()) == null) {
            MsgBox.showWarning((Component)comp, (String)EASResource.getString((String)RES, (String)"ClearingHouse_Null"));
            SysUtil.abort();
        }
        if (!clrHouseInfo.getRelatedCompany().getId().equals((Object)companyInfo.getId())) {
            MsgBox.showWarning((Component)comp, (String)EASResource.getString((String)RES, (String)"CompanyNotClearingHouse"));
            SysUtil.abort();
        }
        if (!clrHouseInfo.isUsed()) {
            MsgBox.showWarning((Component)comp, (String)EASResource.getString((String)RES, (String)"ClearingHouseNotStarted"));
            SysUtil.abort();
        }
    }
}

