/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fee.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fee.BusinessFeeBookNotifyBuilder;
import com.kingdee.eas.fm.fee.BusinessFeeCollection;
import com.kingdee.eas.fm.fee.BusinessFeeFactory;
import com.kingdee.eas.fm.fee.BusinessFeeInfo;
import com.kingdee.eas.fm.fee.BusinessFeeSubsidiaryBookProvider;
import com.kingdee.eas.fm.fee.FeeException;
import com.kingdee.eas.fm.fee.app.AbstractBusinessFeeControllerBean;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fs.ISubsidiaryLedger;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.fm.nt.PayableBillCollection;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class BusinessFeeControllerBean
extends AbstractBusinessFeeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fee.app.BusinessFeeControllerBean");

    @Override
    protected void _addBatch(Context ctx, IObjectCollection feeColl, IObjectCollection sourceColl, BOSObjectType bosType) throws BOSException, EASBizException {
        if (feeColl == null || feeColl.size() < 1) {
            return;
        }
        for (int i = 0; i < feeColl.size(); ++i) {
            BusinessFeeInfo feeFGInfo = (BusinessFeeInfo)feeColl.getObject(i);
            IObjectPK pk = this._addnew(ctx, (IObjectValue)feeFGInfo);
            if (feeFGInfo.isCreatePayment()) {
                FMHelper.genBillByBotp((Context)ctx, (CoreBillBaseInfo)feeFGInfo, (String)new PaymentBillInfo().getBOSType().toString(), (boolean)false);
            }
            for (int j = 0; j < sourceColl.size(); ++j) {
                if (!bosType.equals((Object)new PayableBillInfo().getBOSType())) continue;
                FinUtils.addBotRelation((Context)ctx, (String)((PayableBillCollection)sourceColl).get(j).getId().toString(), (String)pk.toString());
            }
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean isInnerAccNull;
        BusinessFeeInfo info = (BusinessFeeInfo)model;
        if (FMHelper.isEmpty((String)info.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        }
        HashSet<IObjectPK> idSet = new HashSet<IObjectPK>();
        IObjectPK iFeePK = super._addnew(ctx, model);
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        boolean exist = codingRuleManager.isExist((IObjectValue)info, info.getCompany().getId().toString());
        if (exist && codingRuleManager.isAddView((IObjectValue)info, info.getCompany().getId().toString()) && !codingRuleManager.isUseIntermitNumber((IObjectValue)info, info.getCompany().getId().toString())) {
            codingRuleManager.getNumber((IObjectValue)info, info.getCompany().getId().toString());
        }
        boolean bl = isInnerAccNull = this.getBusinessFeeInfo(ctx, iFeePK).getInnerAccount() == null;
        if (!isInnerAccNull) {
            idSet.add(iFeePK);
            this.subsidiaryBook(ctx, idSet);
        }
        return iFeePK;
    }

    private void subsidiaryBook(Context ctx, Set idSet) throws BOSException, EASBizException {
        String builderName = BusinessFeeSubsidiaryBookProvider.class.getName();
        String billId = null;
        ISubsidiaryLedger facade = SubsidiaryLedgerFactory.getLocalInstance((Context)ctx);
        Iterator iter = idSet.iterator();
        while (iter.hasNext()) {
            billId = iter.next().toString();
            facade.book(billId, builderName);
        }
    }

    @Override
    protected void _antiBook(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        String sql = "UPDATE T_FE_BusinessFee SET FCashier = NULL WHERE FID = ? ";
        String billId = null;
        IBookNotifyFacade bookFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            billId = (String)idList.get(i);
            bookFacade.antiBook(billId);
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{billId});
        }
    }

    @Override
    protected void _book(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        this.verifyBeforeBook(ctx, idList);
        BusinessFeeBookNotifyBuilder builder = new BusinessFeeBookNotifyBuilder();
        JournalCollection journalColl = new JournalCollection();
        String sql = "UPDATE T_FE_BusinessFee SET FCashier = ? WHERE FID = ? ";
        String userId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getName().toString();
        String billId = null;
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            billId = (String)idList.get(i);
            if (this.isBooked(ctx, billId)) continue;
            journalColl.addCollection(builder.getJournalColl(ctx, billId));
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userId, billId});
        }
        IBookNotifyFacade bookFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        bookFacade.bookBatch(journalColl);
    }

    private void verifyBeforeBook(Context ctx, List idList) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.setFilter(filter);
        BusinessFeeCollection coll = BusinessFeeFactory.getLocalInstance(ctx).getBusinessFeeCollection(evi);
        BusinessFeeInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (info.getAccountBank() == null) {
                FMHelper.throwFMCommonException((String)(info.getNumber().toString() + ResourceBase.getString((String)"com.kingdee.eas.fm.fee.FeeResource", (String)"accountNotExist", (Locale)ctx.getLocale())));
            }
            if (EmptyUtil.isEmpty((String)info.getCashier())) continue;
            FMHelper.throwFMCommonException((String)(info.getNumber().toString() + ResourceBase.getString((String)"com.kingdee.eas.fm.fee.FeeResource", (String)"noDataToBook", (Locale)ctx.getLocale())));
        }
    }

    private boolean isBooked(Context ctx, String billId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        view.setFilter(filter);
        JournalCollection coll = JournalFactory.getLocalInstance((Context)ctx).getJournalCollection(view);
        return coll != null && coll.size() > 0;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BusinessFeeInfo feeOldInfo;
        String oldInnerAccPK = null;
        BOSUuid oldId = ((BusinessFeeInfo)model).getId();
        if (oldId != null && this.exists(ctx, (IObjectPK)new ObjectStringPK(oldId.toString())) && (feeOldInfo = this.getBusinessFeeInfo(ctx, (IObjectPK)new ObjectStringPK(oldId.toString()))).getInnerAccount() != null) {
            oldInnerAccPK = feeOldInfo.getInnerAccount().getId().toString();
        }
        IObjectPK feePK = super._submit(ctx, model);
        BusinessFeeInfo feeNewInfo = this.getBusinessFeeInfo(ctx, feePK);
        String newInnerAccPK = null;
        if (feeNewInfo.getInnerAccount() != null) {
            newInnerAccPK = feeNewInfo.getInnerAccount().getId().toString();
        }
        HashSet<IObjectPK> idSet = new HashSet<IObjectPK>();
        idSet.add(feePK);
        if (oldInnerAccPK != null) {
            this.againBook(ctx, idSet, oldInnerAccPK, newInnerAccPK);
        } else if (newInnerAccPK != null) {
            this.subsidiaryBook(ctx, idSet);
        }
        return feePK;
    }

    protected void againBook(Context ctx, Set idSet, String oldInnerId, String newInnerId) throws BOSException, EASBizException {
        boolean isAgain = false;
        Iterator iter = idSet.iterator();
        String billId = null;
        while (iter.hasNext()) {
            billId = iter.next().toString();
        }
        InnerAccountInfo oldInfo = null;
        if (oldInnerId != null) {
            oldInfo = InnerAccountFactory.getLocalInstance((Context)ctx).getInnerAccountInfo((IObjectPK)new ObjectStringPK(oldInnerId));
        }
        InnerAccountInfo newInfo = null;
        if (newInnerId != null) {
            newInfo = InnerAccountFactory.getLocalInstance((Context)ctx).getInnerAccountInfo((IObjectPK)new ObjectStringPK(newInnerId));
        }
        HashSet<String> feeIdSet = new HashSet<String>();
        boolean isCanDelete = true;
        if (oldInfo != null) {
            isCanDelete = this.deleteSubsidiary(ctx, billId);
        }
        if (!isCanDelete) {
            throw new FeeException(FeeException.FEECANNOTDELSUB);
        }
        if (newInfo != null) {
            feeIdSet.add(billId);
            this.subsidiaryBook(ctx, feeIdSet);
            isAgain = true;
        }
        if (!isAgain && oldInfo != null && newInfo != null) {
            throw new FeeException(FeeException.BOOKISLOST);
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BusinessFeeInfo info = (BusinessFeeInfo)this.getValue(ctx, pk);
        super._delete(ctx, pk);
        boolean isDelSub = true;
        if (info.getInnerAccount() != null) {
            isDelSub = this.deleteSubsidiary(ctx, pk.toString());
        }
        if (!isDelSub) {
            throw new FeeException(FeeException.FEECANNOTDELSUB);
        }
    }

    protected boolean deleteSubsidiary(Context ctx, String id) {
        boolean flag = true;
        try {
            String strSelSql = "select * from T_FS_SubsidiaryLedger where fbillid = '" + id + "'";
            if (DbUtil.executeQuery((Context)ctx, (String)strSelSql).size() == 0) {
                return true;
            }
            String strDelSql = "delete T_FS_SubsidiaryLedger where fbillid = '" + id + "'";
            DbUtil.execute((Context)ctx, (String)strDelSql);
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }
}

