/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fee.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fee.FeeMethodEnum;
import com.kingdee.eas.fm.fee.FeeTariffEntryCollection;
import com.kingdee.eas.fm.fee.FeeTariffEntryInfo;
import com.kingdee.eas.fm.fee.FeeTariffFactory;
import com.kingdee.eas.fm.fee.FeeTariffInfo;
import com.kingdee.eas.fm.fee.app.FeeCalculateInterface;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class CalculateByQuantityImpl
implements FeeCalculateInterface {
    private static String SQL = "SELECT COUNT(*) FROM T_FS_SUBSIDIARYLEDGER SUBLEDGER,T_FS_SETTLEMENTBILL SETBILL,T_FE_FEETARIFF TARIFF WHERE SUBLEDGER.FINNERACCOUNTID = ? AND SUBLEDGER.FCURRENCYID = ? AND SUBLEDGER.FDATE >= ? AND SUBLEDGER.FDATE < ? AND SUBLEDGER.FBIZTYPE = 2 AND SETBILL.FID = SUBLEDGER.FBILLID AND TARIFF.FPRECEDENCESIGN = SETBILL.FISURGENT AND SETBILL.FSETTLETYPEID = TARIFF.FBALANCETYPE AND TARIFF.FBALANCETYPE = ? AND TARIFF.FID = ?";

    @Override
    public BigDecimal calculate(Context ctx, FeeTariffInfo feeTariffInfo, BigDecimal amount) throws EASBizException, BOSException {
        if (feeTariffInfo.getMethod() == null) {
            feeTariffInfo = (FeeTariffInfo)FeeTariffFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(feeTariffInfo.getId().toString()), this.getFeeTariffSelector());
        }
        FeeMethodEnum methodType = feeTariffInfo.getMethod();
        BigDecimal feeAmount = Constants.ZERO;
        FeeTariffEntryInfo entryInfo = this.findFeeTariffEntryInfoByAmount(feeTariffInfo.getEntries(), amount);
        BigDecimal amt = amount.multiply(entryInfo.getCharge());
        if (methodType.equals((Object)FeeMethodEnum.BY_OVEREDAMT)) {
            amt = amt.subtract(entryInfo.getDeduction());
        }
        amt = FMHelper.max((BigDecimal)amt, (BigDecimal)entryInfo.getFloor());
        BigDecimal ceiling = entryInfo.getCeiling();
        if (ceiling == null || FMHelper.isZERO((BigDecimal)ceiling)) {
            feeAmount = feeAmount.add(amt);
        } else {
            amt = FMHelper.min((BigDecimal)amt, (BigDecimal)ceiling);
            feeAmount = feeAmount.add(amt);
        }
        return feeAmount;
    }

    private FeeTariffEntryInfo findFeeTariffEntryInfoByAmount(FeeTariffEntryCollection feeTariffEntryColl, BigDecimal amt) {
        if (amt.compareTo(BigDecimal.valueOf(feeTariffEntryColl.get(feeTariffEntryColl.size() - 1).getLevelValue())) > 0) {
            return feeTariffEntryColl.get(feeTariffEntryColl.size() - 1);
        }
        FeeTariffEntryInfo lstInfo = feeTariffEntryColl.get(0);
        if (amt.compareTo(BigDecimal.valueOf(lstInfo.getLevelValue())) <= 0) {
            return lstInfo;
        }
        for (int i = 1; i < feeTariffEntryColl.size(); ++i) {
            FeeTariffEntryInfo curInfo = feeTariffEntryColl.get(i);
            BigDecimal curLevel = BigDecimal.valueOf(curInfo.getLevelValue());
            if (amt.compareTo(BigDecimal.valueOf(lstInfo.getLevelValue())) > 0 && amt.compareTo(curLevel) <= 0) {
                return curInfo;
            }
            lstInfo = curInfo;
        }
        return lstInfo;
    }

    @Override
    public List getSubsidiaryCountsAndAmt(Context ctx, String innerAccountId, String currencyId, Date period, FeeTariffInfo feeTariffInfo) throws BOSException, SQLException {
        IRowSet result = null;
        GregorianCalendar date = new GregorianCalendar();
        date.setTime(period);
        ((Calendar)date).add(2, 1);
        Date endDate = date.getTime();
        ArrayList<BigDecimal> rst = new ArrayList<BigDecimal>();
        result = DbUtil.executeQuery((Context)ctx, (String)SQL, (Object[])new Object[]{innerAccountId, currencyId, DateUtil.getSQLBegin((Date)period), DateUtil.getSQLBegin((Date)endDate), feeTariffInfo.getBalanceType().getId().toString(), feeTariffInfo.getId().toString()});
        while (result.next()) {
            BigDecimal bigDecimal = result.getBigDecimal(1);
            if (bigDecimal == null || bigDecimal.compareTo(SysConstant.BIGZERO) == 0) continue;
            rst.add(bigDecimal);
        }
        return rst;
    }

    private SelectorItemCollection getFeeTariffSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("entries.*");
        selector.add("expenseType.*");
        return selector;
    }
}

