/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fee.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fee.FeeTariffInfo;
import com.kingdee.eas.fm.fee.app.FeeCalculateFactory;
import com.kingdee.eas.fm.fee.app.FeeCalculateInterface;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class FeeCalculateHelper {
    private Context ctx;
    private String currencyId;
    private String innerAccountId;
    private Date period;
    private FeeTariffInfo feeTariffInfo;
    private FeeCalculateInterface feeCalculate;

    public FeeCalculateHelper(Context ctx, String innerAccountId, String currencyId, Date period, FeeTariffInfo feeTariffInfo) {
        this.ctx = ctx;
        this.currencyId = currencyId;
        this.innerAccountId = innerAccountId;
        this.period = period;
        this.feeTariffInfo = feeTariffInfo;
        FeeCalculateFactory feeCalculateFactory = new FeeCalculateFactory();
        this.feeCalculate = feeCalculateFactory.getFeeCalculate(feeTariffInfo);
    }

    public BigDecimal getFeeAmount() throws BOSException, EASBizException {
        BigDecimal feeAmount = Constants.ZERO;
        try {
            List list = this.getSubsidiarys();
            if (FMHelper.isEmpty((Collection)list)) {
                return feeAmount;
            }
            for (int i = 0; i < list.size(); ++i) {
                BigDecimal amount = this.feeCalculate.calculate(this.ctx, this.feeTariffInfo, (BigDecimal)list.get(i));
                feeAmount = feeAmount.add(amount);
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            throw new BOSException((Throwable)e);
        }
        return feeAmount;
    }

    public List getSubsidiarys() throws BOSException, SQLException {
        return this.feeCalculate.getSubsidiaryCountsAndAmt(this.ctx, this.innerAccountId, this.currencyId, this.period, this.feeTariffInfo);
    }
}

