/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin;

import com.kingdee.bos.Context;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.IntReceivedBillTypeEnum;
import com.kingdee.eas.fm.common.util.AccrualCalculator;
import com.kingdee.eas.fm.common.util.AccrualCalculatorElementNeededInfo;
import com.kingdee.eas.fm.common.util.AccrualResultInfo;
import com.kingdee.eas.fm.fin.CompDepositAccountBillInfo;
import com.kingdee.eas.fm.fin.CompIntReceivedBillInfo;
import com.kingdee.eas.fm.fin.TDException;
import com.kingdee.eas.fm.fin.TimeDepositHelper;
import com.kingdee.eas.fm.fin.util.AccrualCalculatorPropertyUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class IntReceiveHelper {
    private static IntReceiveHelper intReceiveHelper;
    private static final Logger logger;
    private Date selectedDateInScopeUI;
    private TimeDepositHelper helper;

    public CompIntReceivedBillInfo createIntReceiveBillToBeSaved(Context ctx, CompIntReceivedBillInfo objectValue, CompDepositAccountBillInfo CompDepositAccountBillInfo2, Date date) throws TDException {
        this.selectedDateInScopeUI = date;
        this.initIntReceiveBill(ctx, objectValue, CompDepositAccountBillInfo2, date);
        return objectValue;
    }

    public CompIntReceivedBillInfo createIntReceivePayBillToBeSaved(Context ctx, CompIntReceivedBillInfo objectValue, CompDepositAccountBillInfo CompDepositAccountBillInfo2, Date beginDate, Date endDate) throws TDException {
        this.selectedDateInScopeUI = endDate;
        this.initIntReceivePayBill(ctx, objectValue, CompDepositAccountBillInfo2, beginDate, endDate);
        return objectValue;
    }

    private void initIntReceiveBill(Context ctx, CompIntReceivedBillInfo objectValue, CompDepositAccountBillInfo CompDepositAccountBillInfo2, Date endDate) throws TDException {
        objectValue.setCorpCurAcct(CompDepositAccountBillInfo2.getCorpCurAcct());
        objectValue.setCompany(CompDepositAccountBillInfo2.getCompany());
        objectValue.setCreator(CompDepositAccountBillInfo2.getCreator());
        objectValue.setSrcBillID(CompDepositAccountBillInfo2.getId().toString());
        objectValue.setHasEffected(true);
        objectValue.setIsreceived(false);
        objectValue.setBizDate(DateUtil.getDayBegin());
        objectValue.setTimeDepositBillID(CompDepositAccountBillInfo2);
        objectValue.setSrcBillID(CompDepositAccountBillInfo2.getId().toString());
        objectValue.setEffectiveDate(this.calcuEffectiveDate(CompDepositAccountBillInfo2));
        objectValue.setEndDate(this.calcuMarturity(CompDepositAccountBillInfo2));
        if (objectValue.getEffectiveDate().compareTo(objectValue.getEndDate()) > 0) {
            throw new TDException(TDException.INT_PRE_ERROR, new String[]{CompDepositAccountBillInfo2.getNumber()});
        }
        objectValue.setIntReceiveType(IntReceivedBillTypeEnum.PRE_DRAWING);
        objectValue.setBank(CompDepositAccountBillInfo2.getDepositBank());
        objectValue.setDepCompany(CompDepositAccountBillInfo2.getDepCompany());
        objectValue.setCurrency(CompDepositAccountBillInfo2.getCurrency());
        BigDecimal IntFreeAmt = CompDepositAccountBillInfo2.getIntFreeAmt() == null ? Constants.ZERO : CompDepositAccountBillInfo2.getIntFreeAmt();
        objectValue.setDepositAmt(CompDepositAccountBillInfo2.getBalance().subtract(IntFreeAmt));
        objectValue.setDepYearRate(IntReceiveHelper.calcuYearRate_Redeposit(ctx, CompDepositAccountBillInfo2, objectValue.getEndDate()));
        objectValue.setCreYearRate(Constants.ZERO);
        objectValue.setIsChongzhang(false);
        objectValue.setDigest(CompDepositAccountBillInfo2.getNumber() + " " + objectValue.getIntReceiveType().getAlias());
        objectValue.setYearDays(CompDepositAccountBillInfo2.getYearDays());
        objectValue.setIntRateTypeExpression(CompDepositAccountBillInfo2.getIntRateTypeExpression());
        objectValue.setLastIntDate(CompDepositAccountBillInfo2.getLastIntDate());
        AccrualCalculatorElementNeededInfo aceni = new AccrualCalculatorElementNeededInfo();
        aceni.setCustomerEndDate(endDate);
        AccrualCalculatorPropertyUtil.copyPropertiesValue(ctx, aceni, (CoreBaseInfo)CompDepositAccountBillInfo2, objectValue.getIntReceiveType());
        aceni.setFloorAmt(CompDepositAccountBillInfo2.getIntFreeAmt());
        aceni.setBizDate(objectValue.getEndDate());
        try {
            AccrualResultInfo info = AccrualCalculator.getInstance((AccrualCalculatorElementNeededInfo)aceni).doCalculate(ctx, (CoreBaseInfo)objectValue);
            AccrualCalculatorPropertyUtil.copyResultToIntBillInfo((CoreBaseInfo)objectValue, info);
        }
        catch (FMException e) {
            logger.error((Object)e);
        }
    }

    private void initIntReceivePayBill(Context ctx, CompIntReceivedBillInfo objectValue, CompDepositAccountBillInfo CompDepositAccountBillInfo2, Date beginDate, Date endDate) throws TDException {
        objectValue.setCorpCurAcct(CompDepositAccountBillInfo2.getCorpCurAcct());
        objectValue.setCompany(CompDepositAccountBillInfo2.getCompany());
        objectValue.setCreator(CompDepositAccountBillInfo2.getCreator());
        objectValue.setSrcBillID(CompDepositAccountBillInfo2.getId().toString());
        objectValue.setHasEffected(true);
        objectValue.setIsreceived(false);
        objectValue.setBizDate(DateUtil.getDayBegin());
        objectValue.setTimeDepositBillID(CompDepositAccountBillInfo2);
        objectValue.setSrcBillID(CompDepositAccountBillInfo2.getId().toString());
        objectValue.setEffectiveDate(this.calcuEffectiveDate(CompDepositAccountBillInfo2, beginDate));
        objectValue.setEndDate(this.calcuMarturity(CompDepositAccountBillInfo2));
        if (objectValue.getEffectiveDate().compareTo(objectValue.getEndDate()) > 0) {
            throw new TDException(TDException.INT_PRE_ERROR, new String[]{CompDepositAccountBillInfo2.getNumber()});
        }
        objectValue.setIntReceiveType(IntReceivedBillTypeEnum.INTBILL_PAYINTEREST);
        objectValue.setBank(CompDepositAccountBillInfo2.getDepositBank());
        objectValue.setDepCompany(CompDepositAccountBillInfo2.getDepCompany());
        objectValue.setCurrency(CompDepositAccountBillInfo2.getCurrency());
        objectValue.setDepositAmt(CompDepositAccountBillInfo2.getBalance());
        int days = 0;
        days = TimeDepositHelper.getInstance().calcuIntervalDays(objectValue.getEndDate(), objectValue.getEffectiveDate()) + 1;
        objectValue.setIntervalDays(days);
        objectValue.setDepYearRate(IntReceiveHelper.calcuYearRate_Redeposit(ctx, CompDepositAccountBillInfo2, objectValue.getEndDate()));
        objectValue.setCreYearRate(Constants.ZERO);
        objectValue.setIsChongzhang(false);
        objectValue.setDigest(CompDepositAccountBillInfo2.getNumber() + " " + objectValue.getIntReceiveType().getAlias());
        objectValue.setYearDays(CompDepositAccountBillInfo2.getYearDays());
        objectValue.setIntRateTypeExpression(CompDepositAccountBillInfo2.getIntRateTypeExpression());
        objectValue.setLastIntDate(CompDepositAccountBillInfo2.getLastPayDate());
        AccrualCalculatorElementNeededInfo aceni = new AccrualCalculatorElementNeededInfo();
        aceni.setIntervalDays(new BigDecimal(String.valueOf(days)));
        aceni.setCustomerEndDate(objectValue.getEndDate());
        aceni.setFloorAmt(CompDepositAccountBillInfo2.getIntFreeAmt());
        AccrualCalculatorPropertyUtil.copyPropertiesValue(ctx, aceni, (CoreBaseInfo)CompDepositAccountBillInfo2, objectValue.getIntReceiveType());
        aceni.setFloorAmt(CompDepositAccountBillInfo2.getIntFreeAmt());
        aceni.setBizDate(objectValue.getEndDate());
        try {
            AccrualResultInfo info = AccrualCalculator.getInstance((AccrualCalculatorElementNeededInfo)aceni).doCalculate(ctx, (CoreBaseInfo)objectValue);
            AccrualCalculatorPropertyUtil.copyResultToIntBillInfo((CoreBaseInfo)objectValue, info);
        }
        catch (FMException e) {
            logger.error((Object)e);
        }
    }

    private Date calcuMarturity(CompDepositAccountBillInfo info) {
        Date endDate = this.selectedDateInScopeUI;
        if (null != info.getMaturityDay() && info.getMaturityDay().before(this.selectedDateInScopeUI)) {
            endDate = info.getMaturityDay();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(endDate);
        c.add(5, -1);
        return DateTimeUtils.truncateDate((Date)c.getTime());
    }

    private Date calcuEffectiveDate(CompDepositAccountBillInfo info) {
        Date returnDate = info.getEffectiveDate();
        if (null != info.getLastPayDate() && returnDate.before(info.getLastPayDate())) {
            returnDate = info.getLastPayDate();
        }
        if (null != info.getLastIntDate() && returnDate.before(info.getLastIntDate())) {
            returnDate = info.getLastIntDate();
        }
        return DateTimeUtils.truncateDate((Date)returnDate);
    }

    private Date calcuEffectiveDate(CompDepositAccountBillInfo info, Date beginDate) throws TDException {
        Date lastPayDate = info.getLastPayDate();
        Date effectiveDate = info.getEffectiveDate();
        if (beginDate == null) {
            if (lastPayDate != null) {
                return DateTimeUtils.truncateDate((Date)lastPayDate);
            }
            if (lastPayDate == null && effectiveDate != null) {
                return DateTimeUtils.truncateDate((Date)effectiveDate);
            }
            throw new TDException(TDException.BEGINDATE_NULL);
        }
        if (beginDate != null) {
            if (lastPayDate != null) {
                if (beginDate.before(lastPayDate)) {
                    return DateTimeUtils.truncateDate((Date)lastPayDate);
                }
                return DateTimeUtils.truncateDate((Date)beginDate);
            }
            if (lastPayDate == null && effectiveDate != null) {
                if (beginDate.before(effectiveDate)) {
                    return DateTimeUtils.truncateDate((Date)effectiveDate);
                }
                return DateTimeUtils.truncateDate((Date)beginDate);
            }
            throw new TDException(TDException.BEGINDATE_NULL);
        }
        throw new TDException(TDException.BEGINDATE_NULL);
    }

    public static BigDecimal calcuYearRate_Redeposit(Context ctx, CompDepositAccountBillInfo info, Date date) {
        BigDecimal returnValue = Constants.ZERO;
        if (info.getDepositType().getValue().equals("timedeposit") || info.getDepositType().getValue().equals("timedeposit_outer")) {
            returnValue = info.getRate();
        } else if (info.getDepositType().getValue().equals("calldeposit") || info.getDepositType().getValue().equals("calldeposit_outer")) {
            try {
                returnValue = TimeDepositHelper.getInstance().calcYearRate(ctx, info.getIntRateTable(), info.getCurrency(), date);
            }
            catch (Exception e) {
                SysUtil.abort((Throwable)e.getCause());
            }
        }
        return returnValue;
    }

    public static IntReceiveHelper getInstance() {
        if (intReceiveHelper == null) {
            intReceiveHelper = new IntReceiveHelper();
        }
        return intReceiveHelper;
    }

    static {
        logger = CoreUIObject.getLogger(IntReceiveHelper.class);
    }
}

