/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.fin.LimitIsBankCreditEnum;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

public class RptGrantCreditFundDetailFilterParam
implements FilterParam {
    private static final long serialVersionUID = -7794961955565532516L;
    private Set companyIdSet;
    private Set organizationIdSet;
    private String relations1;
    private Set organizationIdSet_Company;
    private Date dateFrom;
    private Date dateTo;
    private int unit1;
    private BigDecimal amount;
    private int orderType;
    private boolean closedState;
    private Date startdate = null;
    private Date enddate = null;

    public FilterInfo getFilter() {
        CompanyOrgUnitInfo companyif = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterCollection = filter.getFilterItems();
        if (this.relations1 != null) {
            if ("2".equals(this.relations1)) {
                if (this.getOrganizationIdSet_Company() != null && this.getOrganizationIdSet_Company().size() > 0) {
                    filterCollection.add(new FilterItemInfo("creditCompany.id", (Object)this.getOrganizationIdSet_Company(), CompareType.INCLUDE));
                }
                filterCollection.add(new FilterItemInfo("CreditInstitution.id", null, CompareType.EQUALS));
            } else {
                if (this.getOrganizationIdSet() != null && this.getOrganizationIdSet().size() > 0) {
                    filterCollection.add(new FilterItemInfo("CreditInstitution.id", (Object)this.getOrganizationIdSet(), CompareType.INCLUDE));
                }
                filterCollection.add(new FilterItemInfo("creditCompany.id", null, CompareType.EQUALS));
                if ("1".equals(this.relations1)) {
                    filterCollection.add(new FilterItemInfo("CreditInstitution.isBank", (Object)Boolean.TRUE));
                } else if ("0".equals(this.relations1)) {
                    filterCollection.add(new FilterItemInfo("CreditInstitution.isBank", (Object)Boolean.FALSE));
                }
            }
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)companyif) && companyif != null && this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            filterCollection.add(new FilterItemInfo("ShareOrg.id", (Object)this.getCompanyIdSet(), CompareType.INCLUDE));
        } else if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            filterCollection.add(new FilterItemInfo("ShareOrg.id", (Object)companyif.getId().toString(), CompareType.EQUALS));
        }
        if (this.getAmount() != null) {
            int intUnit = this.getUnit().getValue();
            filterCollection.add(new FilterItemInfo("Parent.LocalAmount", (Object)this.getAmount().multiply(new BigDecimal(String.valueOf(intUnit))), CompareType.GREATER_EQUALS));
        }
        filterCollection.add(new FilterItemInfo("limitType", (Object)1));
        this.startdate = this.getDateFrom();
        this.enddate = this.getDateTo();
        FilterInfo filterDate = new FilterInfo();
        if (this.enddate != null) {
            filterDate.getFilterItems().add(new FilterItemInfo("Parent.IssueDate", (Object)DateTimeUtils.truncateDate((Date)this.enddate), CompareType.LESS_EQUALS));
        }
        if (this.startdate != null) {
            filterDate.getFilterItems().add(new FilterItemInfo("Parent.ExpiredDate", (Object)DateTimeUtils.truncateDate((Date)this.startdate), CompareType.GREATER_EQUALS));
        }
        filterDate.getFilterItems().add(new FilterItemInfo("Parent.IsClosed", (Object)0, CompareType.EQUALS));
        if (this.getClosedState()) {
            filterDate.getFilterItems().add(new FilterItemInfo("Parent.IsClosed", (Object)1, CompareType.EQUALS));
            if (this.startdate != null) {
                filterDate.setMaskString("#0 and #1 and (#2 or #3)");
            } else {
                filterDate.setMaskString("#0 and (#1 or #2)");
            }
        }
        try {
            filter.mergeFilter(filterDate, "and");
        }
        catch (BOSException e) {
            throw new RuntimeException(e);
        }
        return filter;
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo isCreditHorizonStateSorter = new SorterItemInfo("CreditHorizonState");
        isCreditHorizonStateSorter.setSortType(SortType.DESCEND);
        sorter.add(isCreditHorizonStateSorter);
        switch (this.getOrderType()) {
            case 1: {
                sorter.add(new SorterItemInfo("ShareOrg.id"));
                break;
            }
            case 2: {
                sorter.add(new SorterItemInfo("CreditInstitution.id"));
                break;
            }
            case 3: {
                sorter.add(new SorterItemInfo("currency.id"));
                break;
            }
            case 4: {
                sorter.add(new SorterItemInfo("creditCompany.id"));
                break;
            }
            case 5: {
                sorter.add(new SorterItemInfo("fixid"));
                break;
            }
            default: {
                throw new IllegalArgumentException("invalidate getOrderType");
            }
        }
        return sorter;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Set getOrganizationIdSet() {
        return this.organizationIdSet;
    }

    public void setOrganizationIdSet(Set organizationIdSet) {
        this.organizationIdSet = organizationIdSet;
    }

    public Set getCompanyIdSet() {
        return this.companyIdSet;
    }

    public void setCompanyIdSet(Set companyIdSet) {
        this.companyIdSet = companyIdSet;
    }

    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    public Date getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo;
    }

    public int getOrderType() {
        return this.orderType;
    }

    public void setOrderType(int orderType) {
        this.orderType = orderType;
    }

    public AmountUnitEnum getUnit() {
        return AmountUnitEnum.getEnum((int)this.unit1);
    }

    public void setUnit(AmountUnitEnum unit) {
        this.unit1 = unit == null ? -1 : unit.getValue();
    }

    public boolean getClosedState() {
        return this.closedState;
    }

    public void setClosedState(boolean closedState) {
        this.closedState = closedState;
    }

    public Set getOrganizationIdSet_Company() {
        return this.organizationIdSet_Company;
    }

    public void setOrganizationIdSet_Company(Set organizationIdSet_Company) {
        this.organizationIdSet_Company = organizationIdSet_Company;
    }

    public LimitIsBankCreditEnum getRelations() {
        return LimitIsBankCreditEnum.getEnum(this.relations1);
    }

    public void setRelations(LimitIsBankCreditEnum relations) {
        this.relations1 = relations == null ? null : relations.getValue();
    }

    public Date getEnddate() {
        return this.enddate;
    }

    public void setEnddate(Date enddate) {
        this.enddate = enddate;
    }

    public Date getStartdate() {
        return this.startdate;
    }

    public void setStartdate(Date startdate) {
        this.startdate = startdate;
    }

    public int getUnit1() {
        return this.unit1;
    }

    public void setUnit1(int unit1) {
        this.unit1 = unit1;
    }
}

