/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.FilterParam;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

public class RptLoanDetailFilterParam
implements FilterParam {
    private static final long serialVersionUID = 7954987771289899967L;
    Set companyIdSet = null;
    Set bankIdSet = null;
    Set groupID = null;
    Set finProductTypeIdSet = null;
    Date dateFrom = null;
    Date dateTo = null;
    int unit1 = -1;
    BigDecimal amount = null;
    int horize = -1;
    int dimType = 0;
    boolean isViewZeroOfBalance = false;
    boolean isViewRepayment = false;
    boolean isViewLongTime = false;
    private String debteeState;
    private CurrencyInfo currency;
    private boolean isJoinQuery = false;

    public CurrencyInfo getCurrency() {
        return this.currency;
    }

    public void setCurrency(CurrencyInfo currency) {
        this.currency = currency;
    }

    public boolean isJoinQuery() {
        return this.isJoinQuery;
    }

    public void setJoinQuery(boolean isJoinQuery) {
        this.isJoinQuery = isJoinQuery;
    }

    public FilterInfo getFilter() {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterCollection = filter.getFilterItems();
        if (this.getBankIdSet() != null && this.getBankIdSet().size() > 0) {
            filterCollection.add(new FilterItemInfo("Institution.id", (Object)this.getBankIdSet(), CompareType.INCLUDE));
        }
        if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            filterCollection.add(new FilterItemInfo("company.id", (Object)this.getCompanyIdSet(), CompareType.INCLUDE));
        }
        if (this.getDateFrom() != null) {
            filterCollection.add(new FilterItemInfo("IssueDate", (Object)this.getDateTo(), CompareType.LESS_EQUALS));
            filterCollection.add(new FilterItemInfo("ExpiredDate", (Object)this.getDateFrom(), CompareType.GREATER_EQUALS));
        } else {
            filterCollection.add(new FilterItemInfo("IssueDate", (Object)this.getDateTo(), CompareType.LESS_EQUALS));
            filterCollection.add(new FilterItemInfo("ExpiredDate", (Object)this.getDateTo(), CompareType.GREATER_EQUALS));
        }
        if (this.getAmount() != null) {
            int intUnit = this.getUnit().getValue();
            BigDecimal bdUnit = new BigDecimal(String.valueOf(intUnit));
            filterCollection.add(new FilterItemInfo("Amount", (Object)this.getAmount().multiply(bdUnit), CompareType.GREATER_EQUALS));
        }
        if (!this.isViewZeroOfBalance) {
            filterCollection.add(new FilterItemInfo("balance", (Object)Constants.ZERO, CompareType.GREATER));
        }
        return filter;
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection sorter = new SorterItemCollection();
        switch (this.getDimType()) {
            case 1: {
                sorter.add(new SorterItemInfo("company.id"));
                break;
            }
            case 2: {
                sorter.add(new SorterItemInfo("Institution.id"));
                break;
            }
            case 3: {
                sorter.add(new SorterItemInfo("GaranteeType.id"));
                break;
            }
            case 4: {
                sorter.add(new SorterItemInfo("Currency.id"));
                break;
            }
            case 5: {
                sorter.add(new SorterItemInfo("CreditorGroup.id"));
                break;
            }
            case 6: {
                sorter.add(new SorterItemInfo("IsInCredit"));
                break;
            }
            default: {
                throw new IllegalArgumentException("invalidate getOrderType");
            }
        }
        return sorter;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Set getBankIdSet() {
        return this.bankIdSet;
    }

    public void setBankIdSet(Set bankIdSet) {
        this.bankIdSet = bankIdSet;
    }

    public Set getCompanyIdSet() {
        return this.companyIdSet;
    }

    public void setCompanyIdSet(Set companyIdSet) {
        this.companyIdSet = companyIdSet;
    }

    public Set getFinProductTypeIdSet() {
        return this.finProductTypeIdSet;
    }

    public void setFinProductTypeIdSet(Set finProductTypeIdSet) {
        this.finProductTypeIdSet = finProductTypeIdSet;
    }

    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    public Date getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo;
    }

    public int getDimType() {
        return this.dimType;
    }

    public void setDimType(int dimType) {
        this.dimType = dimType;
    }

    public AmountUnitEnum getUnit() {
        return AmountUnitEnum.getEnum((int)this.unit1);
    }

    public void setUnit(AmountUnitEnum unit) {
        this.unit1 = unit == null ? -1 : unit.getValue();
    }

    public boolean isIsViewZeroOfBalance() {
        return this.isViewZeroOfBalance;
    }

    public void setIsViewZeroOfBalance(boolean isViewZeroOfBalance) {
        this.isViewZeroOfBalance = isViewZeroOfBalance;
    }

    public boolean isIsViewRepayment() {
        return this.isViewRepayment;
    }

    public void setIsViewRepayment(boolean isViewRepayment) {
        this.isViewRepayment = isViewRepayment;
    }

    public boolean isIsViewLongTime() {
        return this.isViewLongTime;
    }

    public void setIsViewLongTime(boolean isViewLongTime) {
        this.isViewLongTime = isViewLongTime;
    }

    public String getDebteeState() {
        return this.debteeState;
    }

    public void setDebteeState(String debteeState) {
        this.debteeState = debteeState;
    }

    public Set getGroupID() {
        return this.groupID;
    }

    public void setGroupID(Set groupID) {
        this.groupID = groupID;
    }

    public int getHorize() {
        return this.horize;
    }

    public void setHorize(int horize) {
        this.horize = horize;
    }
}

