/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.freechart.util.Log;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.permission.ContextUtils;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.cl.ConsingnRepaymentBillInfo;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.common.IvtModualUtils;
import com.kingdee.eas.fm.common.app.FMDBHelper;
import com.kingdee.eas.fm.ctl.AssureBillFactory;
import com.kingdee.eas.fm.ctl.AssureBillInfo;
import com.kingdee.eas.fm.ctl.AssureBillManagerFacadeFactory;
import com.kingdee.eas.fm.ctl.AssureBillStateEnum;
import com.kingdee.eas.fm.ctl.BankFactorFactory;
import com.kingdee.eas.fm.ctl.BankFactorInfo;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeInfo;
import com.kingdee.eas.fm.fin.CreditLimitFactory;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.CreditLimitManagerFactory;
import com.kingdee.eas.fm.fin.CreditLimitUsedCollection;
import com.kingdee.eas.fm.fin.CreditLimitUsedInfo;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.FinancingBillTypeEnum;
import com.kingdee.eas.fm.fin.GuaranteeDetailCollection;
import com.kingdee.eas.fm.fin.GuaranteeDetailFactory;
import com.kingdee.eas.fm.fin.GuaranteeDetailInfo;
import com.kingdee.eas.fm.fin.GuaranteeTypePropertyEnum;
import com.kingdee.eas.fm.fin.ILoanInterest;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LimitPropertyEnum;
import com.kingdee.eas.fm.fin.LimitTypeEnum;
import com.kingdee.eas.fm.fin.LoanEntryCollection;
import com.kingdee.eas.fm.fin.LoanEntryFactory;
import com.kingdee.eas.fm.fin.LoanException;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.LoanInterestCollection;
import com.kingdee.eas.fm.fin.LoanInterestFactory;
import com.kingdee.eas.fm.fin.LoanInterestInfo;
import com.kingdee.eas.fm.fin.LoanRepaymentApplyInfo;
import com.kingdee.eas.fm.fin.RepaymentBook4PayableNotifyBuilder;
import com.kingdee.eas.fm.fin.RepaymentBookNotifyBuilder;
import com.kingdee.eas.fm.fin.RepaymentCollection;
import com.kingdee.eas.fm.fin.RepaymentException;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.ReverseBill;
import com.kingdee.eas.fm.fin.ShareTypeEnum;
import com.kingdee.eas.fm.fin.StatusExtEnum;
import com.kingdee.eas.fm.fin.WageFactory;
import com.kingdee.eas.fm.fin.WageInfo;
import com.kingdee.eas.fm.fin.app.AbstractRepaymentControllerBean;
import com.kingdee.eas.fm.fin.app.CreditLimitManagerHelper;
import com.kingdee.eas.fm.fin.app.LetterOfCreditRepaymentStragety;
import com.kingdee.eas.fm.fin.app.LetterOfGuaranteeRepaymentStragety;
import com.kingdee.eas.fm.fin.app.LoanRepaymentStragety;
import com.kingdee.eas.fm.fin.app.PayableBillRepaymentStragety;
import com.kingdee.eas.fm.fin.app.RepaymentBillSubsidiaryBookProvider;
import com.kingdee.eas.fm.fin.app.RepaymentBillSubsidiaryBookProviderLetter;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.fm.ft.FundTransferRepayBillInfo;
import com.kingdee.eas.fm.ivt.CHLoanException;
import com.kingdee.eas.fm.ivt.EntRepaymentBillFactory;
import com.kingdee.eas.fm.ivt.EntRepaymentBillInfo;
import com.kingdee.eas.fm.mnt.ForecastedBlockingFlowFactory;
import com.kingdee.eas.fm.nt.BillMakeTypeEnum;
import com.kingdee.eas.fm.nt.LetterOfCreditReachInfo;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class AbstractRepaymentStragety
extends AbstractRepaymentControllerBean {
    private static final long serialVersionUID = 1L;
    public static int Action_AddNew = 0;
    public static int Action_Remove = 2;
    protected String mappingID = null;

    public static AbstractRepaymentStragety getInstance(FinancingBillTypeEnum billType) {
        switch (billType.getValue()) {
            case 1: {
                return new LoanRepaymentStragety();
            }
            case 3: {
                return new LetterOfCreditRepaymentStragety();
            }
            case 4: {
                return new LetterOfGuaranteeRepaymentStragety();
            }
            case 2: {
                return new PayableBillRepaymentStragety();
            }
        }
        return new LoanRepaymentStragety();
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RepaymentInfo repaymentInfo = (RepaymentInfo)model;
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)repaymentInfo);
        if (EmptyUtil.isEmpty((String)repaymentInfo.getNumber())) {
            String numberSilent = NumberRuleUtil.getNumberSilent((Context)ctx, (CoreBaseInfo)repaymentInfo, (String)repaymentInfo.getCompany().getId().toString());
            repaymentInfo.setNumber(numberSilent);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)repaymentInfo, (String)"number");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)repaymentInfo, (String)"SourceBillid");
        BOSUuid sourceBillId = BOSUuid.read((String)repaymentInfo.getSourceBillId());
        FinancingBillInfo finBillInfo = FinUtils.getFinBillLocalOld(ctx, sourceBillId.toString());
        this.verify(ctx, (IObjectValue)repaymentInfo, finBillInfo, !repaymentInfo.isBat4Payable());
        if (repaymentInfo.getInterest() != null) {
            repaymentInfo.setPayment(FMHelper.add((BigDecimal)repaymentInfo.getSourceAmount(), (BigDecimal)repaymentInfo.getInterest()));
        }
        repaymentInfo.setIsGenPayBill(false);
        repaymentInfo.setStatusExtEnum(StatusExtEnum.SUBMIT);
        repaymentInfo.setMakeType(BillMakeTypeEnum.SELF);
        this.beforeAddNew(ctx, model, finBillInfo);
        this.autoCalc(ctx, repaymentInfo);
        IObjectPK pk = super._addnew(ctx, model);
        this.dispose(ctx, model, finBillInfo);
        EntRepaymentBillInfo entRepaymentInfo = repaymentInfo.getEntRepaymentBill();
        if (entRepaymentInfo != null) {
            this.updateEntRepayment(ctx, entRepaymentInfo.getId().toString(), false);
        }
        if (finBillInfo == null) {
            return pk;
        }
        this.returnCreditLimit(ctx, repaymentInfo, finBillInfo);
        if (!repaymentInfo.isBat4Payable()) {
            HashMap<String, String> idMap = new HashMap<String, String>();
            idMap.put(sourceBillId.toString(), pk.toString());
            FMHelper.saveBOTRelation((Context)ctx, idMap);
            ReverseBill.getInstance().updateSrcBalance(ctx, ReverseBill.Action_AddNew, repaymentInfo, finBillInfo);
        } else if (repaymentInfo.getAmount().compareTo(finBillInfo.getBalance()) > 0) {
            throw new FinBizException(FinBizException.PAYABLEBALANCE);
        }
        ForecastedBlockingFlowFactory.getLocalInstance((Context)ctx).editForecastBlockingFlow(sourceBillId, repaymentInfo.getAmount());
        AssureBillManagerFacadeFactory.getLocalInstance((Context)ctx).returnAssure(repaymentInfo.getId());
        this.afterAddNew(ctx, model, finBillInfo);
        this.updateFpItem(ctx, pk);
        this.recAccount(ctx, repaymentInfo);
        return pk;
    }

    private boolean repaymentReturnedQuotaIsZero(RepaymentInfo repaymentInfo) {
        return repaymentInfo.getReturnedQuota() != null && repaymentInfo.getReturnedQuota().signum() == 0;
    }

    protected abstract void beforeAddNew(Context var1, IObjectValue var2, FinancingBillInfo var3) throws BOSException, EASBizException;

    protected abstract void dispose(Context var1, IObjectValue var2, FinancingBillInfo var3) throws BOSException, EASBizException;

    protected abstract void afterAddNew(Context var1, IObjectValue var2, FinancingBillInfo var3) throws BOSException, EASBizException;

    private void updateEntRepayment(Context ctx, String id, boolean isDelete) throws BOSException {
        String sql = "";
        sql = isDelete ? " update T_IVT_EntRepaymentBill set FIsDownLoaded = 0 where fid = ? " : " update T_IVT_EntRepaymentBill set FIsDownLoaded = 1 where fid = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{id});
    }

    private void recAccount(Context ctx, RepaymentInfo repaymentInfo) throws EASBizException, BOSException {
        if (repaymentInfo.getInnerAccount() != null) {
            try {
                SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).book(repaymentInfo.getId().toString(), RepaymentBillSubsidiaryBookProvider.class.getName());
            }
            catch (Exception e) {
                String msg = e.getMessage();
                e.printStackTrace();
                if (e.getCause() != null) {
                    msg = e.getCause().getMessage();
                }
                throw new FMException(FMException.NOTBOOK, new Object[]{msg, repaymentInfo.getNumber()});
            }
        }
    }

    private String getBosTypeByBillType(FinancingBillTypeEnum type) {
        if (type.equals((Object)FinancingBillTypeEnum.CommercialDraft)) {
            return new PayableBillInfo().getBOSType().toString();
        }
        if (type.equals((Object)FinancingBillTypeEnum.LetterOfCredit)) {
            return LetterOfCreditInfo.BOSTYPE.toString();
        }
        if (type.equals((Object)FinancingBillTypeEnum.LetterOfGuarantee)) {
            return new LetterOfGuaranteeInfo().getBOSType().toString();
        }
        if (type.equals((Object)FinancingBillTypeEnum.Loan)) {
            return LoanInfo.BOSTYPE.toString();
        }
        if (type.equals((Object)FinancingBillTypeEnum.BONDS)) {
            return LoanInfo.BOSTYPE.toString();
        }
        throw new IllegalArgumentException("");
    }

    private void updateFpItem(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        FmMbgHelper.requestBudget((Context)ctx, (IObjectPK)pk);
    }

    private void autoCalc(Context ctx, RepaymentInfo repayInfo) throws FinBizException, EASBizException, BOSException {
        BigDecimal bdAmount = repayInfo.getSourceAmount();
        BigDecimal bdLocalRate = repayInfo.getLocalCurExRate();
        repayInfo.setLocalAmount(bdAmount.multiply(bdLocalRate));
    }

    protected void verify(Context ctx, IObjectValue objectValue, FinancingBillInfo finBillInfo, boolean isNeedCheck) throws BOSException, EASBizException {
        RepaymentInfo repayInfo = (RepaymentInfo)objectValue;
        if (isNeedCheck) {
            FMVerifyHelper.checkNotLessThanZero((Context)ctx, (IObjectValue)repayInfo, (String)"Amount");
            FMVerifyHelper.checkMustMoreThanZero((Context)ctx, (IObjectValue)repayInfo, (String)"LocalCurExRate");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)repayInfo, (String)"bizDate");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)repayInfo, (String)"company");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)repayInfo, (String)"Currency");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)repayInfo, (String)"SourceType");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)repayInfo, (String)"SourceBillid");
            if (repayInfo.getCreditLimit() != null) {
                FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)repayInfo, (String)"ReturnedQuota");
            }
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)repayInfo, (String)"Payment");
            this.checkBizDate(ctx, finBillInfo, repayInfo);
        }
    }

    private void checkBizDate(Context ctx, FinancingBillInfo finBillInfo, RepaymentInfo repayInfo) throws BOSException, EASBizException, FMException {
        boolean createdByFinancing;
        boolean createdByEntRepayment = repayInfo.getEntRepaymentBill() != null;
        boolean bl = createdByFinancing = finBillInfo != null;
        if (createdByFinancing || createdByEntRepayment) {
            Date srcIssue = null;
            EntRepaymentBillInfo entRpInfo = null;
            if (createdByEntRepayment) {
                entRpInfo = EntRepaymentBillFactory.getLocalInstance((Context)ctx).getEntRepaymentBillInfo((IObjectPK)new ObjectUuidPK(repayInfo.getEntRepaymentBill().getId()));
                srcIssue = entRpInfo.getRepayDate();
            } else if (createdByFinancing) {
                srcIssue = finBillInfo == null ? null : finBillInfo.getIssueDate();
            } else {
                FinUtils.throwFMCommonException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"11_RepaymentControllerBean", (Locale)ctx.getLocale()));
            }
            RepaymentInfo preRepayInfo = null;
            if (createdByEntRepayment) {
                preRepayInfo = this.getPreRepaymentByEntRepayment(ctx, repayInfo.getRepaySeq(), entRpInfo.getId().toString());
            } else if (createdByFinancing) {
                preRepayInfo = this.getPreRepaymentByFinancing(ctx, repayInfo.getRepaySeq(), repayInfo.getSourceBillId());
            } else {
                FinUtils.throwFMCommonException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"11_RepaymentControllerBean", (Locale)ctx.getLocale()));
            }
            Date preRepayBizDate = preRepayInfo == null ? null : preRepayInfo.getBizDate();
            Date atLeast = DateTimeUtils.truncateDate((Date)FinHelper.maxDate(new Date[]{srcIssue, preRepayBizDate}));
            if (atLeast != null && DateTimeUtils.truncateDate((Date)repayInfo.getBizDate()).before(atLeast)) {
                FinUtils.throwFMCommonException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"12_RepaymentControllerBean", (Locale)ctx.getLocale()));
            }
            RepaymentInfo nextRepayInfo = null;
            if (createdByEntRepayment) {
                nextRepayInfo = this.getNextRepaymentByEntRepayment(ctx, repayInfo.getRepaySeq(), entRpInfo.getId().toString());
            } else if (createdByFinancing) {
                nextRepayInfo = this.getNextRepaymentByFinancing(ctx, repayInfo.getRepaySeq(), repayInfo.getSourceBillId());
            } else {
                FinUtils.throwFMCommonException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"11_RepaymentControllerBean", (Locale)ctx.getLocale()));
            }
            Date nextRepayBizDate = nextRepayInfo == null ? null : nextRepayInfo.getBizDate();
            Date atMost = DateTimeUtils.truncateDate((Date)nextRepayBizDate);
            if (atMost != null && DateTimeUtils.truncateDate((Date)repayInfo.getBizDate()).after(atMost)) {
                FinUtils.throwFMCommonException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"13_RepaymentControllerBean", (Locale)ctx.getLocale()));
            }
        }
    }

    private RepaymentInfo getNextRepaymentByFinancing(Context ctx, int currentRepaySeq, String sourceBillId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)sourceBillId));
        filter.getFilterItems().add(new FilterItemInfo("repaySeq", (Object)new Integer(currentRepaySeq + 1)));
        view.setFilter(filter);
        RepaymentCollection col = RepaymentFactory.getLocalInstance(ctx).getRepaymentCollection(view);
        if (col == null || col.size() == 0) {
            return null;
        }
        return col.get(0);
    }

    private RepaymentInfo getNextRepaymentByEntRepayment(Context ctx, int currentRepaySeq, String entRepaymentId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("entRepaymentBill", (Object)entRepaymentId));
        filter.getFilterItems().add(new FilterItemInfo("repaySeq", (Object)new Integer(currentRepaySeq + 1)));
        view.setFilter(filter);
        RepaymentCollection col = RepaymentFactory.getLocalInstance(ctx).getRepaymentCollection(view);
        if (col == null || col.size() == 0) {
            return null;
        }
        return col.get(0);
    }

    private RepaymentInfo getPreRepaymentByFinancing(Context ctx, int currentRepaySeq, String sourceBillId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)sourceBillId));
        filter.getFilterItems().add(new FilterItemInfo("repaySeq", (Object)new Integer(currentRepaySeq - 1)));
        view.setFilter(filter);
        RepaymentCollection col = RepaymentFactory.getLocalInstance(ctx).getRepaymentCollection(view);
        if (col == null || col.size() == 0) {
            return null;
        }
        return col.get(0);
    }

    private RepaymentInfo getPreRepaymentByEntRepayment(Context ctx, int currentRepaySeq, String entRepaymentId) throws BOSException, EASBizException {
        if (currentRepaySeq == 1) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("entRepaymentBill", (Object)entRepaymentId));
        filter.getFilterItems().add(new FilterItemInfo("repaySeq", (Object)new Integer(currentRepaySeq - 1)));
        view.setFilter(filter);
        RepaymentCollection col = RepaymentFactory.getLocalInstance(ctx).getRepaymentCollection(view);
        if (col == null || col.size() == 0) {
            return null;
        }
        return col.get(0);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        RepaymentInfo repaymentInfo = (RepaymentInfo)this._getValue(ctx, pk);
        if (repaymentInfo.getCashier() != null) {
            throw new RepaymentException(RepaymentException.REPAYMENTLISTUI_003);
        }
        if (repaymentInfo.isIsGenPayBill() && !BOSUuid.read((String)repaymentInfo.getSourceBillId()).getType().equals((Object)new PayableBillInfo().getBOSType())) {
            throw new RepaymentException(RepaymentException.REPAYMENTLISTUI_004);
        }
        if (repaymentInfo.getStatusExtEnum() == StatusExtEnum.AUDIT) {
            throw new RepaymentException(RepaymentException.REPAYMENTLISTUI_005);
        }
        String sourceBillId = repaymentInfo.getSourceBillId();
        Map hm = this._getInitEditData(ctx, (IObjectPK)new ObjectUuidPK(sourceBillId));
        Integer maxSeqInteger = (Integer)hm.get("maxseq");
        int maxSeq = maxSeqInteger;
        int realSeq = repaymentInfo.getRepaySeq();
        if (realSeq != maxSeq - 1) {
            throw new CHLoanException(CHLoanException.ENTREPAYMENT_DELETE_ERROR2);
        }
        IBOTRelation botRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        botRelation.removeRelationByDestObjId(pk.toString(), this.getBosTypeByBillType(repaymentInfo.getSourceType()));
        if (botRelation.getSrcObjIdBySrcType(pk.toString(), new PaymentBillInfo().getBOSType().toString()).size() > 0) {
            botRelation.removeRelationByDestObjId(pk.toString(), new PaymentBillInfo().getBOSType().toString());
        }
        if ("".equals(repaymentInfo.getSourceBillId())) {
            throw new BOSException("source bill is empty");
        }
        this.delBookAndSubsidiary(ctx, (IObjectValue)repaymentInfo);
        FinancingBillInfo finBillInfo = FinUtils.getFinBillLocal(ctx, repaymentInfo.getSourceBillId().toString());
        CreditLimitUsedCollection usedCol = null;
        if (finBillInfo.getCreditLimit() != null) {
            usedCol = CreditLimitManagerHelper.getUsedCol(ctx, repaymentInfo.getId(), finBillInfo.getCreditLimit());
        }
        BOSUuid sourcebill = BOSUuid.read((String)repaymentInfo.getSourceBillId());
        this.cancelReturnCreditLimit(ctx, null, repaymentInfo, finBillInfo, usedCol);
        ReverseBill.getInstance().updateSrcBalance(ctx, ReverseBill.Action_Remove, repaymentInfo, finBillInfo);
        this.beforeDelete(ctx, (IObjectValue)repaymentInfo, finBillInfo);
        AssureBillManagerFacadeFactory.getLocalInstance((Context)ctx).cancelReturnAssure(repaymentInfo.getId());
        BigDecimal amount = repaymentInfo.getAmount();
        amount = amount.negate();
        ForecastedBlockingFlowFactory.getLocalInstance((Context)ctx).editForecastBlockingFlow(sourcebill, amount);
        if (repaymentInfo.isIsGenPayBill()) {
            Set idSet = FMHelper.getDestBillIdSet((Context)ctx, (String)repaymentInfo.getId().toString());
            for (String descId : idSet) {
                if (!BOSUuid.read((String)descId).getType().equals((Object)new PaymentBillInfo().getBOSType())) continue;
                PaymentBillFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(descId));
            }
        }
        FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
        FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)pk);
        super._delete(ctx, pk);
        this.reverseLoanRepay(ctx, repaymentInfo, "0");
        this.afterDelete(ctx, (IObjectValue)repaymentInfo, finBillInfo);
        EntRepaymentBillInfo entRepaymentInfo = repaymentInfo.getEntRepaymentBill();
        if (entRepaymentInfo != null) {
            this.updateEntRepayment(ctx, entRepaymentInfo.getId().toString(), true);
        }
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)repaymentInfo, (String)repaymentInfo.getCompany().getId().toString());
    }

    protected void cancelAntiWage(Context ctx, Map antiMap) throws EASBizException, BOSException {
        int j;
        if (antiMap == null) {
            return;
        }
        ArrayList assureList = (ArrayList)antiMap.get("assureList");
        ArrayList pledgeList = (ArrayList)antiMap.get("pledgeList");
        ArrayList impawnList = (ArrayList)antiMap.get("impawnList");
        ArrayList<String> assureIdList = new ArrayList<String>();
        ArrayList<String> wageIdList = new ArrayList<String>();
        for (int i = 0; i < assureList.size(); ++i) {
            String[] assures = (String[])assureList.get(i);
            assureIdList.add(assures[0]);
        }
        for (j = 0; j < pledgeList.size(); ++j) {
            String[] pledges = (String[])pledgeList.get(j);
            wageIdList.add(pledges[0]);
        }
        for (j = 0; j < impawnList.size(); ++j) {
            String[] impawns = (String[])impawnList.get(j);
            wageIdList.add(impawns[0]);
        }
        if (assureIdList.size() != 0 || wageIdList.size() != 0) {
            RepaymentFactory.getLocalInstance(ctx).doAntiWage(assureIdList, wageIdList);
        }
    }

    protected abstract void delBookAndSubsidiary(Context var1, IObjectValue var2) throws BOSException, EASBizException;

    protected abstract boolean isCancelLimit(Context var1, IObjectValue var2, FinancingBillInfo var3) throws BOSException, EASBizException;

    protected abstract void beforeDelete(Context var1, IObjectValue var2, FinancingBillInfo var3) throws BOSException, EASBizException;

    protected abstract void afterDelete(Context var1, IObjectValue var2, FinancingBillInfo var3) throws BOSException, EASBizException;

    private void reverseLoanRepay(Context ctx, RepaymentInfo info, String isCreate) throws BOSException, EASBizException {
        if (!StringUtil.isEmpty((String)info.getSourceBillId())) {
            BOSUuid bisid = BOSUuid.read((String)info.getSourceBillId());
            BOSObjectType idType = bisid.getType();
            String sql = null;
            if (idType.equals((Object)LoanRepaymentApplyInfo.BOSTYPE)) {
                sql = "Update T_FIN_LoanRepaymentApply set FIsCreateRepayBill =? where Fid=?";
                FMDBHelper.execute((Context)ctx, (String)sql, (Object[])new String[]{isCreate, info.getSourceBillId()});
            } else if (!idType.equals((Object)FundTransferRepayBillInfo.BOSTYPE) && !idType.equals((Object)ConsingnRepaymentBillInfo.BOSTYPE) && info.getCreateFrom() != null) {
                BOSUuid bisid2 = BOSUuid.read((String)info.getCreateFrom());
                BOSObjectType idType2 = bisid2.getType();
                if (idType2.equals((Object)FundTransferRepayBillInfo.BOSTYPE)) {
                    sql = "Update T_FT_FundTransferRepayBill set FIsCreateLoanRepayBill =? where Fid=?";
                    FMDBHelper.execute((Context)ctx, (String)sql, (Object[])new String[]{isCreate, info.getCreateFrom()});
                } else if (idType2.equals((Object)ConsingnRepaymentBillInfo.BOSTYPE)) {
                    sql = "Update T_CL_ConsingnRepaymentBill set FIsCreateLoanRepayBill =? where Fid=?";
                    FMDBHelper.execute((Context)ctx, (String)sql, (Object[])new String[]{isCreate, info.getCreateFrom()});
                } else if (idType2.equals((Object)LoanRepaymentApplyInfo.BOSTYPE)) {
                    sql = "Update T_FIN_LoanRepaymentApply set FIsCreateRepayBill = ? where Fid= ?";
                    FMDBHelper.execute((Context)ctx, (String)sql, (Object[])new String[]{isCreate, info.getCreateFrom()});
                }
            }
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RepaymentInfo oldInfo;
        RepaymentInfo info = (RepaymentInfo)model;
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)info);
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)((RepaymentInfo)model));
        boolean isExists = this._exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
        if (null != info.getId() && isExists && (oldInfo = this.getRepaymentInfo(ctx, "select *  where id='" + info.getId().toString() + "'")) != null) {
            FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)new ObjectStringPK(oldInfo.getId().toString()));
        }
        info.setPayment(Constants.ZERO);
        this.verify(ctx, (IObjectValue)info, null, true);
        if (info.getInterest() != null) {
            info.setPayment(info.getSourceAmount().add(info.getInterest()));
        }
        if (!EmptyUtil.isEmpty((String)info.getSourceBillId()) && FMHelper.isInstanceof((String)info.getSourceBillId(), PayableBillInfo.class)) {
            PayableBillInfo payInfo = (PayableBillInfo)PayableBillFactory.getLocalInstance((Context)ctx).getBillBaseInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()));
            info.setNtType(payInfo.getNtType());
        }
        IObjectPK pk = super._submit(ctx, model);
        FinancingBillInfo finBillInfo = FinUtils.getFinBillLocal(ctx, info.getSourceBillId().toString());
        this.afterSubmit(ctx, model, finBillInfo, !isExists);
        RepaymentInfo sumbittedInfo = this.getRepaymentInfo(ctx, "select * where id='" + pk.toString() + "'");
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)sumbittedInfo);
        this.reverseLoanRepay(ctx, info, "1");
        String sql = "update T_FIN_Repayment set fstatusextenum = 0 where fid = '" + pk.toString() + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        return pk;
    }

    protected abstract void afterSubmit(Context var1, IObjectValue var2, FinancingBillInfo var3, boolean var4) throws BOSException, EASBizException;

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected void _checkSeqDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filter = this.getCheckSeqDupFilter(model, true, "repaySeq");
        if (this._exists(ctx, filter)) {
            throw new FinBizException(FinBizException.CHECKDUPSEQ, new Object[]{model.getString("repaySeq"), ""});
        }
    }

    protected FilterInfo getCheckSeqDupFilter(IObjectValue model, boolean isNeedComp, String seqName) {
        FilterInfo filter = new FilterInfo();
        if (isNeedComp) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)model.getObjectValue("company").getBOSUuid("id")));
        }
        filter.getFilterItems().add(new FilterItemInfo(seqName, (Object)model.getString(seqName)));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)model.getBOSUuid("id"), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("SourceBillid", (Object)model.getString("SourceBillid")));
        return filter;
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        DAPTransformResult dDAPTransformResult = super._generateVoucher(ctx, sourceBillCollection, botMappingPK);
        if (IvtModualUtils.getSysParam((Context)ctx, (String)"FIN009")) {
            for (int i = 0; i < sourceBillCollection.size(); ++i) {
                ObjectUuidPK srcBillPK = new ObjectUuidPK(AccessHelper.getId((Object)sourceBillCollection.getObject(i)));
                LoanInterestInfo intRe = this.findLoanInterestBillInfo(ctx, (IObjectPK)srcBillPK);
                if (intRe == null || intRe.isFivouchered() || intRe.getRealInterest().compareTo(Constants.ZERO) == 0 && intRe.getPunishInterest().compareTo(Constants.ZERO) == 0) continue;
                try {
                    LoanInterestFactory.getLocalInstance(ctx).generateVoucher((IObjectPK)new ObjectUuidPK(intRe.getId().toString()));
                    continue;
                }
                catch (BOSException e) {
                    throw e;
                }
                catch (EASBizException e) {
                    throw new FMException(FMException.EASBIZADDBOT, new Object[]{e.getMessage()});
                }
            }
        }
        return dDAPTransformResult;
    }

    private LoanInterestInfo findLoanInterestBillInfo(Context ctx, IObjectPK srcBillPK) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("repayment.id", (Object)srcBillPK.toString()));
        evi.setFilter(f);
        LoanInterestCollection intCol = LoanInterestFactory.getLocalInstance(ctx).getLoanInterestCollection(evi);
        if (intCol != null && intCol.size() > 0) {
            return intCol.get(0);
        }
        return null;
    }

    protected boolean _deleteVoucher(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        LoanInterestInfo intRe;
        if (IvtModualUtils.getSysParam((Context)ctx, (String)"FIN009") && (intRe = this.findLoanInterestBillInfo(ctx, sourceBillPk)) != null && intRe.isFivouchered()) {
            LoanInterestFactory.getLocalInstance(ctx).deleteVoucher((IObjectPK)new ObjectUuidPK(intRe.getId().toString()));
        }
        return super._deleteVoucher(ctx, sourceBillPk);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        RepaymentInfo repaymentInfo = (RepaymentInfo)model;
        RepaymentInfo oldRepaymentInfo = RepaymentFactory.getLocalInstance(ctx).getRepaymentInfo((IObjectPK)new ObjectUuidPK(repaymentInfo.getId()));
        BigDecimal OriginalAmount = oldRepaymentInfo.getAmount();
        this.autoCalc(ctx, repaymentInfo);
        super._update(ctx, pk, model);
        this.updateFpItem(ctx, pk);
        FinancingBillInfo finBillInfo = FinUtils.getFinBillLocal(ctx, repaymentInfo.getSourceBillId());
        BOSUuid sourceBillId = BOSUuid.read((String)repaymentInfo.getSourceBillId());
        CreditLimitUsedCollection usedCol = null;
        if (finBillInfo.getCreditLimit() != null) {
            usedCol = CreditLimitManagerHelper.getUsedCol(ctx, oldRepaymentInfo.getId(), finBillInfo.getCreditLimit());
        }
        this.cancelReturnCreditLimit(ctx, repaymentInfo, oldRepaymentInfo, finBillInfo, usedCol);
        this.returnCreditLimit(ctx, repaymentInfo, finBillInfo);
        BigDecimal latestAmount = repaymentInfo.getAmount();
        ForecastedBlockingFlowFactory.getLocalInstance((Context)ctx).editForecastBlockingFlow(sourceBillId, latestAmount.subtract(OriginalAmount));
    }

    private void returnCreditLimit(Context ctx, RepaymentInfo repaymentInfo, FinancingBillInfo finBillInfo) throws EASBizException, BOSException {
        if (finBillInfo.isIsInCredit()) {
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)repaymentInfo, (String)"CreditLimit");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)repaymentInfo, (String)"ReturnedQuota");
        }
        if (!this.repaymentReturnedQuotaIsZero(repaymentInfo)) {
            FinUtils.returnQuota(ctx, repaymentInfo, finBillInfo, false);
            if (FinUtils.isNeedReturnQuota(false, finBillInfo)) {
                ReverseBill.getInstance().updateReturnedQuota(ctx, ReverseBill.Action_AddNew, repaymentInfo, finBillInfo, null);
            }
        }
    }

    private void cancelReturnCreditLimit(Context ctx, RepaymentInfo repayInfo, RepaymentInfo oldRepayInfo, FinancingBillInfo finBillInfo, CreditLimitUsedCollection usedCol) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty((AbstractObjectCollection)usedCol)) {
            return;
        }
        if (this.isCancelLimit(ctx, (IObjectValue)oldRepayInfo, finBillInfo)) {
            if (finBillInfo != null && finBillInfo.isIsInCredit()) {
                if (finBillInfo.getCreditLimit() != null) {
                    BigDecimal returnQuota = this.getReturanQuota(repayInfo, oldRepayInfo);
                    FinUtils.checkAmount(ctx, finBillInfo.getCreditLimit().getId().toString(), finBillInfo.getId().toString(), returnQuota);
                }
                if (finBillInfo.getCreditLimit() != null && finBillInfo.getCreditLimit().getCreditUsage().isColligateCredit() && finBillInfo.getCreditLimit().getShareType() == ShareTypeEnum.ASSIGN && !LimitTypeEnum.BILLPOOL_LIMIT.equals((Object)finBillInfo.getCreditLimit().getLimitType())) {
                    CreditLimitManagerFactory.getLocalInstance(ctx).cancelLimitByFinancingProduct(oldRepayInfo.getId(), finBillInfo, oldRepayInfo.getReturnedQuota());
                } else {
                    CreditLimitManagerFactory.getLocalInstance(ctx).cancelLimit(oldRepayInfo.getId(), finBillInfo.getCreditLimit().getId());
                }
            }
            this.updateReturnedQuota(ctx, ReverseBill.Action_Remove, oldRepayInfo, finBillInfo, usedCol);
        }
    }

    private void updateReturnedQuota(Context ctx, int actiontype, RepaymentInfo repaymentInfo, FinancingBillInfo finBillInfo, CreditLimitUsedCollection usedCollection) throws BOSException, EASBizException {
        if (actiontype == Action_AddNew) {
            if (repaymentInfo.getCreditLimit() != null && repaymentInfo.getAmount().compareTo(SysConstant.BIGZERO) == 1) {
                this.updateReturnedQuota(ctx, finBillInfo, repaymentInfo.getReturnedQuota(), repaymentInfo, actiontype, usedCollection);
            }
        } else if (repaymentInfo.getCreditLimit() != null) {
            this.updateReturnedQuota(ctx, finBillInfo, repaymentInfo.getReturnedQuota().negate(), repaymentInfo, actiontype, usedCollection);
        }
    }

    private void updateReturnedQuota(Context ctx, FinancingBillInfo finBillInfo, BigDecimal orgAmount, RepaymentInfo repaymentInfo, int actiontype, CreditLimitUsedCollection usedCol2) throws BOSException, EASBizException {
        CreditLimitInfo creditLimitInfo = this.getCreditLimitInfo(ctx, finBillInfo.getId());
        if (creditLimitInfo != null && creditLimitInfo.getProperty().equals((Object)LimitPropertyEnum.REVOLVING_AMOUNT)) {
            if (finBillInfo.getCreditLimit().getCreditUsage().isColligateCredit() && finBillInfo.getCreditLimit().getShareType() == ShareTypeEnum.ASSIGN) {
                CreditLimitUsedCollection usedCollection = this.getUsedCollection(ctx, finBillInfo, repaymentInfo, actiontype, usedCol2);
                String sql = "update T_FIN_CreditLimitUsed set FReturnedQuota= FReturnedQuota+? where FBillId=? and  FFinProID = ? and FCompanyID = ? and fcreditlimitid = ?";
                for (int i = 0; i < usedCollection.size(); ++i) {
                    CreditLimitUsedInfo usedInfo = usedCollection.get(i);
                    BigDecimal returnedQuota = usedInfo.getUsedQuota();
                    if (actiontype == Action_AddNew) {
                        returnedQuota = returnedQuota.negate();
                    }
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{returnedQuota, finBillInfo.getId().toString(), usedInfo.getFinPro().getId().toString(), usedInfo.getCompany().getId().toString(), creditLimitInfo.getId().toString()});
                }
            } else {
                String sql = "update T_FIN_CreditLimitUsed set FReturnedQuota= FReturnedQuota+? where FBillId=?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{orgAmount, finBillInfo.getId().toString()});
            }
        }
    }

    private CreditLimitInfo getCreditLimitInfo(Context ctx, BOSUuid finBillId) throws BOSException, EASBizException {
        String clId = this.getCreditLimitId(ctx, finBillId);
        if (clId == null) {
            return null;
        }
        return CreditLimitFactory.getLocalInstance(ctx).getCreditLimitInfo((IObjectPK)new ObjectUuidPK(clId));
    }

    private String getCreditLimitId(Context ctx, BOSUuid finBillId) throws BOSException {
        String tableName = EJBAccessFactory.createLocalInstance((Context)ctx).getEntityTableName(finBillId.getType());
        StringBuffer sb = new StringBuffer();
        sb.append("select FCreditLimitId from ").append(tableName).append("\n");
        sb.append("where FID=?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{finBillId.toString()});
        try {
            if (rs.next()) {
                return rs.getString("FCreditLimitId");
            }
            return null;
        }
        catch (SQLException e) {
            throw FMHelper.toBOSException((Throwable)e);
        }
    }

    private CreditLimitUsedCollection getUsedCollection(Context ctx, FinancingBillInfo finBillInfo, RepaymentInfo repaymentInfo, int actiontype, CreditLimitUsedCollection usedCol2) throws EASBizException, BOSException {
        CreditLimitUsedCollection usedCollection = null;
        usedCollection = actiontype == Action_AddNew ? CreditLimitManagerHelper.getUsedCol(ctx, repaymentInfo.getId(), finBillInfo.getCreditLimit()) : usedCol2;
        return usedCollection;
    }

    private BigDecimal getReturanQuota(RepaymentInfo repayInfo, RepaymentInfo oldRepayInfo) {
        if (repayInfo != null) {
            BigDecimal hisReturnQuota;
            BigDecimal returnQuota = repayInfo.getReturnedQuota() == null ? Constants.ZERO : repayInfo.getReturnedQuota();
            BigDecimal bigDecimal = hisReturnQuota = oldRepayInfo.getReturnedQuota() == null ? Constants.ZERO : oldRepayInfo.getReturnedQuota();
            if (returnQuota.compareTo(hisReturnQuota) < 0) {
                return hisReturnQuota.subtract(returnQuota);
            }
            return Constants.ZERO;
        }
        return oldRepayInfo.getReturnedQuota();
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.verify(ctx, model, null, true);
        return super._save(ctx, model);
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            RepaymentInfo info = (RepaymentInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setAccountant(null);
                info.setFiVouchered(false);
                info.setVoucherNumber(null);
                info.setVoucherType(null);
            } else {
                info.setAccountant(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                info.setFiVouchered(true);
                String voucherID = relation.getDestObjectID();
                VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(voucherID));
                info.setVoucherNumber(voucherInfo.getNumber());
                info.setVoucherType(voucherInfo.getVoucherType());
            }
        }
        super._update(ctx, srcBillPK, srcBillVO);
    }

    @Override
    protected void _antiAudit(Context ctx, String pk) throws BOSException, EASBizException {
        RepaymentInfo info = RepaymentFactory.getLocalInstance(ctx).getRepaymentInfo((IObjectPK)new ObjectUuidPK(pk));
        if (info.getStatusExtEnum() != StatusExtEnum.AUDIT) {
            throw new RepaymentException(RepaymentException.REPAYMENTLISTUI_001);
        }
        if (!FMHelper.isEmpty((CoreBaseInfo)info.getCashier())) {
            throw new RepaymentException(RepaymentException.REPAYMENTLISTUI_002);
        }
        String sql = "update T_FIN_Repayment set fstatusextenum = -1, fauditorID = null where fid = '" + pk + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected Map _batchAntiAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        RepaymentCollection coll = RepaymentFactory.getLocalInstance(ctx).getRepaymentCollection(view);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)coll)) {
            for (int i = 0; i < coll.size(); ++i) {
                RepaymentInfo info = coll.get(i);
                try {
                    if (info.getStatusExtEnum() != StatusExtEnum.AUDIT) {
                        idSet.remove(info.getId().toString());
                        throw new RepaymentException(RepaymentException.REPAYMENTLISTUI_001);
                    }
                    if (!FMHelper.isEmpty((CoreBaseInfo)info.getCashier())) {
                        idSet.remove(info.getId().toString());
                        throw new RepaymentException(RepaymentException.REPAYMENTLISTUI_002);
                    }
                    BOTRelationCollection colls = this.getBOTRelation(ctx, info.getId().toString());
                    if (colls.size() <= 0) continue;
                    idSet.remove(info.getId().toString());
                    throw new RepaymentException(RepaymentException.REPAYMENTLISTUI_006);
                }
                catch (RepaymentException e) {
                    map.put(info.getNumber(), e.getMessage());
                }
            }
            if (idSet.size() > 0) {
                String sql = "update T_FIN_Repayment set fstatusextenum = -1, fauditorID = null where fid in " + FMHelper.setTran2String((Set)idSet) + "";
                DbUtil.execute((Context)ctx, (String)sql);
            }
        }
        return map;
    }

    private BOTRelationCollection getBOTRelation(Context ctx, String billId) throws BTPException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        view.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)billId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)new LoanInterestInfo().getBOSType().toString(), CompareType.NOTEQUALS));
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        BOTRelationCollection relateColl = iBOTRelation.getCollection(view);
        return relateColl;
    }

    @Override
    protected void _audit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserByID(ctx.getCaller());
        String userId = user.getId().toString();
        String sql = "update T_FIN_Repayment set fstatusextenum = 1 , fauditorID = '" + userId + "' where fid = '" + ((RepaymentInfo)model).getId().toString() + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected void _confirm(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected void _batchConfirm(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
    }

    @Override
    protected void _batchRepayment(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        for (RepaymentInfo element : colls) {
            this.submit(ctx, (CoreBaseInfo)element);
        }
    }

    @Override
    protected void _book(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        this.verifyBeforeBook(ctx, idList);
        String repaymentId = (String)idList.toArray()[0];
        Object builder = null;
        RepaymentInfo info = RepaymentFactory.getLocalInstance(ctx).getRepaymentInfo((IObjectPK)new ObjectUuidPK(repaymentId));
        BOSUuid sourceBillId = BOSUuid.read((String)info.getSourceBillId());
        builder = sourceBillId.getType().equals((Object)new PayableBillInfo().getBOSType()) ? new RepaymentBook4PayableNotifyBuilder() : new RepaymentBookNotifyBuilder();
        JournalCollection journalColl = new JournalCollection();
        String sql = "UPDATE T_FIN_Repayment SET FCashierID = ? WHERE FID = ? ";
        String userId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString();
        String billId = null;
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            billId = (String)idList.get(i);
            if (this.isBooked(ctx, billId)) continue;
            journalColl.addCollection(builder.getJournalColl(ctx, billId));
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userId, billId});
        }
        IBookNotifyFacade bookFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        bookFacade.bookBatch(journalColl);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("repayment.id", new HashSet(idList), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("cashier", null, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isGenPayBill", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("account", null, CompareType.NOTEQUALS));
        view.setFilter(filter);
        ILoanInterest loanIntlocalInstance = LoanInterestFactory.getLocalInstance(ctx);
        LoanInterestCollection intCol = loanIntlocalInstance.getLoanInterestCollection(view);
        ArrayList<String> intIdList = new ArrayList<String>();
        int size2 = intCol.size();
        for (int i = 0; i < size2; ++i) {
            intIdList.add(intCol.get(i).getId().toString());
        }
        if (intIdList.size() > 0) {
            loanIntlocalInstance.book(intIdList);
        }
    }

    private void verifyBeforeBook(Context ctx, List idList) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.getSelector().add("BankAcct.*");
        evi.getSelector().add("acutionAcctBank.*");
        evi.setFilter(filter);
        RepaymentCollection coll = RepaymentFactory.getLocalInstance(ctx).getRepaymentCollection(evi);
        RepaymentInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            boolean isLess;
            info = coll.get(i);
            if (info.isIsGenPayBill()) {
                throw new LoanException(LoanException.HAS_GEN_PAY);
            }
            BigDecimal tmp = info.getAmount().subtract(info.getCautionAmt());
            boolean isGreater = tmp.compareTo(Constants.ZERO) > 0;
            boolean bl = isLess = tmp.compareTo(Constants.ZERO) < 0;
            if ((isGreater || isLess) && info.getBankAcct() == null) {
                throw new LoanException(LoanException.BOOKERROR, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"14_RepaymentControllerBean", (Locale)ctx.getLocale())});
            }
            if (info.getCautionAmt().compareTo(Constants.ZERO) != 0 && info.getAcutionAcctBank() == null) {
                throw new LoanException(LoanException.BOOKERROR, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"9_LoanFacadeControllerBean", (Locale)ctx.getLocale())});
            }
            String sourceBillId = info.getSourceBillId();
            if (FMHelper.isEmpty((String)sourceBillId)) continue;
            this.subVerifyBeforeBook(ctx, info);
        }
    }

    protected abstract void subVerifyBeforeBook(Context var1, RepaymentInfo var2) throws BOSException, EASBizException;

    private boolean isBooked(Context ctx, String billId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        view.setFilter(filter);
        JournalCollection coll = JournalFactory.getLocalInstance((Context)ctx).getJournalCollection(view);
        return coll != null && coll.size() > 0;
    }

    @Override
    protected void _cancelBook(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        String sql = "UPDATE T_FIN_Repayment SET FCashierID = NULL WHERE FID = ? ";
        IBookNotifyFacade bookFacade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            String billId = (String)idList.get(i);
            bookFacade.antiBook(billId);
            paramList.add(new Object[]{billId});
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, paramList);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("repayment.id", new HashSet(idList), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("cashier", null, CompareType.NOTEQUALS));
        view.setFilter(filter);
        ILoanInterest loanIntlocalInstance = LoanInterestFactory.getLocalInstance(ctx);
        LoanInterestCollection intCol = loanIntlocalInstance.getLoanInterestCollection(view);
        ArrayList<String> intIdList = new ArrayList<String>();
        int size2 = intCol.size();
        for (int i = 0; i < size2; ++i) {
            intIdList.add(intCol.get(i).getId().toString());
        }
        if (intIdList.size() > 0) {
            loanIntlocalInstance.cancelBook(intIdList);
        }
    }

    @Override
    protected Map _checkCanDoAnti(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanInfo loanInfo = LoanFactory.getLocalInstance(ctx).getLoanInfo(pk);
        if (loanInfo.getBalance().compareTo(Constants.ZERO) != 0) {
            return null;
        }
        String oql = "select id,billId,billNumber,guaranteeTypeProperty where parentBillId='" + loanInfo.getId().toString() + "'";
        GuaranteeDetailCollection GDColl = GuaranteeDetailFactory.getLocalInstance(ctx).getGuaranteeDetailCollection(oql);
        ArrayList<String[]> assureList = new ArrayList<String[]>();
        ArrayList<String[]> pledgeList = new ArrayList<String[]>();
        ArrayList<String[]> impawnList = new ArrayList<String[]>();
        for (int i = 0; i < GDColl.size(); ++i) {
            WageInfo wageInfo;
            GuaranteeDetailInfo GDInfo = GDColl.get(i);
            String entryId = GDInfo.getBillId();
            if (EmptyUtil.isEmpty((String)entryId)) continue;
            if (GDInfo.getGuaranteeTypeProperty() == GuaranteeTypePropertyEnum.assure) {
                AssureBillInfo assureInfo = AssureBillFactory.getLocalInstance((Context)ctx).getAssureBillInfo((IObjectPK)new ObjectUuidPK(entryId));
                if (assureInfo.isCanceled()) continue;
                String[] assures = new String[]{entryId, GDInfo.getBillNumber()};
                assureList.add(assures);
                continue;
            }
            if (GDInfo.getGuaranteeTypeProperty() == GuaranteeTypePropertyEnum.pledge) {
                BankFactorInfo bankFactInfo;
                String[] pledges;
                if (FMHelper.isInstanceof((String)entryId, WageInfo.class)) {
                    wageInfo = WageFactory.getLocalInstance(ctx).getWageInfo((IObjectPK)new ObjectUuidPK(entryId));
                    if (wageInfo.isIsAntiWage()) continue;
                    pledges = new String[]{entryId, GDInfo.getBillNumber()};
                    pledgeList.add(pledges);
                    continue;
                }
                if (!FMHelper.isInstanceof((String)entryId, BankFactorInfo.class) || (bankFactInfo = BankFactorFactory.getLocalInstance((Context)ctx).getBankFactorInfo((IObjectPK)new ObjectUuidPK(entryId))).isIsCancel()) continue;
                pledges = new String[]{entryId, GDInfo.getBillNumber()};
                pledgeList.add(pledges);
                continue;
            }
            if (GDInfo.getGuaranteeTypeProperty() != GuaranteeTypePropertyEnum.impawn || (wageInfo = WageFactory.getLocalInstance(ctx).getWageInfo((IObjectPK)new ObjectUuidPK(entryId))).isIsAntiWage()) continue;
            String[] impawns = new String[]{entryId, GDInfo.getBillNumber()};
            impawnList.add(impawns);
        }
        HashMap<String, ArrayList<String[]>> map = new HashMap<String, ArrayList<String[]>>();
        map.put("assureList", assureList);
        map.put("pledgeList", pledgeList);
        map.put("impawnList", impawnList);
        return map;
    }

    @Override
    protected Map _checkCanCancelAnti(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanInfo loanInfo = LoanFactory.getLocalInstance(ctx).getLoanInfo(pk);
        String oql = "select id,billId,billNumber,guaranteeTypeProperty where parentBillId='" + loanInfo.getId().toString() + "'";
        GuaranteeDetailCollection GDColl = GuaranteeDetailFactory.getLocalInstance(ctx).getGuaranteeDetailCollection(oql);
        ArrayList<String[]> assureList = new ArrayList<String[]>();
        ArrayList<String[]> pledgeList = new ArrayList<String[]>();
        ArrayList<String[]> impawnList = new ArrayList<String[]>();
        for (int i = 0; i < GDColl.size(); ++i) {
            WageInfo wageInfo;
            GuaranteeDetailInfo GDInfo = GDColl.get(i);
            String entryId = GDInfo.getBillId();
            if (EmptyUtil.isEmpty((String)entryId)) continue;
            if (GDInfo.getGuaranteeTypeProperty() == GuaranteeTypePropertyEnum.assure) {
                AssureBillInfo assureInfo = AssureBillFactory.getLocalInstance((Context)ctx).getAssureBillInfo((IObjectPK)new ObjectUuidPK(entryId));
                if (!assureInfo.isCanceled()) continue;
                String[] assures = new String[]{entryId, GDInfo.getBillNumber()};
                assureList.add(assures);
                continue;
            }
            if (GDInfo.getGuaranteeTypeProperty() == GuaranteeTypePropertyEnum.pledge) {
                BankFactorInfo bankFactInfo;
                String[] pledges;
                if (FMHelper.isInstanceof((String)entryId, WageInfo.class)) {
                    wageInfo = WageFactory.getLocalInstance(ctx).getWageInfo((IObjectPK)new ObjectUuidPK(entryId));
                    if (!wageInfo.isIsAntiWage()) continue;
                    pledges = new String[]{entryId, GDInfo.getBillNumber()};
                    pledgeList.add(pledges);
                    continue;
                }
                if (!FMHelper.isInstanceof((String)entryId, BankFactorInfo.class) || !(bankFactInfo = BankFactorFactory.getLocalInstance((Context)ctx).getBankFactorInfo((IObjectPK)new ObjectUuidPK(entryId))).isIsCancel()) continue;
                pledges = new String[]{entryId, GDInfo.getBillNumber()};
                pledgeList.add(pledges);
                continue;
            }
            if (GDInfo.getGuaranteeTypeProperty() != GuaranteeTypePropertyEnum.impawn || !(wageInfo = WageFactory.getLocalInstance(ctx).getWageInfo((IObjectPK)new ObjectUuidPK(entryId))).isIsAntiWage()) continue;
            String[] impawns = new String[]{entryId, GDInfo.getBillNumber()};
            impawnList.add(impawns);
        }
        HashMap<String, ArrayList<String[]>> map = new HashMap<String, ArrayList<String[]>>();
        map.put("assureList", assureList);
        map.put("pledgeList", pledgeList);
        map.put("impawnList", impawnList);
        return map;
    }

    @Override
    protected void _doAntiWage(Context ctx, List assureIdList, List pledgeIdList) throws BOSException, EASBizException {
        for (int i = 0; i < assureIdList.size(); ++i) {
            this.doAntiAssure(ctx, (String)assureIdList.get(i));
        }
        for (int j = 0; j < pledgeIdList.size(); ++j) {
            this.doAntiPledge(ctx, (String)pledgeIdList.get(j));
        }
    }

    private void doAntiAssure(Context ctx, String pk) throws EASBizException, BOSException {
        AssureBillInfo assureInfo = AssureBillFactory.getLocalInstance((Context)ctx).getAssureBillInfo((IObjectPK)new ObjectUuidPK(pk));
        if (AssureBillStateEnum.APPROVE.equals((Object)assureInfo.getState())) {
            AssureBillFactory.getLocalInstance((Context)ctx).cancel(pk);
        }
    }

    private void doAntiPledge(Context ctx, String pk) throws EASBizException, BOSException {
        if (!EmptyUtil.isEmpty((String)pk)) {
            if (FMHelper.isInstanceof((String)pk, WageInfo.class)) {
                WageInfo wageInfo = WageFactory.getLocalInstance(ctx).getWageInfo((IObjectPK)new ObjectUuidPK(pk));
                if (wageInfo.isIsRelationRec()) {
                    WageFactory.getLocalInstance(ctx).antiWage((IObjectPK)new ObjectUuidPK(pk), new ReceivableBillInfo().getBOSType());
                } else {
                    WageFactory.getLocalInstance(ctx).antiWage((IObjectPK)new ObjectUuidPK(pk), null);
                }
            } else if (FMHelper.isInstanceof((String)pk, BankFactorInfo.class)) {
                BankFactorFactory.getLocalInstance((Context)ctx).repeal((IObjectPK)new ObjectUuidPK(pk));
            }
        }
    }

    @Override
    protected void _doCancelAntiWage(Context ctx, List assureIdList, List pledgeIdList) throws BOSException, EASBizException {
        for (int i = 0; i < assureIdList.size(); ++i) {
            this.doCancelAssure(ctx, (String)assureIdList.get(i));
        }
        for (int j = 0; j < pledgeIdList.size(); ++j) {
            this.doCancelPledge(ctx, (String)pledgeIdList.get(j));
        }
    }

    private void doCancelAssure(Context ctx, String pk) throws EASBizException, BOSException {
        AssureBillInfo assureInfo = AssureBillFactory.getLocalInstance((Context)ctx).getAssureBillInfo((IObjectPK)new ObjectUuidPK(pk));
        if (AssureBillStateEnum.APPROVE.equals((Object)assureInfo.getState())) {
            AssureBillFactory.getLocalInstance((Context)ctx).unCancel(pk);
        }
    }

    private void doCancelPledge(Context ctx, String pk) throws EASBizException, BOSException {
        if (!EmptyUtil.isEmpty((String)pk)) {
            if (FMHelper.isInstanceof((String)pk, WageInfo.class)) {
                WageInfo wageInfo = WageFactory.getLocalInstance(ctx).getWageInfo((IObjectPK)new ObjectUuidPK(pk));
                if (wageInfo.isIsRelationRec()) {
                    WageFactory.getLocalInstance(ctx).unAntiWage((IObjectPK)new ObjectUuidPK(pk), new ReceivableBillInfo().getBOSType());
                } else {
                    WageFactory.getLocalInstance(ctx).unAntiWage((IObjectPK)new ObjectUuidPK(pk), null);
                }
            } else if (FMHelper.isInstanceof((String)pk, BankFactorInfo.class)) {
                // empty if block
            }
        }
    }

    @Override
    protected Map _getInitEditData(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        int maxRepaySeq = 0;
        BigDecimal accumulativeRepayTotalAmt = null;
        Date lastRepayDate = null;
        HashMap<String, Serializable> returnValue = new HashMap<String, Serializable>();
        String sql = "select FRepaySeq,FAddAmount ,FBizDate  from T_FIN_Repayment where FRepaySeq = ( select isnull(max(FRepaySeq),0) from T_FIN_Repayment where FSourceBillID = ?) and FSourceBillID = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString(), pk.toString()});
        try {
            if (rs.next()) {
                maxRepaySeq = rs.getInt(1);
                accumulativeRepayTotalAmt = rs.getBigDecimal(2);
                java.sql.Date d = rs.getDate(3);
                lastRepayDate = new Date(d.getTime());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        returnValue.clear();
        if (maxRepaySeq == 0) {
            accumulativeRepayTotalAmt = Constants.ZERO;
        }
        returnValue.put("maxseq", new Integer(++maxRepaySeq));
        returnValue.put("accoumulateamt", accumulativeRepayTotalAmt);
        returnValue.put("lastrepaydate", lastRepayDate);
        return returnValue;
    }

    @Override
    protected Map _getMsgWhenCreateEntRepayment(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        HashMap<String, Object> msg = new HashMap<String, Object>();
        int repaySeq = 0;
        int recEntRepaySeq = 0;
        String chLoanId = "";
        String loanID = "";
        String sql1 = " select FRepaySeq,FLoanBillIDID from T_IVT_EntRepaymentBill where fid = ?";
        String sql2 = " select FID from t_fin_loan where FEntLoanID = ?";
        String sql3 = " select isnull(max(FRepaySeq),0) from t_fin_repayment where FSourceBillID =? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new Object[]{pk.toString()});
        try {
            if (rs.next()) {
                repaySeq = rs.getInt(1);
                chLoanId = rs.getString(2);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        rs = DbUtil.executeQuery((Context)ctx, (String)sql2, (Object[])new Object[]{chLoanId});
        try {
            if (rs.next()) {
                loanID = rs.getString(1);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        rs = DbUtil.executeQuery((Context)ctx, (String)sql3, (Object[])new Object[]{loanID});
        try {
            if (rs.next()) {
                recEntRepaySeq = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (repaySeq == recEntRepaySeq + 1) {
            msg.put("canRec", new Boolean(true));
        } else {
            msg.put("canRec", new Boolean(false));
        }
        msg.put("chLoanID", chLoanId);
        msg.put("loanID", loanID);
        return msg;
    }

    @Override
    protected String _getRelationLoanBillID(Context ctx, String sourceBillID) throws BOSException {
        String loanID = "";
        if (StringUtil.isEmpty((String)sourceBillID)) {
            return loanID;
        }
        BOSUuid bisid = BOSUuid.read((String)sourceBillID);
        BOSObjectType idType = bisid.getType();
        String sql = null;
        if (idType.equals((Object)FundTransferRepayBillInfo.BOSTYPE)) {
            sql = "select loan.FID from T_FT_FundTransferRepayBill repay,T_FIN_Loan loan where repay.FLoanID=loan.FTransBillID and repay.FID='" + sourceBillID + "'";
        } else if (idType.equals((Object)ConsingnRepaymentBillInfo.BOSTYPE)) {
            sql = "select loan.FID from T_CL_ConsingnRepaymentBill repay,T_FIN_Loan loan where repay.FLoanID=loan.FSourceBillId and repay.FID='" + sourceBillID + "'";
        } else if (idType.equals((Object)LoanRepaymentApplyInfo.BOSTYPE)) {
            sql = "select loan.FID from T_FIN_LoanRepaymentApply repay,T_FIN_Loan loan where repay.FLoanID=loan.FID and repay.FID='" + sourceBillID + "'";
        } else if (idType.equals((Object)LetterOfCreditReachInfo.BOSTYPE)) {
            sql = "select letter.FID from T_NT_LetterOfCreditReach reach,T_FIN_LetterOfCredit letter where reach.FCreditID=letter.FID and reach.FID='" + sourceBillID + "'";
        }
        if (!StringUtil.isEmpty((String)sql)) {
            ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql);
            IRowSet set = exec.executeSQL();
            try {
                if (set != null && set.next()) {
                    loanID = set.getString(1);
                    set.close();
                }
            }
            catch (SQLException e) {
                Log.debug((Object)e.getMessage());
                return loanID;
            }
        }
        return loanID;
    }

    @Override
    protected void _submit4wf(Context ctx, IObjectValue model) throws BOSException {
    }

    @Override
    protected void _updateLetterOfCredit(Context ctx, String letterOfCreditID) throws BOSException, EASBizException {
    }

    @Override
    protected void _writeAcount(Context ctx, IObjectValue mode) throws BOSException, EASBizException {
        RepaymentInfo info = (RepaymentInfo)mode;
        if (info.getInnerAccount() != null) {
            RepaymentBillSubsidiaryBookProviderLetter provider = new RepaymentBillSubsidiaryBookProviderLetter();
            SubsidiaryLedgerCollection subsidiaryColl = provider.getCollection(ctx, info.getId().toString());
            SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).book(subsidiaryColl);
        }
    }

    @Override
    protected void _writeLetterOfCredit(Context ctx, IObjectValue mode) throws BOSException, EASBizException {
    }

    protected void verifyCanGatherGenPayBill(RepaymentCollection repaymentCol) throws BOSException, EASBizException {
    }

    @Override
    protected void _gatherGenPaymentBill(Context ctx, IObjectCollection srcColl) throws BOSException, EASBizException {
        RepaymentCollection repaymentCol = (RepaymentCollection)srcColl;
        this.verifyCanGatherGenPayBill(repaymentCol);
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BOTRelationCollection botRelCol = iBTPManager.getRelationCollection(repaymentCol.get(0).getId().toString());
        String srcBosType = null;
        for (int i = 0; i < botRelCol.size(); ++i) {
            srcBosType = botRelCol.get(i).getSrcEntityID();
        }
        boolean isCreateFromLoanBill = new LoanInfo().getBOSType().toString().equals(srcBosType);
        boolean isCreateFromPayableBill = new PayableBillInfo().getBOSType().toString().equals(srcBosType);
        if (isCreateFromLoanBill || isCreateFromPayableBill) {
            int i;
            String destBillBosType = new PaymentBillInfo().getBOSType().toString();
            CoreBillBaseCollection coreBillBaseCol = new CoreBillBaseCollection();
            if (repaymentCol.size() < 2) {
                throw new FinBizException(FinBizException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"518_AbstractRepaymentStragety", (Locale)ctx.getLocale())});
            }
            RepaymentInfo repaymentInfo = null;
            BigDecimal totalPayedAmt = new BigDecimal(0);
            BigDecimal totalCautionAmt = new BigDecimal(0);
            BigDecimal zero = new BigDecimal(0);
            for (i = 0; i < repaymentCol.size(); ++i) {
                repaymentInfo = repaymentCol.get(i);
                totalPayedAmt = totalPayedAmt.add(isCreateFromLoanBill ? repaymentInfo.getAmount().add(repaymentInfo.getInterest()) : repaymentInfo.getAmount());
                totalCautionAmt = totalCautionAmt.add(repaymentInfo.getCautionAmt() == null ? zero : repaymentInfo.getCautionAmt());
            }
            for (i = 0; i < (this instanceof LoanRepaymentStragety ? repaymentCol.size() : 2); ++i) {
                coreBillBaseCol.addObject(repaymentCol.getObject(i));
            }
            PaymentBillCollection paymentBillCol = this.getPaymentBillColl(ctx, coreBillBaseCol, destBillBosType);
            if (paymentBillCol != null) {
                String bankAcctId;
                AccountBankInfo acctBankInfo = null;
                PaymentBillInfo paymentBillInfo = null;
                BOTRelationCollection botRelationCol = null;
                String string = bankAcctId = repaymentCol.get(0).getBankAcct() == null ? null : repaymentCol.get(0).getBankAcct().getId().toString();
                if (bankAcctId != null) {
                    acctBankInfo = this.getAccountBankInfo(ctx, bankAcctId);
                }
                paymentBillInfo = paymentBillCol.get(0);
                if (isCreateFromLoanBill) {
                    this.fillPaymentBillAmountInterest(paymentBillInfo, acctBankInfo, repaymentCol);
                } else {
                    this.fillPaymentBill(paymentBillInfo, acctBankInfo, totalPayedAmt);
                }
                botRelationCol = this.genBotRelation(ctx, repaymentCol, paymentBillInfo, 0);
                iBTPManager.saveRelations((CoreBillBaseInfo)paymentBillInfo, botRelationCol);
                AccountBankInfo acutionAcctBank = this.getAcutionAcctBank(repaymentCol);
                if (acutionAcctBank != null && totalCautionAmt.compareTo(BigDecimal.ZERO) > 0) {
                    acctBankInfo = this.getAccountBankInfo(ctx, acutionAcctBank.getId().toString());
                    paymentBillInfo = paymentBillCol.get(1);
                    this.fillPaymentBill(paymentBillInfo, acctBankInfo, totalCautionAmt);
                    botRelationCol = this.genBotRelation(ctx, repaymentCol, paymentBillInfo, 1);
                    iBTPManager.saveRelations((CoreBillBaseInfo)paymentBillInfo, botRelationCol);
                }
            }
        }
    }

    protected PaymentBillCollection getPaymentBillColl(Context ctx, CoreBillBaseCollection coreBillBaseCol, String destBillBosType) throws BOSException, BTPException {
        return null;
    }

    private AccountBankInfo getAcutionAcctBank(RepaymentCollection repaymentCol) {
        for (int i = 0; i < repaymentCol.size(); ++i) {
            if (repaymentCol.get(i).getAcutionAcctBank() == null) continue;
            return repaymentCol.get(i).getAcutionAcctBank();
        }
        return null;
    }

    private AccountBankInfo getAccountBankInfo(Context ctx, String bankAcctId) throws EASBizException, BOSException {
        SelectorItemCollection selCol = this.getAcctBankSelector();
        ObjectUuidPK acctBankId = new ObjectUuidPK(bankAcctId);
        return AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)acctBankId, selCol);
    }

    private void fillPaymentBill(PaymentBillInfo paymentBillInfo, AccountBankInfo acctBankInfo, BigDecimal amt) {
        paymentBillInfo.setActPayAmt(amt);
        paymentBillInfo.setActPayLocAmt(amt.multiply(paymentBillInfo.getExchangeRate()));
        paymentBillInfo.setPayerAccountBank(acctBankInfo);
        paymentBillInfo.setPayerAccount(acctBankInfo == null ? null : acctBankInfo.getAccount());
        paymentBillInfo.setPayerBank(acctBankInfo == null ? null : acctBankInfo.getBank());
        PaymentBillEntryCollection entrysCol = paymentBillInfo.getEntries();
        for (int i = 0; i < entrysCol.size(); ++i) {
            entrysCol.get(i).setActualAmt(amt);
            entrysCol.get(i).setActualLocAmt(amt.multiply(paymentBillInfo.getExchangeRate()));
        }
    }

    private void fillPaymentBillAmountInterest(PaymentBillInfo paymentBillInfo, AccountBankInfo acctBankInfo, RepaymentCollection repaymentCol) {
        BigDecimal totalPayedAmt = new BigDecimal(0);
        for (int i = 0; i < paymentBillInfo.getEntries().size(); ++i) {
            paymentBillInfo.getEntries().get(i).setActualLocAmt(paymentBillInfo.getEntries().get(i).getActualAmt().multiply(paymentBillInfo.getExchangeRate()));
            totalPayedAmt = totalPayedAmt.add(paymentBillInfo.getEntries().get(i).getActualAmt());
        }
        paymentBillInfo.setActPayAmt(totalPayedAmt);
        paymentBillInfo.setActPayLocAmt(totalPayedAmt.multiply(paymentBillInfo.getExchangeRate()));
        paymentBillInfo.setPayerAccountBank(acctBankInfo);
        paymentBillInfo.setPayerAccount(acctBankInfo == null ? null : acctBankInfo.getAccount());
        paymentBillInfo.setPayerBank(acctBankInfo == null ? null : acctBankInfo.getBank());
    }

    private BOTRelationCollection genBotRelation(Context ctx, RepaymentCollection repaymentCol, PaymentBillInfo paymentBillInfo, int index) throws BOSException {
        RepaymentInfo repaymentInfo = repaymentCol.get(index);
        IBOTRelation ibotRel = BOTRelationFactory.getLocalInstance((Context)ctx);
        BOTRelationInfo botRelInfo = null;
        for (int i = 0; i < repaymentCol.size(); ++i) {
            repaymentInfo = repaymentCol.get(i);
            if (this.isExitBotpRelateion(ibotRel, repaymentInfo.getId().toString(), paymentBillInfo.getId().toString())) continue;
            botRelInfo = new BOTRelationInfo();
            botRelInfo.setSrcEntityID(repaymentInfo.getBOSType().toString());
            botRelInfo.setSrcObjectID(repaymentInfo.getId().toString());
            botRelInfo.setDestEntityID(paymentBillInfo.getBOSType().toString());
            botRelInfo.setDestObjectID(paymentBillInfo.getId().toString());
            botRelInfo.setOperatorID(ContextUtils.getUser((Context)ctx).getId().toString());
            if (!EmptyUtil.isEmpty((String)this.mappingID)) {
                botRelInfo.setBOTMappingID(this.mappingID);
            }
            ibotRel.addnew(botRelInfo);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)repaymentInfo.getBOSType().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)paymentBillInfo.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        return ibotRel.getCollection(view);
    }

    private boolean isExitBotpRelateion(IBOTRelation ibotRel, String srcObjectId, String destObjectId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)srcObjectId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)destObjectId, CompareType.EQUALS));
        view.setFilter(filter);
        return ibotRel.getCollection(view).size() > 0;
    }

    private SelectorItemCollection getAcctBankSelector() {
        SelectorItemCollection selCol = new SelectorItemCollection();
        selCol.add(new SelectorItemInfo("id"));
        selCol.add(new SelectorItemInfo("name"));
        selCol.add(new SelectorItemInfo("number"));
        selCol.add(new SelectorItemInfo("bankAccountNumber"));
        selCol.add(new SelectorItemInfo("account.id"));
        selCol.add(new SelectorItemInfo("account.name"));
        selCol.add(new SelectorItemInfo("account.number"));
        selCol.add(new SelectorItemInfo("bank.id"));
        selCol.add(new SelectorItemInfo("bank.name"));
        selCol.add(new SelectorItemInfo("bank.number"));
        return selCol;
    }

    @Override
    protected Map _getRePayPlan(Context ctx, IObjectPK pk) throws BOSException, FinBizException {
        LoanEntryCollection coll = new LoanEntryCollection();
        HashMap<String, LoanEntryCollection> returnValue = new HashMap<String, LoanEntryCollection>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent", (Object)pk.toString()));
        view.setFilter(filter);
        SorterItemInfo sorter = new SorterItemInfo("date");
        sorter.setSortType(SortType.ASCEND);
        SorterItemInfo sorter2 = new SorterItemInfo("seq");
        sorter2.setSortType(SortType.ASCEND);
        view.getSorter().add(sorter);
        view.getSorter().add(sorter2);
        coll = LoanEntryFactory.getLocalInstance(ctx).getLoanEntryCollection(view);
        returnValue.put("REPAYPLAN", coll);
        return returnValue;
    }
}

