/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.ILoanApplyBill;
import com.kingdee.eas.fm.fin.LoanApplyBillCollection;
import com.kingdee.eas.fm.fin.LoanApplyBillFactory;
import com.kingdee.eas.fm.fin.LoanApplyBillInfo;
import com.kingdee.eas.fm.fin.LoanApplyBillStatusEnum;
import com.kingdee.eas.fm.fin.LoanContractCollection;
import com.kingdee.eas.fm.fin.LoanContractFactory;
import com.kingdee.eas.fm.fin.app.AbstractBondApplyBillFacaedControllerBean;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class BondApplyBillFacaedControllerBean
extends AbstractBondApplyBillFacaedControllerBean {
    private static final long serialVersionUID = 734840968125511219L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.BondApplyBillFacaedControllerBean");

    protected ILoanApplyBill getBizInterface(Context ctx) throws BOSException, EASBizException {
        return LoanApplyBillFactory.getLocalInstance(ctx);
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanApplyBillInfo loanApplyBillInfo = (LoanApplyBillInfo)model;
        this.checkStatus(ctx, loanApplyBillInfo);
        loanApplyBillInfo.setStatus(LoanApplyBillStatusEnum.SAVE);
        loanApplyBillInfo.setIsBond(true);
        IObjectPK pk = this.getBizInterface(ctx).save((CoreBaseInfo)loanApplyBillInfo);
        return pk;
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanApplyBillInfo loanApplyBillInfo = (LoanApplyBillInfo)model;
        this.checkStatus(ctx, loanApplyBillInfo);
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)loanApplyBillInfo);
        loanApplyBillInfo.setStatus(LoanApplyBillStatusEnum.SUBMIT);
        loanApplyBillInfo.setIsBond(true);
        IObjectPK pk = this.getBizInterface(ctx).submit((CoreBaseInfo)loanApplyBillInfo);
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)loanApplyBillInfo);
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)loanApplyBillInfo);
        NTHelper.OnWaybgCtrl((Context)ctx, (String)pk.toString());
        return pk;
    }

    private void checkStatus(Context ctx, LoanApplyBillInfo loanApplyBillInfo) throws EASBizException, BOSException {
        LoanApplyBillInfo oldInfo;
        boolean isExist;
        if (!EmptyUtil.isEmpty((Object)loanApplyBillInfo.getId()) && (isExist = this.getBizInterface(ctx).exists((IObjectPK)new ObjectUuidPK(loanApplyBillInfo.getId()))) && !EmptyUtil.isEmpty((CoreBaseInfo)(oldInfo = this.getBizInterface(ctx).getLoanApplyBillInfo((IObjectPK)new ObjectUuidPK(loanApplyBillInfo.getId())))) && LoanApplyBillStatusEnum.AUDITED == oldInfo.getStatus()) {
            throw new FinBizException(FinBizException.FINFEESUBMIT);
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanApplyBillInfo info = this.getBizInterface(ctx).getLoanApplyBillInfo(pk);
        if (info.getStatus().equals((Object)LoanApplyBillStatusEnum.SAVE)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"54_BondApplyBillFacaedControllerBean", (Locale)ctx.getLocale()));
        }
        if (info.getStatus().equals((Object)LoanApplyBillStatusEnum.AUDITED)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"55_BondApplyBillFacaedControllerBean", (Locale)ctx.getLocale()));
        }
        String sql = "update T_FIN_LoanApplyBill set FStatus = ? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(3), pk.toString()});
    }

    @Override
    protected List _batchAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        LoanApplyBillCollection loanApplyCol = this.getLoanApplyCol(ctx, idSet);
        ArrayList<String> returnList = new ArrayList<String>();
        ObjectUuidPK pk = null;
        LoanApplyBillInfo tmpInfo = null;
        for (int i = 0; i < loanApplyCol.size(); ++i) {
            tmpInfo = loanApplyCol.get(i);
            try {
                pk = new ObjectUuidPK(tmpInfo.getId().toString());
                super.audit(ctx, (IObjectPK)pk);
                continue;
            }
            catch (Exception e) {
                returnList.add(tmpInfo.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"56_BondApplyBillFacaedControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
            }
        }
        return returnList;
    }

    @Override
    protected void _antiAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanApplyBillInfo info = this.getBizInterface(ctx).getLoanApplyBillInfo(pk);
        if (info.getStatus() != LoanApplyBillStatusEnum.AUDITED) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"57_BondApplyBillFacaedControllerBean", (Locale)ctx.getLocale()));
        }
        if (info.isIsGenLoanBill()) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"58_BondApplyBillFacaedControllerBean", (Locale)ctx.getLocale()));
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)info.getId().toString()));
        view.setFilter(filter);
        LoanContractCollection col = LoanContractFactory.getLocalInstance(ctx).getLoanContractCollection(view);
        if (col.size() > 0) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"59_BondApplyBillFacaedControllerBean", (Locale)ctx.getLocale())});
        }
        String sql = "update T_FIN_LoanApplyBill set FStatus = ? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(1), pk.toString()});
    }

    @Override
    protected List _batchAntiAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        LoanApplyBillCollection loanApplyCol = this.getLoanApplyCol(ctx, idSet);
        ArrayList<String> returnList = new ArrayList<String>();
        ObjectUuidPK pk = null;
        LoanApplyBillInfo tmpInfo = null;
        for (int i = 0; i < loanApplyCol.size(); ++i) {
            tmpInfo = loanApplyCol.get(i);
            try {
                pk = new ObjectUuidPK(tmpInfo.getId().toString());
                super.antiAudit(ctx, (IObjectPK)pk);
                continue;
            }
            catch (Exception e) {
                returnList.add(tmpInfo.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"60_BondApplyBillFacaedControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
            }
        }
        return returnList;
    }

    @Override
    protected List _batchSubmit(Context ctx, Set idSet) throws BOSException, EASBizException {
        LoanApplyBillCollection loanApplyCol = this.getLoanApplyCol(ctx, idSet);
        ArrayList<String> returnList = new ArrayList<String>();
        LoanApplyBillInfo tmpInfo = null;
        for (int i = 0; i < loanApplyCol.size(); ++i) {
            tmpInfo = loanApplyCol.get(i);
            try {
                if (tmpInfo.getStatus() != LoanApplyBillStatusEnum.SAVE) {
                    throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"61_BondApplyBillFacaedControllerBean", (Locale)ctx.getLocale()));
                }
                super.submit(ctx, (CoreBaseInfo)tmpInfo);
                continue;
            }
            catch (Exception e) {
                returnList.add(tmpInfo.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"7_LoanApplyBillControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
            }
        }
        return returnList;
    }

    private LoanApplyBillCollection getLoanApplyCol(Context ctx, Set idSet) throws EASBizException, BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        return this.getBizInterface(ctx).getLoanApplyBillCollection(evi);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanApplyBillInfo info = this.getBizInterface(ctx).getLoanApplyBillInfo(pk);
        if (info.isIsGenLoanBill()) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"62_BondApplyBillFacaedControllerBean", (Locale)ctx.getLocale()));
        }
        if (info.getStatus() == LoanApplyBillStatusEnum.AUDITED) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"63_BondApplyBillFacaedControllerBean", (Locale)ctx.getLocale()));
        }
        this.getBizInterface(ctx).delete(pk);
    }

    @Override
    protected List _batchDelete(Context ctx, Set idSet) throws BOSException, EASBizException {
        LoanApplyBillCollection loanApplyCol = this.getLoanApplyCol(ctx, idSet);
        ArrayList<String> returnList = new ArrayList<String>();
        ObjectUuidPK pk = null;
        LoanApplyBillInfo tmpInfo = null;
        for (int i = 0; i < loanApplyCol.size(); ++i) {
            tmpInfo = loanApplyCol.get(i);
            try {
                pk = new ObjectUuidPK(tmpInfo.getId().toString());
                super.delete(ctx, (IObjectPK)pk);
                continue;
            }
            catch (Exception e) {
                returnList.add(tmpInfo.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"64_BondApplyBillFacaedControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
            }
        }
        return returnList;
    }
}

