/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.ProjectFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AbstractFMDataImport;
import com.kingdee.eas.fi.cas.FundFlowItemFactory;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.app.RecAndPayDataImportUtil2;
import com.kingdee.eas.fm.fin.CreditRatingEnum;
import com.kingdee.eas.fm.fin.CreditorGroupCollection;
import com.kingdee.eas.fm.fin.CreditorGroupFactory;
import com.kingdee.eas.fm.fin.FinBillStatusEnum;
import com.kingdee.eas.fm.fin.FinancingProductsFactory;
import com.kingdee.eas.fm.fin.GuaranteeTypeCollection;
import com.kingdee.eas.fm.fin.GuaranteeTypeFactory;
import com.kingdee.eas.fm.fin.GuaranteeTypeInputModeEnum;
import com.kingdee.eas.fm.fin.ILoan;
import com.kingdee.eas.fm.fin.IMarketPlace;
import com.kingdee.eas.fm.fin.IssuanceWaysEnum;
import com.kingdee.eas.fm.fin.LoanCollection;
import com.kingdee.eas.fm.fin.LoanEntryFactory;
import com.kingdee.eas.fm.fin.LoanEntryInfo;
import com.kingdee.eas.fm.fin.LoanException;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.MarketPlaceCollection;
import com.kingdee.eas.fm.fin.MarketPlaceFactory;
import com.kingdee.eas.fm.fin.RepayIntTypeEnum;
import com.kingdee.eas.fm.fin.RepaymentTypeEnum;
import com.kingdee.eas.fm.fin.app.LoanBill4HistroyDataImport;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.IntSchemeFactory;
import com.kingdee.eas.fm.mnt.BlockingFlowTypeCollection;
import com.kingdee.eas.fm.mnt.BlockingFlowTypeFactory;
import com.kingdee.eas.fm.mnt.BlockingFlowTypeInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BondsBillDataImport
extends AbstractFMDataImport {
    private static Logger logger = Logger.getLogger((String)LoanBill4HistroyDataImport.class.getName());
    private static String TRUE = "true";
    private static String FALSE = "false";
    LoanEntryInfo entryInfo = null;
    protected CompanyOrgUnitInfo importCompanyInfo = null;

    protected ICoreBase _getController(Context ctx) throws EASBizException, BOSException {
        return LoanFactory.getLocalInstance(ctx);
    }

    protected CoreBaseInfo _transmit(Hashtable hsData, Context ctx) throws EASBizException, BOSException {
        String number = (String)this.getData(hsData, "FNumber");
        String companyId = null;
        CompanyOrgUnitInfo company = null;
        Object companyData = this.getData(hsData, "FCompany_number");
        if (companyData != null && companyData.toString().trim().length() > 0) {
            company = RecAndPayDataImportUtil2.getCompanyByNumber((Context)ctx, (String)((String)companyData));
        }
        if (company == null) {
            company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        }
        companyId = company.getId().toString();
        this.importCompanyInfo = company;
        LoanInfo info = new LoanInfo();
        ObjectUuidPK companyPK = new ObjectUuidPK(company.getId().toString());
        ObjectUuidPK userPK = new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId());
        boolean hasFunctionPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)userPK, (IObjectPK)companyPK, "fin_Loan_loanImport");
        if (!hasFunctionPermission) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"661_LoanImport", (Locale)ctx.getLocale()));
        }
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        info = this.getHeadInfo(ctx, mode, number, companyId);
        info.setCompany(company);
        info = this.parseInfo(hsData, ctx, info);
        return info;
    }

    private LoanInfo parseInfo(Hashtable hsData, Context ctx, LoanInfo info) throws BOSException, EASBizException {
        AccountTableInfo accountTableInfo;
        MarketPlaceCollection collection;
        Object collection2;
        FilterInfo filter;
        this.prepareImport(ctx, (IObjectValue)info, hsData);
        Object data = null;
        data = this.getData(hsData, "FNumber");
        if (data != null && data.toString().trim().length() > 0) {
            info.setNumber(data.toString());
        }
        if ((data = this.getData(hsData, "FBizDate")) == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"16_AgentPayBillDataImport", (Locale)ctx.getLocale()));
        }
        info.setBizDate(RecAndPayDataImportUtil2.objToDate((Context)ctx, (Object)data));
        data = this.getData(hsData, "FDescription");
        if (data != null && data.toString().trim().length() > 0) {
            if (data.toString().length() > 255) {
                throw new RecPayException(RecPayException.DESCNOTMORE, (Object[])new String[]{String.valueOf(255)});
            }
            info.setDescription(data.toString());
        }
        if ((data = this.getData(hsData, "FType_number")) != null && data.toString().trim().length() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            view.setFilter(filter);
            collection2 = FinancingProductsFactory.getLocalInstance((Context)ctx).getFinancingProductsCollection(view);
            if (collection2.size() > 0) {
                info.setType(collection2.get(0));
            } else {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1090_LoanImport", (Locale)ctx.getLocale()));
            }
        }
        if ((data = this.getData(hsData, "FContractNum")) != null && data.toString().trim().length() > 0) {
            info.setContractNum(data.toString());
        }
        if ((data = this.getData(hsData, "FBondsCode")) != null && data.toString().trim().length() > 0) {
            info.setBondsCode(data.toString());
        }
        if ((data = this.getData(hsData, "FBondsShortForm")) != null && data.toString().trim().length() > 0) {
            info.setBondsShortForm(data.toString());
        }
        if ((data = this.getData(hsData, "FBondsFullName")) != null && data.toString().trim().length() > 0) {
            info.setBondsFullName(data.toString());
        }
        if ((data = this.getData(hsData, "FSeeAlso")) != null && data.toString().trim().length() > 0) {
            info.setSeeAlso(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        if ((data = this.getData(hsData, "FIssueNum")) != null && data.toString().trim().length() > 0) {
            info.setIssueNum(TypeConversionUtils.objToInt((Object)data.toString()));
        }
        if ((data = this.getData(hsData, "FPlanIssuanceAmt")) != null && data.toString().trim().length() > 0) {
            if (TypeConversionUtils.objToBigDecimal((Object)data).compareTo(BigDecimal.ZERO) < 1) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"93_BondsBillDataImport", (Locale)ctx.getLocale()));
            }
        } else {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"94_BondsBillDataImport", (Locale)ctx.getLocale()));
        }
        info.setPlanIssuanceAmt(TypeConversionUtils.objToBigDecimal((Object)data));
        data = this.getData(hsData, "FMarketPlace_number");
        if (data != null && data.toString().trim().length() > 0) {
            IMarketPlace iMarketPlace = MarketPlaceFactory.getLocalInstance(ctx);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter2 = new FilterInfo();
            filter2.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            filter2.getFilterItems().add(new FilterItemInfo("name", (Object)data.toString().trim()));
            filter2.setMaskString("#0 or #1");
            evi.setFilter(filter2);
            collection = iMarketPlace.getMarketPlaceCollection(evi);
            if (collection == null || collection.size() <= 0) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"95_BondsBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setMarketPlace(collection.get(0));
        } else {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"96_BondsBillDataImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "FCurrency_number");
        if (data != null && data.toString().trim().length() > 0) {
            info.setCurrency(RecAndPayDataImportUtil2.getCurrencyByNumber((Context)ctx, (String)data.toString()));
        } else {
            CompanyOrgUnitInfo company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            try {
                info.setCurrency(ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(info.getCompany()));
            }
            catch (Exception e) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"17_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        data = this.getData(hsData, "FAmount");
        if (data != null && data.toString().trim().length() > 0) {
            if (TypeConversionUtils.objToBigDecimal((Object)data).compareTo(BigDecimal.ZERO) < 1) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"97_BondsBillDataImport", (Locale)ctx.getLocale()));
            }
        } else {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"98_BondsBillDataImport", (Locale)ctx.getLocale()));
        }
        info.setAmount(TypeConversionUtils.objToBigDecimal((Object)data));
        data = this.getData(hsData, "FBalance");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"99_BondsBillDataImport", (Locale)ctx.getLocale()));
        }
        info.setBalance(TypeConversionUtils.objToBigDecimal((Object)data));
        if (info.getBalance().compareTo(info.getAmount()) != 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"100_BondsBillDataImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "FLocalCurExRate");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"101_BondsBillDataImport", (Locale)ctx.getLocale()));
        }
        info.setLocalCurExRate(TypeConversionUtils.objToBigDecimal((Object)data));
        data = this.getData(hsData, "FAmountLocalCur");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"102_BondsBillDataImport", (Locale)ctx.getLocale()));
        }
        info.setAmountLocalCur(TypeConversionUtils.objToBigDecimal((Object)data));
        data = this.getData(hsData, "FIntFreeAmt");
        if (data != null && data.toString().trim().length() > 0) {
            info.setIntFreeAmt(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        if ((data = this.getData(hsData, "FIssueDate")) == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"103_BondsBillDataImport", (Locale)ctx.getLocale()));
        }
        info.setIssueDate(RecAndPayDataImportUtil2.objToDate((Context)ctx, (Object)data));
        data = this.getData(hsData, "FExpiredDate");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"104_BondsBillDataImport", (Locale)ctx.getLocale()));
        }
        info.setExpiredDate(RecAndPayDataImportUtil2.objToDate((Context)ctx, (Object)data));
        if (info.getExpiredDate().compareTo(info.getIssueDate()) <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"105_BondsBillDataImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "FHorizon");
        if (data != null && data.toString().trim().length() > 0) {
            if (TypeConversionUtils.objToBigDecimal((Object)data).compareTo(BigDecimal.ZERO) < 1) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"665_LoanImport", (Locale)ctx.getLocale()));
            }
            info.setHorizon(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        if ((data = this.getData(hsData, "FHistoryBill")) != null && data.toString().trim().length() > 0) {
            boolean historyBill = false;
            if (!TRUE.equalsIgnoreCase(data.toString()) && !FALSE.equalsIgnoreCase(data.toString())) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"673_LoanImport", (Locale)ctx.getLocale()));
            }
            if (TRUE.equalsIgnoreCase(data.toString())) {
                historyBill = true;
            }
            info.setHistoryBill(false);
        }
        if ((data = this.getData(hsData, "FCreditorGroup_number")) != null && data.toString().trim().length() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            view.setFilter(filter);
            collection2 = CreditorGroupFactory.getLocalInstance(ctx).getCreditorGroupCollection(view);
            if (collection2.size() > 0) {
                info.setCreditorGroup(((CreditorGroupCollection)((Object)collection2)).get(0));
            } else {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"1091_LoanImport", (Locale)ctx.getLocale()));
            }
        }
        if ((data = this.getData(hsData, "FBankAcct_number")) != null && data.toString().trim().length() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            view.setFilter(filter);
            collection2 = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
            if (collection2.size() > 0) {
                info.setBankAcct(collection2.get(0));
            }
        }
        if ((data = this.getData(hsData, "FSettlementAcct_number")) != null && data.toString().trim().length() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)this.importCompanyInfo.getId().toString()));
            accountTableInfo = this.importCompanyInfo.getAccountTable();
            if (accountTableInfo != null && accountTableInfo.getId() != null) {
                filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTableInfo.getId().toString()));
            }
            view.setFilter(filter);
            collection = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
            if (collection.size() > 0) {
                info.setSettlementAcct(collection.get(0));
            }
        }
        if ((data = this.getData(hsData, "FLoanAcct_number")) != null && data.toString().trim().length() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)this.importCompanyInfo.getId().toString()));
            accountTableInfo = this.importCompanyInfo.getAccountTable();
            if (accountTableInfo != null && accountTableInfo.getId() != null) {
                filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTableInfo.getId().toString()));
            }
            view.setFilter(filter);
            collection = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
            if (collection.size() > 0) {
                info.setLoanAcct(collection.get(0));
            }
        }
        if ((data = this.getData(hsData, "FYieldRate")) != null && data.toString().trim().length() > 0) {
            info.setYieldRate(TypeConversionUtils.objToBigDecimal((Object)data));
        } else {
            info.setYieldRate(BigDecimal.ZERO);
        }
        data = this.getData(hsData, "FPayIntMode_number");
        if (data != null && data.toString().trim().length() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            view.setFilter(filter);
            collection2 = IntSchemeFactory.getLocalInstance((Context)ctx).getIntSchemeCollection(view);
            if (collection2.size() > 0) {
                info.setPayIntMode(collection2.get(0));
            }
        }
        if ((data = this.getData(hsData, "FIntFeeAcctView_number")) != null && data.toString().trim().length() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)this.importCompanyInfo.getId().toString()));
            accountTableInfo = this.importCompanyInfo.getAccountTable();
            if (accountTableInfo != null && accountTableInfo.getId() != null) {
                filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTableInfo.getId().toString()));
            }
            view.setFilter(filter);
            collection = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
            if (collection.size() > 0) {
                info.setIntFeeAcctView(collection.get(0));
            }
        }
        if ((data = this.getData(hsData, "FLastIntDate")) != null && data.toString().trim().length() > 0) {
            info.setLastIntDate(RecAndPayDataImportUtil2.objToDate((Context)ctx, (Object)data));
        }
        if ((data = this.getData(hsData, "FIntRateTypeExpression")) != null && data.toString().trim().length() > 0) {
            info.setIntRateTypeExpression(IntRateTypeExpressionEnum.getEnum((String)data.toString()));
        }
        if ((data = this.getData(hsData, "FYearDays")) != null && data.toString().trim().length() > 0) {
            int parseInt = Integer.parseInt(data.toString());
            if (parseInt <= 0) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"669_LoanImport", (Locale)ctx.getLocale()));
            }
            info.setYearDays(parseInt);
        } else {
            info.setYearDays(360);
        }
        data = this.getData(hsData, "FRepaymentType");
        if (data != null && data.toString().trim().length() > 0) {
            info.setRepaymentType(RepaymentTypeEnum.getEnum(Integer.parseInt(data.toString())));
        } else {
            info.setRepaymentType(RepaymentTypeEnum.BY_LUMP_SUM);
        }
        data = this.getData(hsData, "FIssuanceWays");
        if (data != null && data.toString().trim().length() > 0) {
            info.setIssuanceWays(IssuanceWaysEnum.getEnum(Integer.parseInt(data.toString())));
        } else {
            info.setIssuanceWays(IssuanceWaysEnum.Empty);
        }
        data = this.getData(hsData, "FCreditRating");
        if (data != null && data.toString().trim().length() > 0 && CreditRatingEnum.getEnum(Integer.parseInt(data.toString())) != null) {
            info.setCreditRating(CreditRatingEnum.getEnum(Integer.parseInt(data.toString())));
        }
        if ((data = this.getData(hsData, "FRatingAgency")) != null && data.toString().trim().length() > 0) {
            info.setRatingAgency(data.toString());
        }
        if ((data = this.getData(hsData, "FRegistrationNotice")) != null && data.toString().trim().length() > 0) {
            info.setRegistrationNotice(data.toString());
        }
        if ((data = this.getData(hsData, "FRemark")) != null && data.toString().trim().length() > 0) {
            info.setRemark(data.toString());
        }
        if ((data = this.getData(hsData, "FGaranteeType_number")) != null && data.toString().trim().length() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            view.setFilter(filter);
            collection2 = GuaranteeTypeFactory.getLocalInstance(ctx).getGuaranteeTypeCollection(view);
            if (collection2.size() > 0) {
                info.setGaranteeType(((GuaranteeTypeCollection)((Object)collection2)).get(0));
            }
        }
        if ((data = this.getData(hsData, "FProject_number")) != null && data.toString().trim().length() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            view.setFilter(filter);
            collection2 = ProjectFactory.getLocalInstance((Context)ctx).getProjectCollection(view);
            if (collection2.size() > 0) {
                info.setProject(collection2.get(0));
            }
        }
        if ((data = this.getData(hsData, "FFundFlowItem_number")) != null && data.toString().trim().length() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            view.setFilter(filter);
            collection2 = FundFlowItemFactory.getLocalInstance((Context)ctx).getFundFlowItemCollection(view);
            if (collection2.size() > 0) {
                info.setFundFlowItem(collection2.get(0));
            }
        }
        if ((data = this.getData(hsData, "FCautionAcctBank_number")) != null && data.toString().trim().length() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            view.setFilter(filter);
            collection2 = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
            if (collection2.size() > 0) {
                info.setCautionAcctBank(collection2.get(0));
            }
        }
        if ((data = this.getData(hsData, "FAuctionPerc")) != null && data.toString().trim().length() > 0) {
            info.setAuctionPerc(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        if ((data = this.getData(hsData, "FCautionAmt")) != null && data.toString().trim().length() > 0) {
            info.setCautionAmt(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        if ((data = this.getData(hsData, "FHandlerRemark")) != null && data.toString().trim().length() > 0) {
            info.setHandlerRemark(data.toString());
        }
        if ((data = this.getData(hsData, "FCostCenter_number")) != null && data.toString().trim().length() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
            view.setFilter(filter);
            collection2 = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitCollection(view);
            if (collection2.size() > 0) {
                info.setCostCenter(collection2.get(0));
            }
        }
        data = this.getData(hsData, " FFiVouchered");
        boolean FFiVouchered = false;
        if (data != null && data.toString().trim().length() > 0) {
            if (!TRUE.equalsIgnoreCase(data.toString()) && !FALSE.equalsIgnoreCase(data.toString())) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"106_BondsBillDataImport", (Locale)ctx.getLocale()));
            }
            if (TRUE.equalsIgnoreCase(data.toString())) {
                FFiVouchered = true;
            }
            info.setFiVouchered(FFiVouchered);
        } else {
            info.setFiVouchered(FFiVouchered);
        }
        data = this.getData(hsData, " FIsCanReSell");
        boolean FIsCanReSell = false;
        if (data != null && data.toString().trim().length() > 0) {
            if (!TRUE.equalsIgnoreCase(data.toString()) && !FALSE.equalsIgnoreCase(data.toString())) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"107_BondsBillDataImport", (Locale)ctx.getLocale()));
            }
            if (TRUE.equalsIgnoreCase(data.toString())) {
                FIsCanReSell = true;
            }
            info.setIsCanReSell(FIsCanReSell);
        } else {
            info.setIsCanReSell(FIsCanReSell);
        }
        data = this.getData(hsData, "FIsConvetibleBonds");
        boolean FIsConvetibleBonds = false;
        if (data != null && data.toString().trim().length() > 0) {
            if (!TRUE.equalsIgnoreCase(data.toString()) && !FALSE.equalsIgnoreCase(data.toString())) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"108_BondsBillDataImport", (Locale)ctx.getLocale()));
            }
            if (TRUE.equalsIgnoreCase(data.toString())) {
                FIsConvetibleBonds = true;
            }
            info.setIsConvetibleBonds(FIsConvetibleBonds);
        } else {
            info.setIsConvetibleBonds(FIsConvetibleBonds);
        }
        if (info.getStatus() == null) {
            info.setStatus(FinBillStatusEnum.SAVE);
        } else {
            info.setStatus(info.getStatus());
        }
        info.setCreator(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        if (info.getGuaranteeTypeInputMode() == null) {
            info.setGuaranteeTypeInputMode(GuaranteeTypeInputModeEnum.notassure);
        }
        if ((data = this.getData(hsData, "FIsBonds")) != null && data.toString().trim().length() > 0) {
            if (!TRUE.equalsIgnoreCase(data.toString())) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"109_BondsBillDataImport", (Locale)ctx.getLocale()));
            }
        } else {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"110_BondsBillDataImport", (Locale)ctx.getLocale()));
        }
        info.setIsBonds(true);
        return info;
    }

    protected void _submit(CoreBaseInfo coreBaseInfo, Context ctx) throws BOSException, EASBizException {
        if (coreBaseInfo == null) {
            return;
        }
        if (coreBaseInfo.getId() == null || !this._getController(ctx).exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
            this._getController(ctx).addnew(coreBaseInfo);
        } else {
            LoanInfo info = (LoanInfo)coreBaseInfo;
            if (FinBillStatusEnum.SAVE.equals((Object)info.getStatus()) || FinBillStatusEnum.SUBMIT.equals((Object)info.getStatus())) {
                this._getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            } else {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"14_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        LoanInfo loanInfo = (LoanInfo)coreBaseInfo;
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)loanInfo.getEntrys())) {
            if (loanInfo.getRepaymentType() == RepaymentTypeEnum.BY_LUMP_SUM) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("parent", (Object)loanInfo.getId().toString(), CompareType.EQUALS));
                LoanEntryFactory.getLocalInstance(ctx).delete(filter);
                LoanEntryFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)this.getDefaultLoanEntry(ctx, loanInfo));
            }
        } else {
            LoanEntryFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)this.getDefaultLoanEntry(ctx, loanInfo));
        }
    }

    public LoanEntryInfo getDefaultLoanEntry(Context ctx, LoanInfo loanInfo) throws BOSException, EASBizException {
        LoanEntryInfo info = new LoanEntryInfo();
        info.setDate(loanInfo.getExpiredDate());
        info.setAmount(loanInfo.getAmount());
        info.setRepayIntType(RepayIntTypeEnum.REPAY_INT);
        info.setBlockFlowType(this.getDefaultBlockingFlowTypeInfo(ctx));
        info.setSeq(1);
        info.setParent(loanInfo);
        return info;
    }

    public BlockingFlowTypeInfo getDefaultBlockingFlowTypeInfo(Context ctx) throws EASBizException, BOSException {
        EntityViewInfo vi = new EntityViewInfo();
        FilterInfo fInfo = new FilterInfo();
        fInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"001", CompareType.EQUALS));
        vi.setFilter(fInfo);
        BlockingFlowTypeCollection bftCollection = null;
        bftCollection = BlockingFlowTypeFactory.getLocalInstance((Context)ctx).getBlockingFlowTypeCollection(vi);
        if (bftCollection == null || bftCollection.size() == 0) {
            throw new LoanException(LoanException.BLOCKINGFLOWTYPENUMBER001NOTEXISTS);
        }
        BlockingFlowTypeInfo bftInfo = bftCollection.get(0);
        return bftInfo;
    }

    public void submitHead(CoreBaseInfo coreBaseInfo, Context ctx) throws BOSException {
        try {
            IObjectPK pk = LoanFactory.getLocalInstance(ctx).save(coreBaseInfo);
            coreBaseInfo.setId(BOSUuid.read((String)pk.toString()));
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
    }

    protected String getTemplateNumber() {
        return "BondsBill";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = super.getExportFilterForQuery(ctx);
        Object obj = this.getContextParameter().get("filter");
        if (obj != null && obj instanceof FilterInfo) {
            FilterInfo filter1 = (FilterInfo)obj;
            try {
                filter.mergeFilter(filter1, "AND");
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fm.fin.BondsQuery";
    }

    public Hashtable _exportTransmit(IRowSet rs, Context ctx) throws EASBizException, BOSException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            int fiVouchered;
            BigDecimal amountLocalCur;
            BigDecimal seeAlso;
            String bondsFullName;
            String bondsShortForm;
            String bondsCode;
            int issuanceWays;
            String garanteeType;
            String project;
            String fundFlowItem;
            Date lastIntDate;
            BigDecimal cautionAmt;
            BigDecimal auctionPerc;
            String handlerRemark;
            String costCenter;
            String intRateTypeExpression;
            int repaymentType;
            String cautionAcctBank;
            String description;
            String Remark;
            String typeNumber;
            String contractNum;
            String marketPlace;
            String currency;
            BigDecimal amount;
            BigDecimal balance;
            BigDecimal localCurExRate;
            BigDecimal horizon;
            String companyNumber;
            String payIntMode;
            String creditorGroup;
            String bankAcct;
            String settlementAcct;
            String loanAcct;
            BigDecimal yieldRate;
            String intFeeAcctView;
            BigDecimal intFreeAmt;
            Date bizDate;
            String ratingAgency;
            String registrationNotice;
            Date expiredDate;
            Date issueDate;
            String number = this.getString(rs, "number");
            if (number != null) {
                result.put("FNumber", number);
            }
            if ((issueDate = rs.getDate("issueDate")) != null) {
                result.put("FIssueDate", DateTimeUtils.format((java.util.Date)issueDate, (String)"yyyy-MM-dd"));
            }
            if ((expiredDate = rs.getDate("expiredDate")) != null) {
                result.put("FExpiredDate", DateTimeUtils.format((java.util.Date)expiredDate, (String)"yyyy-MM-dd"));
            }
            if ((registrationNotice = this.getString(rs, "registrationNotice")) != null) {
                result.put("FRegistrationNotice", registrationNotice);
            }
            if ((ratingAgency = this.getString(rs, "ratingAgency")) != null) {
                result.put("FRatingAgency", ratingAgency);
            }
            if ((bizDate = rs.getDate("bizDate")) != null) {
                result.put("FBizDate", DateTimeUtils.format((java.util.Date)bizDate, (String)"yyyy-MM-dd"));
            }
            if ((intFreeAmt = rs.getBigDecimal("intFreeAmt")) != null) {
                result.put("FIntFreeAmt", intFreeAmt);
            }
            if ((intFeeAcctView = this.getString(rs, "intFeeAcctView.number")) != null) {
                result.put("FIntFeeAcctView_number", intFeeAcctView);
            }
            if ((yieldRate = rs.getBigDecimal("yieldRate")) != null) {
                result.put("FYieldRate", yieldRate);
            }
            if ((loanAcct = this.getString(rs, "loanAcct.number")) != null) {
                result.put("FLoanAcct_number", loanAcct);
            }
            if ((settlementAcct = this.getString(rs, "settlementAcct.number")) != null) {
                result.put("FSettlementAcct_number", settlementAcct);
            }
            if ((bankAcct = this.getString(rs, "bankAcct.number")) != null) {
                result.put("FBankAcct_number", bankAcct);
            }
            if ((creditorGroup = this.getString(rs, "creditorGroup.number")) != null) {
                result.put("FCreditorGroup_number", creditorGroup);
            }
            if ((payIntMode = this.getString(rs, "payIntMode.number")) != null) {
                result.put("FPayIntMode_number", payIntMode);
            }
            if ((companyNumber = this.getString(rs, "company.number")) != null) {
                result.put("FCompany_number", companyNumber);
            }
            if ((horizon = rs.getBigDecimal("horizon")) != null) {
                result.put("FHorizon", horizon);
            }
            if ((localCurExRate = rs.getBigDecimal("localCurExRate")) != null) {
                result.put("FLocalCurExRate", localCurExRate);
            }
            if ((balance = rs.getBigDecimal("balance")) != null) {
                result.put("FBalance", balance);
            }
            if ((amount = rs.getBigDecimal("amount")) != null) {
                result.put("FAmount", amount);
            }
            if ((currency = this.getString(rs, "currency.number")) != null) {
                result.put("FCurrency_number", currency);
            }
            if ((marketPlace = this.getString(rs, "marketPlace.number")) != null) {
                result.put("FMarketPlace_number", marketPlace);
            }
            if ((contractNum = this.getString(rs, "contractNum")) != null) {
                result.put("FContractNum", contractNum);
            }
            if ((typeNumber = this.getString(rs, "type.number")) != null) {
                result.put("FType_number", typeNumber);
            }
            if ((Remark = this.getString(rs, "Remark")) != null) {
                result.put("FRemark", Remark);
            }
            if ((description = this.getString(rs, "description")) != null) {
                result.put("FDescription", description);
            }
            if ((cautionAcctBank = this.getString(rs, "cautionAcctBank.number")) != null) {
                result.put("FCautionAcctBank_number", cautionAcctBank);
            }
            if (RepaymentTypeEnum.getEnum(repaymentType = rs.getInt("repaymentType")) != null) {
                result.put("FRepaymentType", repaymentType);
            }
            if ((intRateTypeExpression = this.getString(rs, "intRateTypeExpression")) != null) {
                result.put("FIntRateTypeExpression", intRateTypeExpression);
            }
            if ((costCenter = this.getString(rs, "costCenter.number")) != null) {
                result.put("FCostCenter_number", costCenter);
            }
            if ((handlerRemark = this.getString(rs, "handlerRemark")) != null) {
                result.put("FHandlerRemark", handlerRemark);
            }
            if ((auctionPerc = rs.getBigDecimal("auctionPerc")) != null) {
                result.put("FAuctionPerc", auctionPerc);
            }
            if ((cautionAmt = rs.getBigDecimal("cautionAmt")) != null) {
                result.put("FCautionAmt", cautionAmt);
            }
            if ((lastIntDate = rs.getDate("lastIntDate")) != null) {
                result.put("FLastIntDate", DateTimeUtils.format((java.util.Date)lastIntDate, (String)"yyyy-MM-dd"));
            }
            if ((fundFlowItem = this.getString(rs, "fundFlowItem.number")) != null) {
                result.put("FFundFlowItem_number", fundFlowItem);
            }
            if ((project = this.getString(rs, "project.number")) != null) {
                result.put("FProject_number", project);
            }
            if ((garanteeType = this.getString(rs, "garanteeType.number")) != null) {
                result.put("FGaranteeType_number", garanteeType);
            }
            int yearDays = rs.getInt("yearDays");
            result.put("FYearDays", yearDays);
            int creditRating = rs.getInt("creditRating");
            if (CreditRatingEnum.getEnum(creditRating) != null) {
                result.put("FCreditRating", creditRating);
            }
            if (IssuanceWaysEnum.getEnum(issuanceWays = rs.getInt("issuanceWays")) != null) {
                result.put("FIssuanceWays", issuanceWays);
            }
            if ((bondsCode = this.getString(rs, "bondsCode")) != null) {
                result.put("FBondsCode", bondsCode);
            }
            if ((bondsShortForm = this.getString(rs, "bondsShortForm")) != null) {
                result.put("FBondsShortForm", bondsShortForm);
            }
            if ((bondsFullName = this.getString(rs, "bondsFullName")) != null) {
                result.put("FBondsFullName", bondsFullName);
            }
            if ((seeAlso = rs.getBigDecimal("seeAlso")) != null) {
                result.put("FSeeAlso", seeAlso);
            }
            int issueNum = rs.getInt("issueNum");
            result.put("FIssueNum", issueNum);
            BigDecimal planIssuanceAmt = rs.getBigDecimal("planIssuanceAmt");
            if (planIssuanceAmt != null) {
                result.put("FPlanIssuanceAmt", planIssuanceAmt);
            }
            if ((amountLocalCur = rs.getBigDecimal("amountLocalCur")) != null) {
                result.put("FAmountLocalCur", amountLocalCur);
            }
            if ((fiVouchered = rs.getInt("fiVouchered")) == 0) {
                result.put("FFiVouchered", "false");
            } else if (fiVouchered == 1) {
                result.put("FFiVouchered", "true");
            }
            int historyBill = rs.getInt("historyBill");
            if (historyBill == 0) {
                result.put("FHistoryBill", "false");
            } else if (historyBill == 1) {
                result.put("FHistoryBill", "true");
            }
            int isConvetibleBonds = rs.getInt("isConvetibleBonds");
            if (isConvetibleBonds == 0) {
                result.put("FIsConvetibleBonds", "false");
            } else if (isConvetibleBonds == 1) {
                result.put("FIsConvetibleBonds", "true");
            }
            int isCanReSell = rs.getInt("isCanReSell");
            if (isCanReSell == 0) {
                result.put("FIsCanReSell", "false");
            } else if (isCanReSell == 1) {
                result.put("FIsCanReSell", "true");
            }
            int isBonds = rs.getInt("isBonds");
            if (isBonds == 0) {
                result.put("FIsBonds", "false");
            } else if (isBonds == 1) {
                result.put("FIsBonds", "true");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return result;
    }

    private LoanInfo getHeadInfo(Context ctx, int mode, String number, String companyid) throws BOSException, EASBizException {
        if (mode == 16 || mode == 128) {
            if (companyid == null || number == null) {
                return new LoanInfo();
            }
            try {
                ILoan loanInfo = (ILoan)this.getController(ctx);
                LoanCollection coll = loanInfo.getLoanCollection("where number = '" + number + "' and company.id = '" + companyid + "'");
                if (coll != null && coll.size() > 0) {
                    return coll.get(0);
                }
                return new LoanInfo();
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"15_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        if (mode == 8) {
            return new LoanInfo();
        }
        return new LoanInfo();
    }
}

