/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FinBillResult;
import com.kingdee.eas.fm.fin.BondsContractFacadeFactory;
import com.kingdee.eas.fm.fin.IBondsContractFacade;
import com.kingdee.eas.fm.fin.ILoanContract;
import com.kingdee.eas.fm.fin.LoanCollection;
import com.kingdee.eas.fm.fin.LoanContractCollection;
import com.kingdee.eas.fm.fin.LoanContractEnum;
import com.kingdee.eas.fm.fin.LoanContractFactory;
import com.kingdee.eas.fm.fin.LoanContractInfo;
import com.kingdee.eas.fm.fin.LoanException;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.app.AbstractBondsContractFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class BondsContractFacadeControllerBean
extends AbstractBondsContractFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.BondsContractFacadeControllerBean");
    private static final long serialVersionUID = 1L;

    private ILoanContract getBizInterface(Context ctx) throws BOSException {
        ILoanContract iLoanContract = null;
        iLoanContract = ctx == null ? LoanContractFactory.getRemoteInstance() : LoanContractFactory.getLocalInstance(ctx);
        return iLoanContract;
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanContractInfo info = (LoanContractInfo)model;
        info.setIsBondsContract(true);
        return this.getBizInterface(ctx).save((CoreBaseInfo)info);
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanContractInfo info = (LoanContractInfo)model;
        info.setIsBondsContract(true);
        return this.getBizInterface(ctx).submit((CoreBaseInfo)info);
    }

    @Override
    protected void _audit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanContractInfo info = (LoanContractInfo)model;
        if (info.getStatus() == LoanContractEnum.SAVE || info.getStatus() == LoanContractEnum.AUDITED) {
            throw new LoanException(LoanException.AUDIT_BILL_ERROR, new Object[]{info.getNumber()});
        }
        UserInfo currentUser = (UserInfo)ctx.get((Object)"UserInfo");
        String sql = "update T_FIN_LoanContract set FStatus = ?, FAuditorID = ? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(2), currentUser.getId().toString(), info.getId().toString()});
    }

    @Override
    protected void _antiAudit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanContractInfo info = (LoanContractInfo)model;
        if (info.getStatus() == LoanContractEnum.SAVE || info.getStatus() == LoanContractEnum.SUBMIT) {
            throw new LoanException(LoanException.ANTIAUDIT_BILL_ERROR, new Object[]{info.getNumber()});
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)info.getId().toString()));
        view.setFilter(filter);
        LoanCollection col = LoanFactory.getLocalInstance(ctx).getLoanCollection(view);
        if (col.size() > 0) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"111_BondsContractFacadeControllerBean", (Locale)ctx.getLocale())});
        }
        String sql = "update T_FIN_LoanContract set FStatus = ?, FAuditorID = null  where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(0), info.getId().toString()});
    }

    @Override
    protected void _close(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanContractInfo info = (LoanContractInfo)model;
        if (info.getStatus() != LoanContractEnum.AUDITED) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"112_BondsContractFacadeControllerBean", (Locale)ctx.getLocale())});
        }
        String sql = "update T_FIN_LoanContract set FStatus = ? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(3), info.getId().toString()});
    }

    @Override
    protected void _unClose(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanContractInfo info = (LoanContractInfo)model;
        if (info.getStatus() != LoanContractEnum.CLOSED) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"113_BondsContractFacadeControllerBean", (Locale)ctx.getLocale())});
        }
        String sql = "update T_FIN_LoanContract set FStatus = ? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(2), info.getId().toString()});
    }

    @Override
    protected ArrayList _batchAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        ArrayList<FinBillResult> reslts = new ArrayList<FinBillResult>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idSet), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getSelectors());
        LoanContractCollection col = LoanContractFactory.getLocalInstance(ctx).getLoanContractCollection(view);
        IBondsContractFacade iBondsContractFacade = BondsContractFacadeFactory.getLocalInstance(ctx);
        for (int i = 0; i < col.size(); ++i) {
            LoanContractInfo loanInfo = col.get(i);
            FinBillResult resultInfo = new FinBillResult(loanInfo.getId().toString(), loanInfo.getNumber(), "");
            try {
                iBondsContractFacade.audit(loanInfo);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                resultInfo.setDetailMsg(e.getMessage());
            }
            reslts.add(resultInfo);
        }
        col = null;
        return reslts;
    }

    @Override
    protected ArrayList _batchAntiAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        ArrayList<FinBillResult> reslts = new ArrayList<FinBillResult>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idSet), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getSelectors());
        LoanContractCollection col = LoanContractFactory.getLocalInstance(ctx).getLoanContractCollection(view);
        IBondsContractFacade iBondsContractFacade = BondsContractFacadeFactory.getLocalInstance(ctx);
        for (int i = 0; i < col.size(); ++i) {
            LoanContractInfo loanInfo = col.get(i);
            FinBillResult resultInfo = new FinBillResult(loanInfo.getId().toString(), loanInfo.getNumber(), "");
            try {
                iBondsContractFacade.antiAudit(loanInfo);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                resultInfo.setDetailMsg(e.getMessage());
            }
            reslts.add(resultInfo);
        }
        col = null;
        return reslts;
    }

    @Override
    protected ArrayList _batchClose(Context ctx, Set idSet) throws BOSException, EASBizException {
        ArrayList<FinBillResult> reslts = new ArrayList<FinBillResult>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idSet), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getSelectors());
        LoanContractCollection col = LoanContractFactory.getLocalInstance(ctx).getLoanContractCollection(view);
        IBondsContractFacade iBondsContractFacade = BondsContractFacadeFactory.getLocalInstance(ctx);
        for (int i = 0; i < col.size(); ++i) {
            LoanContractInfo loanInfo = col.get(i);
            FinBillResult resultInfo = new FinBillResult(loanInfo.getId().toString(), loanInfo.getNumber(), "");
            try {
                iBondsContractFacade.close(loanInfo);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                resultInfo.setDetailMsg(e.getMessage());
            }
            reslts.add(resultInfo);
        }
        col = null;
        return reslts;
    }

    @Override
    protected ArrayList _batchUnClose(Context ctx, Set idSet) throws BOSException, EASBizException {
        ArrayList<FinBillResult> reslts = new ArrayList<FinBillResult>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idSet), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getSelectors());
        LoanContractCollection col = LoanContractFactory.getLocalInstance(ctx).getLoanContractCollection(view);
        IBondsContractFacade iBondsContractFacade = BondsContractFacadeFactory.getLocalInstance(ctx);
        for (int i = 0; i < col.size(); ++i) {
            LoanContractInfo loanInfo = col.get(i);
            FinBillResult resultInfo = new FinBillResult(loanInfo.getId().toString(), loanInfo.getNumber(), "");
            try {
                iBondsContractFacade.unClose(loanInfo);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                resultInfo.setDetailMsg(e.getMessage());
            }
            reslts.add(resultInfo);
        }
        col = null;
        return reslts;
    }

    protected SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("company.*");
        sic.add("guaranteeEntrys.*");
        sic.add("IsInCredit");
        sic.add("CreditLimit.*");
        sic.add("CreditLimit.CreditUsage.*");
        return sic;
    }
}

