/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.fin.CompDepositAccountBillFactory;
import com.kingdee.eas.fm.fin.CompDepositAccountBillInfo;
import com.kingdee.eas.fm.fin.CompDepositBillStatusEnum;
import com.kingdee.eas.fm.fin.CompIntReceivedBillCollection;
import com.kingdee.eas.fm.fin.CompIntReceivedBillFactory;
import com.kingdee.eas.fm.fin.CompIntReceivedBillInfo;
import com.kingdee.eas.fm.fin.app.AbstractCompDepositAccountBillControllerBean;
import com.kingdee.eas.fm.fin.app.CompDepositAccountBillSubsidiaryBookProvider;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.td.TimeDepositApplyFactory;
import com.kingdee.eas.fm.td.TimeDepositApplyInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class CompDepositAccountBillControllerBean
extends AbstractCompDepositAccountBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.CompDepositAccountBillControllerBean");

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = NumberRuleUtil.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    @Override
    protected IRowSet _getMaturityDeposit(Context ctx) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CompDepositAccountBillInfo info = (CompDepositAccountBillInfo)model;
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)info);
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)info, (AbstractCoreBaseControllerBean)this);
        this.checkNumberDup(ctx, (IObjectValue)info);
        return super._addnew(ctx, (IObjectValue)info);
    }

    @Override
    public IObjectPK addnew(Context ctx, CompDepositAccountBillInfo model) throws BOSException, EASBizException {
        return super.addnew(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CompDepositAccountBillInfo info = (CompDepositAccountBillInfo)model;
        if (info.getLastPayDate() == null) {
            info.setLastPayDate(info.getEffectiveDate());
        }
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)info);
        IObjectPK pk = super._submit(ctx, (IObjectValue)info);
        this.doSubmit(ctx, info, pk);
        boolean isSubmitIsAccepted = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("FIN017", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (!info.isIsHistory() && !isSubmitIsAccepted) {
            info.setEffectedStatus(CompDepositBillStatusEnum.SUBMIT);
            this.doUpdateStatus(ctx, info);
        } else {
            this.doAccepted(ctx, info);
        }
        return pk;
    }

    private void doSubmit(Context ctx, CompDepositAccountBillInfo info, IObjectPK pk) throws EASBizException, BOSException {
        String sourceBillId;
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)info);
        CompDepositAccountBillInfo bgCompDepositAccountBillInfo = this.getCompDepositAccountBillInfo(ctx, "select * where id='" + pk.toString() + "'");
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)bgCompDepositAccountBillInfo);
        if (info.isIsReDeposited()) {
            this.doUpdate(ctx, info);
            this.saveBOTPRelationShip(ctx, pk, info);
        }
        if ((sourceBillId = info.getSourceBillId()) != null && new TimeDepositApplyInfo().getBOSType().equals((Object)BOSUuid.read((String)sourceBillId).getType())) {
            HashMap<String, String> botpRelationShip = new HashMap<String, String>();
            botpRelationShip.clear();
            botpRelationShip.put(sourceBillId, pk.toString());
            FMHelper.saveBOTRelation((Context)ctx, botpRelationShip);
            TimeDepositApplyInfo timeDepositApplyInfo = TimeDepositApplyFactory.getLocalInstance((Context)ctx).getTimeDepositApplyInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
            timeDepositApplyInfo.setIsBalanceBill(1);
            TimeDepositApplyFactory.getLocalInstance((Context)ctx).update(pk, (CoreBaseInfo)timeDepositApplyInfo);
        }
        NTHelper.updateFpItem((Context)ctx, (IObjectPK)pk, (String)"com.kingdee.eas.fm.fin.app.CompDepositAccountBill");
    }

    private void doBook(Context ctx, CompDepositAccountBillInfo info) throws EASBizException, BOSException {
        if (!info.isIsHistory()) {
            this.recAccount(ctx, info);
        }
    }

    private void saveBOTPRelationShip(Context ctx, IObjectPK pk, CompDepositAccountBillInfo CompDepositAccountBillInfo2) throws BOSException {
        HashMap<String, String> botpRelationShip = new HashMap<String, String>();
        botpRelationShip.clear();
        botpRelationShip.put(CompDepositAccountBillInfo2.getSourceBillId().toString(), pk.toString());
        FMHelper.saveBOTRelation((Context)ctx, botpRelationShip);
    }

    private void doUpdate(Context ctx, CompDepositAccountBillInfo CompDepositAccountBillInfo2) throws EASBizException, BOSException {
        String sql = "update T_FIN_CompDepositAccountBill set FIsChangeByReDeposited=1,FBalance = 0,FLastIntDate=? where fid=? ";
        Date lastRecDate = new Date(CompDepositAccountBillInfo2.getBizDate().getTime());
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{DateUtil.truncateSqlDate((Date)lastRecDate), CompDepositAccountBillInfo2.getSourceBillId()});
    }

    private void recAccount(Context ctx, CompDepositAccountBillInfo CompDepositAccountBillInfo2) throws EASBizException, BOSException {
        try {
            SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).book(CompDepositAccountBillInfo2.getId().toString(), CompDepositAccountBillSubsidiaryBookProvider.class.getName());
            String updateChequeSql = "update T_FIN_CompDepositAccountBill SET Fisbook=1 where fid=?";
            DbUtil.execute((Context)ctx, (String)updateChequeSql, (Object[])new Object[]{CompDepositAccountBillInfo2.getId().toString()});
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (e.getCause() != null) {
                msg = e.getCause().getMessage();
            }
            throw new FMException(FMException.NOTBOOK, new Object[]{msg, CompDepositAccountBillInfo2.getNumber()});
        }
    }

    protected IObjectPK _submitRelations(Context ctx, IObjectValue model, IObjectCollection relations) throws BOSException, EASBizException {
        return super._submitRelations(ctx, model, relations);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CompDepositAccountBillInfo billInfo = (CompDepositAccountBillInfo)this.getValue(ctx, pk);
        if (billInfo.isIsReDeposited()) {
            this.doOtherWork(ctx, billInfo);
        }
        SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).cancelBook(billInfo.getId().toString());
        String sourceBillId = billInfo.getSourceBillId();
        if (sourceBillId != null && new TimeDepositApplyInfo().getBOSType().equals((Object)BOSUuid.read((String)sourceBillId).getType())) {
            TimeDepositApplyInfo timeDepositApplyInfo = TimeDepositApplyFactory.getLocalInstance((Context)ctx).getTimeDepositApplyInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
            timeDepositApplyInfo.setIsBalanceBill(0);
            TimeDepositApplyFactory.getLocalInstance((Context)ctx).update(pk, (CoreBaseInfo)timeDepositApplyInfo);
        }
        NTHelper.cancelFpItem((Context)ctx, (String)pk.toString());
        super._delete(ctx, pk);
        FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
    }

    private void doOtherWork(Context ctx, CompDepositAccountBillInfo billInfo) throws BOSException, EASBizException {
        this.deleteIntBill(ctx, billInfo.getSourceBillId());
        this.reverseSourceBillAmt(ctx, billInfo);
        this.deleteBOTRelations(ctx, billInfo);
    }

    private void deleteBOTRelations(Context ctx, CompDepositAccountBillInfo billInfo) throws BOSException, BTPException {
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (!iBTPManager.ifHaveDestBills(billInfo.getSourceBillId())) {
            try {
                CompDepositAccountBillInfo info = new CompDepositAccountBillInfo();
                info.setId(BOSUuid.read((String)billInfo.getSourceBillId()));
                iBTPManager.removeAllSRCRelation((CoreBillBaseInfo)billInfo);
            }
            catch (BTPException ex) {
                throw new BTPException(BTPException.RELATIONDELETEERROR);
            }
        }
    }

    private void deleteIntBill(Context ctx, String pk) throws BOSException, EASBizException {
        CompIntReceivedBillFactory.getLocalInstance(ctx).deleteRelated((IObjectPK)new ObjectUuidPK(pk), true);
    }

    private void reverseSourceBillAmt(Context ctx, CompDepositAccountBillInfo billInfo) throws BOSException, EASBizException {
        String sql = "update T_FIN_CompDepositAccountBill set FIsChangeByReDeposited=0 ,FBalance = FBalance + " + billInfo.getAmount().subtract(billInfo.getAccrualToDepositAmt()) + " where fid = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{billInfo.getSourceBillId()});
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            CompDepositAccountBillInfo info = (CompDepositAccountBillInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setAccountant(null);
                info.setFiVouchered(false);
            } else if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.ADDNEW)) {
                info.setAccountant(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                info.setFiVouchered(true);
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    private void doAccepted(Context ctx, CompDepositAccountBillInfo info) throws EASBizException, BOSException {
        java.util.Date settleDate;
        CompanyOrgUnitInfo org = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        java.util.Date acceptedDate = settleDate = BankFactory.getLocalInstance((Context)ctx).getClearingHouse(org.getId().toString()).getSettleDate();
        if (!EmptyUtil.isEmpty((Object)info.getBizDate())) {
            acceptedDate = info.getBizDate().after(settleDate) ? info.getBizDate() : settleDate;
        }
        FinHelper.checkInnerAcctCtrl(ctx, info.getCorpCurAcct(), info.getCurrency(), info.getAmount());
        if (!info.isIsHistory()) {
            info.setAcceptedDate(acceptedDate);
            info.setAcceptor(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        } else {
            info.setAcceptedDate(null);
            info.setAcceptor(null);
        }
        info.setEffectedStatus(CompDepositBillStatusEnum.ACCEPTED);
        this._update(ctx, (IObjectPK)new ObjectStringPK(info.getId().toString()), (IObjectValue)info);
        this.doBook(ctx, info);
        if (info.isIsReDeposited()) {
            this.acceptIntBill(ctx, info.getSourceBillId());
        }
    }

    private void acceptIntBill(Context ctx, String sourceBillId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("intReceiveType", (Object)new Integer("2")));
        filter.getFilterItems().add(new FilterItemInfo("srcBillID", (Object)sourceBillId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        CompIntReceivedBillCollection col = CompIntReceivedBillFactory.getLocalInstance(ctx).getCompIntReceivedBillCollection(evi);
        CompIntReceivedBillInfo info = null;
        for (int i = 0; i < col.size(); ++i) {
            info = col.get(i);
            CompIntReceivedBillFactory.getLocalInstance(ctx).accepted((IObjectPK)new ObjectUuidPK(info.getId().toString()));
        }
    }

    private void antiAcceptIntBill(Context ctx, String sourceBillId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("intReceiveType", (Object)new Integer("2")));
        filter.getFilterItems().add(new FilterItemInfo("srcBillID", (Object)sourceBillId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        CompIntReceivedBillCollection col = CompIntReceivedBillFactory.getLocalInstance(ctx).getCompIntReceivedBillCollection(evi);
        CompIntReceivedBillInfo info = null;
        for (int i = 0; i < col.size(); ++i) {
            info = col.get(i);
            CompIntReceivedBillFactory.getLocalInstance(ctx).antiAccepted((IObjectPK)new ObjectUuidPK(info.getId().toString()));
        }
    }

    @Override
    protected void _accepted(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CompDepositAccountBillInfo info = CompDepositAccountBillFactory.getLocalInstance(ctx).getCompDepositAccountBillInfo(pk);
        this.doAccepted(ctx, info);
    }

    @Override
    protected void _antiAccepted(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CompDepositAccountBillInfo info = CompDepositAccountBillFactory.getLocalInstance(ctx).getCompDepositAccountBillInfo(pk);
        info.setAcceptedDate(null);
        info.setAcceptor(null);
        super._submit(ctx, (IObjectValue)info);
        info.setEffectedStatus(CompDepositBillStatusEnum.SUBMIT);
        this.doUpdateStatus(ctx, info);
        SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).cancelBook(pk.toString());
        if (info.isIsReDeposited()) {
            this.antiAcceptIntBill(ctx, info.getSourceBillId());
        }
    }

    private void doUpdateStatus(Context ctx, CompDepositAccountBillInfo info) throws EASBizException, BOSException {
        String sql = "update T_FIN_CompDepositAccountBill set FEffectedStatus=? where fid=? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(info.getEffectedStatus().getValue()), info.getId().toString()});
    }
}

