/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.common.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.common.IntReceivedBillTypeEnum;
import com.kingdee.eas.fm.fin.CompDepositAccountBillCollection;
import com.kingdee.eas.fm.fin.CompDepositAccountBillFactory;
import com.kingdee.eas.fm.fin.CompDepositAccountBillInfo;
import com.kingdee.eas.fm.fin.CompDepositBillStatusEnum;
import com.kingdee.eas.fm.fin.CompIntReceivedBillCollection;
import com.kingdee.eas.fm.fin.CompIntReceivedBillFactory;
import com.kingdee.eas.fm.fin.CompIntReceivedBillInfo;
import com.kingdee.eas.fm.fin.CompUnTimeDepositBillFactory;
import com.kingdee.eas.fm.fin.CompUnTimeDepositBillInfo;
import com.kingdee.eas.fm.fin.IntReceiveHelper;
import com.kingdee.eas.fm.fin.TDException;
import com.kingdee.eas.fm.fin.TimeDepositHelper;
import com.kingdee.eas.fm.fin.app.AbstractCompIntReceivedBillControllerBean;
import com.kingdee.eas.fm.fin.app.CompIntReceivedBillSubsidiaryBookProvider;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.framework.BillBaseCollection;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CompIntReceivedBillControllerBean
extends AbstractCompIntReceivedBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.CompIntReceivedBillControllerBean");
    private Map botpRelationShip = new HashMap();

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)((BillBaseInfo)model), (AbstractCoreBaseControllerBean)this);
        this.checkNumberDup(ctx, model);
        return super._addnew(ctx, model);
    }

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = NumberRuleUtil.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CompIntReceivedBillInfo oldInfo;
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)((CompIntReceivedBillInfo)model));
        CompIntReceivedBillInfo infoInt = (CompIntReceivedBillInfo)model;
        if (!infoInt.getIntReceiveType().getValue().equals("0") && EmptyUtil.isEmpty((CoreBaseInfo)infoInt.getCorpCurAcct())) {
            throw new TDException(TDException.CUR_ACCOUNT_NOT_NULL);
        }
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)infoInt);
        if (null != infoInt.getId() && this._exists(ctx, (IObjectPK)new ObjectUuidPK(infoInt.getId())) && (oldInfo = this.getCompIntReceivedBillInfo(ctx, "select * where id='" + infoInt.getId().toString() + "'")) != null) {
            FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)new ObjectStringPK(oldInfo.getId().toString()));
        }
        IObjectPK pkReturn = super._submit(ctx, model);
        if (infoInt.getIntReceiveType() != IntReceivedBillTypeEnum.PRE_DRAWING) {
            NTHelper.updateFpItem((Context)ctx, (IObjectPK)pkReturn, null);
            FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pkReturn, (IFMBgUsed)((CompIntReceivedBillInfo)model));
        }
        this.afterSubmit(ctx, infoInt, pkReturn);
        return pkReturn;
    }

    private void afterSubmit(Context ctx, CompIntReceivedBillInfo infoInt, IObjectPK pk) throws EASBizException, BOSException {
        this.processDoAccepted(ctx, infoInt, pk);
        String addNewType = infoInt.getIntReceiveType().getValue();
        if (addNewType.equals("1")) {
            if (null == infoInt.getCompUnTimeDepositBillInfo()) {
                return;
            }
            this.additionalProcessIntbillUntimeposit(infoInt, (CoreBaseInfo)infoInt.getCompUnTimeDepositBillInfo(), ctx, pk);
        } else if (addNewType.equals("2")) {
            if (null == infoInt.getCompDepositAccountBillInfo()) {
                return;
            }
            this.additionalProcessIntbillRedeposit(infoInt, (CoreBaseInfo)infoInt.getCompDepositAccountBillInfo(), ctx, pk);
        } else if (addNewType.equals("0")) {
            this.additionalProcessPreDrawing(infoInt, ctx, pk);
        } else if (addNewType.equals("3")) {
            this.additionalProcessIntbillPayinterest(infoInt, ctx, pk);
        }
        if (!"0".equals(addNewType)) {
            this.doBizOperation(infoInt, pk, ctx, addNewType);
        }
        if (!"0".equals(infoInt.getIntReceiveType().getValue())) {
            this.book(ctx, pk, infoInt);
        }
    }

    private void processDoAccepted(Context ctx, CompIntReceivedBillInfo infoInt, IObjectPK pk) throws EASBizException, BOSException {
        CompanyOrgUnitInfo org = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        boolean isSubmitIsAccepted = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("FIN017", (IObjectPK)new ObjectUuidPK(org.getId()));
        if (isSubmitIsAccepted && !"0".equals(infoInt.getIntReceiveType().getValue())) {
            this.doAccepted(ctx, infoInt, pk);
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pkReturn = super._save(ctx, model);
        CompIntReceivedBillInfo infoInt = (CompIntReceivedBillInfo)model;
        this.afterSave(ctx, infoInt, pkReturn);
        return pkReturn;
    }

    private void afterSave(Context ctx, CompIntReceivedBillInfo infoInt, IObjectPK pk) throws EASBizException, BOSException {
        String addNewType = infoInt.getIntReceiveType().getValue();
        if (addNewType.equals("0")) {
            this.additionalProcessPreDrawing(infoInt, ctx, pk);
        } else if (addNewType.equals("3")) {
            this.reverseLastPayDateToTimeDepositBill(infoInt, ctx);
        }
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            CompIntReceivedBillInfo info = (CompIntReceivedBillInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setAccountant(null);
                info.setFivouchered(false);
            } else {
                info.setAccountant(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                info.setFivouchered(true);
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    private void additionalProcessIntbillUntimeposit(CompIntReceivedBillInfo info, CoreBaseInfo billInfo, Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        CompUnTimeDepositBillInfo CompUnTimeDepositBillInfo2 = (CompUnTimeDepositBillInfo)billInfo;
        this.addUnDepositBill(ctx, info, CompUnTimeDepositBillInfo2);
        this.saveBOTPRelationShip(ctx, pk, info.getTimeDepositBillID());
        this.saveBOTPRelationShip(ctx, pk, CompUnTimeDepositBillInfo2.getId());
    }

    private void additionalProcessIntbillRedeposit(CompIntReceivedBillInfo info, CoreBaseInfo billInfo, Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CompDepositAccountBillInfo CompDepositAccountBillInfo2 = (CompDepositAccountBillInfo)billInfo;
        this.addTimeDepositBill(ctx, CompDepositAccountBillInfo2, info);
        String Srcid = info.getSrcBillID();
        info.setSrcBillID(Srcid);
        this.saveBOTPRelationShip(ctx, pk, info.getTimeDepositBillID());
    }

    private void additionalProcessPreDrawing(CompIntReceivedBillInfo info, Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.reverseToTimeDepositBill(info, ctx);
        this.saveBOTPRelationShip(ctx, pk, info.getTimeDepositBillID());
        this.reverseIsPreDraw(ctx, info.getTimeDepositBillID());
    }

    private void additionalProcessIntbillPayinterest(CompIntReceivedBillInfo info, Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.saveBOTPRelationShip(ctx, pk, info.getTimeDepositBillID());
    }

    private void book(Context ctx, IObjectPK pk, CompIntReceivedBillInfo info) throws BOSException, EASBizException {
        info = CompIntReceivedBillFactory.getLocalInstance(ctx).getCompIntReceivedBillInfo(pk);
        String fromAccepted = (String)ctx.get((Object)"fromAccepted");
        CompanyOrgUnitInfo org = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        boolean isSubmitIsAccepted = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("FIN017", (IObjectPK)new ObjectUuidPK(org.getId()));
        if (isSubmitIsAccepted || !EmptyUtil.isEmpty((String)fromAccepted)) {
            if (info.getShijiAmt().compareTo(Constants.ZERO) != 0 && !info.isIsBooked()) {
                this.doBook(ctx, pk);
            }
        } else {
            info.setEffectedStatus(CompDepositBillStatusEnum.SUBMIT);
            this._update(ctx, pk, (IObjectValue)info);
        }
        ctx.put((Object)"fromAccepted", (Object)"");
    }

    private void doBook(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).book(pk.toString(), CompIntReceivedBillSubsidiaryBookProvider.class.getName());
        String sql = "update t_fin_compintreceivedbill set FIsBooked = 1 where fid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
    }

    private void addUnDepositBill(Context ctx, CompIntReceivedBillInfo info, CompUnTimeDepositBillInfo CompUnTimeDepositBillInfo2) throws BOSException, EASBizException {
        try {
            CompUnTimeDepositBillInfo2.setIntDeAmt(info.getDeInterest());
            CompUnTimeDepositBillInfo2.setIntCurAmt(info.getCreInterest());
            CompUnTimeDepositBillInfo2.setIntSum(CompUnTimeDepositBillInfo2.getIntDeAmt().add(CompUnTimeDepositBillInfo2.getIntCurAmt()));
            CompUnTimeDepositBillInfo2.setYearRate(info.getCreYearRate());
            CompUnTimeDepositBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)CompUnTimeDepositBillInfo2);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e1) {
            throw new BOSException((Throwable)e1);
        }
    }

    private void antiBook(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).cancelBook(pk.toString());
        String sql = "update T_fin_CompIntReceivedBill set FIsBooked = 0 where fid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
    }

    private void doBizOperation(CompIntReceivedBillInfo info, IObjectPK pk, Context ctx, String addNewType) throws BOSException, EASBizException {
        CompDepositAccountBillInfo compDepositAccountBillInfo;
        if (addNewType.equals("1") && (compDepositAccountBillInfo = CompDepositAccountBillFactory.getLocalInstance(ctx).getCompDepositAccountBillInfo((IObjectPK)new ObjectUuidPK(info.getTimeDepositBillID().getId().toString()))).getBalance().compareTo(new BigDecimal("0.0")) > 0) {
            return;
        }
        String sqlUpdate2 = "update T_fin_CompIntReceivedBill set FYichongxiaoAmt = FYichongxiaoAmt + (select isnull(sum(FShijiAmt),0) from T_fin_CompIntReceivedBill" + " where FIsChongzhang = 0 and FEndDate <= ? and FIntReceiveType ='0' and FTimeDepositBillIDID =? ) where fid = ?".intern();
        Object[] params2 = new Object[]{new Date(info.getEndDate().getTime()), info.getTimeDepositBillID().getId().toString(), info.getId().toString()};
        DbUtil.execute((Context)ctx, (String)sqlUpdate2, (Object[])params2);
        String sqlUpdate1 = "update T_fin_CompIntReceivedBill set FIsChongzhang =?, FStrikedBy = ? where FIsChongzhang = 0 and  FEndDate <= ? and FIntReceiveType ='0' and FTimeDepositBillIDID =?".intern();
        Object[] params1 = new Object[]{new Integer(1), pk.toString(), new Date(info.getEndDate().getTime()), info.getTimeDepositBillID().getId().toString()};
        DbUtil.execute((Context)ctx, (String)sqlUpdate1, (Object[])params1);
    }

    private void doUnBizOperation(CompIntReceivedBillInfo info, IObjectPK pk, Context ctx) throws BOSException, EASBizException {
        this.reverseIntBillChongZhangStatus(ctx, pk.toString());
    }

    private void addTimeDepositBill(Context ctx, CompDepositAccountBillInfo CInfo, CompIntReceivedBillInfo info) throws BOSException {
        BigDecimal billDepsositAmt = CInfo.getAmount();
        if (CInfo.isIsAccrualToDepositAmt()) {
            CInfo.setAmount(CInfo.getAmount().add(info.getShijiAmt()));
            CInfo.setNaturalAmt(CInfo.getAmount().multiply(CInfo.getExchangeRate()));
            CInfo.setBalance(CInfo.getAmount());
            CInfo.setAccrualToDepositAmt(info.getShijiAmt());
            BigDecimal intervalDays = new BigDecimal(String.valueOf(TimeDepositHelper.getInstance().calcuIntervalDays(CInfo.getMaturityDay(), CInfo.getEffectiveDate())));
            IntRateTypeExpressionEnum intRateTypeExpressionEnum = CInfo.getIntRateTypeExpression();
            BigDecimal base = Constants.ONE_HUNDRED;
            if (intRateTypeExpressionEnum != IntRateTypeExpressionEnum.YEAR) {
                base = Constants.ONE_THOUSAND;
            }
            BigDecimal depositAmt = CInfo.getAmount().subtract(CInfo.getIntFreeAmt());
            CInfo.setExpireIn(TimeDepositHelper.getInstance().calcMatureIntAmt(depositAmt, CInfo.getRate(), new BigDecimal(String.valueOf(CInfo.getYearDays())), intervalDays, base));
            if (CInfo.isIsHistory()) {
                CInfo.setInitBalanceOfHistoryBill(CInfo.getBalance());
            } else {
                CInfo.setInitBalanceOfHistoryBill(CInfo.getAmount());
            }
        }
        try {
            this.checkNowDBBalance(ctx, CInfo.getSourceBillId(), billDepsositAmt);
            CompDepositAccountBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)CInfo);
        }
        catch (EASBizException e) {
            throw new BOSException(e.getMessage());
        }
    }

    private void reverseIsPreDraw(Context ctx, CompDepositAccountBillInfo info) throws BOSException {
        String sql = "update T_FIN_CompDepositAccountBill set FIsPreDraw = ? where fid=?".intern();
        Object[] params = new Object[]{new Integer(1), info.getId().toString()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    private void reverseToTimeDepositBill(CompIntReceivedBillInfo info, Context ctx) throws BOSException, EASBizException {
        String sql = "update T_FIN_CompDepositAccountBill set FLastIntDate = ? where fid = ?";
        java.util.Date intBillEndDate = DateUtil.getAfterDay((java.util.Date)info.getEndDate());
        Object[] params = new Object[]{new Date(intBillEndDate.getTime()), info.getTimeDepositBillID().getId().toString()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    private void reverseLastPayDateToTimeDepositBill(CompIntReceivedBillInfo info, Context ctx) throws BOSException, EASBizException {
        String sql = "update T_FIN_CompDepositAccountBill set FLastPayDate = ? where fid = ?";
        java.util.Date intBillEndDate = DateUtil.getAfterDay((java.util.Date)info.getEndDate());
        Object[] params = new Object[]{new Date(intBillEndDate.getTime()), info.getTimeDepositBillID().getId().toString()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    private void saveBOTPRelationShip(Context ctx, IObjectPK pk, CompDepositAccountBillInfo timeDepositBillID) throws BOSException {
        this.saveBOTPRelationShip(ctx, pk, timeDepositBillID.getId());
    }

    private void saveBOTPRelationShip(Context ctx, IObjectPK pk, BOSUuid bOSUuid) throws BOSException {
        this.botpRelationShip.clear();
        this.botpRelationShip.put(bOSUuid.toString(), pk.toString());
        BOTPUtil.saveBOTRelation((Context)ctx, (Map)this.botpRelationShip);
    }

    @Override
    protected Set _addBatch(Context ctx, Set ids, java.util.Date date) throws BOSException, EASBizException {
        CompDepositAccountBillInfo CompDepositAccountBillInfo2 = null;
        CompIntReceivedBillInfo CompIntReceivedBillInfo2 = null;
        HashSet<IObjectPK> createdIntReceivedID = new HashSet<IObjectPK>();
        CompDepositAccountBillCollection tdbc = this.getCompDepositAccountBillCollection(ctx, ids);
        for (int i = 0; i < tdbc.size(); ++i) {
            CompDepositAccountBillInfo2 = tdbc.get(i);
            CompIntReceivedBillInfo2 = new CompIntReceivedBillInfo();
            CompIntReceivedBillInfo2 = IntReceiveHelper.getInstance().createIntReceiveBillToBeSaved(ctx, CompIntReceivedBillInfo2, CompDepositAccountBillInfo2, date);
            CompIntReceivedBillInfo2.setCreator(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
            if ((CompIntReceivedBillInfo2.getIntReceiveType() == IntReceivedBillTypeEnum.PRE_DRAWING || CompIntReceivedBillInfo2.getIntReceiveType() == IntReceivedBillTypeEnum.INTBILL_PAYINTEREST) && FmMbgHelper.isCtrl((Context)ctx, (BOSObjectType)CompIntReceivedBillInfo2.getBOSType())) {
                createdIntReceivedID.add(this.save(ctx, (CoreBaseInfo)CompIntReceivedBillInfo2));
                continue;
            }
            createdIntReceivedID.add(this.submit(ctx, (CoreBaseInfo)CompIntReceivedBillInfo2));
        }
        return createdIntReceivedID;
    }

    private CompDepositAccountBillCollection getCompDepositAccountBillCollection(Context ctx, Set ids) throws BOSException {
        String includeValue = this.parseValue(ids);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)includeValue, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("interm.*"));
        evi.getSelector().add(new SelectorItemInfo("corpCurAcct.*"));
        return CompDepositAccountBillFactory.getLocalInstance(ctx).getCompDepositAccountBillCollection(evi);
    }

    private String parseValue(Set setIDs) {
        return TimeDepositHelper.getInstance().parseValue(setIDs);
    }

    protected Set _addBatch(Context ctx, BillBaseCollection col, java.util.Date date) throws BOSException, EASBizException {
        CompDepositAccountBillInfo CompDepositAccountBillInfo2 = null;
        CompIntReceivedBillInfo CompIntReceivedBillInfo2 = null;
        HashSet<IObjectPK> createdIntReceivedID = new HashSet<IObjectPK>();
        for (int i = 0; i < col.size(); ++i) {
            CompDepositAccountBillInfo2 = (CompDepositAccountBillInfo)col.get(i);
            CompIntReceivedBillInfo2 = new CompIntReceivedBillInfo();
            CompIntReceivedBillInfo2 = IntReceiveHelper.getInstance().createIntReceiveBillToBeSaved(ctx, CompIntReceivedBillInfo2, CompDepositAccountBillInfo2, date);
            createdIntReceivedID.add(this.save(ctx, (CoreBaseInfo)CompIntReceivedBillInfo2));
        }
        return createdIntReceivedID;
    }

    private void beforeDelete(Context ctx, CompIntReceivedBillInfo CompCompIntReceivedBillInfo) throws BOSException, EASBizException {
        this.checkIntBillIsAccepted(ctx, CompCompIntReceivedBillInfo);
        this.checkIntBillIsVoucher(ctx, CompCompIntReceivedBillInfo);
        this.checkIntBillIsLastBill(ctx, CompCompIntReceivedBillInfo);
    }

    private void afterDelete(Context ctx, CompIntReceivedBillInfo compCompIntReceivedBillInfo) throws BOSException, EASBizException {
        this.doUnBizOperation(compCompIntReceivedBillInfo, (IObjectPK)new ObjectUuidPK(compCompIntReceivedBillInfo.getId()), ctx);
        this.antiBook(ctx, (IObjectPK)new ObjectUuidPK(compCompIntReceivedBillInfo.getId()));
        this.reLastDate(ctx, compCompIntReceivedBillInfo);
    }

    private void reLastDate(Context ctx, CompIntReceivedBillInfo compCompIntReceivedBillInfo) throws BOSException, EASBizException {
        java.util.Date lastIntDate = compCompIntReceivedBillInfo.getLastIntDate();
        Date dp = null;
        if (lastIntDate != null) {
            dp = new Date(lastIntDate.getTime());
        }
        String sql = null;
        if (lastIntDate == null) {
            sql = compCompIntReceivedBillInfo.getIntReceiveType().equals((Object)IntReceivedBillTypeEnum.INTBILL_PAYINTEREST) ? "update T_FIN_CompDepositAccountBill set FLastPayDate = null where fid = ?" : "update T_FIN_CompDepositAccountBill set FLastIntDate = null where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{compCompIntReceivedBillInfo.getTimeDepositBillID().getId().toString()});
        } else {
            sql = compCompIntReceivedBillInfo.getIntReceiveType().equals((Object)IntReceivedBillTypeEnum.INTBILL_PAYINTEREST) ? "update T_FIN_CompDepositAccountBill set FLastPayDate = ? where fid = ?" : "update T_FIN_CompDepositAccountBill set FLastIntDate = ? where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{dp, compCompIntReceivedBillInfo.getTimeDepositBillID().getId().toString()});
        }
    }

    @Override
    protected void _deleteRelated(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._deleteRelated(ctx, pk, false);
    }

    @Override
    protected void _deleteRelated(Context ctx, IObjectPK pk, boolean reDeposit) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        if (reDeposit) {
            filter.getFilterItems().add(new FilterItemInfo("intReceiveType", (Object)new Integer("2")));
        }
        filter.getFilterItems().add(new FilterItemInfo("srcBillID", (Object)pk.toString()));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        CompIntReceivedBillCollection col = CompIntReceivedBillFactory.getLocalInstance(ctx).getCompIntReceivedBillCollection(evi);
        CompIntReceivedBillInfo CompCompIntReceivedBillInfo = null;
        for (int i = 0; i < col.size(); ++i) {
            CompCompIntReceivedBillInfo = col.get(i);
            this.checkIntBillIsAccepted(ctx, CompCompIntReceivedBillInfo);
            this.checkIntBillIsVoucher(ctx, CompCompIntReceivedBillInfo);
            this.checkIntBillIsLastBill(ctx, CompCompIntReceivedBillInfo);
            this.doUnBizOperation(CompCompIntReceivedBillInfo, (IObjectPK)new ObjectUuidPK(CompCompIntReceivedBillInfo.getId()), ctx);
            this.deleteIntBill(ctx, (IObjectPK)new ObjectUuidPK(CompCompIntReceivedBillInfo.getId()));
            String sql = null;
            java.util.Date lastIntDate = CompCompIntReceivedBillInfo.getLastIntDate();
            if (!CompCompIntReceivedBillInfo.getIntReceiveType().equals((Object)IntReceivedBillTypeEnum.PRE_DRAWING) && !CompCompIntReceivedBillInfo.getIntReceiveType().equals((Object)IntReceivedBillTypeEnum.INTBILL_REDEPOSIT) || lastIntDate == null) continue;
            sql = "update T_FIN_CompDepositAccountBill set FLastIntDate = ? where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{CompCompIntReceivedBillInfo.getLastIntDate(), CompCompIntReceivedBillInfo.getTimeDepositBillID().getId().toString()});
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        CompIntReceivedBillInfo info = this.getCompIntReceivedBillInfo(ctx, pk);
        this.beforeDelete(ctx, info);
        NTHelper.cancelFpItem((Context)ctx, (String)pk.toString());
        FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
        super._delete(ctx, pk);
        this.afterDelete(ctx, info);
        NumberRuleUtil.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
    }

    private void checkIntBillIsVoucher(Context ctx, CompIntReceivedBillInfo CompCompIntReceivedBillInfo) throws BOSException {
        if (CompCompIntReceivedBillInfo.isFivouchered()) {
            throw new BOSException(EASCommonResource.getString((String)"com.kingdee.eas.fm.fin.TdResource", (String)"intBillCannotDeleted_reason1", (Locale)ctx.getLocale()));
        }
    }

    private void deleteIntBill(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        this.updateChoangZhangStatus(ctx, pk);
        SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).cancelBook(pk.toString());
        super._delete(ctx, pk);
    }

    private void updateChoangZhangStatus(Context ctx, IObjectPK pk) throws BOSException {
        String sqlUpdate1 = "update T_FIN_CompIntReceivedBill set FIsChongzhang =? where  FStrikedBy = ? and FIntReceiveType ='0'".intern();
        Object[] params1 = new Object[]{new Integer(0), pk.toString()};
        DbUtil.execute((Context)ctx, (String)sqlUpdate1, (Object[])params1);
    }

    private void checkIntBillIsAccepted(Context ctx, CompIntReceivedBillInfo info) throws BOSException {
        if (info.getEffectedStatus() == CompDepositBillStatusEnum.ACCEPTED) {
            throw new BOSException(EASCommonResource.getString((String)"com.kingdee.eas.fm.fin.TdResource", (String)"intBillCannotDeleted_reason3", (Locale)ctx.getLocale()));
        }
    }

    private void checkIntBillIsLastBill(Context ctx, CompIntReceivedBillInfo CompCompIntReceivedBillInfo) throws BOSException {
        IntReceivedBillTypeEnum intReceivedBilltype;
        String relatedTimeBillId = CompCompIntReceivedBillInfo.getTimeDepositBillID().getId().toString();
        java.util.Date maxDate = this.getMaxDate(ctx, relatedTimeBillId, intReceivedBilltype = CompCompIntReceivedBillInfo.getIntReceiveType());
        if (maxDate != null && this.isStartDateBeforeEndDate(CompCompIntReceivedBillInfo.getEndDate(), maxDate)) {
            throw new BOSException(EASCommonResource.getString((String)"com.kingdee.eas.fm.fin.TdResource", (String)"intBillCannotDeleted_reason2", (Locale)ctx.getLocale()));
        }
    }

    private void checkNowDBBalance(Context ctx, String sourceID, BigDecimal billDepsositAmt) throws EASBizException, BOSException {
        CompDepositAccountBillInfo sourceInfo = CompDepositAccountBillFactory.getLocalInstance(ctx).getCompDepositAccountBillInfo((IObjectPK)new ObjectUuidPK(sourceID));
        BigDecimal balanceNow = sourceInfo.getBalance();
        if (balanceNow.compareTo(billDepsositAmt) != 0) {
            throw new TDException(TDException.REDEPOSIT_ERROR1);
        }
    }

    private void reverseIntBillChongZhangStatus(Context ctx, String id) throws BOSException, EASBizException {
        String sql = "update T_FIN_CompIntReceivedBill set FIsChongzhang = 0 where FStrikedBy = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{id});
    }

    private boolean isStartDateBeforeEndDate(java.util.Date p_startDate, java.util.Date p_endDate) {
        return p_startDate.compareTo(p_endDate) < 0;
    }

    private java.util.Date getMaxDate(Context ctx, String relatedTimeBillId, IntReceivedBillTypeEnum intReceivedBilltype) throws BOSException {
        java.util.Date returnDate = null;
        String sql = "";
        IRowSet rs = null;
        if ("0".equals(intReceivedBilltype.getValue())) {
            sql = "select max(fenddate) from T_FIN_CompIntReceivedBill where  ftimedepositbillidid = ? and FIntReceiveType = ? ";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{relatedTimeBillId, intReceivedBilltype.getValue()});
        } else {
            sql = "select max(fenddate) from T_FIN_CompIntReceivedBill where  ftimedepositbillidid = ? and FIntReceiveType <> ? ";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{relatedTimeBillId, "0"});
        }
        try {
            Date obj;
            if (rs.next() && (obj = rs.getDate(1)) != null) {
                returnDate = new java.util.Date(rs.getDate(1).getTime());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return returnDate;
    }

    @Override
    protected Map _addBatch(Context ctx, Set ids, java.util.Date beginDay, java.util.Date endDay) throws BOSException, EASBizException {
        java.util.Date endDate = new java.util.Date();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (ids == null || ids.size() == 0) {
            return map;
        }
        if (endDay != null) {
            endDate = endDay;
        }
        CompDepositAccountBillInfo CompDepositAccountBillInfo2 = null;
        CompIntReceivedBillInfo compIntReceivedBillInfo = null;
        HashSet<IObjectPK> createdIntReceivedID = new HashSet<IObjectPK>();
        CompDepositAccountBillCollection tdbc = this.getCompDepositAccountBillCollection(ctx, ids);
        StringBuffer exceptionString = new StringBuffer("");
        for (int i = 0; i < tdbc.size(); ++i) {
            try {
                CompDepositAccountBillInfo2 = tdbc.get(i);
                compIntReceivedBillInfo = new CompIntReceivedBillInfo();
                compIntReceivedBillInfo = IntReceiveHelper.getInstance().createIntReceivePayBillToBeSaved(ctx, compIntReceivedBillInfo, CompDepositAccountBillInfo2, beginDay, endDate);
                compIntReceivedBillInfo.setCreator(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                createdIntReceivedID.add(this.save(ctx, (CoreBaseInfo)compIntReceivedBillInfo));
                continue;
            }
            catch (TDException e) {
                exceptionString = exceptionString.append(CompDepositAccountBillInfo2.getNumber()).append(" ");
            }
        }
        map.put("createdIntReceivedID", createdIntReceivedID);
        map.put("exceptionString", exceptionString.toString());
        return map;
    }

    @Override
    protected Map _subBatch(Context ctx, Set ids) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        if (ids == null || ids.size() <= 0) {
            return map;
        }
        HashSet<IObjectPK> createdIntReceivedID = new HashSet<IObjectPK>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        CompIntReceivedBillCollection compIntReceivedBillCollection = CompIntReceivedBillFactory.getLocalInstance(ctx).getCompIntReceivedBillCollection(evi);
        Iterator iterator = compIntReceivedBillCollection.iterator();
        while (iterator.hasNext()) {
            CompIntReceivedBillInfo compIntReceivedBillInfo = (CompIntReceivedBillInfo)iterator.next();
            if (compIntReceivedBillInfo == null || IntReceivedBillTypeEnum.INTBILL_PAYINTEREST != compIntReceivedBillInfo.getIntReceiveType() || CompDepositBillStatusEnum.ACCEPTED == compIntReceivedBillInfo.getEffectedStatus()) continue;
            createdIntReceivedID.add(this.submit(ctx, (CoreBaseInfo)compIntReceivedBillInfo));
            map.put("createdIntReceivedID", createdIntReceivedID);
        }
        return map;
    }

    private void doAccepted(Context ctx, CompIntReceivedBillInfo info, IObjectPK pk) throws EASBizException, BOSException {
        java.util.Date settleDate;
        info = CompIntReceivedBillFactory.getLocalInstance(ctx).getCompIntReceivedBillInfo(pk);
        CompanyOrgUnitInfo org = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        java.util.Date acceptedDate = settleDate = BankFactory.getLocalInstance((Context)ctx).getClearingHouse(org.getId().toString()).getSettleDate();
        if (!EmptyUtil.isEmpty((Object)info.getBizDate())) {
            acceptedDate = info.getBizDate().after(settleDate) ? info.getBizDate() : settleDate;
        }
        info.setAcceptedDate(acceptedDate);
        info.setAcceptor(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        info.setEffectedStatus(CompDepositBillStatusEnum.ACCEPTED);
        this._update(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected void _accepted(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CompIntReceivedBillInfo info = this.getCompIntReceivedBillInfo(ctx, pk);
        ctx.put((Object)"fromAccepted", (Object)"fromAccepted");
        this.doAccepted(ctx, info, pk);
        this.book(ctx, pk, info);
    }

    @Override
    protected void _antiAccepted(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CompIntReceivedBillInfo info = this.getCompIntReceivedBillInfo(ctx, pk);
        info.setAcceptedDate(null);
        info.setAcceptor(null);
        info.setEffectedStatus(CompDepositBillStatusEnum.SUBMIT);
        this._update(ctx, pk, (IObjectValue)info);
        this.antiBook(ctx, pk);
    }

    @Override
    protected void _batchReverseSave(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos, IObjectCollection destObjCol) throws BOSException, EASBizException {
        if (bOTRelationInfos == null || bOTRelationInfos.size() < 1) {
            return;
        }
        BOTRelationInfo botRelation = bOTRelationInfos.get(0);
        if (!new VoucherInfo().getBOSType().toString().equals(botRelation.getDestEntityID())) {
            return;
        }
        String vouche = "UPDATE T_FIN_CompIntReceivedBill SET ffivouchered = 1, faccountantid = ?, FVOUCHERNUMBER = ?, FVOUCHERTYPEID = ? WHERE FID = ? ";
        String unVouche = "UPDATE T_FIN_CompIntReceivedBill SET ffivouchered = 0, faccountantid = null, FVOUCHERNUMBER = null, FVOUCHERTYPEID = null WHERE FID = ? ";
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        for (int i = 0; i < bOTRelationInfos.size(); ++i) {
            String srcBillId = bOTRelationInfos.get(i).getSrcObjectID();
            VoucherInfo voucherInfo = null;
            if (destObjCol != null && destObjCol.size() > 0) {
                try {
                    voucherInfo = (VoucherInfo)destObjCol.getObject(0);
                }
                catch (Exception e) {
                    voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(botRelation.getDestObjectID()));
                }
            } else {
                voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(botRelation.getDestObjectID()));
            }
            String voucherTypeID = voucherInfo.getVoucherType().getId().toString();
            String voucherNumber = voucherInfo.getNumber();
            if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                DbUtil.execute((Context)ctx, (String)unVouche, (Object[])new Object[]{srcBillId});
                continue;
            }
            DbUtil.execute((Context)ctx, (String)vouche, (Object[])new Object[]{userId, voucherNumber, voucherTypeID, srcBillId});
        }
    }
}

