/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fin.CompDepositAccountBillFactory;
import com.kingdee.eas.fm.fin.CompDepositAccountBillInfo;
import com.kingdee.eas.fm.fin.CompIntReceivedBillFactory;
import com.kingdee.eas.fm.fin.CompIntReceivedBillInfo;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.ISubsidiaryBookProvider;
import com.kingdee.eas.fm.fs.SubsidiaryBillTypeEnum;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;

public class CompIntReceivedBillSubsidiaryBookProvider
implements ISubsidiaryBookProvider {
    public SubsidiaryLedgerCollection getCollection(Context ctx, String billId) throws BOSException, EASBizException {
        CompIntReceivedBillInfo billInfo = this.getCompDepositAccountBill(ctx, billId);
        CompDepositAccountBillInfo cdbillInfo = billInfo.getTimeDepositBillID();
        BigDecimal creditAmt = billInfo.getShijiAmt();
        SubsidiaryLedgerInfo slInfo = new SubsidiaryLedgerInfo();
        SubsidiaryLedgerCollection coll = new SubsidiaryLedgerCollection();
        if (billInfo.getCorpCurAcct() != null) {
            CompDepositAccountBillInfo redepobill;
            slInfo.setApplyUnit(billInfo.getDepCompany());
            slInfo.setCompany(billInfo.getCompany());
            slInfo.setInnerAccount(billInfo.getCorpCurAcct());
            slInfo.setCurrency(billInfo.getCurrency());
            slInfo.setBillId(billInfo.getId());
            slInfo.setBillNumber(billInfo.getNumber());
            BankInfo clearingHouse = FSHelper.getClearingHouseInfo((Context)ctx, (String)billInfo.getCompany().getId().toString());
            if (!clearingHouse.isUsed()) {
                throw new FSException(FSException.CLEARINGHOUSENOTUSED);
            }
            Date bizDate = new Date();
            bizDate = billInfo.getBizDate().after(clearingHouse.getSettleDate()) ? DateTimeUtils.truncateDate((Date)billInfo.getBizDate()) : DateTimeUtils.truncateDate((Date)clearingHouse.getSettleDate());
            slInfo.setDate(bizDate);
            slInfo.setCpCurrency(billInfo.getCurrency());
            slInfo.setDescription(EASCommonResource.getString((String)"com.kingdee.eas.fm.fin.FinResource.CompIntrecBill", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"1_CompDepositAccountBillSubsidiaryBookProvider", (Locale)ctx.getLocale()));
            slInfo.setCreditAmount(Constants.ZERO);
            slInfo.setDebitAmount(creditAmt);
            slInfo.setExchangeRate(CompIntReceivedBillSubsidiaryBookProvider.getExRate(ctx, billInfo.getCurrency().getId()));
            slInfo.setBookkeeper(billInfo.getCreator());
            slInfo.setBizType(SubsidiaryBillTypeEnum.COMPUINTRECDEPOSITBILL);
            slInfo.setIsDownLoad(false);
            coll.add(slInfo);
            String addNewType = billInfo.getIntReceiveType().getValue();
            if (addNewType.equals("2") && (redepobill = CompDepositAccountBillFactory.getLocalInstance(ctx).getCompDepositAccountBillInfo((IObjectPK)new ObjectUuidPK(billInfo.getSourceBillId()))).isIsAccrualToDepositAmt()) {
                coll.remove(slInfo);
            }
        }
        return coll;
    }

    private CompIntReceivedBillInfo getCompDepositAccountBill(Context ctx, String CompIntReceivedBillInfoId) throws BOSException, EASBizException {
        SelectorItemCollection sicEndorse = new SelectorItemCollection();
        sicEndorse.add("*");
        sicEndorse.add("innerAccount.*");
        sicEndorse.add("innerAccount.company.*");
        sicEndorse.add("innerAccount.applyUnit.*");
        sicEndorse.add("timeDepositBillID.*");
        CompIntReceivedBillInfo CompIntReceivedBillInfo2 = CompIntReceivedBillFactory.getLocalInstance(ctx).getCompIntReceivedBillInfo((IObjectPK)new ObjectUuidPK(CompIntReceivedBillInfoId), sicEndorse);
        return CompIntReceivedBillInfo2;
    }

    private static BigDecimal getExRate(Context ctx, BOSUuid currencyId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        BOSUuid companyId = currentCompany.getId();
        BOSUuid baseCurId = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(currentCompany).getId();
        return FinUtils.getCurrencyExRate(ctx, companyId, currencyId, baseCurId, DateUtil.getDayBegin());
    }
}

