/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IntReceivedBillTypeEnum;
import com.kingdee.eas.fm.common.IvtModualUtils;
import com.kingdee.eas.fm.fin.CompDepositAccountBillInfo;
import com.kingdee.eas.fm.fin.CompDepositBillStatusEnum;
import com.kingdee.eas.fm.fin.CompIntReceivedBillCollection;
import com.kingdee.eas.fm.fin.CompIntReceivedBillFactory;
import com.kingdee.eas.fm.fin.CompIntReceivedBillInfo;
import com.kingdee.eas.fm.fin.CompUnTimeDepositBillFactory;
import com.kingdee.eas.fm.fin.CompUnTimeDepositBillInfo;
import com.kingdee.eas.fm.fin.TDException;
import com.kingdee.eas.fm.fin.app.AbstractCompUnTimeDepositBillControllerBean;
import com.kingdee.eas.fm.fin.app.CompUnTimeDepositBillSubsidiaryBookProvider;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.fm.td.UnTimeDepositApplyBillFactory;
import com.kingdee.eas.fm.td.UnTimeDepositApplyBillInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CompUnTimeDepositBillControllerBean
extends AbstractCompUnTimeDepositBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.CompUnTimeDepositBillControllerBean");

    @Override
    protected Map _getMaxUnDepositSeqAndAccumalateAmt(Context ctx, IObjectPK timeDepositBillID) throws BOSException {
        int maxUnDepositSeq = 0;
        BigDecimal accumulativeuntimedepostamt = null;
        HashMap<String, Number> returnValue = new HashMap<String, Number>();
        String sql = "select max(funtimedepositseqno),max(faccumulativeuntimedepostamt) from t_fin_untimedepositbill where ftimedepositbillid=? ";
        Connection cn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            cn = this.getConnection(ctx);
            pstmt = cn.prepareStatement(sql);
            pstmt.setString(1, timeDepositBillID.toString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                maxUnDepositSeq = rs.getInt(1);
                accumulativeuntimedepostamt = rs.getBigDecimal(2);
            }
            if (accumulativeuntimedepostamt == null) {
                accumulativeuntimedepostamt = Constants.ZERO;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
        returnValue.clear();
        returnValue.put("UNDEPOSIT_MAX_SEQ", new Integer(maxUnDepositSeq));
        returnValue.put("UNDEPOSIT_ACCUMULATE_AMT", accumulativeuntimedepostamt);
        return returnValue;
    }

    @Override
    protected java.util.Date _getMaxUnDepositDateByTiemDeposit(Context ctx, String timeDepositBillID) throws BOSException {
        java.util.Date returnDate = null;
        String sql = "select max(fbizdate) from t_fin_untimedepositbill where ftimedepositbillid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{timeDepositBillID});
        try {
            Date sqlDate;
            if (rs.next() && (sqlDate = rs.getDate(1)) != null) {
                returnDate = DateTimeUtils.truncateDate((java.util.Date)new java.util.Date(sqlDate.getTime()));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return returnDate;
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            CompUnTimeDepositBillInfo info = (CompUnTimeDepositBillInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setAccountant(null);
                info.setFiVouchered(false);
            } else {
                info.setAccountant(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                info.setFiVouchered(true);
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CompUnTimeDepositBillInfo info = (CompUnTimeDepositBillInfo)model;
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)info, (AbstractCoreBaseControllerBean)this);
        this.checkNumberDup(ctx, (IObjectValue)info);
        return super._addnew(ctx, (IObjectValue)info);
    }

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CompUnTimeDepositBillInfo info = (CompUnTimeDepositBillInfo)model;
        this.submitCheck(ctx, info);
        IObjectPK pkReturn = super._submit(ctx, (IObjectValue)info);
        this.doSubmit(ctx, info, pkReturn);
        boolean isSubmitIsAccepted = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("FIN017", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (!isSubmitIsAccepted) {
            info.setStatus(CompDepositBillStatusEnum.SUBMIT);
            this._update(ctx, pkReturn, (IObjectValue)info);
        } else {
            this.doAccepted(ctx, info, pkReturn);
        }
        return pkReturn;
    }

    private void doSubmit(Context ctx, CompUnTimeDepositBillInfo info, IObjectPK pkReturn) throws BOSException, EASBizException {
        this.updateLastDateOfUnde(ctx, info);
        this.saveBOTPRelations(ctx, pkReturn, info);
        this.deductRemamt(ctx, info.getUnDepositAmt(), info.getTimeDepositBill().getId().toString());
        this.updateStatusToTimedePosit(ctx, info, 1);
        String sourceBillId = info.getSourceBillId();
        if (sourceBillId != null && new UnTimeDepositApplyBillInfo().getBOSType().equals((Object)BOSUuid.read((String)sourceBillId).getType())) {
            HashMap<String, String> botpRelationShip = new HashMap<String, String>();
            botpRelationShip.clear();
            botpRelationShip.put(sourceBillId, pkReturn.toString());
            FMHelper.saveBOTRelation((Context)ctx, botpRelationShip);
            UnTimeDepositApplyBillInfo unTimeDepositApplyBillInfo = UnTimeDepositApplyBillFactory.getLocalInstance((Context)ctx).getUnTimeDepositApplyBillInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
            unTimeDepositApplyBillInfo.setIsCreCmpUnTmDep(true);
            UnTimeDepositApplyBillFactory.getLocalInstance((Context)ctx).update(pkReturn, (CoreBaseInfo)unTimeDepositApplyBillInfo);
        }
    }

    private void doBook(Context ctx, CompUnTimeDepositBillInfo info) throws EASBizException, BOSException {
        if (!info.isIsBooked()) {
            this.recAccount(ctx, info);
        }
    }

    private void submitCheck(Context ctx, CompUnTimeDepositBillInfo info) throws BOSException, EASBizException {
        this.checkUnDepositSeq(ctx, info);
        this.checkDepositBalance(ctx, info);
        this.checkUnDepositUnTimeDate(ctx, info);
    }

    private void checkUnDepositUnTimeDate(Context ctx, CompUnTimeDepositBillInfo info) throws BOSException, EASBizException {
        String sql = "select max(FUntimeDate) FUntimeDate from T_FIN_UnTimeDepositBill where FTimeDepositBillID = ?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{info.getTimeDepositBill().getId().toString()});
            if (rs.next() && rs.getDate("FUntimeDate") != null) {
                Date unTimeDate = rs.getDate("FUntimeDate");
                if (info.getUntimeDate().before(unTimeDate)) {
                    throw new TDException(TDException.UNTIMEDATE_ERROR);
                }
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkDepositBalance(Context ctx, CompUnTimeDepositBillInfo info) throws BOSException, EASBizException {
        String sql = "select FBalance from T_FIN_CompDepositAccountBill where fid = ?";
        try {
            BigDecimal balance;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{info.getTimeDepositBill().getId().toString()});
            if (rs.next() && (balance = rs.getBigDecimal(1)) != null && balance.compareTo(Constants.ZERO) == 0) {
                throw new TDException(TDException.NOT_UNDEPOSIT_REASON2);
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkUnDepositSeq(Context ctx, CompUnTimeDepositBillInfo info) throws BOSException, EASBizException {
        String sql = "select fid from T_FIN_UnTimeDepositBill where FTimeDepositBillID = ? and FUnTimeDepositSeqNo = ?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{info.getTimeDepositBill().getId().toString(), new Integer(info.getUnTimeDepositSeqNo())});
            if (rs.next()) {
                throw new TDException(TDException.UNDEPSOITSEQ_ERROR, new Object[]{new Integer(info.getUnTimeDepositSeqNo())});
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void updateLastDateOfUnde(Context ctx, CompUnTimeDepositBillInfo info) throws BOSException {
        String sql = "update t_fin_untimedepositbill set FLastUnDepositDate= ( select FLastUnDepositDate from t_fin_CompdepositAccountbill where fid = ?) where fid =? ".intern();
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getTimeDepositBill().getId().toString(), info.getId().toString()});
    }

    private void saveBOTPRelations(Context ctx, IObjectPK pkReturn, CompUnTimeDepositBillInfo CompUnTimeDepositBillInfo2) throws BOSException {
        HashMap<String, String> botpRelationShip = new HashMap<String, String>();
        botpRelationShip.clear();
        botpRelationShip.put(CompUnTimeDepositBillInfo2.getTimeDepositBill().getId().toString(), pkReturn.toString());
        FMHelper.saveBOTRelation((Context)ctx, botpRelationShip);
    }

    private void deductRemamt(Context ctx, BigDecimal unDepositAmt, String timeBillid) throws BOSException {
        String sql = "update t_fin_CompdepositAccountbill set FBalance = FBalance -  ?  where fid = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{unDepositAmt, timeBillid});
    }

    private void updateStatusToTimedePosit(Context ctx, CompUnTimeDepositBillInfo CompUnTimeDepositBillInfo2, int type) throws BOSException {
        String id = CompUnTimeDepositBillInfo2.getTimeDepositBill().getId().toString();
        java.util.Date lastUnDepositDate = null;
        Date dateParam = null;
        lastUnDepositDate = type == 1 ? CompUnTimeDepositBillInfo2.getUntimeDate() : CompUnTimeDepositBillInfo2.getLastUnDepositDate();
        if ((lastUnDepositDate = DateTimeUtils.truncateDate((java.util.Date)lastUnDepositDate)) != null) {
            dateParam = new Date(lastUnDepositDate.getTime());
        }
        if (dateParam == null) {
            String sql = "update t_fin_CompdepositAccountbill set fisundeposit = 0 where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{id});
            if (CompUnTimeDepositBillInfo2.isIsCalInt()) {
                String string = " update  t_fin_CompdepositAccountbill set FLastUnDepositDate = ? where fid = ? ";
            }
        } else {
            String sql = "update t_fin_CompdepositAccountbill set fisundeposit = 1 where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{id});
            if (CompUnTimeDepositBillInfo2.isIsCalInt()) {
                String string = " update  t_fin_CompdepositAccountbill set FLastUnDepositDate = ? where fid = ? ";
            }
        }
    }

    private void recAccount(Context ctx, CompUnTimeDepositBillInfo CompUnTimeDepositBillInfo2) throws EASBizException, BOSException {
        try {
            SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).book(CompUnTimeDepositBillInfo2.getId().toString(), CompUnTimeDepositBillSubsidiaryBookProvider.class.getName());
            String updateChequeSql = "update t_fin_untimedepositbill SET Fisbooked=1 where fid=?";
            DbUtil.execute((Context)ctx, (String)updateChequeSql, (Object[])new Object[]{CompUnTimeDepositBillInfo2.getId().toString()});
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (e.getCause() != null) {
                msg = e.getCause().getMessage();
            }
            throw new FMException(FMException.NOTBOOK, new Object[]{msg, CompUnTimeDepositBillInfo2.getNumber()});
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        CompUnTimeDepositBillInfo billInfo = this.getCompUnTimeDepositBillInfo(ctx, pk);
        String sourceBill = billInfo.getTimeDepositBill().getId().toString();
        if (!billInfo.isIsHis()) {
            this.deleteRalatedIntBill(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()));
            this.deductRemamt(ctx, billInfo.getUnDepositAmt().negate(), sourceBill);
            this.antiBook(ctx, pk);
        }
        this.deleteBOTRelations(ctx, billInfo);
        this.updateLastDateOfUnde(ctx, billInfo);
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)billInfo, (String)billInfo.getCompany().getId().toString());
        String sourceBillId = billInfo.getSourceBillId();
        if (sourceBillId != null && new UnTimeDepositApplyBillInfo().getBOSType().equals((Object)BOSUuid.read((String)sourceBillId).getType())) {
            UnTimeDepositApplyBillInfo unTimeDepositApplyBillInfo = UnTimeDepositApplyBillFactory.getLocalInstance((Context)ctx).getUnTimeDepositApplyBillInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
            unTimeDepositApplyBillInfo.setIsCreCmpUnTmDep(false);
            UnTimeDepositApplyBillFactory.getLocalInstance((Context)ctx).update(pk, (CoreBaseInfo)unTimeDepositApplyBillInfo);
        }
        super._delete(ctx, pk);
        this.updateStatusToTimedePosit(ctx, billInfo, 0);
    }

    private void deleteBOTRelations(Context ctx, CompUnTimeDepositBillInfo billInfo) throws BOSException, BTPException {
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (!iBTPManager.ifHaveDestBills(billInfo.getTimeDepositBill().getId().toString())) {
            try {
                CompDepositAccountBillInfo info = new CompDepositAccountBillInfo();
                info.setId(billInfo.getTimeDepositBill().getId());
                iBTPManager.removeAllSRCRelation((CoreBillBaseInfo)billInfo);
            }
            catch (BTPException ex) {
                throw new BTPException(BTPException.RELATIONDELETEERROR);
            }
        }
    }

    private void deleteRalatedIntBill(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        CompIntReceivedBillFactory.getLocalInstance(ctx).deleteRelated(pk);
    }

    private void antiBook(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).cancelBook(pk.toString());
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        DAPTransformResult dAPTransformResult = super._generateVoucher(ctx, sourceBillCollection, botMappingPK);
        if (IvtModualUtils.getSysParam((Context)ctx, (String)"FIN010")) {
            for (int i = 0; i < sourceBillCollection.size(); ++i) {
                ObjectUuidPK srcBillPK = new ObjectUuidPK(AccessHelper.getId((Object)sourceBillCollection.getObject(i)));
                CompIntReceivedBillInfo intRe = this.findIntReceivedBillInfo(ctx, (IObjectPK)srcBillPK);
                if (intRe == null || intRe.isFivouchered() || intRe.getCreInterest().compareTo(Constants.ZERO) == 0 && intRe.getDeInterest().compareTo(Constants.ZERO) == 0) continue;
                if (intRe.getIntReceiveType() != IntReceivedBillTypeEnum.PRE_DRAWING && intRe.getEffectedStatus() != CompDepositBillStatusEnum.ACCEPTED) {
                    throw new TDException(TDException.EXCEPTION75);
                }
                if (intRe.getIntReceiveType() == IntReceivedBillTypeEnum.PRE_DRAWING && intRe.getEffectedStatus() != CompDepositBillStatusEnum.SUBMIT) {
                    throw new TDException(TDException.EXCEPTION76);
                }
                CompIntReceivedBillFactory.getLocalInstance(ctx).generateVoucher((IObjectPK)new ObjectUuidPK(intRe.getId().toString()));
            }
        }
        return dAPTransformResult;
    }

    protected boolean _deleteVoucher(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        CompIntReceivedBillInfo intRe;
        if (IvtModualUtils.getSysParam((Context)ctx, (String)"FIN010") && (intRe = this.findIntReceivedBillInfo(ctx, sourceBillPk)) != null && intRe.isFivouchered()) {
            CompIntReceivedBillFactory.getLocalInstance(ctx).deleteVoucher((IObjectPK)new ObjectUuidPK(intRe.getId().toString()));
        }
        return super._deleteVoucher(ctx, sourceBillPk);
    }

    private CompIntReceivedBillInfo findIntReceivedBillInfo(Context ctx, IObjectPK srcBillPK) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("srcBillID", (Object)srcBillPK.toString()));
        evi.setFilter(f);
        CompIntReceivedBillCollection intCol = CompIntReceivedBillFactory.getLocalInstance(ctx).getCompIntReceivedBillCollection(evi);
        if (intCol != null && intCol.size() > 0) {
            return intCol.get(0);
        }
        return null;
    }

    private void doAccepted(Context ctx, CompUnTimeDepositBillInfo info, IObjectPK pk) throws EASBizException, BOSException {
        java.util.Date settleDate;
        CompanyOrgUnitInfo org = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        java.util.Date acceptedDate = settleDate = BankFactory.getLocalInstance((Context)ctx).getClearingHouse(org.getId().toString()).getSettleDate();
        if (!FMHelper.isEmpty((Object)info.getBizDate())) {
            acceptedDate = info.getBizDate().after(settleDate) ? info.getBizDate() : settleDate;
        }
        info.setAcceptedDate(acceptedDate);
        info.setAcceptor(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        info.setStatus(CompDepositBillStatusEnum.ACCEPTED);
        this._update(ctx, pk, (IObjectValue)info);
        this.doBook(ctx, info);
    }

    @Override
    protected void _accepted(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CompUnTimeDepositBillInfo info = CompUnTimeDepositBillFactory.getLocalInstance(ctx).getCompUnTimeDepositBillInfo(pk);
        this.doAccepted(ctx, info, pk);
        this.intRecAccepted(ctx, info);
    }

    @Override
    protected void _antiAccepted(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CompUnTimeDepositBillInfo info = CompUnTimeDepositBillFactory.getLocalInstance(ctx).getCompUnTimeDepositBillInfo(pk);
        info.setAcceptedDate(null);
        info.setAcceptor(null);
        info.setStatus(CompDepositBillStatusEnum.SUBMIT);
        info.setIsBooked(false);
        this._update(ctx, pk, (IObjectValue)info);
        SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).cancelBook(pk.toString());
        this.antiIntRecAccepted(ctx, info);
    }

    private void antiIntRecAccepted(Context ctx, CompUnTimeDepositBillInfo info) throws BOSException, EASBizException {
        Set downBillSet = FMHelper.getDestBillIdSet((Context)ctx, (String)info.getId().toString());
        if (!FMHelper.isEmpty((Collection)downBillSet)) {
            for (String downId : downBillSet) {
                if (FMHelper.isEmpty((String)downId) || !FMHelper.isInstanceof((String)downId, CompIntReceivedBillInfo.class)) continue;
                CompIntReceivedBillFactory.getLocalInstance(ctx).antiAccepted((IObjectPK)new ObjectStringPK(downId));
            }
        }
    }

    private void intRecAccepted(Context ctx, CompUnTimeDepositBillInfo info) throws BOSException, EASBizException {
        Set downBillSet = FMHelper.getDestBillIdSet((Context)ctx, (String)info.getId().toString());
        if (!FMHelper.isEmpty((Collection)downBillSet)) {
            for (String downId : downBillSet) {
                if (FMHelper.isEmpty((String)downId) || !FMHelper.isInstanceof((String)downId, CompIntReceivedBillInfo.class)) continue;
                CompIntReceivedBillFactory.getLocalInstance(ctx).accepted((IObjectPK)new ObjectStringPK(downId));
            }
        }
    }
}

