/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fin.CompUnTimeDepositBillFactory;
import com.kingdee.eas.fm.fin.CompUnTimeDepositBillInfo;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.ISubsidiaryBookProvider;
import com.kingdee.eas.fm.fs.SubsidiaryBillTypeEnum;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Date;

public class CompUnTimeDepositBillSubsidiaryBookProvider
implements ISubsidiaryBookProvider {
    public SubsidiaryLedgerCollection getCollection(Context ctx, String billId) throws BOSException, EASBizException {
        CompUnTimeDepositBillInfo billInfo = this.getCompUnTimeDepositBillInfo(ctx, billId);
        BigDecimal creditAmt = billInfo.getUnDepositAmt();
        SubsidiaryLedgerInfo DepslInfo = new SubsidiaryLedgerInfo();
        SubsidiaryLedgerInfo CurslInfo = new SubsidiaryLedgerInfo();
        DepslInfo.setApplyUnit(billInfo.getDepCompany());
        DepslInfo.setCompany(billInfo.getCompany());
        DepslInfo.setInnerAccount(billInfo.getCorpDepAcct());
        DepslInfo.setCurrency(billInfo.getCurrency());
        DepslInfo.setBillId(billInfo.getId());
        DepslInfo.setBillNumber(billInfo.getNumber());
        BankInfo clearingHouse = FSHelper.getClearingHouseInfo((Context)ctx, (String)billInfo.getCompany().getId().toString());
        if (!clearingHouse.isUsed()) {
            throw new FSException(FSException.CLEARINGHOUSENOTUSED);
        }
        Date bizDate = new Date();
        bizDate = billInfo.getBizDate().after(clearingHouse.getSettleDate()) ? DateTimeUtils.truncateDate((Date)billInfo.getBizDate()) : DateTimeUtils.truncateDate((Date)clearingHouse.getSettleDate());
        DepslInfo.setDate(bizDate);
        DepslInfo.setCpCurrency(billInfo.getCurrency());
        DepslInfo.setCreditAmount(creditAmt);
        CurslInfo.setDebitAmount(Constants.ZERO);
        DepslInfo.setExchangeRate(CompUnTimeDepositBillSubsidiaryBookProvider.getExRate(ctx, billInfo.getCurrency().getId()));
        DepslInfo.setBizType(SubsidiaryBillTypeEnum.COMPUNTIMEDEPOSITBILL);
        DepslInfo.setBookkeeper(billInfo.getCreator());
        DepslInfo.setIsDownLoad(false);
        CurslInfo.setApplyUnit(billInfo.getDepCompany());
        CurslInfo.setCompany(billInfo.getCompany());
        CurslInfo.setInnerAccount(billInfo.getCorpCurAcct());
        CurslInfo.setCurrency(billInfo.getCurrency());
        CurslInfo.setBillId(billInfo.getId());
        CurslInfo.setBillNumber(billInfo.getNumber());
        CurslInfo.setDate(billInfo.getBizDate());
        CurslInfo.setCpCurrency(billInfo.getCurrency());
        CurslInfo.setDebitAmount(creditAmt);
        CurslInfo.setCreditAmount(Constants.ZERO);
        CurslInfo.setExchangeRate(CompUnTimeDepositBillSubsidiaryBookProvider.getExRate(ctx, billInfo.getCurrency().getId()));
        CurslInfo.setBizType(SubsidiaryBillTypeEnum.COMPUNTIMEDEPOSITBILL);
        CurslInfo.setBookkeeper(billInfo.getCreator());
        CurslInfo.setIsDownLoad(false);
        SubsidiaryLedgerCollection coll = new SubsidiaryLedgerCollection();
        coll.add(DepslInfo);
        if (billInfo.getCorpCurAcct() != null) {
            coll.add(CurslInfo);
        }
        return coll;
    }

    private CompUnTimeDepositBillInfo getCompUnTimeDepositBillInfo(Context ctx, String CompUnTimeDepositBillInfoId) throws BOSException, EASBizException {
        SelectorItemCollection sicEndorse = new SelectorItemCollection();
        sicEndorse.add("*");
        sicEndorse.add("innerAccount.*");
        sicEndorse.add("innerAccount.company.*");
        sicEndorse.add("innerAccount.applyUnit.*");
        CompUnTimeDepositBillInfo CompUnTimeDepositBillInfo2 = CompUnTimeDepositBillFactory.getLocalInstance(ctx).getCompUnTimeDepositBillInfo((IObjectPK)new ObjectUuidPK(CompUnTimeDepositBillInfoId), sicEndorse);
        return CompUnTimeDepositBillInfo2;
    }

    private static BigDecimal getExRate(Context ctx, BOSUuid currencyId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        BOSUuid companyId = currentCompany.getId();
        BOSUuid baseCurId = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(currentCompany).getId();
        return FinUtils.getCurrencyExRate(ctx, companyId, currencyId, baseCurId, DateUtil.getDayBegin());
    }
}

