/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.BillStateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.fin.ApplyResultEnum;
import com.kingdee.eas.fm.fin.CreditApplyBillFactory;
import com.kingdee.eas.fm.fin.CreditApplyBillInfo;
import com.kingdee.eas.fm.fin.app.AbstractCreditApplyBillControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import org.apache.log4j.Logger;

public class CreditApplyBillControllerBean
extends AbstractCreditApplyBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.CreditApplyBillControllerBean");

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CreditApplyBillInfo info = this.getCreditApplyBillInfo(ctx, pk);
        super._delete(ctx, pk);
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue objectValue) throws EASBizException, BOSException {
        CreditApplyBillInfo billInfo = (CreditApplyBillInfo)objectValue;
        billInfo.setBillState(BillStateEnum.SUBMITTED);
        super._submit(ctx, pk, (IObjectValue)billInfo);
        this.checkNumberDup(ctx, (IObjectValue)billInfo);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue objectValue) throws BOSException, EASBizException {
        CreditApplyBillInfo billInfo = (CreditApplyBillInfo)objectValue;
        billInfo.setBillState(BillStateEnum.SUBMITTED);
        IObjectPK pk = super._submit(ctx, (IObjectValue)billInfo);
        this.checkNumberDup(ctx, (IObjectValue)billInfo);
        return pk;
    }

    @Override
    protected boolean _antiAudit(Context ctx, String billID) {
        if (billID == null) {
            logger.error((Object)"CreditApplyBillControllerBean/billID is null");
            return false;
        }
        try {
            CreditApplyBillInfo info = new CreditApplyBillInfo();
            info.setId(BOSUuid.read((String)billID));
            info.setBillState(BillStateEnum.SAVED);
            info.setAuditor(null);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("billState"));
            sic.add(new SelectorItemInfo("AUDITOR"));
            CreditApplyBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
            return true;
        }
        catch (EASBizException e) {
            logger.error((Object)("CreditApplyBillControllerBean/billID:" + billID));
            logger.error((Object)e.getMessage(), e.getCause());
            return false;
        }
        catch (BOSException e) {
            logger.error((Object)("CreditApplyBillControllerBean/billID:" + billID));
            logger.error((Object)e.getMessage(), e.getCause());
            return false;
        }
    }

    @Override
    protected boolean _audit(Context ctx, String billID) {
        if (billID == null) {
            logger.error((Object)"CreditApplyBillControllerBean/billID is null");
            return false;
        }
        try {
            CreditApplyBillInfo info = new CreditApplyBillInfo();
            info.setId(BOSUuid.read((String)billID));
            info.setBillState(BillStateEnum.AUDITED);
            if (ctx.getCaller() != null) {
                UserInfo auditUser = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
                info.setAuditor(auditUser);
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("billState"));
            sic.add(new SelectorItemInfo("AUDITOR"));
            CreditApplyBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
            return true;
        }
        catch (EASBizException e) {
            logger.error((Object)("CreditApplyBillControllerBean/billID:" + billID));
            logger.error((Object)e.getMessage(), e.getCause());
            return false;
        }
        catch (BOSException e) {
            logger.error((Object)("CreditApplyBillControllerBean/billID:" + billID));
            logger.error((Object)e.getMessage(), e.getCause());
            return false;
        }
    }

    @Override
    protected void _applyResult(Context ctx, Set idSet, ApplyResultEnum newValue) throws BOSException, EASBizException {
        String sql = "update t_fin_creditapplybill set FApplyResult = ? where fid = ?";
        Connection con = this.getConnection(ctx);
        int newReuslt = newValue.getValue();
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
            ps.clearBatch();
            String[] ids = idSet.toArray(new String[idSet.size()]);
            for (int i = 0; i < ids.length; ++i) {
                ps.setInt(1, newReuslt);
                ps.setString(2, ids[i]);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException exc) {
            logger.error((Object)("sql is:" + sql), (Throwable)exc);
            throw new BOSException("Sql3 execute exception : " + sql, (Throwable)exc);
        }
        finally {
            SQLUtils.cleanup(null, (Statement)ps, (Connection)con);
        }
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        CreditApplyBillInfo info = this.getCreditApplyBillInfo(ctx, srcBillPK);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isCreateToLimit"));
        if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
            info.setIsCreateToLimit(false);
        } else if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
            info.setIsCreateToLimit(true);
        }
        this.updatePartial(ctx, (CoreBaseInfo)info, sic);
    }

    private void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CreditApplyBillInfo billInfo = (CreditApplyBillInfo)model;
        IObjectPK pk = super._save(ctx, model);
        this.checkNumberDup(ctx, (IObjectValue)billInfo);
        return pk;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CreditApplyBillInfo billInfo = (CreditApplyBillInfo)model;
        if (FMHelper.isEmpty((String)billInfo.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)billInfo, (String)billInfo.getCompany().getId().toString());
            billInfo.setNumber(numberSilent);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)billInfo, (String)"number");
        this.checkNumberDup(ctx, (IObjectValue)billInfo);
        return super._addnew(ctx, model);
    }

    @Override
    protected void _audit4WF(Context ctx, String billID) throws BOSException {
        if (billID == null) {
            logger.error((Object)"CreditApplyBillControllerBean/billID is null");
            return;
        }
        try {
            CreditApplyBillInfo info = new CreditApplyBillInfo();
            info.setId(BOSUuid.read((String)billID));
            info.setBillState(BillStateEnum.AUDITED);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("billState"));
            CreditApplyBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
            return;
        }
        catch (EASBizException e) {
            logger.error((Object)("CreditApplyBillControllerBean/billID:" + billID));
            logger.error((Object)e.getMessage(), e.getCause());
        }
        catch (BOSException e) {
            logger.error((Object)("CreditApplyBillControllerBean/billID:" + billID));
            logger.error((Object)e.getMessage(), e.getCause());
        }
    }
}

