/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.ctl.AssureBillFactory;
import com.kingdee.eas.fm.ctl.AssureBillInfo;
import com.kingdee.eas.fm.fin.ControlWayEnum;
import com.kingdee.eas.fm.fin.CreditApplyBillFactory;
import com.kingdee.eas.fm.fin.CreditApplyBillInfo;
import com.kingdee.eas.fm.fin.CreditFinancingReduceCollection;
import com.kingdee.eas.fm.fin.CreditFinancingReduceFactory;
import com.kingdee.eas.fm.fin.CreditFinancingReduceInfo;
import com.kingdee.eas.fm.fin.CreditLimitBillStatusEnum;
import com.kingdee.eas.fm.fin.CreditLimitCollection;
import com.kingdee.eas.fm.fin.CreditLimitEntryCollection;
import com.kingdee.eas.fm.fin.CreditLimitEntryInfo;
import com.kingdee.eas.fm.fin.CreditLimitFactory;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.CreditLimitUsedCollection;
import com.kingdee.eas.fm.fin.CreditLimitUsedFactory;
import com.kingdee.eas.fm.fin.CreditLimitUsedInfo;
import com.kingdee.eas.fm.fin.CreditlimitGTEntryCollection;
import com.kingdee.eas.fm.fin.CreditlimitGTEntryInfo;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.GuaranteeTypePropertyEnum;
import com.kingdee.eas.fm.fin.ICreditFinancingReduce;
import com.kingdee.eas.fm.fin.LimitPropertyEnum;
import com.kingdee.eas.fm.fin.RevokeStatusEnum;
import com.kingdee.eas.fm.fin.ShareTypeEnum;
import com.kingdee.eas.fm.fin.TimeDepositHelper;
import com.kingdee.eas.fm.fin.WageFactory;
import com.kingdee.eas.fm.fin.WageInfo;
import com.kingdee.eas.fm.fin.app.AbstractCreditLimitControllerBean;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.ntp.NTPException;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class CreditLimitControllerBean
extends AbstractCreditLimitControllerBean {
    private static String assureBillBosType = new AssureBillInfo().getBOSType().toString();
    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final String NTP_RESOURCE = "com.kingdee.eas.fm.ntp.NtpResource";
    private static String WageBillBosType = new WageInfo().getBOSType().toString();
    private static String CreditLimitBosType = new CreditLimitInfo().getBOSType().toString();
    private static String ReceivableBillBosType = new ReceivableBillInfo().getBOSType().toString();
    private static String CreditApplyBillBosType = new CreditApplyBillInfo().getBOSType().toString();
    private Map botpRelationShip = new HashMap();
    private static Integer one = new Integer(1);
    private static Integer zero = new Integer(1);

    @Override
    protected void _close(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CreditLimitInfo info = (CreditLimitInfo)CreditLimitFactory.getLocalInstance(ctx).getValue(pk);
        if (info.isIsClosed()) {
            throw new FinBizException(FinBizException.CREDITLIMITHASCLOSED);
        }
        if (info.getExpiredDate().before(DateTimeUtils.truncateDate((Date)new Date()))) {
            info.setIsOverdue(true);
        }
        info.setIsClosed(true);
        CreditLimitFactory.getLocalInstance(ctx).update(pk, (CoreBaseInfo)info);
    }

    @Override
    protected void _anticlose(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CreditLimitInfo info = (CreditLimitInfo)CreditLimitFactory.getLocalInstance(ctx).getValue(pk);
        if (!info.isIsClosedByHand()) {
            if (!info.isIsClosed()) {
                throw new FinBizException(FinBizException.CREDITLIMITHASNOCLOSED);
            }
            if (this.checkeIsUsedUnion(ctx, pk.toString())) {
                throw new FinBizException(FinBizException.CREDITLIMITHASUNIONED);
            }
            info.setIsClosed(false);
            CreditLimitFactory.getLocalInstance(ctx).update(pk, (CoreBaseInfo)info);
        }
    }

    @Override
    protected void _checkOverdue(Context ctx) throws BOSException {
        String sql = "UPDATE T_FIN_CREDITLIMIT SET FIsOverdue = 1 where FExpiredDate < CURDATE()";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CreditLimitInfo info = (CreditLimitInfo)model;
        if (FMHelper.isEmpty((String)info.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        this._checkNumberDup(ctx, (IObjectValue)info);
        this.check_FIN012(ctx, info);
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        this.createWithCreditApplyBotpRelation(ctx, info);
        if (info.getSourceBillId() != null) {
            CreditApplyBillFactory.getLocalInstance(ctx).reverseSave((IObjectPK)new ObjectUuidPK(info.getSourceBillId()), null, BOTBillOperStateEnum.ADDNEW, null);
        }
        return pk;
    }

    private void createWithCreditApplyBotpRelation(Context ctx, CreditLimitInfo info) throws BOSException {
        if (info == null || info.getSourceBillId() == null) {
            return;
        }
        FinUtils.addBotRelation(ctx, info.getSourceBillId(), info.getId().toString());
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CreditLimitInfo info = (CreditLimitInfo)model;
        if (FMHelper.isEmpty((String)info.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        this._checkNumberDup(ctx, pk, (IObjectValue)info);
        this.check_FIN012(ctx, info);
        this.verifyGuaranteeWage(ctx, info);
        super._addnew(ctx, pk, (IObjectValue)info);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CreditLimitInfo newInfo = (CreditLimitInfo)model;
        this._deleteGTEntry(ctx, newInfo.getId().toString());
        this.verifyGuaranteeWage(ctx, newInfo);
        super._update(ctx, pk, model);
    }

    private void checkEntryFinProDuplicate(CreditLimitEntryCollection collection) throws FinBizException {
        String orgId = "";
        String finproID = "";
        CreditLimitEntryInfo tmp = null;
        HashSet<String> allDifferent = new HashSet<String>();
        int entryCount = collection.size();
        for (int i = 0; i < entryCount; ++i) {
            tmp = collection.get(i);
            orgId = tmp.getShareOrg() == null ? "nullValue" : tmp.getShareOrg().getId().toString();
            finproID = tmp.getFinPro() == null ? "nullValue" : tmp.getFinPro().getId().toString();
            allDifferent.add(orgId + finproID);
        }
        if (allDifferent.size() != entryCount) {
            throw new FinBizException(FinBizException.SOMEFINPRO);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CreditLimitInfo info = (CreditLimitInfo)model;
        info.setGuarantee("kingdee");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)model, (String)"CreditUsage");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)model, (String)"Currency");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)model, (String)"IssueDate");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)model, (String)"ExpiredDate");
        if (info.getProperty() == null) {
            info.setProperty(LimitPropertyEnum.REVOLVING_AMOUNT);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)model, (String)"Property");
        FMVerifyHelper.checkMustMoreThanZero((Context)ctx, (IObjectValue)model, (String)"QuotaAmount");
        FMVerifyHelper.checkMustMoreThanZero((Context)ctx, (IObjectValue)model, (String)"ExchangeRate");
        FMVerifyHelper.checkMustMoreThanZero((Context)ctx, (IObjectValue)model, (String)"CreditHorizon");
        Date issueDate = info.getIssueDate();
        Date expiredDate = info.getExpiredDate();
        if (!expiredDate.after(issueDate)) {
            throw new FinBizException(FinBizException.ENDDATEMUSTAFTERBEGINDATE);
        }
        this.verify(ctx, info);
        CreditLimitEntryCollection collection = info.getEntrys();
        BigDecimal bdTotalEntryShareAmount = new BigDecimal("0.00");
        int precision = FMHelper.getPrecOfCurrency((Context)ctx, (String)((CurrencyInfo)model.get("currency")).getId().toString());
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            CreditLimitEntryInfo entryInfo = collection.get(i);
            if (entryInfo.getShareOrg() == null) {
                throw new FinBizException(FinBizException.CREDITLIMITENTRYSHAREORGNOTEMPTY);
            }
            if (!info.getShareType().equals((Object)ShareTypeEnum.ASSIGN)) continue;
            entryInfo.setSharedAmount(entryInfo.getSharedAmount().setScale(precision, 4));
            bdTotalEntryShareAmount = bdTotalEntryShareAmount.add(entryInfo.getSharedAmount());
        }
        if (info.getShareType().equals((Object)ShareTypeEnum.ASSIGN) && bdTotalEntryShareAmount.compareTo(info.getQuotaAmount()) != 0) {
            throw new FinBizException(FinBizException.CREDITLIMITENTRYAMOUNTEQUALSHARE);
        }
        if (info.getShareType().equals((Object)ShareTypeEnum.PRIVATE) && !EmptyUtil.isEmpty((AbstractObjectCollection)info.getEntrys())) {
            info.getEntrys().get(0).setBanlance(info.getQuotaAmount());
            info.getEntrys().get(0).setSharedAmount(info.getQuotaAmount());
        }
        this.checkEntryFinProDuplicate(collection);
        IObjectPK pk = super._submit(ctx, model);
        this._checkNumberDup(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (IObjectValue)info);
        this.saveAssureBOTPRelationShip(ctx, info);
        return pk;
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CreditLimitInfo info = this.getCreditLimitInfo(ctx, pk);
        IBOTRelation botIntf = BOTRelationFactory.getLocalInstance((Context)ctx);
        botIntf.removeRelationByDestObjId(pk.toString(), CreditApplyBillBosType);
        super._delete(ctx, pk);
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
        if (info.getSourceBillId() != null) {
            CreditApplyBillFactory.getLocalInstance(ctx).reverseSave((IObjectPK)new ObjectUuidPK(info.getSourceBillId()), null, BOTBillOperStateEnum.DELETE, null);
        }
    }

    private boolean checkeUsedAddNew(Context ctx, String id) throws BOSException {
        String sql = " select *  from T_FIN_CreditLimitUsed where fIsUnionAddnew=0 and FCreditLimitId='" + id + "'";
        ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        boolean result = false;
        try {
            if (rs != null && rs.next()) {
                result = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private boolean checkeIsUsedUnion(Context ctx, String id) throws BOSException {
        String sql = " select *  from T_BOT_Relation where FDestEntityID='" + CreditLimitBosType + "' and FSrcObjectID='" + id + "'";
        ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        boolean result = false;
        try {
            if (rs != null && rs.next()) {
                result = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    protected static void addAssureBillBotp(Context ctx, String creditLimitId, String assureId) throws BOSException {
        FinUtils.addBotRelation(ctx, assureId, creditLimitId);
    }

    private CreditLimitCollection getCreditLimitCollection(Context ctx, Set ids) throws BOSException {
        String includeValue = this.parseValue(ids);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)includeValue, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return CreditLimitFactory.getLocalInstance(ctx).getCreditLimitCollection(evi);
    }

    private String parseValue(Set setIDs) {
        return TimeDepositHelper.getInstance().parseValue(setIDs);
    }

    protected static void removeAssureBotp(Context ctx, CreditLimitInfo newInfo) throws EASBizException, BOSException {
        IBOTRelation botIntf = BOTRelationFactory.getLocalInstance((Context)ctx);
        Connection conn = null;
        PreparedStatement ps = null;
        String sql = "delete T_BOT_Relation  where fsrcentityid='8167DC90' and fdestobjectid='J0U3vwESEADgAAGKwKgSE7V9UdA=' ";
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            int n = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected void verify(Context ctx, CreditLimitInfo info) throws BOSException, EASBizException {
        BigDecimal totalScale = new BigDecimal(String.valueOf(0));
        Iterator iter = info.getAssureBillEntry().iterator();
        while (iter.hasNext()) {
            CreditlimitGTEntryInfo element = (CreditlimitGTEntryInfo)iter.next();
            if (element.getScale() == null) continue;
            totalScale = totalScale.add(element.getScale());
        }
        if (!FMHelper.isEmpty((Object)info.getUsedAmount()) && info.getQuotaAmount().compareTo(info.getUsedAmount()) < 0) {
            throw new FinBizException(FinBizException.BATCN_OVERDUE_ERROR, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"2_CreditLimitControllerBean", (Locale)ctx.getLocale())});
        }
    }

    private void check_FIN012(Context ctx, CreditLimitInfo info) throws FinBizException {
        IContextHelper ctxHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        boolean mustCreateFromApply = ctxHelper.getBooleanParam("FIN012", (IObjectPK)new ObjectUuidPK(ctxHelper.getCurrentCompany().getId()));
        if (mustCreateFromApply) {
            if (info.getSourceBillId() == null) {
                throw new FinBizException(FinBizException.BATCN_OVERDUE_ERROR, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"3_CreditLimitControllerBean", (Locale)ctx.getLocale())});
            }
            BOSUuid uuid = BOSUuid.read((String)info.getSourceBillId());
            if (!uuid.getType().equals((Object)new CreditApplyBillInfo().getBOSType())) {
                throw new FinBizException(FinBizException.BATCN_OVERDUE_ERROR, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"3_CreditLimitControllerBean", (Locale)ctx.getLocale())});
            }
        }
    }

    @Override
    protected void _deleteRelated(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IBOTRelation botIntf = BOTRelationFactory.getLocalInstance((Context)ctx);
        botIntf.removeRelationByDestObjId(pk.toString(), assureBillBosType);
        botIntf.removeRelationByDestObjId(pk.toString(), ReceivableBillBosType);
        botIntf.removeRelationByDestObjId(pk.toString(), WageBillBosType);
    }

    @Override
    protected IObjectPK _addUnionBill(Context ctx, Set ids, IObjectValue info) throws BOSException, EASBizException {
        int i;
        IObjectPK pk = this.submit(ctx, (CoreBaseInfo)((CreditLimitInfo)info));
        CreditLimitInfo newData = this.getCreditLimitInfo(ctx, pk);
        CreditLimitEntryCollection entry = newData.getEntrys();
        CreditLimitEntryInfo newEntryInfo = null;
        int entrySize = entry.size();
        HashMap<String, CreditLimitEntryInfo> newInfoMap = new HashMap<String, CreditLimitEntryInfo>();
        String key = null;
        String orgID = null;
        String finPro = null;
        for (int i2 = 0; i2 < entrySize; ++i2) {
            newEntryInfo = entry.get(i2);
            orgID = newEntryInfo.getShareOrg() == null ? "null" : newEntryInfo.getShareOrg().getId().toString();
            finPro = newEntryInfo.getFinPro() == null ? "null" : newEntryInfo.getFinPro().getId().toString();
            key = orgID + "-" + finPro;
            newInfoMap.put(key, newEntryInfo);
        }
        HashMap<String, String> map2 = new HashMap<String, String>();
        CreditLimitInfo OldCreditLimitInfo = null;
        CreditLimitUsedInfo OldUsedInfo = null;
        CreditLimitCollection tdbc = this.getCreditLimitCollection(ctx, ids);
        CreditLimitUsedCollection UsedColl = this.getCreditLimitUsedCollection(ctx, ids);
        for (i = 0; i < tdbc.size(); ++i) {
            OldCreditLimitInfo = tdbc.get(i);
            CreditLimitEntryCollection collection = OldCreditLimitInfo.getEntrys();
            for (int j = 0; j < collection.size(); ++j) {
                CreditLimitEntryInfo entryInfo = collection.get(j);
                entryInfo.setBalanceBack(entryInfo.getBanlance());
                entryInfo.setBanlance(entryInfo.getSharedAmount());
                orgID = entryInfo.getShareOrg() == null ? "null" : entryInfo.getShareOrg().getId().toString();
                finPro = entryInfo.getFinPro() == null ? "null" : entryInfo.getFinPro().getId().toString();
                key = orgID + "-" + finPro;
                CreditLimitEntryInfo newEntryInfo2 = (CreditLimitEntryInfo)newInfoMap.get(key);
                if (entryInfo == null || newEntryInfo2 == null) continue;
                map2.put(entryInfo.getId().toString(), newEntryInfo2.getId().toString());
            }
            OldCreditLimitInfo.setBalanceBack(OldCreditLimitInfo.getBalance());
            OldCreditLimitInfo.setBalance(OldCreditLimitInfo.getQuotaAmount());
            OldCreditLimitInfo.setUsedAmount(Constants.ZERO);
            OldCreditLimitInfo.setIsClosed(true);
            this._submit(ctx, (IObjectValue)OldCreditLimitInfo);
            StringBuilder sb = new StringBuilder();
            sb.append("update t_fin_loan set fcreditlimitid='").append(pk.toString()).append("' where fcreditlimitid='").append(OldCreditLimitInfo.getId()).append("';");
            sb.append("update t_fin_letterofcredit set fcreditlimitid='").append(pk.toString()).append("' where fcreditlimitid='").append(OldCreditLimitInfo.getId()).append("';");
            sb.append("update t_ctl_LetterOfGuarantee set fcreditlimitid='").append(pk.toString()).append("' where fcreditlimitid='").append(OldCreditLimitInfo.getId()).append("';");
            sb.append("update T_NT_PayableBill set fcreditlimitid='").append(pk.toString()).append("' where fcreditlimitid='").append(OldCreditLimitInfo.getId()).append("';");
            sb.append("update T_FIN_REPAYMENT set fcreditlimitid='").append(pk.toString()).append("' where fcreditlimitid='").append(OldCreditLimitInfo.getId()).append("';");
            sb.append("update T_NT_AssureAmount set fcreditlimitid='").append(pk.toString()).append("' where fcreditlimitid='").append(OldCreditLimitInfo.getId()).append("';");
            this.executeBatchUpdate(ctx, sb.toString().split(";"));
            String sql = "update T_BOT_Relation set fsrcobjectid='" + pk.toString() + "' where fsrcobjectid='" + OldCreditLimitInfo.getId().toString() + "'";
            DbUtil.execute((Context)ctx, (String)sql);
            String delBtpRelaSql = "delete T_BOT_Relation where fsrcobjectid='" + OldCreditLimitInfo.getId().toString() + "'";
            DbUtil.execute((Context)ctx, (String)delBtpRelaSql);
            this.saveBOTPRelationShip(ctx, OldCreditLimitInfo, pk);
        }
        for (i = 0; i < UsedColl.size(); ++i) {
            OldUsedInfo = UsedColl.get(i);
            String sql = "update T_FIN_CreditLimitUsed set FIsUnioned=1 where FId='" + OldUsedInfo.getId() + "'";
            DbUtil.execute((Context)ctx, (String)sql);
            this.recordUsedInfo(ctx, OldUsedInfo.getUsedQuota(), OldUsedInfo.getBillId(), info, OldUsedInfo);
        }
        CreditFinancingReduceCollection redColl = this.getCreditFinancingReduceCollection(ctx, ids);
        CreditFinancingReduceInfo reduceInfo = null;
        CreditFinancingReduceInfo newReduceInfo = null;
        String newEntryId = null;
        CreditLimitEntryInfo limitEntryInfo = null;
        ICreditFinancingReduce icfr = CreditFinancingReduceFactory.getLocalInstance(ctx);
        StringBuffer returnSb = new StringBuffer();
        Object[] idsAr = ids.toArray();
        for (int i3 = 0; i3 < idsAr.length; ++i3) {
            if (i3 == idsAr.length - 1) {
                returnSb.append("'").append(idsAr[i3].toString()).append("'");
                continue;
            }
            returnSb.append("'").append(idsAr[i3].toString()).append("'").append(",");
        }
        String sqlUpdate = "update T_FIN_CreditFinancingReduce set FisUnion = 1 where FCreditLimitID in (" + returnSb.toString() + ")";
        DbUtil.execute((Context)ctx, (String)sqlUpdate);
        for (int i4 = 0; i4 < redColl.size(); ++i4) {
            reduceInfo = redColl.get(i4);
            newEntryId = (String)map2.get(reduceInfo.getCreditEntry().getId().toString());
            if (EmptyUtil.isEmpty((String)newEntryId)) continue;
            newReduceInfo = (CreditFinancingReduceInfo)reduceInfo.clone();
            newReduceInfo.setId(null);
            newReduceInfo.setCreditLimitID(BOSUuid.read((String)pk.toString()));
            limitEntryInfo = new CreditLimitEntryInfo();
            limitEntryInfo.setId(BOSUuid.read((String)newEntryId));
            newReduceInfo.setCreditEntry(limitEntryInfo);
            newReduceInfo.setIsUnion(false);
            icfr.submit(newReduceInfo);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("update t_fin_creditlimit set fcreditCloseDate = CURDATE() where fid in ").append(FMHelper.coll2String((Collection)ids));
        DbUtil.execute((Context)ctx, (String)sb.toString());
        return pk;
    }

    protected int[] executeBatchUpdate(Context ctx, String[] sqls) throws BOSException {
        int[] i2;
        Connection con = null;
        Statement ps = null;
        try {
            con = this.getConnection(ctx);
            ps = con.createStatement();
            int n = sqls.length;
            for (int i2 = 0; i2 < n; ++i2) {
                ps.addBatch(sqls[i2]);
            }
            i2 = ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                if (ps != null) {
                    e.setNextException(new SQLException("Execute batch update: " + ps));
                }
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
        return i2;
    }

    private void saveBOTPRelationShip(Context ctx, CreditLimitInfo OldCreditLimit, IObjectPK pk) throws BOSException {
        this.botpRelationShip.clear();
        this.botpRelationShip.put(OldCreditLimit.getId().toString(), pk.toString());
        FMHelper.saveBOTRelation((Context)ctx, (Map)this.botpRelationShip);
    }

    private void saveAssureBOTPRelationShip(Context ctx, CreditLimitInfo CreditLimit2) throws BOSException {
        CreditlimitGTEntryCollection collection = CreditLimit2.getAssureBillEntry();
        for (int j = 0; j < collection.size(); ++j) {
            CreditlimitGTEntryInfo entryInfo = collection.get(j);
            this.botpRelationShip.clear();
            if (entryInfo.getBillId() == null || RevokeStatusEnum.revoked.equals((Object)entryInfo.getRevokeStatus())) continue;
            this.botpRelationShip.put(entryInfo.getBillId().toString(), CreditLimit2.getId().toString());
            FMHelper.saveBOTRelation((Context)ctx, (Map)this.botpRelationShip);
        }
    }

    private void saveAssureBOTPRelationShip(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CreditLimitInfo CreditLimit2 = CreditLimitFactory.getLocalInstance(ctx).getCreditLimitInfo(pk);
        CreditlimitGTEntryCollection collection = CreditLimit2.getAssureBillEntry();
        for (int j = 0; j < collection.size(); ++j) {
            CreditlimitGTEntryInfo entryInfo = collection.get(j);
            this.botpRelationShip.clear();
            if (entryInfo.getBillId() == null || RevokeStatusEnum.revoked.equals((Object)entryInfo.getRevokeStatus())) continue;
            this.botpRelationShip.put(pk.toString(), entryInfo.getBillId().toString());
            FMHelper.saveBOTRelation((Context)ctx, (Map)this.botpRelationShip);
        }
    }

    private void resumeOldCreditLimit(Context ctx, IObjectPK pk, CreditLimitInfo info) throws BOSException, EASBizException {
        BOTRelationCollection OldCreditLimitBotpColl = this.getBotpExColl(ctx, pk);
        CreditLimitInfo OldCreditLimitInfo = null;
        BOTRelationInfo BOTRelationInfo2 = null;
        for (int i = 0; i < OldCreditLimitBotpColl.size(); ++i) {
            BOTRelationInfo2 = OldCreditLimitBotpColl.get(i);
            OldCreditLimitInfo = CreditLimitFactory.getLocalInstance(ctx).getCreditLimitInfo((IObjectPK)new ObjectUuidPK(BOTRelationInfo2.getSrcObjectID()));
            String sql1 = "update t_fin_loan set fcreditlimitid='" + OldCreditLimitInfo.getId().toString() + "' where fid in(select fbillid from  T_FIN_CreditLimitUsed where  fcreditlimitid='" + OldCreditLimitInfo.getId().toString() + "')";
            DbUtil.execute((Context)ctx, (String)sql1);
            String sql2 = "update t_fin_letterofcredit set fcreditlimitid='" + OldCreditLimitInfo.getId().toString() + "' where fid in(select fbillid from  T_FIN_CreditLimitUsed where  fcreditlimitid='" + OldCreditLimitInfo.getId().toString() + "')";
            DbUtil.execute((Context)ctx, (String)sql2);
            String sql3 = "update t_ctl_LetterOfGuarantee set fcreditlimitid='" + OldCreditLimitInfo.getId().toString() + "' where fid in(select fbillid from  T_FIN_CreditLimitUsed where  fcreditlimitid='" + OldCreditLimitInfo.getId().toString() + "')";
            DbUtil.execute((Context)ctx, (String)sql3);
            String sql4 = "update T_NT_PayableBill set fcreditlimitid='" + OldCreditLimitInfo.getId().toString() + "' where fid in(select fbillid from  T_FIN_CreditLimitUsed where  fcreditlimitid='" + OldCreditLimitInfo.getId().toString() + "')";
            DbUtil.execute((Context)ctx, (String)sql4);
            String sql6 = "update T_FIN_REPAYMENT set fcreditlimitid='" + OldCreditLimitInfo.getId().toString() + "' where fid in(select fbillid from  T_FIN_CreditLimitUsed where  fcreditlimitid='" + OldCreditLimitInfo.getId().toString() + "')";
            DbUtil.execute((Context)ctx, (String)sql6);
            String sql7 = "update T_NT_AssureAmount set fcreditlimitid='" + OldCreditLimitInfo.getId().toString() + "' where fid in(select fbillid from  T_FIN_CreditLimitUsed where  fcreditlimitid='" + OldCreditLimitInfo.getId().toString() + "')";
            DbUtil.execute((Context)ctx, (String)sql7);
            CreditLimitEntryCollection collection = OldCreditLimitInfo.getEntrys();
            for (int j = 0; j < collection.size(); ++j) {
                CreditLimitEntryInfo entryInfo = collection.get(j);
                entryInfo.setBanlance(entryInfo.getBalanceBack());
                String sql = "update T_FIN_CreditLimitEntry set FBanlance=FBalanceBack where FId='" + entryInfo.getId() + "'";
                DbUtil.execute((Context)ctx, (String)sql);
            }
            String sql = "update T_FIN_CreditLimit set FBalance=FBalanceBack , FUsedAmount=FQuotaAmount-FBalanceBack , FIsClosed=0 where FId='" + OldCreditLimitInfo.getId() + "'";
            DbUtil.execute((Context)ctx, (String)sql);
            CreditLimitUsedCollection UsedColl = this.getCreditLimitUsedCollection(ctx, OldCreditLimitInfo.getId().toString());
            CreditLimitUsedInfo OldUsedInfo = null;
            for (int j = 0; j < UsedColl.size(); ++j) {
                OldUsedInfo = UsedColl.get(j);
                try {
                    EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(OldUsedInfo.getBillId());
                    this.botpRelationShip.clear();
                    this.botpRelationShip.put(OldCreditLimitInfo.getId().toString(), OldUsedInfo.getBillId());
                    FMHelper.saveBOTRelation((Context)ctx, (Map)this.botpRelationShip);
                    String sql5 = "update T_FIN_CreditLimitUsed set FIsUnioned=0 where FId='" + OldUsedInfo.getId() + "'";
                    DbUtil.execute((Context)ctx, (String)sql5);
                    continue;
                }
                catch (Exception e) {
                    if (!(e instanceof ObjectNotFoundException)) continue;
                    String delUsedSql = "delete T_FIN_CreditLimitUsed where FId='" + OldUsedInfo.getId() + "'";
                    DbUtil.execute((Context)ctx, (String)delUsedSql);
                }
            }
            String sqlUpdate = "update T_FIN_CreditFinancingReduce set FisUnion = 0 where FCreditLimitID=?";
            DbUtil.execute((Context)ctx, (String)sqlUpdate, (Object[])new Object[]{OldCreditLimitInfo.getId().toString()});
        }
    }

    private BOTRelationCollection getBotpExColl(Context ctx, IObjectPK pk) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("destobjectid", (Object)pk.toString()));
        filter.getFilterItems().add(new FilterItemInfo("srcentityid", (Object)CreditLimitBosType));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(evi);
    }

    @Override
    protected void _deleteUnionBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String strsql = "select FSrcObjectID from T_BOT_Relation where FDestEntityID='B57D51D0' and FSrcEntityID='B57D51D0' and  FDestObjectID = '" + String.valueOf(pk) + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strsql);
        try {
            while (rs.next()) {
                String FSrcObjectID = rs.getString("FSrcObjectID").toString();
                CreditLimitInfo info = this.getCreditLimitInfo(ctx, (IObjectPK)new ObjectStringPK(FSrcObjectID));
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(info.getExpiredDate());
                calendar.set(5, calendar.get(5) + 1);
                info.setCreditCloseDate(calendar.getTime());
                info.setDeferDay(1);
                this.submit(ctx, (CoreBaseInfo)info);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        CreditLimitInfo info = this.getCreditLimitInfo(ctx, pk);
        if (this.checkeUsedAddNew(ctx, info.getId().toString())) {
            throw new FinBizException(FinBizException.CHECKEUSEDADDNEW);
        }
        this.resumeOldCreditLimit(ctx, pk, info);
        String sql = "delete T_BOT_Relation where fsrcobjectid='" + pk.toString() + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        String sql2 = "delete T_BOT_Relation where fdestobjectid='" + pk.toString() + "'";
        DbUtil.execute((Context)ctx, (String)sql2);
        String sql3 = "delete T_FIN_CreditLimitUsed where fcreditlimitid='" + pk.toString() + "'";
        DbUtil.execute((Context)ctx, (String)sql3);
        String sql4 = "delete T_FIN_CreditFinancingReduce where FCreditLimitID=?";
        DbUtil.execute((Context)ctx, (String)sql4, (Object[])new Object[]{pk.toString()});
        super._delete(ctx, pk);
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
    }

    private void recordUsedInfo(Context ctx, BigDecimal amount, String finBillId, IObjectValue creditLimitInfo, CreditLimitUsedInfo oldUsedInfo) throws BOSException, EASBizException {
        BillBaseInfo finBillInfo = (BillBaseInfo)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(finBillId.toString());
        CreditLimitUsedInfo newUsedInfo = this.createUsedInfo(ctx, amount, finBillId, finBillInfo, creditLimitInfo, oldUsedInfo);
        CreditLimitUsedFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)newUsedInfo);
    }

    private CreditLimitUsedInfo createUsedInfo(Context ctx, BigDecimal amount, String finBillId, BillBaseInfo finBillInfo, IObjectValue creditLimitInfo, CreditLimitUsedInfo oldUsedInfo) {
        CreditLimitInfo Info = (CreditLimitInfo)creditLimitInfo;
        CreditLimitUsedInfo newUsedInfo = new CreditLimitUsedInfo();
        newUsedInfo.setCreditLimit(Info);
        newUsedInfo.setProperty(Info.getProperty());
        newUsedInfo.setBillId(finBillId.toString());
        newUsedInfo.setBillNumber(finBillInfo.getNumber());
        newUsedInfo.setBillType(finBillInfo.getBOSType().toString());
        newUsedInfo.setUsedQuota(amount);
        newUsedInfo.setReturnedQuota(oldUsedInfo.getReturnedQuota());
        newUsedInfo.setCreateTime(DateUtil.getTimeStampDayBegin());
        newUsedInfo.setCreator((UserInfo)ctx.get((Object)"UserInfo"));
        newUsedInfo.setLastUpdateTime(DateUtil.getTimeStampDayBegin());
        newUsedInfo.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        newUsedInfo.setCurrency(Info.getCurrency());
        newUsedInfo.setIsUnionAddnew(true);
        newUsedInfo.setCompany(oldUsedInfo.getCompany());
        newUsedInfo.setFinPro(oldUsedInfo.getFinPro());
        newUsedInfo.setUsingBank(oldUsedInfo.getUsingBank());
        newUsedInfo.setCreditUsage(oldUsedInfo.getCreditUsage());
        newUsedInfo.setUsingCompany(oldUsedInfo.getUsingCompany());
        newUsedInfo.setIssueDate(oldUsedInfo.getIssueDate());
        newUsedInfo.setExpiredDate(oldUsedInfo.getExpiredDate());
        return newUsedInfo;
    }

    private CreditFinancingReduceCollection getCreditFinancingReduceCollection(Context ctx, Set ids) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("creditLimitID", (Object)ids, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return CreditFinancingReduceFactory.getLocalInstance(ctx).getCreditFinancingReduceCollection(evi);
    }

    private CreditLimitUsedCollection getCreditLimitUsedCollection(Context ctx, Set ids) throws BOSException {
        String includeValue = this.parseValue(ids);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CreditLimit", (Object)includeValue, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return CreditLimitUsedFactory.getLocalInstance(ctx).getCreditLimitUsedCollection(evi);
    }

    private CreditLimitUsedCollection getCreditLimitUsedCollection(Context ctx, String pk) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CreditLimit", (Object)pk.toString()));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return CreditLimitUsedFactory.getLocalInstance(ctx).getCreditLimitUsedCollection(evi);
    }

    protected void _deleteGTEntry(Context ctx, String pk) throws BOSException, EASBizException {
        String sql = "delete T_FIN_CreditlimitGTEntry where FParentBillIdID='" + pk + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected boolean _inspectCreditLimitIsByUnion(Context ctx, String CreditLimitid) throws BOSException {
        String strsql = "select FSrcObjectID from T_BOT_Relation where FDestEntityID='B57D51D0' and FSrcEntityID='B57D51D0' and FSrcObjectID = '" + String.valueOf(CreditLimitid) + "'";
        boolean flag = false;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strsql);
        try {
            while (rs.next()) {
                flag = true;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return flag;
    }

    @Override
    protected Date _getAppDate(Context ctx) throws BOSException {
        return new Date();
    }

    @Override
    protected void _updateIsClosed(Context ctx) throws BOSException {
        String sSQL = "update T_FIN_creditlimit set FIsClosed= 1 where FCreditCloseDate <= CURDATE()";
        DbUtil.execute((Context)ctx, (String)sSQL);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String sql = "update T_FIN_CreditLimit set FBillStatus=? \n";
        sql = sql + " where fid = '" + pk.toString() + "'";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(1)});
        if (ctx.getCaller() != null) {
            String updateAuditor = "update T_FIN_CreditLimit set FAUDITORID =? \n";
            updateAuditor = updateAuditor + " where fid = '" + pk.toString() + "'";
            DbUtil.execute((Context)ctx, (String)updateAuditor, (Object[])new Object[]{ctx.getCaller().toString()});
        }
    }

    @Override
    protected void _antiAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("IsClosed");
        CreditLimitInfo info = this.getCreditLimitInfo(ctx, pk, selector);
        if (info.isIsClosed()) {
            throw new FinBizException(FinBizException.CREDIT_CLO_CANNOT_ANTIAUDIT);
        }
        String sql = "update T_FIN_CreditLimit set FBillStatus=?,FAUDITORID = null \n";
        sql = sql + " where fid = '" + pk.toString() + "'";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(0)});
    }

    @Override
    protected boolean _checkUsed(Context ctx, String creditLimitid) throws BOSException, EASBizException {
        String sql = " select 1 from T_FIN_CreditLimitUsed where FCreditLimitId='" + creditLimitid + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        boolean result = false;
        try {
            if (rs != null && rs.next()) {
                result = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private void verifyGuaranteeWage(Context ctx, CreditLimitInfo info) throws EASBizException, BOSException {
        CreditlimitGTEntryCollection gdColl = info.getAssureBillEntry();
        for (int i = 0; i < gdColl.size(); ++i) {
            SelectorItemCollection sic;
            CreditlimitGTEntryInfo gdInfo = gdColl.get(i);
            if (EmptyUtil.isEmpty((String)gdInfo.getBillId())) continue;
            String id = gdInfo.getBillId();
            if (gdInfo.getGuaranteeTypeProperty() == GuaranteeTypePropertyEnum.assure) {
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("canceled"));
                AssureBillInfo assureInfo = AssureBillFactory.getLocalInstance((Context)ctx).getAssureBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
                if (!assureInfo.isCanceled()) continue;
                gdColl.removeObject(i);
                --i;
                continue;
            }
            if (gdInfo.getGuaranteeTypeProperty() != GuaranteeTypePropertyEnum.pledge && gdInfo.getGuaranteeTypeProperty() != GuaranteeTypePropertyEnum.impawn || info.isIsClosed()) continue;
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("isAntiWage"));
            WageInfo wage = WageFactory.getLocalInstance(ctx).getWageInfo((IObjectPK)new ObjectUuidPK(id), sic);
            if (!wage.isIsAntiWage()) continue;
            gdColl.removeObject(i);
            --i;
        }
    }

    @Override
    protected Map _poolDelete(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        CreditLimitCollection coll = this.getCreditLimitCollection(ctx, idSet);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        int success = 0;
        CreditLimitInfo info = null;
        for (int i = 0; i < coll.size(); ++i) {
            try {
                info = coll.get(i);
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"ntp_creditLimit_04delete");
                if (!isPermission) {
                    throw new CasWebException(CasWebException.NO_DELETE_AUTHRIZED);
                }
                if (CreditLimitBillStatusEnum.SUBMIT != info.getBillStatus()) {
                    throw new NTPException(NTPException.CREDITLIMIT_CANNOT_DELETE);
                }
                this.delete(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
                ++success;
                continue;
            }
            catch (Exception e) {
                String msg = CASWebUtil.getResource((Context)ctx, (String)NTP_RESOURCE, (String)"creditLimit_poolDelete_fail", (String[])new String[]{info.getNumber(), e.getMessage()});
                result.getDetailMsgList().add(msg);
            }
        }
        if (success == coll.size()) {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)"ALL_DELETE_SUCCESS");
            result.setSummaryMsg(summary);
        } else {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)"DELETE_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(coll.size() - success)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected Map _poolAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        CreditLimitCollection coll = this.getCreditLimitCollection(ctx, idSet);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        int success = 0;
        CreditLimitInfo info = null;
        for (int i = 0; i < coll.size(); ++i) {
            try {
                info = coll.get(i);
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"ntp_creditLimit_05audit");
                if (!isPermission) {
                    throw new NTPException(NTPException.NO_AUDIT_AUTHRIZED);
                }
                if (CreditLimitBillStatusEnum.SUBMIT != info.getBillStatus()) {
                    throw new NTPException(NTPException.CREDITLIMIT_CANNOT_AUDIT);
                }
                info.setBillStatus(CreditLimitBillStatusEnum.AUDIT);
                UserInfo auditUser = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
                info.setAuditor(auditUser);
                info.setAuditDate(DATE_FORMAT.parse(DATE_FORMAT.format(new Date())));
                this.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
                ++success;
                continue;
            }
            catch (Exception e) {
                String msg = CASWebUtil.getResource((Context)ctx, (String)NTP_RESOURCE, (String)"creditLimit_poolAudit_fail", (String[])new String[]{info.getNumber(), e.getMessage()});
                result.getDetailMsgList().add(msg);
            }
        }
        if (success == coll.size()) {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)NTP_RESOURCE, (String)"ALL_AUDIT_SUCCESS");
            result.setSummaryMsg(summary);
        } else {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)NTP_RESOURCE, (String)"AUDIT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(coll.size() - success)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected Map _poolUnAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        CreditLimitCollection coll = this.getCreditLimitCollection(ctx, idSet);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        int success = 0;
        CreditLimitInfo info = null;
        for (int i = 0; i < coll.size(); ++i) {
            try {
                info = coll.get(i);
                boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"ntp_creditLimit_06unaudit");
                if (!isPermission) {
                    throw new NTPException(NTPException.NO_UNAUDIT_AUTHRIZED);
                }
                if (CreditLimitBillStatusEnum.AUDIT != info.getBillStatus()) {
                    throw new NTPException(NTPException.CREDITLIMIT_CANNOT_UNAUDIT01);
                }
                if (this._checkUsed(ctx, info.getId().toString())) {
                    throw new NTPException(NTPException.CREDITLIMIT_CANNOT_UNAUDIT02);
                }
                info.setBillStatus(CreditLimitBillStatusEnum.SUBMIT);
                info.setAuditor(null);
                info.setAuditDate(null);
                info.setAdjustor(null);
                info.setAdjustDate(null);
                this.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
                ++success;
                continue;
            }
            catch (Exception e) {
                String msg = CASWebUtil.getResource((Context)ctx, (String)NTP_RESOURCE, (String)"creditLimit_poolUnAudit_fail", (String[])new String[]{info.getNumber(), e.getMessage()});
                result.getDetailMsgList().add(msg);
            }
        }
        if (success == coll.size()) {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)NTP_RESOURCE, (String)"ALL_UNAUDIT_SUCCESS");
            result.setSummaryMsg(summary);
        } else {
            summary = summary + CASWebUtil.getResource((Context)ctx, (String)NTP_RESOURCE, (String)"UNAUDIT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(coll.size() - success)});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    @Override
    protected void _addCreditLimitEntry(Context ctx, IObjectValue creditLimitInfo, IObjectValue companyInfo) throws BOSException, EASBizException {
        CreditLimitInfo creditLimit = (CreditLimitInfo)creditLimitInfo;
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)companyInfo;
        if (creditLimit.getShareType().getValue() == 1) {
            HashMap<String, CompanyOrgUnitInfo> companyMap = new HashMap<String, CompanyOrgUnitInfo>();
            for (int i = 0; i < creditLimit.getEntrys().size(); ++i) {
                CompanyOrgUnitInfo info = creditLimit.getEntrys().get(i).getShareOrg();
                companyMap.put(info.getId().toString(), info);
            }
            if (companyMap.containsKey(company.getId().toString())) {
                return;
            }
            Set set = this._getPerCompanyIdSet(ctx, company.getId().toString());
            for (String percompanyId : set) {
                if (!companyMap.containsKey(percompanyId)) continue;
                CreditLimitEntryInfo item = new CreditLimitEntryInfo();
                item.setShareOrg(company);
                item.setParent(creditLimit);
                item.setSeq(creditLimit.getEntrys().size());
                item.setControlWay(ControlWayEnum.NO);
                creditLimit.getEntrys().add(item);
                this.update(ctx, (IObjectPK)new ObjectUuidPK(creditLimit.getId().toString()), (CoreBaseInfo)creditLimit);
                break;
            }
        }
    }

    @Override
    protected Set _getPerCompanyIdSet(Context ctx, String companyId) throws BOSException, EASBizException {
        CompanyOrgUnitInfo info = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        String[] tmpLongNumbers = info.getLongNumber().split("!");
        HashSet<String> longNumbers = new HashSet<String>();
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < tmpLongNumbers.length; ++i) {
            if (i == 0) {
                strBuf.append(tmpLongNumbers[i]);
            } else {
                strBuf.append("!" + tmpLongNumbers[i]);
            }
            longNumbers.add(strBuf.toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("longnumber", longNumbers, CompareType.INCLUDE));
        view.setFilter(filter);
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        HashSet<String> resultSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            resultSet.add(coll.get(i).getId().toString());
        }
        return resultSet;
    }

    @Override
    protected void _closeByHand(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CreditLimitInfo info = (CreditLimitInfo)CreditLimitFactory.getLocalInstance(ctx).getValue(pk);
        if (info.isIsClosed()) {
            throw new FinBizException(FinBizException.CREDITLIMITHASCLOSED);
        }
        if (info.getExpiredDate().before(DateTimeUtils.truncateDate((Date)new Date()))) {
            info.setIsOverdue(true);
        }
        info.setIsClosed(true);
        info.setIsClosedByHand(true);
        info.setCreditCloseDate(new Date());
        CreditLimitFactory.getLocalInstance(ctx).update(pk, (CoreBaseInfo)info);
    }

    @Override
    protected void _antiCloseByHand(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CreditLimitInfo info = CreditLimitFactory.getLocalInstance(ctx).getCreditLimitInfo(pk);
        if (!info.isIsClosed()) {
            throw new FinBizException(FinBizException.CREDITLIMITHASNOCLOSED);
        }
        if (this.checkeIsUsedUnion(ctx, pk.toString())) {
            throw new FinBizException(FinBizException.CREDITLIMITHASUNIONED);
        }
        info.setIsClosed(false);
        info.setIsClosedByHand(false);
        Calendar cl = Calendar.getInstance();
        cl.setTime(info.getExpiredDate());
        cl.add(5, info.getDeferDay());
        info.setCreditCloseDate(cl.getTime());
        CreditLimitFactory.getLocalInstance(ctx).update(pk, (CoreBaseInfo)info);
    }
}

