/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.AbstractCreditLimitInfo;
import com.kingdee.eas.fm.fin.CreditFinancingReduceCollection;
import com.kingdee.eas.fm.fin.CreditFinancingReduceFactory;
import com.kingdee.eas.fm.fin.CreditFinancingReduceInfo;
import com.kingdee.eas.fm.fin.CreditLimitEntryCollection;
import com.kingdee.eas.fm.fin.CreditLimitEntryInfo;
import com.kingdee.eas.fm.fin.CreditLimitFactory;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.CreditLimitUsedCollection;
import com.kingdee.eas.fm.fin.CreditLimitUsedFactory;
import com.kingdee.eas.fm.fin.CreditLimitUsedInfo;
import com.kingdee.eas.fm.fin.LimitTypeEnum;
import com.kingdee.eas.fm.fin.util.ReduceSeqSorter;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreditLimitEntryGetterHelper {
    Map getCreditEntryAfterRetore(Context ctx, BOSUuid billID, BOSUuid creditID) throws BOSException, EASBizException {
        CreditLimitInfo creditInfo = CreditLimitFactory.getLocalInstance(ctx).getCreditLimitInfo((IObjectPK)new ObjectUuidPK(creditID.toString()), this.getSelectors());
        CreditLimitEntryCollection creditEntries = creditInfo.getEntrys();
        CreditLimitUsedCollection usedCol = this.getUsedCol(ctx, billID, creditID);
        CreditLimitEntryCollection afterRestore = this.restoreBalanceFromUsedCol(ctx, creditEntries, usedCol);
        CreditFinancingReduceCollection reduceEntries = this.getCreditFinancingReduceCollection(ctx, billID, creditID);
        List<Object> reduceColList = Arrays.asList(reduceEntries.toArray());
        Collections.sort(reduceColList, new ReduceSeqSorter());
        Map retValue = this.assemblData(ctx, afterRestore, reduceColList);
        return retValue;
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("entrys.*");
        sic.add("entrys.ShareOrg.*");
        sic.add("entrys.finPro.*");
        return sic;
    }

    private CreditLimitUsedCollection getUsedCol(Context ctx, BOSUuid billID, BOSUuid creditLimitID) throws EASBizException, BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("CreditLimit.id", (Object)creditLimitID.toString()));
        f.getFilterItems().add(new FilterItemInfo("BillId", (Object)billID.toString()));
        evi.setFilter(f);
        return CreditLimitUsedFactory.getLocalInstance(ctx).getCreditLimitUsedCollection(evi);
    }

    private CreditLimitEntryCollection restoreBalanceFromUsedCol(Context ctx, CreditLimitEntryCollection creditEntries, CreditLimitUsedCollection usedCol) {
        CreditLimitEntryCollection retCol = new CreditLimitEntryCollection();
        int entrySize = creditEntries.size();
        CreditLimitEntryInfo tmpEntryInfo = null;
        int usedSize = usedCol.size();
        CreditLimitUsedInfo tmpUsedInfo = null;
        for (int i = 0; i < entrySize; ++i) {
            tmpEntryInfo = creditEntries.get(i);
            for (int j = 0; j < usedSize; ++j) {
                tmpUsedInfo = usedCol.get(j);
                if (!this.sameRecord(tmpEntryInfo, tmpUsedInfo, ctx)) continue;
                this.restoreBalance(tmpEntryInfo, tmpUsedInfo);
            }
            retCol.add(tmpEntryInfo);
        }
        return retCol;
    }

    private boolean sameRecord(CreditLimitEntryInfo tmpEntryInfo, CreditLimitUsedInfo tmpUsedInfo, Context ctx) {
        AbstractCreditLimitInfo creditLimitInfo = null;
        try {
            creditLimitInfo = CreditLimitFactory.getLocalInstance(ctx).getCreditLimitInfo((IObjectPK)new ObjectUuidPK(tmpEntryInfo.getParent().getId()));
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        boolean isSameFinPro = creditLimitInfo.getLimitType().equals((Object)LimitTypeEnum.BILLPOOL_LIMIT) ? true : tmpEntryInfo.getFinPro().getId().equals((Object)tmpUsedInfo.getFinPro().getId());
        boolean isSameCompany = tmpEntryInfo.getShareOrg().getId().equals((Object)tmpUsedInfo.getCompany().getId());
        return isSameCompany && isSameFinPro;
    }

    private void restoreBalance(CreditLimitEntryInfo tmpEntryInfo, CreditLimitUsedInfo tmpUsedInfo) {
        tmpEntryInfo.setBanlance(FMHelper.add((BigDecimal)tmpEntryInfo.getBanlance(), (BigDecimal)tmpUsedInfo.getUsedQuota().subtract(tmpUsedInfo.getReturnedQuota())));
    }

    private CreditFinancingReduceCollection getCreditFinancingReduceCollection(Context ctx, BOSUuid billid, BOSUuid creditLimitID) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("billID", (Object)billid.toString()));
        f.getFilterItems().add(new FilterItemInfo("creditLimitID", (Object)creditLimitID.toString()));
        evi.setFilter(f);
        return CreditFinancingReduceFactory.getLocalInstance(ctx).getCreditFinancingReduceCollection(evi);
    }

    private Map assemblData(Context ctx, CreditLimitEntryCollection afterRestore, List reduceColList) {
        CreditFinancingReduceCollection rightData = new CreditFinancingReduceCollection();
        CreditFinancingReduceCollection leftData = new CreditFinancingReduceCollection();
        int sizeCreditEntrySize = afterRestore.size();
        CreditLimitEntryInfo entryInfoTmp = null;
        CreditFinancingReduceInfo reducInfoTmp = null;
        for (int i = 0; i < sizeCreditEntrySize; ++i) {
            entryInfoTmp = afterRestore.get(i);
            reducInfoTmp = this.findCorrespondingReduceInfo(entryInfoTmp, reduceColList);
            if (reducInfoTmp != null) {
                rightData.add(this.createARightData(entryInfoTmp, reducInfoTmp));
                continue;
            }
            leftData.add(this.createALeftData(entryInfoTmp, reducInfoTmp));
        }
        HashMap<String, CreditFinancingReduceCollection> hm = new HashMap<String, CreditFinancingReduceCollection>();
        if (rightData.size() > 0) {
            hm.put("right", rightData);
        }
        if (leftData.size() > 0) {
            hm.put("left", leftData);
        }
        return hm;
    }

    private CreditFinancingReduceInfo findCorrespondingReduceInfo(CreditLimitEntryInfo entryInfoTmp, List reduceColList) {
        int reduceColListSize = reduceColList.size();
        CreditFinancingReduceInfo reducInfoTmp = null;
        CreditFinancingReduceInfo reducInfoRet = null;
        for (int j = 0; j < reduceColListSize; ++j) {
            reducInfoTmp = (CreditFinancingReduceInfo)reduceColList.get(j);
            if (!this.sameCompanyAndFinpro(entryInfoTmp, reducInfoTmp)) continue;
            reducInfoRet = reducInfoTmp;
            break;
        }
        return reducInfoRet;
    }

    private boolean sameCompanyAndFinpro(CreditLimitEntryInfo entryInfoTmp, CreditFinancingReduceInfo reducInfoTmp) {
        boolean isSameCompany = entryInfoTmp.getShareOrg().getId().equals((Object)reducInfoTmp.getShareOrg().getId());
        boolean isSameFinPro = entryInfoTmp.getFinPro().getId().equals((Object)reducInfoTmp.getFinPro().getId());
        return isSameCompany && isSameFinPro;
    }

    private CreditFinancingReduceInfo createARightData(CreditLimitEntryInfo entryInfo, CreditFinancingReduceInfo reducInfoTmp) {
        CreditFinancingReduceInfo creditFinancingReduceInfo = new CreditFinancingReduceInfo();
        this.setCommonValues(entryInfo, creditFinancingReduceInfo);
        creditFinancingReduceInfo.setReduceSeq(reducInfoTmp.getReduceSeq());
        return creditFinancingReduceInfo;
    }

    private void setCommonValues(CreditLimitEntryInfo entryInfo, CreditFinancingReduceInfo creditFinancingReduceInfo) {
        creditFinancingReduceInfo.setAssignAmt(entryInfo.getSharedAmount());
        creditFinancingReduceInfo.setBalance(entryInfo.getBanlance());
        creditFinancingReduceInfo.setUsedAmt(FMHelper.subtract((BigDecimal)creditFinancingReduceInfo.getAssignAmt(), (BigDecimal)creditFinancingReduceInfo.getBalance()));
        creditFinancingReduceInfo.setFinPro(entryInfo.getFinPro());
        creditFinancingReduceInfo.setCreditEntry(entryInfo);
        creditFinancingReduceInfo.setControlWay(entryInfo.getControlWay());
        creditFinancingReduceInfo.setShareOrg(entryInfo.getShareOrg());
        creditFinancingReduceInfo.setCreditEntry(entryInfo);
    }

    private CreditFinancingReduceInfo createALeftData(CreditLimitEntryInfo entryInfo, CreditFinancingReduceInfo reducInfoTmp) {
        CreditFinancingReduceInfo creditFinancingReduceInfo = new CreditFinancingReduceInfo();
        this.setCommonValues(entryInfo, creditFinancingReduceInfo);
        return creditFinancingReduceInfo;
    }
}

