/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeInfo;
import com.kingdee.eas.fm.fin.AbstractCreditLimitUsedInfo;
import com.kingdee.eas.fm.fin.ControlWayEnum;
import com.kingdee.eas.fm.fin.CreditFinancingReduceCollection;
import com.kingdee.eas.fm.fin.CreditFinancingReduceFactory;
import com.kingdee.eas.fm.fin.CreditFinancingReduceInfo;
import com.kingdee.eas.fm.fin.CreditLimitEntryCollection;
import com.kingdee.eas.fm.fin.CreditLimitEntryInfo;
import com.kingdee.eas.fm.fin.CreditLimitFactory;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.CreditLimitStatusEnum;
import com.kingdee.eas.fm.fin.CreditLimitUsedCollection;
import com.kingdee.eas.fm.fin.CreditLimitUsedFactory;
import com.kingdee.eas.fm.fin.CreditLimitUsedInfo;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.ICreditLimitUsed;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LimitIsBankCreditEnum;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.ShareTypeEnum;
import com.kingdee.eas.fm.fin.app.CreditLimitManagerHelper;
import com.kingdee.eas.fm.fin.util.ReduceSeqSorter;
import com.kingdee.eas.fm.ibt.BillRediscountOutInfo;
import com.kingdee.eas.fm.ibt.CreditAssetsTransferOutInfo;
import com.kingdee.eas.fm.ibt.InnerFinancingBorrowingInInfo;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class CreditLimitManagerByFinancingProduct {
    private static ThreadLocal<BigDecimal> oldRetuanQuotaThreadLocal = new ThreadLocal<BigDecimal>(){

        @Override
        protected BigDecimal initialValue() {
            return BigDecimal.ZERO;
        }
    };

    private boolean isExistsWithCreditLimitUsed(Context ctx, BOSUuid finbillId, boolean isCheckIsUnioned) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("BillId", (Object)finbillId));
        if (isCheckIsUnioned) {
            filter.getFilterItems().add(new FilterItemInfo("IsUnioned", (Object)"0"));
        }
        filter.getFilterItems().add(new FilterItemInfo("returnedQuota", (Object)Constants.ZERO, CompareType.NOTEQUALS));
        return CreditLimitUsedFactory.getLocalInstance(ctx).exists(filter);
    }

    private CreditFinancingReduceCollection getReduceCollection(Context ctx, BOSUuid companyId, BOSUuid creditLimitId, BOSUuid finbillId) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.getSelector().add("shareOrg.*");
        evi.getSelector().add("finPro.*");
        evi.getSelector().add("creditEntry.*");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("ShareOrg.id", (Object)companyId.toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("creditLimitID", (Object)creditLimitId.toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("billID", (Object)finbillId.toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isUnion", (Object)Boolean.FALSE));
        String mask = "#0 and #1 and #2 and #3";
        evi.getFilter().setMaskString(mask);
        return CreditFinancingReduceFactory.getLocalInstance(ctx).getCreditFinancingReduceCollection(evi);
    }

    private void updateLimitState(Context ctx, String creditLimitId) throws BOSException, EASBizException {
        CreditLimitStatusEnum creditStatus = CreditLimitManagerHelper.getCreditLimitStatus(ctx, creditLimitId);
        String ssql = "UPDATE T_FIN_CreditLimit SET FCreditLimitStat = ? WHERE (FID = ?)";
        DbUtil.execute((Context)ctx, (String)ssql, (Object[])new Object[]{new Integer(creditStatus.getValue()), creditLimitId});
    }

    void useLimitByFinancingProduct(Context ctx, BOSUuid creditLimitId, BigDecimal amount, BOSUuid companyId, BOSUuid finBillId, boolean isRepayment, FinancingBillInfo finBillInfo) throws BOSException, EASBizException {
        if (amount != null && amount.signum() == 0) {
            return;
        }
        if (this.isExistsWithCreditLimitUsed(ctx, finBillId, false)) {
            return;
        }
        CreditLimitManagerHelper.verify4UseLimit(creditLimitId, amount, companyId, finBillId);
        this.cancelLimitByFinancingProduct(ctx, finBillId, finBillInfo, amount);
        CreditLimitInfo creditLimitInfo = this.getCreditLimitInfo(ctx, creditLimitId);
        this.checkAmount(amount, creditLimitInfo);
        CreditFinancingReduceCollection reduceCollection = this.getReduceCollection(ctx, companyId, creditLimitId, finBillInfo.getId());
        CreditLimitUsedCollection usedCollection = this.recordUsedInfo(ctx, amount, finBillId, creditLimitInfo, finBillInfo, reduceCollection, isRepayment);
        this.updateCreditInfoUseLimit(ctx, creditLimitInfo, amount, usedCollection);
    }

    void useLetterOfCreditLimitByFinancingProduct(Context ctx, BOSUuid creditLimitId, BigDecimal amount, BOSUuid companyId, BOSUuid finBillId, boolean isRepayment, FinancingBillInfo finBillInfo) throws BOSException, EASBizException {
        if (amount != null && amount.signum() == 0) {
            return;
        }
        CreditLimitManagerHelper.verify4UseLimit(creditLimitId, amount, companyId, finBillId);
        CreditLimitInfo creditLimitInfo = this.getCreditLimitInfo(ctx, creditLimitId);
        this.checkAmount(amount, creditLimitInfo);
        CreditFinancingReduceCollection reduceCollection = this.getReduceCollection(ctx, companyId, creditLimitId, finBillInfo.getId());
        CreditLimitUsedCollection usedCollection = this.recordLetterUsedInfo(ctx, amount, finBillId, creditLimitInfo, finBillInfo, reduceCollection, isRepayment);
        this.updateLetterCreditInfoUseLimit(ctx, creditLimitInfo, amount, usedCollection);
        oldRetuanQuotaThreadLocal.remove();
    }

    private CreditLimitInfo getCreditLimitInfo(Context ctx, BOSUuid creditLimitId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("entrys.*");
        sic.add("entrys.ShareOrg.*");
        sic.add("entrys.finPro.*");
        CreditLimitInfo creditLimitInfo = CreditLimitFactory.getLocalInstance(ctx).getCreditLimitInfo((IObjectPK)new ObjectUuidPK(creditLimitId), sic);
        return creditLimitInfo;
    }

    private void checkAmount(BigDecimal amount, CreditLimitInfo creditLimitInfo) throws FinBizException {
        BigDecimal banlance;
        ShareTypeEnum shareType = creditLimitInfo.getShareType();
        if (!(shareType.equals((Object)ShareTypeEnum.ASSIGN) || (banlance = creditLimitInfo.getBalance()).compareTo(Constants.ZERO) >= 0 && amount.compareTo(banlance) <= 0)) {
            throw new FinBizException(FinBizException.CREDITLIMITAMOUNTFULLFILL);
        }
    }

    private CreditLimitUsedCollection recordUsedInfo(Context ctx, BigDecimal amount, BOSUuid finBillId, CreditLimitInfo creditLimitInfo, FinancingBillInfo finBillInfo, CreditFinancingReduceCollection reduceCollection, boolean isRepayment) throws EASBizException, BOSException {
        CreditLimitUsedCollection usedCol = this.createUsedCollectionByFinPro(ctx, amount, finBillId, creditLimitInfo, finBillInfo, reduceCollection, isRepayment);
        if (usedCol.size() > 0) {
            ICreditLimitUsed localInstance = CreditLimitUsedFactory.getLocalInstance(ctx);
            for (int i = 0; i < usedCol.size(); ++i) {
                localInstance.addnew((CoreBaseInfo)usedCol.get(i));
            }
        }
        return usedCol;
    }

    private CreditLimitUsedCollection recordLetterUsedInfo(Context ctx, BigDecimal amount, BOSUuid finBillId, CreditLimitInfo creditLimitInfo, FinancingBillInfo finBillInfo, CreditFinancingReduceCollection reduceCollection, boolean isRepayment) throws EASBizException, BOSException {
        CreditLimitUsedCollection usedCol = new CreditLimitUsedCollection();
        BillBaseInfo financingBillInfo = (BillBaseInfo)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(finBillId.toString());
        List<CreditFinancingReduceInfo> reduceList = this.convertListAndSort(reduceCollection, isRepayment);
        CreditLimitEntryCollection entryCollection = creditLimitInfo.getEntrys();
        CreditLimitUsedCollection usedCollection = CreditLimitManagerHelper.getUsedCol(ctx, finBillInfo.getId(), creditLimitInfo);
        BigDecimal balanceTmp = isRepayment ? amount.negate() : amount;
        BigDecimal oldReturnQuota = oldRetuanQuotaThreadLocal.get();
        for (int i = 0; i < reduceList.size(); ++i) {
            CreditFinancingReduceInfo reduceInfo = reduceList.get(i);
            for (int j = 0; j < entryCollection.size(); ++j) {
                CreditLimitUsedInfo newUsedInfo = this.buildLetterCreditLimitUsedInfo(ctx, finBillId, creditLimitInfo, financingBillInfo, reduceInfo, isRepayment, balanceTmp, entryCollection.get(j), usedCollection, oldReturnQuota);
                if (newUsedInfo == null) continue;
                balanceTmp = balanceTmp.subtract(newUsedInfo.getUsedQuota().abs());
                usedCol.add(newUsedInfo);
            }
        }
        if (oldReturnQuota.compareTo(BigDecimal.ZERO) > 0 && usedCol.size() > 0) {
            BigDecimal tmpQuota = oldReturnQuota;
            for (int i = usedCol.size() - 1; i >= 0; --i) {
                CreditLimitUsedInfo usedInfo = usedCol.get(i);
                if (usedInfo.getUsedQuota().compareTo(tmpQuota) >= 0) {
                    usedInfo.setReturnedQuota(tmpQuota);
                    break;
                }
                usedInfo.setReturnedQuota(usedInfo.getUsedQuota());
                tmpQuota = tmpQuota.subtract(usedInfo.getUsedQuota());
            }
        }
        if (usedCol.size() > 0) {
            ICreditLimitUsed localInstance = CreditLimitUsedFactory.getLocalInstance(ctx);
            for (int i = 0; i < usedCol.size(); ++i) {
                localInstance.addnew((CoreBaseInfo)usedCol.get(i));
            }
        }
        return usedCol;
    }

    private CreditLimitUsedCollection createUsedCollectionByFinPro(Context ctx, BigDecimal amount, BOSUuid finBillId, CreditLimitInfo creditLimitInfo, FinancingBillInfo finBillInfo, CreditFinancingReduceCollection reduceCollection, boolean isRepayment) throws EASBizException, BOSException {
        CreditLimitUsedCollection col = new CreditLimitUsedCollection();
        BillBaseInfo financingBillInfo = (BillBaseInfo)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(finBillId.toString());
        List<CreditFinancingReduceInfo> reduceList = this.convertListAndSort(reduceCollection, isRepayment);
        CreditLimitEntryCollection entryCollection = creditLimitInfo.getEntrys();
        CreditLimitUsedCollection usedCollection = CreditLimitManagerHelper.getUsedCol(ctx, finBillInfo.getId(), creditLimitInfo);
        BigDecimal balanceTmp = isRepayment ? amount.negate() : amount;
        for (int i = 0; i < reduceList.size(); ++i) {
            CreditFinancingReduceInfo reduceInfo = reduceList.get(i);
            for (int j = 0; j < entryCollection.size(); ++j) {
                CreditLimitUsedInfo newUsedInfo = this.buildCreditLimitUsedInfo(ctx, finBillId, creditLimitInfo, financingBillInfo, reduceInfo, isRepayment, balanceTmp, entryCollection.get(j), usedCollection);
                if (newUsedInfo == null) continue;
                balanceTmp = balanceTmp.subtract(newUsedInfo.getUsedQuota().abs());
                col.add(newUsedInfo);
            }
        }
        return col;
    }

    private List<CreditFinancingReduceInfo> convertListAndSort(CreditFinancingReduceCollection reduceCollection, boolean isRepayment) {
        List<Object> reduceList = Arrays.asList(reduceCollection.toArray());
        if (isRepayment) {
            Collections.sort(reduceList, new ReduceSeqSorter("DESC"));
        } else {
            Collections.sort(reduceList, new ReduceSeqSorter());
        }
        return reduceList;
    }

    private CreditLimitUsedInfo buildCreditLimitUsedInfo(Context ctx, BOSUuid finBillId, CreditLimitInfo creditLimitInfo, BillBaseInfo finBillInfo, CreditFinancingReduceInfo reduceInfo, boolean isRepayment, BigDecimal balanceTmp, CreditLimitEntryInfo entryInfo, CreditLimitUsedCollection usedCollection) {
        AbstractCreditLimitUsedInfo newUsedInfo = null;
        if (this.isSameCompanyAndFinPro(entryInfo, reduceInfo) && balanceTmp.compareTo(Constants.ZERO) > 0 && entryInfo.getId().toString().equals(reduceInfo.getCreditEntry().getId().toString())) {
            if (isRepayment) {
                CreditLimitUsedInfo usedInfo = this.findUsedInfoByEntry(entryInfo, usedCollection);
                if (usedInfo != null) {
                    if (balanceTmp.compareTo(usedInfo.getUsedQuota().subtract(usedInfo.getReturnedQuota())) >= 0) {
                        newUsedInfo = new CreditLimitUsedInfo();
                        BigDecimal usedAmt = usedInfo.getUsedQuota().subtract(usedInfo.getReturnedQuota());
                        newUsedInfo.setUsedQuota(usedAmt.negate());
                        balanceTmp = balanceTmp.subtract(usedAmt);
                    } else {
                        newUsedInfo = new CreditLimitUsedInfo();
                        newUsedInfo.setUsedQuota(balanceTmp.negate());
                        balanceTmp = balanceTmp.subtract(balanceTmp);
                    }
                }
            } else if (entryInfo.getBanlance().compareTo(Constants.ZERO) > 0) {
                if (balanceTmp.compareTo(entryInfo.getBanlance()) >= 0) {
                    newUsedInfo = new CreditLimitUsedInfo();
                    newUsedInfo.setUsedQuota(entryInfo.getBanlance());
                    balanceTmp = balanceTmp.subtract(entryInfo.getBanlance());
                } else {
                    newUsedInfo = new CreditLimitUsedInfo();
                    newUsedInfo.setUsedQuota(balanceTmp);
                    balanceTmp = balanceTmp.subtract(balanceTmp);
                }
            }
            if (newUsedInfo != null) {
                newUsedInfo.setReturnedQuota(Constants.ZERO);
                this.buildCommonValue(ctx, creditLimitInfo, finBillInfo, (CreditLimitUsedInfo)newUsedInfo, finBillId, entryInfo);
            }
        }
        return newUsedInfo;
    }

    private CreditLimitUsedInfo buildLetterCreditLimitUsedInfo(Context ctx, BOSUuid finBillId, CreditLimitInfo creditLimitInfo, BillBaseInfo finBillInfo, CreditFinancingReduceInfo reduceInfo, boolean isRepayment, BigDecimal balanceTmp, CreditLimitEntryInfo entryInfo, CreditLimitUsedCollection usedCollection, BigDecimal oldReturnQuota) {
        AbstractCreditLimitUsedInfo newUsedInfo = null;
        if (this.isSameCompanyAndFinPro(entryInfo, reduceInfo) && balanceTmp.compareTo(Constants.ZERO) > 0 && entryInfo.getId().toString().equals(reduceInfo.getCreditEntry().getId().toString())) {
            if (isRepayment) {
                CreditLimitUsedInfo usedInfo = this.findUsedInfoByEntry(entryInfo, usedCollection);
                if (usedInfo != null) {
                    if (balanceTmp.compareTo(usedInfo.getUsedQuota().subtract(usedInfo.getReturnedQuota())) >= 0) {
                        newUsedInfo = new CreditLimitUsedInfo();
                        BigDecimal usedAmt = usedInfo.getUsedQuota().subtract(usedInfo.getReturnedQuota());
                        newUsedInfo.setUsedQuota(usedAmt.negate());
                        balanceTmp = balanceTmp.subtract(usedAmt);
                    } else {
                        newUsedInfo = new CreditLimitUsedInfo();
                        newUsedInfo.setUsedQuota(balanceTmp.negate());
                        balanceTmp = balanceTmp.subtract(balanceTmp);
                    }
                }
            } else if (entryInfo.getBanlance().compareTo(Constants.ZERO) > 0) {
                if (balanceTmp.compareTo(entryInfo.getBanlance()) >= 0) {
                    newUsedInfo = new CreditLimitUsedInfo();
                    newUsedInfo.setUsedQuota(entryInfo.getBanlance());
                    balanceTmp = balanceTmp.subtract(entryInfo.getBanlance());
                } else {
                    newUsedInfo = new CreditLimitUsedInfo();
                    newUsedInfo.setUsedQuota(balanceTmp);
                    balanceTmp = balanceTmp.subtract(balanceTmp);
                }
            }
            if (newUsedInfo != null) {
                newUsedInfo.setReturnedQuota(Constants.ZERO);
                this.buildCommonValue(ctx, creditLimitInfo, finBillInfo, (CreditLimitUsedInfo)newUsedInfo, finBillId, entryInfo);
            }
        }
        return newUsedInfo;
    }

    private boolean isSameCompanyAndFinPro(CreditLimitEntryInfo entryInfo, CreditFinancingReduceInfo reduceInfo) {
        return reduceInfo.getShareOrg().getId().equals((Object)entryInfo.getShareOrg().getId()) && reduceInfo.getFinPro().getId().equals((Object)entryInfo.getFinPro().getId());
    }

    private CreditLimitUsedInfo findUsedInfoByEntry(CreditLimitEntryInfo entryInfo, CreditLimitUsedCollection usedCollection) {
        for (int i = 0; i < usedCollection.size(); ++i) {
            CreditLimitUsedInfo usedInfo = usedCollection.get(i);
            if (!this.isSameCompanyAndFinPro(entryInfo, usedInfo) || usedInfo.getUsedQuota().compareTo(usedInfo.getReturnedQuota()) <= 0) continue;
            return usedInfo;
        }
        return null;
    }

    private boolean isSameCompanyAndFinPro(CreditLimitEntryInfo entryInfo, CreditLimitUsedInfo usedInfo) {
        return usedInfo.getCompany().getId().equals((Object)entryInfo.getShareOrg().getId()) && usedInfo.getFinPro().getId().equals((Object)entryInfo.getFinPro().getId());
    }

    private void buildCommonValue(Context ctx, CreditLimitInfo creditLimitInfo, BillBaseInfo finBillInfo, CreditLimitUsedInfo usedInfo, BOSUuid finBillId, CreditLimitEntryInfo entryInfo) {
        usedInfo.setFinPro(entryInfo.getFinPro());
        usedInfo.setCompany(entryInfo.getShareOrg());
        usedInfo.setBillType(finBillInfo.getBOSType().toString());
        usedInfo.setBillNumber(finBillInfo.getNumber());
        usedInfo.setBillId(finBillId.toString());
        usedInfo.setProperty(creditLimitInfo.getProperty());
        usedInfo.setCreditLimit(creditLimitInfo);
        usedInfo.setCreateTime(DateUtil.getTimeStampDayBegin());
        usedInfo.setCreator((UserInfo)ctx.get((Object)"UserInfo"));
        usedInfo.setLastUpdateTime(DateUtil.getTimeStampDayBegin());
        usedInfo.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        usedInfo.setCurrency(creditLimitInfo.getCurrency());
        usedInfo.setCreditUsage(creditLimitInfo.getCreditUsage());
        if (finBillInfo instanceof PayableBillInfo || finBillInfo instanceof LetterOfCreditInfo || finBillInfo instanceof LetterOfGuaranteeInfo || finBillInfo instanceof InnerFinancingBorrowingInInfo || finBillInfo instanceof BillRediscountOutInfo || finBillInfo instanceof CreditAssetsTransferOutInfo) {
            usedInfo.setUsingBank(((FinancingBillInfo)finBillInfo).getInstitution());
        }
        if (finBillInfo instanceof PayableBillInfo || finBillInfo instanceof LetterOfCreditInfo || finBillInfo instanceof LetterOfGuaranteeInfo) {
            usedInfo.setUsingBank(((FinancingBillInfo)finBillInfo).getInstitution());
        } else if (finBillInfo instanceof LoanInfo) {
            LoanInfo infoLoan = (LoanInfo)finBillInfo;
            if (creditLimitInfo.getIsBankCredit() == LimitIsBankCreditEnum.INNER) {
                usedInfo.setUsingCompany(infoLoan.getGroupID());
            } else {
                usedInfo.setUsingBank(((FinancingBillInfo)finBillInfo).getInstitution());
            }
        }
        if (finBillInfo instanceof FinancingBillInfo) {
            usedInfo.setIssueDate(((FinancingBillInfo)finBillInfo).getIssueDate());
            usedInfo.setExpiredDate(((FinancingBillInfo)finBillInfo).getExpiredDate());
        }
    }

    private void updateCreditInfoUseLimit(Context ctx, CreditLimitInfo creditLimitInfo, BigDecimal amount, CreditLimitUsedCollection usedCollection) throws BOSException, EASBizException {
        String creditLimitId = creditLimitInfo.getId().toString();
        String hsql = "UPDATE T_FIN_CreditLimit SET FBalance = FBalance - ?  WHERE FID = ?";
        FMHelper.execute((Context)ctx, (String)hsql, (Object[])new Object[]{amount, creditLimitId});
        String csql = "UPDATE T_FIN_CreditLimit SET FUsedAmount=FQuotaAmount-FBalance WHERE FID=?";
        DbUtil.execute((Context)ctx, (String)csql, (Object[])new Object[]{creditLimitId});
        String dsql = "UPDATE T_FIN_CreditLimitEntry SET FBanlance = FBanlance - ? WHERE FParentID = ? and FFinProID =? and FShareOrgID = ? and FControlWay = 0";
        for (int i = 0; i < usedCollection.size(); ++i) {
            CreditLimitUsedInfo usedInfo = usedCollection.get(i);
            FMHelper.execute((Context)ctx, (String)dsql, (Object[])new Object[]{usedInfo.getUsedQuota(), creditLimitId, usedInfo.getFinPro().getId().toString(), usedInfo.getCompany().getId().toString()});
        }
        this.updateLimitState(ctx, creditLimitId);
    }

    private void updateLetterCreditInfoUseLimit(Context ctx, CreditLimitInfo creditLimitInfo, BigDecimal amount, CreditLimitUsedCollection usedCollection) throws BOSException, EASBizException {
        String creditLimitId = creditLimitInfo.getId().toString();
        String billId = usedCollection.get(0).getBillId();
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.getSelector().add("finPro.id");
        evi.getSelector().add("company.id");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("BillId", (Object)billId, CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("IsUnioned", (Object)"0"));
        filterInfo.getFilterItems().add(new FilterItemInfo("CreditLimit.id", (Object)creditLimitId));
        evi.setFilter(filterInfo);
        CreditLimitUsedCollection coll = CreditLimitUsedFactory.getLocalInstance(ctx).getCreditLimitUsedCollection(evi);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)coll)) {
            for (int i = 0; i < usedCollection.size(); ++i) {
                CreditLimitUsedInfo usedInfo = usedCollection.get(i);
                for (int j = 0; j < coll.size(); ++j) {
                    CreditLimitUsedInfo otherUsedInfo = coll.get(j);
                    if (!usedInfo.getCompany().getId().toString().equals(otherUsedInfo.getCompany().getId().toString()) || !usedInfo.getFinPro().getId().toString().equals(otherUsedInfo.getFinPro().getId().toString()) || otherUsedInfo.getUsedQuota().compareTo(BigDecimal.ZERO) <= 0) continue;
                    usedInfo.setUsedQuota(usedInfo.getUsedQuota().add(otherUsedInfo.getUsedQuota().subtract(otherUsedInfo.getReturnedQuota())));
                }
            }
        }
        String hsql = "UPDATE T_FIN_CreditLimit SET FBalance = FBalance - ?  WHERE FID = ?";
        FMHelper.execute((Context)ctx, (String)hsql, (Object[])new Object[]{amount.subtract(oldRetuanQuotaThreadLocal.get()), creditLimitId});
        String csql = "UPDATE T_FIN_CreditLimit SET FUsedAmount=FQuotaAmount-FBalance WHERE FID=?";
        DbUtil.execute((Context)ctx, (String)csql, (Object[])new Object[]{creditLimitId});
        String dsql = "UPDATE T_FIN_CreditLimitEntry SET FBanlance = FSharedAmount - ? WHERE FParentID = ? and FFinProID =? and FShareOrgID = ? and FControlWay = 0";
        for (int i = 0; i < usedCollection.size(); ++i) {
            CreditLimitUsedInfo usedInfo = usedCollection.get(i);
            FMHelper.execute((Context)ctx, (String)dsql, (Object[])new Object[]{usedInfo.getUsedQuota().subtract(usedInfo.getReturnedQuota()), creditLimitId, usedInfo.getFinPro().getId().toString(), usedInfo.getCompany().getId().toString()});
        }
        this.updateLimitState(ctx, creditLimitId);
    }

    void cancelLimitByFinancingProduct(Context ctx, BOSUuid finBillId, FinancingBillInfo finBillInfo, BigDecimal amount) throws EASBizException, BOSException {
        if (this.isExistsWithCreditLimitUsed(ctx, finBillId, true)) {
            return;
        }
        CreditLimitUsedCollection usedCollection = this.getCreditLimitUsedCollection(ctx, finBillId, finBillInfo);
        if (usedCollection == null || usedCollection.size() <= 0) {
            return;
        }
        CreditLimitInfo creditLimitInfo = usedCollection.get(0).getCreditLimit();
        this.deleteCreditLimitUsed(ctx, finBillId);
        this.updateCreditInfoCancelLimit(ctx, creditLimitInfo, this.sumUsedQuota(usedCollection), usedCollection);
    }

    void cancelLetterOfCreditLimitByFinancingProduct(Context ctx, BOSUuid finBillId, FinancingBillInfo finBillInfo, BigDecimal amount) throws EASBizException, BOSException {
        CreditLimitUsedCollection usedCollection = this.getCreditLimitUsedCollection(ctx, finBillId, finBillInfo);
        if (usedCollection == null || usedCollection.size() <= 0) {
            return;
        }
        CreditLimitInfo creditLimitInfo = usedCollection.get(0).getCreditLimit();
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.getSelector().add("CreditLimit.*");
        evi.getSelector().add("CreditLimit.entrys.*");
        evi.getSelector().add("finPro.id");
        evi.getSelector().add("company.*");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("BillId", (Object)finBillId));
        evi.setFilter(filterInfo);
        CreditLimitUsedCollection usedCol = CreditLimitUsedFactory.getLocalInstance(ctx).getCreditLimitUsedCollection(evi);
        BigDecimal returnQuota = BigDecimal.ZERO;
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)usedCol)) {
            int size = usedCol.size();
            for (int i = 0; i < size; ++i) {
                CreditLimitUsedInfo usedInfo = usedCol.get(i);
                returnQuota = returnQuota.add(usedInfo.getReturnedQuota());
            }
        }
        oldRetuanQuotaThreadLocal.set(returnQuota);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("BillId", (Object)finBillId));
        CreditLimitUsedFactory.getLocalInstance(ctx).delete(filter);
        this.updateLetterCreditInfoCancelLimit(ctx, creditLimitInfo, this.sumLetterUsedQuota(usedCollection), usedCollection);
    }

    private CreditLimitUsedCollection getCreditLimitUsedCollection(Context ctx, BOSUuid finBillId, FinancingBillInfo finBillInfo) throws BOSException {
        HashSet<String> finProSet = new HashSet<String>();
        CreditFinancingReduceCollection reduceCollection = this.getReduceCollection(ctx, finBillInfo.getCompany().getId(), finBillInfo.getCreditLimit().getId(), finBillId);
        for (int i = 0; i < reduceCollection.size(); ++i) {
            CreditFinancingReduceInfo creditFinancingReduceInfo = reduceCollection.get(i);
            if (creditFinancingReduceInfo.getFinPro() == null) continue;
            finProSet.add(creditFinancingReduceInfo.getFinPro().getId().toString());
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.getSelector().add("CreditLimit.*");
        evi.getSelector().add("CreditLimit.entrys.*");
        evi.getSelector().add("finPro.id");
        evi.getSelector().add("company.*");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("BillId", (Object)finBillId));
        filterInfo.getFilterItems().add(new FilterItemInfo("IsUnioned", (Object)"0"));
        filterInfo.getFilterItems().add(new FilterItemInfo("Company.id", (Object)finBillInfo.getCompany().getId()));
        if (finProSet != null && finProSet.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("finPro.id", finProSet, CompareType.INCLUDE));
        }
        evi.setFilter(filterInfo);
        CreditLimitUsedCollection coll = CreditLimitUsedFactory.getLocalInstance(ctx).getCreditLimitUsedCollection(evi);
        return coll;
    }

    private void deleteCreditLimitUsed(Context ctx, BOSUuid finBillId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("BillId", (Object)finBillId));
        filter.getFilterItems().add(new FilterItemInfo("returnedQuota", (Object)Constants.ZERO));
        CreditLimitUsedFactory.getLocalInstance(ctx).delete(filter);
    }

    private void updateCreditInfoCancelLimit(Context ctx, CreditLimitInfo creditLimitInfo, BigDecimal amount, CreditLimitUsedCollection usedCollection) throws BOSException, EASBizException {
        String creditLimitId = creditLimitInfo.getId().toString();
        String hsql = "UPDATE T_FIN_CreditLimit SET FBalance = FBalance - ?  WHERE FID = ?";
        FMHelper.execute((Context)ctx, (String)hsql, (Object[])new Object[]{amount.negate(), creditLimitId});
        String csql = "UPDATE T_FIN_CreditLimit SET FUsedAmount=FQuotaAmount-FBalance WHERE FID=?";
        DbUtil.execute((Context)ctx, (String)csql, (Object[])new Object[]{creditLimitId});
        String dsql = "UPDATE T_FIN_CreditLimitEntry SET FBanlance = FBanlance - ? WHERE FParentID = ? and FFinProID =? and FShareOrgID = ? and FControlWay = 0";
        for (int i = 0; i < usedCollection.size(); ++i) {
            CreditLimitUsedInfo usedInfo = usedCollection.get(i);
            String finProId = "";
            if (!EmptyUtil.isEmpty((CoreBaseInfo)usedInfo.getFinPro())) {
                finProId = usedInfo.getFinPro().getId().toString();
            }
            FMHelper.execute((Context)ctx, (String)dsql, (Object[])new Object[]{usedInfo.getUsedQuota().negate(), usedInfo.getCreditLimit().getId().toString(), finProId, usedInfo.getCompany().getId().toString()});
        }
        this.updateLimitState(ctx, creditLimitId);
    }

    private void updateLetterCreditInfoCancelLimit(Context ctx, CreditLimitInfo creditLimitInfo, BigDecimal amount, CreditLimitUsedCollection usedCollection) throws BOSException, EASBizException {
        String creditLimitId = creditLimitInfo.getId().toString();
        String hsql = "UPDATE T_FIN_CreditLimit SET FBalance = FBalance - ?  WHERE FID = ?";
        FMHelper.execute((Context)ctx, (String)hsql, (Object[])new Object[]{amount.negate(), creditLimitId});
        String csql = "UPDATE T_FIN_CreditLimit SET FUsedAmount=FQuotaAmount-FBalance WHERE FID=?";
        DbUtil.execute((Context)ctx, (String)csql, (Object[])new Object[]{creditLimitId});
        String dsql = "UPDATE T_FIN_CreditLimitEntry SET FBanlance = FBanlance - ? WHERE FParentID = ? and FFinProID =? and FShareOrgID = ? and FControlWay = 0";
        for (int i = 0; i < usedCollection.size(); ++i) {
            CreditLimitUsedInfo usedInfo = usedCollection.get(i);
            String finProId = "";
            if (!EmptyUtil.isEmpty((CoreBaseInfo)usedInfo.getFinPro())) {
                finProId = usedInfo.getFinPro().getId().toString();
            }
            FMHelper.execute((Context)ctx, (String)dsql, (Object[])new Object[]{usedInfo.getUsedQuota().subtract(usedInfo.getReturnedQuota()).negate(), usedInfo.getCreditLimit().getId().toString(), finProId, usedInfo.getCompany().getId().toString()});
        }
        this.updateLimitState(ctx, creditLimitId);
    }

    private BigDecimal sumUsedQuota(CreditLimitUsedCollection usedCollection) {
        BigDecimal sum = Constants.ZERO;
        for (int i = 0; i < usedCollection.size(); ++i) {
            sum = sum.add(usedCollection.get(i).getUsedQuota());
        }
        return sum;
    }

    private BigDecimal sumLetterUsedQuota(CreditLimitUsedCollection usedCollection) {
        BigDecimal sum = Constants.ZERO;
        for (int i = 0; i < usedCollection.size(); ++i) {
            sum = sum.add(usedCollection.get(i).getUsedQuota().subtract(usedCollection.get(i).getReturnedQuota()));
        }
        return sum;
    }

    public void updateLimitByFinancingProduct(Context ctx, FinancingBillInfo finBillInfo, RepaymentInfo repaymentInfo, BigDecimal amount, boolean isReturned, boolean isRepayment) throws EASBizException, BOSException {
        if (amount == null || amount.compareTo(Constants.ZERO) == 0) {
            return;
        }
        if (isReturned) {
            CreditLimitUsedCollection usedCollection = this.getCreditLimitUsedCollection(ctx, finBillInfo.getId(), finBillInfo);
            if (usedCollection == null || usedCollection.size() <= 0) {
                return;
            }
            this.updateCreditLimitInfo(ctx, finBillInfo, amount, usedCollection);
            this.updateCreditLimitUsed(ctx, finBillInfo, usedCollection, isRepayment);
        } else {
            amount = finBillInfo.getCreditLocalAmt();
            BOSUuid billId = finBillInfo.getId();
            if (isRepayment) {
                amount = repaymentInfo.getReturnedQuota().negate();
                billId = repaymentInfo.getId();
            }
            CreditLimitInfo creditLimitInfo = this.getCreditLimitInfo(ctx, finBillInfo.getCreditLimit().getId());
            CreditFinancingReduceCollection reduceCollection = this.getReduceCollection(ctx, finBillInfo.getCompany().getId(), finBillInfo.getCreditLimit().getId(), finBillInfo.getId());
            reduceCollection = this.reBuildReduceCollection(ctx, reduceCollection, finBillInfo, creditLimitInfo, amount);
            this.deleteCreditLimitUsed(ctx, billId.toString());
            CreditLimitUsedCollection usedCollection = this.recordUsedInfo(ctx, amount, billId, creditLimitInfo, finBillInfo, reduceCollection, isRepayment);
            this.updateCreditInfoUseLimit(ctx, creditLimitInfo, amount, usedCollection);
            if (isRepayment) {
                this.updateCreditLimitUsed(ctx, finBillInfo, usedCollection, isRepayment);
            }
        }
    }

    private void updateCreditLimitInfo(Context ctx, FinancingBillInfo finBillInfo, BigDecimal amount, CreditLimitUsedCollection usedCollection) throws BOSException, EASBizException {
        String hsql = "UPDATE T_FIN_CreditLimit SET FBalance=FBalance+?, FUsedAmount=FUsedAmount-? WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)hsql, (Object[])new Object[]{amount, amount, finBillInfo.getCreditLimit().getId().toString()});
        String dsql = "UPDATE T_FIN_CreditLimitEntry SET FBanlance=FBanlance+? WHERE FParentID = ? and FFinProID =? and FShareOrgID = ? and FControlWay = 0";
        for (int i = 0; i < usedCollection.size(); ++i) {
            CreditLimitUsedInfo usedInfo = usedCollection.get(i);
            String finProId = "";
            if (!EmptyUtil.isEmpty((CoreBaseInfo)usedInfo.getFinPro())) {
                finProId = usedInfo.getFinPro().getId().toString();
            }
            FMHelper.execute((Context)ctx, (String)dsql, (Object[])new Object[]{usedInfo.getUsedQuota().subtract(usedInfo.getReturnedQuota()), usedInfo.getCreditLimit().getId().toString(), finProId, usedInfo.getCompany().getId().toString()});
        }
        this.updateLimitState(ctx, finBillInfo.getCreditLimit().getId().toString());
    }

    private void updateCreditLimitUsed(Context ctx, FinancingBillInfo finBillInfo, CreditLimitUsedCollection usedCollection, boolean isRepayment) throws EASBizException, BOSException {
        String sql = "update T_FIN_CreditLimitUsed set FReturnedQuota= FReturnedQuota+? where FBillId=? and  FFinProID = ? and FCompanyID = ? and fcreditlimitid = ?";
        for (int i = 0; i < usedCollection.size(); ++i) {
            CreditLimitUsedInfo usedInfo = usedCollection.get(i);
            String finProId = "";
            if (!EmptyUtil.isEmpty((CoreBaseInfo)usedInfo.getFinPro())) {
                finProId = usedInfo.getFinPro().getId().toString();
            }
            BigDecimal returnedQuota = isRepayment ? usedInfo.getUsedQuota().subtract(usedInfo.getReturnedQuota()).negate() : usedInfo.getUsedQuota().subtract(usedInfo.getReturnedQuota());
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{returnedQuota, finBillInfo.getId().toString(), finProId, usedInfo.getCompany().getId().toString(), finBillInfo.getCreditLimit().getId().toString()});
        }
    }

    private void deleteCreditLimitUsed(Context ctx, String billId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("BillId", (Object)billId));
        CreditLimitUsedFactory.getLocalInstance(ctx).delete(filter);
    }

    private CreditFinancingReduceCollection reBuildReduceCollection(Context ctx, CreditFinancingReduceCollection _coll, FinancingBillInfo finBillInfo, CreditLimitInfo creditLimitInfo, BigDecimal amount) throws EASBizException, BOSException {
        CreditFinancingReduceCollection coll = _coll;
        CreditFinancingReduceInfo reduceInfo = null;
        CreditLimitEntryInfo entryInfo = null;
        BigDecimal balances = Constants.ZERO;
        int maxSeq = 0;
        String companyId = null;
        HashSet<String> idSet = new HashSet<String>();
        int size = _coll.size();
        for (int i = 0; i < size; ++i) {
            reduceInfo = _coll.get(i);
            entryInfo = reduceInfo.getCreditEntry();
            balances = balances.add(entryInfo.getBanlance());
            maxSeq = reduceInfo.getReduceSeq() > maxSeq ? reduceInfo.getReduceSeq() : maxSeq;
            companyId = entryInfo.getShareOrg().getId().toString();
            idSet.add(entryInfo.getId().toString());
        }
        if (balances.compareTo(amount) >= 0) {
            return coll;
        }
        reduceInfo = null;
        entryInfo = null;
        BigDecimal balance = amount.subtract(balances);
        balances = Constants.ZERO;
        CreditLimitEntryCollection entryColl = creditLimitInfo.getEntrys();
        int size2 = entryColl.size();
        for (int i = 0; i < size2; ++i) {
            entryInfo = entryColl.get(i);
            if (!this.isSameCompany(entryInfo, companyId) || idSet.contains(entryInfo.getId().toString()) || balance.compareTo(Constants.ZERO) <= 0) continue;
            reduceInfo = this.newCreditFinReduceInfo(ctx, finBillInfo, entryInfo, balance, ++maxSeq);
            coll.add(reduceInfo);
            balance = balance.subtract(entryInfo.getBanlance());
            balances = balances.add(entryInfo.getBanlance());
        }
        if (balances.compareTo(amount) < 0) {
            throw new FinBizException(FinBizException.CREDITLIMITAMOUNTFULLFILL);
        }
        return coll;
    }

    private boolean isSameCompany(CreditLimitEntryInfo entryInfo, String companyId) {
        return companyId.equals(entryInfo.getShareOrg().getId().toString()) && ControlWayEnum.NO.equals((Object)entryInfo.getControlWay()) && entryInfo.getBanlance().compareTo(Constants.ZERO) > 0;
    }

    private CreditFinancingReduceInfo newCreditFinReduceInfo(Context ctx, FinancingBillInfo finBillInfo, CreditLimitEntryInfo entryInfo, BigDecimal amount, int seq) throws EASBizException, BOSException {
        CreditFinancingReduceInfo reduceInfo = new CreditFinancingReduceInfo();
        reduceInfo.setBillID(finBillInfo.getId());
        reduceInfo.setCreditLimitID(finBillInfo.getCreditLimit().getId());
        reduceInfo.setCreditEntry(entryInfo);
        reduceInfo.setShareOrg(entryInfo.getShareOrg());
        reduceInfo.setFinPro(entryInfo.getFinPro());
        reduceInfo.setCreditEntry(entryInfo);
        reduceInfo.setAssignAmt(entryInfo.getSharedAmount());
        reduceInfo.setUsedAmt(amount);
        reduceInfo.setBalance(reduceInfo.getAssignAmt().subtract(reduceInfo.getUsedAmt()));
        reduceInfo.setReduceSeq(seq);
        reduceInfo.setControlWay(ControlWayEnum.NO);
        reduceInfo.setIsUnion(false);
        CreditFinancingReduceFactory.getLocalInstance(ctx).submit(reduceInfo);
        return reduceInfo;
    }
}

