/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fm.bond.BondReleaseReportInfo;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeFactory;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeInfo;
import com.kingdee.eas.fm.fin.CreditLimitEntryInfo;
import com.kingdee.eas.fm.fin.CreditLimitFactory;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.CreditLimitStatusEnum;
import com.kingdee.eas.fm.fin.CreditLimitUsedCollection;
import com.kingdee.eas.fm.fin.CreditLimitUsedFactory;
import com.kingdee.eas.fm.fin.CreditLimitUsedInfo;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LimitIsBankCreditEnum;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.ShareTypeEnum;
import com.kingdee.eas.fm.fin.app.AbstractCreditLimitManagerControllerBean;
import com.kingdee.eas.fm.fin.app.CreditLimitEntryGetterHelper;
import com.kingdee.eas.fm.fin.app.CreditLimitManagerByFinancingProduct;
import com.kingdee.eas.fm.fin.app.CreditLimitManagerHelper;
import com.kingdee.eas.fm.ibt.BillRediscountOutInfo;
import com.kingdee.eas.fm.ibt.CreditAssetsTransferOutInfo;
import com.kingdee.eas.fm.ibt.InnerFinancingBorrowingInInfo;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.sl.LoanFetchInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.Map;

public class CreditLimitManagerControllerBean
extends AbstractCreditLimitManagerControllerBean {
    private static ThreadLocal<BigDecimal> oldRetuanQuota = new ThreadLocal<BigDecimal>(){

        @Override
        protected BigDecimal initialValue() {
            return BigDecimal.ZERO;
        }
    };

    @Override
    protected Map _getCreditEntryAfterRetore(Context ctx, BOSUuid billID, BOSUuid creditID) throws BOSException, EASBizException {
        CreditLimitEntryGetterHelper creditLimitEntryGetterHelper = new CreditLimitEntryGetterHelper();
        return creditLimitEntryGetterHelper.getCreditEntryAfterRetore(ctx, billID, creditID);
    }

    @Override
    protected void _useLimitByFinancingProduct(Context ctx, BOSUuid creditLimitID, BigDecimal amount, BOSUuid companyID, BOSUuid finbillID, boolean isRepayment, FinancingBillInfo finBillInfo) throws BOSException, EASBizException {
        CreditLimitManagerByFinancingProduct creditLimitManagerByFinancingProduct = new CreditLimitManagerByFinancingProduct();
        creditLimitManagerByFinancingProduct.useLimitByFinancingProduct(ctx, creditLimitID, amount, companyID, finbillID, isRepayment, finBillInfo);
    }

    @Override
    protected void _useLetterOfCreditLimitByFinancingProduct(Context ctx, BOSUuid creditLimitID, BigDecimal amount, BOSUuid companyID, BOSUuid finbillID, boolean isRepayment, FinancingBillInfo finBillInfo) throws BOSException, EASBizException {
        CreditLimitManagerByFinancingProduct creditLimitManagerByFinancingProduct = new CreditLimitManagerByFinancingProduct();
        creditLimitManagerByFinancingProduct.useLetterOfCreditLimitByFinancingProduct(ctx, creditLimitID, amount, companyID, finbillID, isRepayment, finBillInfo);
    }

    @Override
    protected void _cancelLimitByFinancingProduct(Context ctx, BOSUuid billID, FinancingBillInfo finbill, BigDecimal returnAmt) throws BOSException, EASBizException {
        CreditLimitManagerByFinancingProduct creditLimitManagerByFinancingProduct = new CreditLimitManagerByFinancingProduct();
        creditLimitManagerByFinancingProduct.cancelLimitByFinancingProduct(ctx, billID, finbill, returnAmt);
    }

    @Override
    protected void _cancelLetterOfCreditLimitByFinancingProduct(Context ctx, BOSUuid billID, FinancingBillInfo finbill, BigDecimal returnAmt) throws BOSException, EASBizException {
        CreditLimitManagerByFinancingProduct creditLimitManagerByFinancingProduct = new CreditLimitManagerByFinancingProduct();
        creditLimitManagerByFinancingProduct.cancelLetterOfCreditLimitByFinancingProduct(ctx, billID, finbill, returnAmt);
    }

    private boolean isExistsWithCreditLimitUsed(Context ctx, BOSUuid finBillId, BOSUuid creditLimitId, boolean isCheckIsUnioned) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("BillId", (Object)finBillId));
        if (isCheckIsUnioned) {
            filter.getFilterItems().add(new FilterItemInfo("IsUnioned", (Object)"0"));
        }
        filter.getFilterItems().add(new FilterItemInfo("returnedQuota", (Object)Constants.ZERO, CompareType.NOTEQUALS));
        if (BOSUuid.read((String)finBillId.toString()).getType().equals((Object)new LoanFetchInfo().getBOSType()) || BOSUuid.read((String)finBillId.toString()).getType().equals((Object)new BondReleaseReportInfo().getBOSType())) {
            filter.getFilterItems().add(new FilterItemInfo("CreditLimit.id", (Object)creditLimitId));
        }
        return CreditLimitUsedFactory.getLocalInstance(ctx).exists(filter);
    }

    private void updateCreditInfo(Context ctx, CreditLimitInfo creditLimitInfo, CreditLimitEntryInfo shareEntry, BigDecimal amount) throws BOSException, EASBizException {
        BigDecimal balance = creditLimitInfo.getBalance().subtract(amount).add(oldRetuanQuota.get());
        BigDecimal UsedAmount = creditLimitInfo.getQuotaAmount().subtract(balance);
        String hsql = "UPDATE T_FIN_CreditLimit SET FBalance = ?, FUsedAmount = ? WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)hsql, (Object[])new Object[]{balance, UsedAmount, creditLimitInfo.getId().toString()});
        CreditLimitStatusEnum creditStatus = CreditLimitManagerHelper.getCreditLimitStatus(ctx, creditLimitInfo.getId().toString());
        String ksql = "UPDATE T_FIN_CreditLimit SET FCreditLimitStat = ? WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)ksql, (Object[])new Object[]{new Integer(creditStatus.getValue()), creditLimitInfo.getId().toString()});
        if (!EmptyUtil.isEmpty((CoreBaseInfo)shareEntry)) {
            BigDecimal entryBalance = shareEntry.getBanlance().subtract(amount).add(oldRetuanQuota.get());
            String dsql = "UPDATE T_FIN_CreditLimitEntry SET FBanlance = ? WHERE FID = ?";
            DbUtil.execute((Context)ctx, (String)dsql, (Object[])new Object[]{entryBalance, shareEntry.getId().toString()});
        }
    }

    private void updateLetterCreditInfo(Context ctx, CreditLimitInfo creditLimitInfo, CreditLimitEntryInfo shareEntry, BigDecimal amount, CreditLimitUsedInfo creditLimitUsedInfo) throws BOSException, EASBizException {
        BigDecimal balance = creditLimitInfo.getBalance().subtract(amount).subtract(creditLimitUsedInfo.getReturnedQuota());
        BigDecimal UsedAmount = creditLimitInfo.getQuotaAmount().subtract(balance);
        String hsql = "UPDATE T_FIN_CreditLimit SET FBalance = ?, FUsedAmount = ? WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)hsql, (Object[])new Object[]{balance, UsedAmount, creditLimitInfo.getId().toString()});
        CreditLimitStatusEnum creditStatus = CreditLimitManagerHelper.getCreditLimitStatus(ctx, creditLimitInfo.getId().toString());
        String ksql = "UPDATE T_FIN_CreditLimit SET FCreditLimitStat = ? WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)ksql, (Object[])new Object[]{new Integer(creditStatus.getValue()), creditLimitInfo.getId().toString()});
        if (!EmptyUtil.isEmpty((CoreBaseInfo)shareEntry)) {
            BigDecimal entryBalance = shareEntry.getBanlance().subtract(amount).subtract(creditLimitUsedInfo.getReturnedQuota());
            String dsql = "UPDATE T_FIN_CreditLimitEntry SET FBanlance = ? WHERE FID = ?";
            DbUtil.execute((Context)ctx, (String)dsql, (Object[])new Object[]{entryBalance, shareEntry.getId().toString()});
        }
    }

    @Override
    protected void _useLimit(Context ctx, BOSUuid creditLimitId, BigDecimal amount, BOSUuid companyId, BOSUuid finBillId, boolean isRepayment) throws BOSException, EASBizException {
        if (amount != null && amount.signum() == 0) {
            return;
        }
        if (this.isExistsWithCreditLimitUsed(ctx, finBillId, creditLimitId, false)) {
            return;
        }
        CreditLimitManagerHelper.verify4UseLimit(creditLimitId, amount, companyId, finBillId);
        this._cancelLimit(ctx, finBillId, creditLimitId);
        CreditLimitInfo creditLimitInfo = CreditLimitFactory.getLocalInstance(ctx).getCreditLimitInfo((IObjectPK)new ObjectUuidPK(creditLimitId));
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        CreditLimitFactory.getLocalInstance(ctx).addCreditLimitEntry(creditLimitInfo, companyInfo);
        CreditLimitEntryInfo shareEntry = FinUtils.getOrgEntry(ctx, creditLimitInfo, companyId);
        this.checkAmount(amount, creditLimitInfo, shareEntry, isRepayment);
        this.addnewCreditLimitUsedInfo(ctx, amount, finBillId, creditLimitInfo);
        this.updateCreditInfo(ctx, creditLimitInfo, shareEntry, amount);
    }

    @Override
    protected void _useLetterLimit(Context ctx, BOSUuid creditLimitId, BigDecimal amount, BOSUuid companyId, BOSUuid finBillId, boolean isRepayment) throws BOSException, EASBizException {
        if (amount != null && amount.signum() == 0) {
            return;
        }
        CreditLimitManagerHelper.verify4UseLimit(creditLimitId, amount, companyId, finBillId);
        CreditLimitInfo creditLimitInfo = CreditLimitFactory.getLocalInstance(ctx).getCreditLimitInfo((IObjectPK)new ObjectUuidPK(creditLimitId));
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        CreditLimitFactory.getLocalInstance(ctx).addCreditLimitEntry(creditLimitInfo, companyInfo);
        CreditLimitEntryInfo shareEntry = FinUtils.getOrgEntry(ctx, creditLimitInfo, companyId);
        this.checkAmount(amount, creditLimitInfo, shareEntry, isRepayment);
        BillBaseInfo finBillInfo = (BillBaseInfo)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(finBillId.toString());
        CreditLimitUsedInfo newUsedInfo = this.buildLetterCreditLimitUsedInfo(ctx, amount, finBillId, finBillInfo, creditLimitInfo);
        CreditLimitUsedFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)newUsedInfo);
        this.updateCreditInfo(ctx, creditLimitInfo, shareEntry, amount);
        oldRetuanQuota.remove();
    }

    private void checkAmount(BigDecimal amount, CreditLimitInfo creditLimitInfo, CreditLimitEntryInfo shareEntry, boolean isRepayment) throws FinBizException {
        if (EmptyUtil.isEmpty((CoreBaseInfo)shareEntry)) {
            return;
        }
        ShareTypeEnum shareType = creditLimitInfo.getShareType();
        BigDecimal banlance = null;
        banlance = shareType.equals((Object)ShareTypeEnum.ASSIGN) ? shareEntry.getBanlance() : creditLimitInfo.getBalance();
        if (!(isRepayment || banlance.compareTo(Constants.ZERO) >= 0 && amount.compareTo(banlance) <= 0)) {
            throw new FinBizException(FinBizException.CREDITLIMITAMOUNTFULLFILL);
        }
    }

    private void addnewCreditLimitUsedInfo(Context ctx, BigDecimal amount, BOSUuid finBillId, CreditLimitInfo creditLimitInfo) throws BOSException, EASBizException {
        BillBaseInfo finBillInfo = (BillBaseInfo)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(finBillId.toString());
        CreditLimitUsedInfo newUsedInfo = this.buildCreditLimitUsedInfo(ctx, amount, finBillId, finBillInfo, creditLimitInfo);
        CreditLimitUsedFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)newUsedInfo);
    }

    private CreditLimitUsedInfo buildCreditLimitUsedInfo(Context ctx, BigDecimal amount, BOSUuid finBillId, BillBaseInfo finBillInfo, CreditLimitInfo creditLimitInfo) throws EASBizException, BOSException {
        CreditLimitUsedInfo newUsedInfo = new CreditLimitUsedInfo();
        newUsedInfo.setCreditLimit(creditLimitInfo);
        newUsedInfo.setProperty(creditLimitInfo.getProperty());
        newUsedInfo.setBillId(finBillId.toString());
        newUsedInfo.setBillNumber(finBillInfo.getNumber());
        newUsedInfo.setBillType(finBillInfo.getBOSType().toString());
        newUsedInfo.setCompany(finBillInfo.getCompany());
        if (finBillInfo instanceof PayableBillInfo) {
            newUsedInfo.setCompany(((PayableBillInfo)finBillInfo).getApplyUnit());
        }
        if (finBillInfo instanceof FinancingBillInfo) {
            newUsedInfo.setIssueDate(((FinancingBillInfo)finBillInfo).getIssueDate());
            newUsedInfo.setExpiredDate(((FinancingBillInfo)finBillInfo).getExpiredDate());
        }
        newUsedInfo.setUsedQuota(amount);
        newUsedInfo.setReturnedQuota(SysConstant.BIGZERO);
        newUsedInfo.setCreateTime(DateUtil.getTimeStampDayBegin());
        newUsedInfo.setCreator((UserInfo)ctx.get((Object)"UserInfo"));
        newUsedInfo.setLastUpdateTime(DateUtil.getTimeStampDayBegin());
        newUsedInfo.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        newUsedInfo.setCurrency(creditLimitInfo.getCurrency());
        newUsedInfo.setCreditUsage(creditLimitInfo.getCreditUsage());
        if (finBillInfo instanceof PayableBillInfo || finBillInfo instanceof LetterOfCreditInfo || finBillInfo instanceof LetterOfGuaranteeInfo || finBillInfo instanceof InnerFinancingBorrowingInInfo || finBillInfo instanceof BillRediscountOutInfo || finBillInfo instanceof CreditAssetsTransferOutInfo || finBillInfo instanceof BondReleaseReportInfo) {
            newUsedInfo.setUsingBank(((FinancingBillInfo)finBillInfo).getInstitution());
            newUsedInfo.setFinPro(((FinancingBillInfo)finBillInfo).getType());
        } else if (finBillInfo instanceof LoanInfo) {
            LoanInfo infoLoan = (LoanInfo)finBillInfo;
            if (creditLimitInfo.getIsBankCredit() == LimitIsBankCreditEnum.INNER) {
                newUsedInfo.setUsingCompany(infoLoan.getGroupID());
            } else {
                newUsedInfo.setUsingBank(((FinancingBillInfo)finBillInfo).getInstitution());
            }
            newUsedInfo.setFinPro(infoLoan.getType());
        } else if (finBillInfo instanceof LoanFetchInfo) {
            LoanFetchInfo fetchInfo = (LoanFetchInfo)finBillInfo;
            for (int i = 0; i < fetchInfo.getLoanBankEntry().size(); ++i) {
                if (EmptyUtil.isEmpty((CoreBaseInfo)fetchInfo.getLoanBankEntry().get(i).getCreditLimit()) || !fetchInfo.getLoanBankEntry().get(i).getCreditLimit().getId().equals((Object)creditLimitInfo.getId())) continue;
                newUsedInfo.setUsingBank(fetchInfo.getLoanBankEntry().get(i).getBank());
                newUsedInfo.setFinPro(((FinancingBillInfo)finBillInfo).getType());
                break;
            }
        } else if (finBillInfo instanceof RepaymentInfo) {
            String sourceID = finBillInfo.getSourceBillId();
            ObjectUuidPK sourcePK = new ObjectUuidPK(sourceID);
            BOSUuid id = BOSUuid.read((String)sourceID);
            LetterOfCreditInfo loc = new LetterOfCreditInfo();
            LoanInfo loani = new LoanInfo();
            PayableBillInfo pbi = new PayableBillInfo();
            LetterOfGuaranteeInfo logi = new LetterOfGuaranteeInfo();
            if (loc.getBOSType().equals((Object)id.getType())) {
                loc = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)sourcePK);
                newUsedInfo.setUsingBank(loc.getInstitution());
                newUsedInfo.setFinPro(loc.getType());
            } else if (loani.getBOSType().equals((Object)id.getType())) {
                loani = LoanFactory.getLocalInstance(ctx).getLoanInfo((IObjectPK)sourcePK);
                if (creditLimitInfo.getIsBankCredit() == LimitIsBankCreditEnum.INNER) {
                    newUsedInfo.setUsingCompany(loani.getGroupID());
                } else {
                    newUsedInfo.setUsingBank(loani.getInstitution());
                }
                newUsedInfo.setFinPro(loani.getType());
            } else if (pbi.getBOSType().equals((Object)id.getType())) {
                pbi = PayableBillFactory.getLocalInstance((Context)ctx).getPayableBillInfo((IObjectPK)sourcePK);
                newUsedInfo.setUsingBank(pbi.getInstitution());
                newUsedInfo.setFinPro(pbi.getType());
            } else if (logi.getBOSType().equals((Object)id.getType())) {
                logi = LetterOfGuaranteeFactory.getLocalInstance((Context)ctx).getLetterOfGuaranteeInfo((IObjectPK)sourcePK);
                newUsedInfo.setUsingBank(logi.getInstitution());
                newUsedInfo.setFinPro(logi.getType());
            }
        }
        return newUsedInfo;
    }

    private CreditLimitUsedInfo buildLetterCreditLimitUsedInfo(Context ctx, BigDecimal amount, BOSUuid finBillId, BillBaseInfo finBillInfo, CreditLimitInfo creditLimitInfo) throws EASBizException, BOSException {
        CreditLimitUsedInfo newUsedInfo = new CreditLimitUsedInfo();
        newUsedInfo.setCreditLimit(creditLimitInfo);
        newUsedInfo.setProperty(creditLimitInfo.getProperty());
        newUsedInfo.setBillId(finBillId.toString());
        newUsedInfo.setBillNumber(finBillInfo.getNumber());
        newUsedInfo.setBillType(finBillInfo.getBOSType().toString());
        newUsedInfo.setCompany(finBillInfo.getCompany());
        if (finBillInfo instanceof PayableBillInfo) {
            newUsedInfo.setCompany(((PayableBillInfo)finBillInfo).getApplyUnit());
        }
        if (finBillInfo instanceof FinancingBillInfo) {
            newUsedInfo.setIssueDate(((FinancingBillInfo)finBillInfo).getIssueDate());
            newUsedInfo.setExpiredDate(((FinancingBillInfo)finBillInfo).getExpiredDate());
        }
        newUsedInfo.setUsedQuota(amount);
        newUsedInfo.setReturnedQuota(oldRetuanQuota.get());
        newUsedInfo.setCreateTime(DateUtil.getTimeStampDayBegin());
        newUsedInfo.setCreator((UserInfo)ctx.get((Object)"UserInfo"));
        newUsedInfo.setLastUpdateTime(DateUtil.getTimeStampDayBegin());
        newUsedInfo.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        newUsedInfo.setCurrency(creditLimitInfo.getCurrency());
        newUsedInfo.setCreditUsage(creditLimitInfo.getCreditUsage());
        if (finBillInfo instanceof PayableBillInfo || finBillInfo instanceof LetterOfCreditInfo || finBillInfo instanceof LetterOfGuaranteeInfo || finBillInfo instanceof InnerFinancingBorrowingInInfo || finBillInfo instanceof BillRediscountOutInfo || finBillInfo instanceof CreditAssetsTransferOutInfo || finBillInfo instanceof BondReleaseReportInfo) {
            newUsedInfo.setUsingBank(((FinancingBillInfo)finBillInfo).getInstitution());
            newUsedInfo.setFinPro(((FinancingBillInfo)finBillInfo).getType());
        } else if (finBillInfo instanceof LoanInfo) {
            LoanInfo infoLoan = (LoanInfo)finBillInfo;
            if (creditLimitInfo.getIsBankCredit() == LimitIsBankCreditEnum.INNER) {
                newUsedInfo.setUsingCompany(infoLoan.getGroupID());
            } else {
                newUsedInfo.setUsingBank(((FinancingBillInfo)finBillInfo).getInstitution());
            }
            newUsedInfo.setFinPro(infoLoan.getType());
        } else if (finBillInfo instanceof LoanFetchInfo) {
            LoanFetchInfo fetchInfo = (LoanFetchInfo)finBillInfo;
            for (int i = 0; i < fetchInfo.getLoanBankEntry().size(); ++i) {
                if (EmptyUtil.isEmpty((CoreBaseInfo)fetchInfo.getLoanBankEntry().get(i).getCreditLimit()) || !fetchInfo.getLoanBankEntry().get(i).getCreditLimit().getId().equals((Object)creditLimitInfo.getId())) continue;
                newUsedInfo.setUsingBank(fetchInfo.getLoanBankEntry().get(i).getBank());
                newUsedInfo.setFinPro(((FinancingBillInfo)finBillInfo).getType());
                break;
            }
        } else if (finBillInfo instanceof RepaymentInfo) {
            String sourceID = finBillInfo.getSourceBillId();
            ObjectUuidPK sourcePK = new ObjectUuidPK(sourceID);
            BOSUuid id = BOSUuid.read((String)sourceID);
            LetterOfCreditInfo loc = new LetterOfCreditInfo();
            LoanInfo loani = new LoanInfo();
            PayableBillInfo pbi = new PayableBillInfo();
            LetterOfGuaranteeInfo logi = new LetterOfGuaranteeInfo();
            if (loc.getBOSType().equals((Object)id.getType())) {
                loc = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)sourcePK);
                newUsedInfo.setUsingBank(loc.getInstitution());
                newUsedInfo.setFinPro(loc.getType());
            } else if (loani.getBOSType().equals((Object)id.getType())) {
                loani = LoanFactory.getLocalInstance(ctx).getLoanInfo((IObjectPK)sourcePK);
                if (creditLimitInfo.getIsBankCredit() == LimitIsBankCreditEnum.INNER) {
                    newUsedInfo.setUsingCompany(loani.getGroupID());
                } else {
                    newUsedInfo.setUsingBank(loani.getInstitution());
                }
                newUsedInfo.setFinPro(loani.getType());
            } else if (pbi.getBOSType().equals((Object)id.getType())) {
                pbi = PayableBillFactory.getLocalInstance((Context)ctx).getPayableBillInfo((IObjectPK)sourcePK);
                newUsedInfo.setUsingBank(pbi.getInstitution());
                newUsedInfo.setFinPro(pbi.getType());
            } else if (logi.getBOSType().equals((Object)id.getType())) {
                logi = LetterOfGuaranteeFactory.getLocalInstance((Context)ctx).getLetterOfGuaranteeInfo((IObjectPK)sourcePK);
                newUsedInfo.setUsingBank(logi.getInstitution());
                newUsedInfo.setFinPro(logi.getType());
            }
        }
        return newUsedInfo;
    }

    @Override
    protected void _cancelLimit(Context ctx, BOSUuid finBillId, BOSUuid creditLimitId) throws BOSException, EASBizException {
        if (this.isExistsWithCreditLimitUsed(ctx, finBillId, creditLimitId, true)) {
            return;
        }
        CreditLimitUsedInfo creditLimitUsedInfo = this.getCreditLimitUsedInfo(ctx, finBillId, creditLimitId);
        if (creditLimitUsedInfo == null) {
            return;
        }
        CreditLimitInfo creditLimitInfo = creditLimitUsedInfo.getCreditLimit();
        if (creditLimitInfo == null) {
            throw new BOSException("id not exists!");
        }
        BigDecimal amount = creditLimitUsedInfo.getUsedQuota();
        this.deleteCreditLimitUsed(ctx, finBillId, creditLimitId);
        BOSUuid companyId = creditLimitUsedInfo.getCompany().getId();
        CreditLimitEntryInfo shareEntry = FinUtils.getOrgEntry(ctx, creditLimitInfo, companyId);
        this.updateCreditInfo(ctx, creditLimitInfo, shareEntry, amount.negate());
    }

    @Override
    protected void _cancelLetterLimit(Context ctx, BOSUuid finBillId, BOSUuid creditLimitId) throws BOSException, EASBizException {
        CreditLimitUsedInfo creditLimitUsedInfo = this.getCreditLimitUsedInfo(ctx, finBillId, creditLimitId);
        if (creditLimitUsedInfo == null) {
            return;
        }
        CreditLimitInfo creditLimitInfo = creditLimitUsedInfo.getCreditLimit();
        if (creditLimitInfo == null) {
            throw new BOSException("id not exists!");
        }
        oldRetuanQuota.set(creditLimitUsedInfo.getReturnedQuota());
        BigDecimal amount = creditLimitUsedInfo.getUsedQuota();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("BillId", (Object)finBillId));
        if (BOSUuid.read((String)finBillId.toString()).getType().equals((Object)new LoanFetchInfo().getBOSType()) || BOSUuid.read((String)finBillId.toString()).getType().equals((Object)new BondReleaseReportInfo().getBOSType())) {
            filter.getFilterItems().add(new FilterItemInfo("CreditLimit.id", (Object)creditLimitId));
        }
        CreditLimitUsedFactory.getLocalInstance(ctx).delete(filter);
        BOSUuid companyId = creditLimitUsedInfo.getCompany().getId();
        CreditLimitEntryInfo shareEntry = FinUtils.getOrgEntry(ctx, creditLimitInfo, companyId);
        this.updateLetterCreditInfo(ctx, creditLimitInfo, shareEntry, amount.negate(), creditLimitUsedInfo);
    }

    private CreditLimitUsedInfo getCreditLimitUsedInfo(Context ctx, BOSUuid finBillId, BOSUuid creditLimitId) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("BillId", (Object)finBillId));
        filterInfo.getFilterItems().add(new FilterItemInfo("IsUnioned", (Object)"0"));
        if (BOSUuid.read((String)finBillId.toString()).getType().equals((Object)new LoanFetchInfo().getBOSType()) || BOSUuid.read((String)finBillId.toString()).getType().equals((Object)new BondReleaseReportInfo().getBOSType())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("CreditLimit.id", (Object)creditLimitId));
        }
        ev.setFilter(filterInfo);
        ev.getSelector().add("*");
        ev.getSelector().add("CreditLimit.*");
        ev.getSelector().add("CreditLimit.entrys.*");
        ev.getSelector().add("company.*");
        CreditLimitUsedCollection coll = CreditLimitUsedFactory.getLocalInstance(ctx).getCreditLimitUsedCollection(ev);
        if (coll != null && coll.size() == 1) {
            return coll.get(0);
        }
        if (coll.size() <= 0) {
            return null;
        }
        return null;
    }

    private void deleteCreditLimitUsed(Context ctx, BOSUuid finBillId, BOSUuid creditLimitId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("BillId", (Object)finBillId));
        filter.getFilterItems().add(new FilterItemInfo("returnedQuota", (Object)Constants.ZERO));
        if (BOSUuid.read((String)finBillId.toString()).getType().equals((Object)new LoanFetchInfo().getBOSType()) || BOSUuid.read((String)finBillId.toString()).getType().equals((Object)new BondReleaseReportInfo().getBOSType())) {
            filter.getFilterItems().add(new FilterItemInfo("CreditLimit.id", (Object)creditLimitId));
        }
        CreditLimitUsedFactory.getLocalInstance(ctx).delete(filter);
    }

    @Override
    protected void _useLimit(Context ctx, BOSUuid creditLimitId, BigDecimal amount, BOSUuid companyId, BOSUuid finBillId, boolean isRepayment, boolean isPayable) throws BOSException, EASBizException {
        if (this.isExistsWithCreditLimitUsed(ctx, finBillId, creditLimitId, false)) {
            return;
        }
        CreditLimitManagerHelper.verify4UseLimit(creditLimitId, amount, companyId, finBillId);
        this._cancelLimit(ctx, finBillId, creditLimitId);
        CreditLimitInfo creditLimitInfo = CreditLimitFactory.getLocalInstance(ctx).getCreditLimitInfo((IObjectPK)new ObjectUuidPK(creditLimitId));
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        CreditLimitFactory.getLocalInstance(ctx).addCreditLimitEntry(creditLimitInfo, companyInfo);
        CreditLimitEntryInfo shareEntry = FinUtils.getOrgEntry(ctx, creditLimitInfo, companyId);
        this.checkAmount(amount, creditLimitInfo, shareEntry, isRepayment);
        this.addnewCreditLimitUsedInfo(ctx, amount, finBillId, creditLimitInfo);
        this.updateCreditInfo(ctx, creditLimitInfo, shareEntry, amount);
    }
}

