/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fm.fin.CreditLimitFactory;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.CreditLimitStatusEnum;
import com.kingdee.eas.fm.fin.CreditLimitUsedCollection;
import com.kingdee.eas.fm.fin.CreditLimitUsedFactory;
import com.kingdee.eas.fm.fin.FinBizException;
import java.math.BigDecimal;

public class CreditLimitManagerHelper {
    public static CreditLimitUsedCollection getUsedCol(Context ctx, BOSUuid billID, CreditLimitInfo creditLimitInfo) throws EASBizException, BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("CreditLimit.id", (Object)creditLimitInfo.getId().toString()));
        f.getFilterItems().add(new FilterItemInfo("BillId", (Object)billID.toString()));
        evi.setFilter(f);
        return CreditLimitUsedFactory.getLocalInstance(ctx).getCreditLimitUsedCollection(evi);
    }

    public static CreditLimitStatusEnum getCreditLimitStatus(Context ctx, String id) throws BOSException, EASBizException {
        CreditLimitInfo clInfo = CreditLimitFactory.getLocalInstance(ctx).getCreditLimitInfo((IObjectPK)new ObjectUuidPK(id));
        BigDecimal bdAmount = clInfo.getQuotaAmount();
        BigDecimal bdBalance = clInfo.getBalance();
        CreditLimitStatusEnum state = null;
        if (bdBalance.compareTo(bdAmount) == 0 && !clInfo.isIsClosed()) {
            state = CreditLimitStatusEnum.INEFFECTIVE;
        } else if (bdBalance.compareTo(SysConstant.BIGZERO) > 0 && bdBalance.compareTo(bdAmount) != 0 && !clInfo.isIsClosed() || bdBalance.compareTo(SysConstant.BIGZERO) < 0 && bdBalance.compareTo(bdAmount) != 0 && !clInfo.isIsClosed() && clInfo.isIsUnion()) {
            state = CreditLimitStatusEnum.EFFECTIVE;
        } else if (bdBalance.compareTo(SysConstant.BIGZERO) == 0 || clInfo.isIsClosed()) {
            state = CreditLimitStatusEnum.EXPIRED;
        } else {
            throw new FinBizException(FinBizException.CREDITLIMITAMOUNTFULLFILL);
        }
        return state;
    }

    static void verify4UseLimit(BOSUuid creditLimitId, BigDecimal amount, BOSUuid companyId, BOSUuid finBillId) throws FinBizException {
        if (EmptyUtil.isEmpty((Object)creditLimitId)) {
            throw new FinBizException(FinBizException.CREDITLIMITISNULL);
        }
        if (EmptyUtil.isEmpty((Object)companyId)) {
            throw new FinBizException(FinBizException.COMPANYISNULL);
        }
        if (EmptyUtil.isEmpty((Object)finBillId)) {
            throw new FinBizException(FinBizException.FINBILLISNULL);
        }
    }
}

