/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeCollection;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeFactory;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeInfo;
import com.kingdee.eas.fm.fin.CreditFinancingReduceCollection;
import com.kingdee.eas.fm.fin.CreditFinancingReduceFactory;
import com.kingdee.eas.fm.fin.CreditFinancingReduceInfo;
import com.kingdee.eas.fm.fin.CreditLimitCollection;
import com.kingdee.eas.fm.fin.CreditLimitEntryCollection;
import com.kingdee.eas.fm.fin.CreditLimitEntryInfo;
import com.kingdee.eas.fm.fin.CreditLimitFactory;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.CreditLimitUsedCollection;
import com.kingdee.eas.fm.fin.CreditLimitUsedFactory;
import com.kingdee.eas.fm.fin.CreditLimitUsedInfo;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.LetterOfCreditCollection;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LimitIsBankCreditEnum;
import com.kingdee.eas.fm.fin.LoanCollection;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.RepaymentCollection;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.ShareTypeEnum;
import com.kingdee.eas.fm.fin.app.AbstractCreditLimitRepairFacadeControllerBean;
import com.kingdee.eas.fm.fin.util.ReduceSeqSorter;
import com.kingdee.eas.fm.ibt.BillRediscountOutInfo;
import com.kingdee.eas.fm.ibt.CreditAssetsTransferOutInfo;
import com.kingdee.eas.fm.ibt.InnerFinancingBorrowingInInfo;
import com.kingdee.eas.fm.nt.PayableBillCollection;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CreditLimitRepairFacadeControllerBean
extends AbstractCreditLimitRepairFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.CreditLimitRepairFacadeControllerBean");
    static String bosTypeOfLoan = new LoanInfo().getBOSType().toString();
    static String bosTypeOfLetterOfCredit = new LetterOfCreditInfo().getBOSType().toString();
    static String bosTypeOfPayableBill = new PayableBillInfo().getBOSType().toString();
    static String bosTypeOfLetterOfGuarantee = new LetterOfGuaranteeInfo().getBOSType().toString();
    static final String NOT_HAVE_USED = "not_have_used";
    static final String USEDQUOTA_NOT_CORRECT = "usedquota_not_correct";
    static final String RETURNEDQUOTA_NOT_CORRECT = "returnedquota_not_correct";
    static final String BOTH_NOT_CORRECT = "both_not_correct";

    @Override
    protected Map _checkCreditLimit(Context ctx) throws BOSException, EASBizException {
        HashMap<CreditLimitInfo, Map> results = new HashMap<CreditLimitInfo, Map>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Boolean(true), CompareType.NOTEQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("usedAmount");
        sic.add("quotaAmount");
        sic.add("balance");
        sic.add("company.name");
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.setSelector(sic);
        CreditLimitCollection creditLimitColl = CreditLimitFactory.getLocalInstance(ctx).getCreditLimitCollection(view);
        for (int i = 0; i < creditLimitColl.size(); ++i) {
            CreditLimitInfo creditLimit = creditLimitColl.get(i);
            Map result = this.checkCreditLimit(ctx, creditLimit);
            if (result.size() <= 0) continue;
            results.put(creditLimit, result);
        }
        return results;
    }

    private Map checkCreditLimit(Context ctx, CreditLimitInfo creditLimit) throws BOSException, EASBizException {
        LetterOfGuaranteeCollection letterOfGuaranteeColl;
        Map letterOfGuaranteeResultMap;
        PayableBillCollection payableBillColl;
        Map payableBillResultMap;
        LetterOfCreditCollection letterOfCreditColl;
        Map letterOfCreditResultMap;
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("CreditLimit", (Object)creditLimit.getId().toString()));
        FilterInfo filter2 = new FilterInfo();
        filter2.getFilterItems().add(new FilterItemInfo("BillType", (Object)"18180D81", CompareType.NOTEQUALS));
        filter2.getFilterItems().add(new FilterItemInfo("BillType", (Object)"5BE5C252", CompareType.NOTEQUALS));
        filter2.mergeFilter(filter1, "AND");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("creditLimit.*");
        sic.add("creditLimit.creditUsage.*");
        EntityViewInfo view1 = new EntityViewInfo();
        view1.setFilter(filter1);
        view1.setSelector(sic);
        EntityViewInfo view2 = new EntityViewInfo();
        view2.setFilter(filter2);
        CreditLimitUsedCollection usedColl = CreditLimitUsedFactory.getLocalInstance(ctx).getCreditLimitUsedCollection(view2);
        BigDecimal sumUsedInFactQuota = this.getSumUsedInFactQuota(usedColl).setScale(4, 4);
        if (sumUsedInFactQuota.equals(creditLimit.getUsedAmount().setScale(4, 4))) {
            return result;
        }
        Map usedCollsOfFinType = this.resolveUsedColl(ctx, usedColl);
        CreditLimitUsedCollection usedCollsOfLoan = (CreditLimitUsedCollection)((Object)usedCollsOfFinType.get(bosTypeOfLoan));
        CreditLimitUsedCollection usedCollsOfLetterOfCredit = (CreditLimitUsedCollection)((Object)usedCollsOfFinType.get(bosTypeOfLetterOfCredit));
        CreditLimitUsedCollection usedCollsOfPayableBill = (CreditLimitUsedCollection)((Object)usedCollsOfFinType.get(bosTypeOfPayableBill));
        CreditLimitUsedCollection usedCollsOfLetterOfGuarantee = (CreditLimitUsedCollection)((Object)usedCollsOfFinType.get(bosTypeOfLetterOfGuarantee));
        RepaymentCollection repayColl = this.getRepaymentColl(ctx, creditLimit.getId().toString());
        LoanCollection loanColl = LoanFactory.getLocalInstance(ctx).getLoanCollection(view1);
        Map loanResultMap = this.checkUsedCollByBillType(ctx, loanColl, usedCollsOfLoan, repayColl, bosTypeOfLoan);
        if (loanResultMap != null) {
            this.mergeResultMap(result, loanResultMap);
        }
        if ((letterOfCreditResultMap = this.checkUsedCollByBillType(ctx, letterOfCreditColl = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditCollection(view1), usedCollsOfLetterOfCredit, repayColl, bosTypeOfLetterOfCredit)) != null) {
            this.mergeResultMap(result, letterOfCreditResultMap);
        }
        if ((payableBillResultMap = this.checkUsedCollByBillType(ctx, (AbstractObjectCollection)(payableBillColl = PayableBillFactory.getLocalInstance((Context)ctx).getPayableBillCollection(view1)), usedCollsOfPayableBill, repayColl, bosTypeOfPayableBill)) != null) {
            this.mergeResultMap(result, payableBillResultMap);
        }
        if ((letterOfGuaranteeResultMap = this.checkUsedCollByBillType(ctx, (AbstractObjectCollection)(letterOfGuaranteeColl = LetterOfGuaranteeFactory.getLocalInstance((Context)ctx).getLetterOfGuaranteeCollection(view1)), usedCollsOfLetterOfGuarantee, repayColl, bosTypeOfLetterOfGuarantee)) != null) {
            this.mergeResultMap(result, letterOfGuaranteeResultMap);
        }
        if (result.size() != 0) {
            CreditLimitUsedCollection correctUsedColl = this.getCorrctUsedColl(result, usedColl);
            sumUsedInFactQuota = this.getSumUsedInFactQuota(correctUsedColl);
        }
        result.put("sumUsedInFactQuota", sumUsedInFactQuota);
        return result;
    }

    private RepaymentCollection getRepaymentColl(Context ctx, String creditLimitId) throws BOSException {
        String id = creditLimitId;
        HashSet<String> idSet = new HashSet<String>();
        while (id != null) {
            idSet.add(id);
            id = this.getUnionCreditLimitId(ctx, id);
        }
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("CreditLimit", idSet, CompareType.INCLUDE));
        EntityViewInfo view1 = new EntityViewInfo();
        view1.setFilter(filter1);
        return RepaymentFactory.getLocalInstance(ctx).getRepaymentCollection(view1);
    }

    private String getUnionCreditLimitId(Context ctx, String id) throws BOSException {
        String strsql = "select FSrcObjectID from T_BOT_Relation where FDestEntityID='B57D51D0' and FSrcEntityID='B57D51D0' and  FDestObjectID = '" + id + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strsql);
        try {
            if (rs.next()) {
                String FSrcObjectID = rs.getString("FSrcObjectID").toString();
                return FSrcObjectID;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return null;
    }

    private CreditLimitUsedCollection getCorrctUsedColl(Map result, CreditLimitUsedCollection usedColl) {
        Set entrySet = ((Map)result.get("correctMap")).entrySet();
        for (Map.Entry entry : entrySet) {
            Object correctInfo = entry.getKey();
            CreditLimitUsedInfo errorInfo = (CreditLimitUsedInfo)entry.getValue();
            if (correctInfo instanceof CreditLimitUsedInfo) {
                if (errorInfo == null) {
                    usedColl.add((CreditLimitUsedInfo)correctInfo);
                    continue;
                }
                for (int i = 0; i < usedColl.size(); ++i) {
                    CreditLimitUsedInfo oldUsedInfo = usedColl.get(i);
                    if (!errorInfo.equals(oldUsedInfo)) continue;
                    oldUsedInfo = (CreditLimitUsedInfo)correctInfo;
                }
            }
            if (!(correctInfo instanceof CreditLimitUsedCollection)) continue;
            for (int j = 0; j < ((CreditLimitUsedCollection)((Object)correctInfo)).size(); ++j) {
                CreditLimitUsedInfo usedInfo = ((CreditLimitUsedCollection)((Object)correctInfo)).get(j);
                usedColl.add(usedInfo);
            }
        }
        return usedColl;
    }

    private void mergeResultMap(Map result, Map finResultMap) {
        if (result.size() != 0) {
            Map errorTypeMap1 = (Map)result.get("errorTypeMap");
            Map errorMap1 = (Map)result.get("errorMap");
            Map correctMap1 = (Map)result.get("correctMap");
            Map errorTypeMap2 = (Map)finResultMap.get("errorTypeMap");
            Map errorMap2 = (Map)finResultMap.get("errorMap");
            Map correctMap2 = (Map)finResultMap.get("correctMap");
            errorTypeMap1.putAll(errorTypeMap2);
            errorMap1.putAll(errorMap2);
            correctMap1.putAll(correctMap2);
            result.put("errorTypeMap", errorTypeMap1);
            result.put("errorMap", errorMap1);
            result.put("correctMap", correctMap1);
        } else {
            result.putAll(finResultMap);
        }
    }

    private BigDecimal getSumUsedInFactQuota(CreditLimitUsedCollection usedColl) {
        BigDecimal sumUsedQuota = FMConstants.ZERO;
        BigDecimal sumReturnedQuota = FMConstants.ZERO;
        BigDecimal sumUsedInFactQuota = FMConstants.ZERO;
        for (int i = 0; i < usedColl.size(); ++i) {
            CreditLimitUsedInfo usedInfo = usedColl.get(i);
            sumUsedQuota = sumUsedQuota.add(usedInfo.getUsedQuota());
            sumReturnedQuota = sumReturnedQuota.add(usedInfo.getReturnedQuota());
        }
        sumUsedInFactQuota = sumUsedQuota.subtract(sumReturnedQuota);
        return sumUsedInFactQuota;
    }

    private Map resolveUsedColl(Context ctx, CreditLimitUsedCollection usedColl) {
        CreditLimitUsedCollection usedCollsOfLoan = new CreditLimitUsedCollection();
        CreditLimitUsedCollection usedCollsOfLetterOfCredit = new CreditLimitUsedCollection();
        CreditLimitUsedCollection usedCollsOfPayableBill = new CreditLimitUsedCollection();
        CreditLimitUsedCollection usedCollsOfLetterOfGuarantee = new CreditLimitUsedCollection();
        for (int i = 0; i < usedColl.size(); ++i) {
            CreditLimitUsedInfo usedInfo = usedColl.get(i);
            if (bosTypeOfLoan.equals(usedInfo.getBillType())) {
                usedCollsOfLoan.add(usedInfo);
            }
            if (bosTypeOfLetterOfCredit.equals(usedInfo.getBillType())) {
                usedCollsOfLetterOfCredit.add(usedInfo);
            }
            if (bosTypeOfPayableBill.equals(usedInfo.getBillType())) {
                usedCollsOfPayableBill.add(usedInfo);
            }
            if (!bosTypeOfLetterOfGuarantee.equals(usedInfo.getBillType())) continue;
            usedCollsOfLetterOfGuarantee.add(usedInfo);
        }
        HashMap<String, CreditLimitUsedCollection> result = new HashMap<String, CreditLimitUsedCollection>();
        result.put(bosTypeOfLoan, usedCollsOfLoan);
        result.put(bosTypeOfLetterOfCredit, usedCollsOfLetterOfCredit);
        result.put(bosTypeOfPayableBill, usedCollsOfPayableBill);
        result.put(bosTypeOfLetterOfGuarantee, usedCollsOfLetterOfGuarantee);
        return result;
    }

    private Map checkUsedCollByBillType(Context ctx, AbstractObjectCollection finColl, CreditLimitUsedCollection usedColl, RepaymentCollection repayColl, String billType) throws EASBizException, BOSException {
        HashMap<FinancingBillInfo, String> errorTypeMap = new HashMap<FinancingBillInfo, String>();
        HashMap<FinancingBillInfo, CreditLimitUsedInfo> errorMap = new HashMap<FinancingBillInfo, CreditLimitUsedInfo>();
        HashMap<Object, CreditLimitUsedInfo> correctMap = new HashMap<Object, CreditLimitUsedInfo>();
        for (int i = 0; i < finColl.size(); ++i) {
            BigDecimal repayAmount;
            FinancingBillInfo finInfo = (FinancingBillInfo)finColl.getObject(i);
            if (billType.equals(bosTypeOfLoan) && finInfo.isHistoryBill()) continue;
            CreditLimitUsedInfo usedInfo = this.getUsedInfo(usedColl, finInfo.getId().toString());
            if (usedInfo == null) {
                errorTypeMap.put(finInfo, NOT_HAVE_USED);
                errorMap.put(finInfo, null);
                Object newUsedInfo = this.createNewUsedInfo(ctx, finInfo);
                correctMap.put(newUsedInfo, null);
                continue;
            }
            CreditLimitUsedInfo oldUsedInfo = (CreditLimitUsedInfo)usedInfo.clone();
            BigDecimal creditAmt = this.calCreditLocalAmt(finInfo).setScale(4, 4);
            if (!creditAmt.equals(usedInfo.getUsedQuota().setScale(4, 4))) {
                usedInfo.setUsedQuota(creditAmt);
                errorTypeMap.put(finInfo, USEDQUOTA_NOT_CORRECT);
                errorMap.put(finInfo, usedInfo);
                correctMap.put(usedInfo, oldUsedInfo);
            }
            if ((repayAmount = this.getRepayAmount(repayColl, finInfo.getId().toString()).setScale(4, 4)).compareTo(usedInfo.getReturnedQuota().setScale(4, 4)) == 0) continue;
            usedInfo.setReturnedQuota(repayAmount);
            if (errorTypeMap.containsKey(finInfo)) {
                errorTypeMap.put(finInfo, BOTH_NOT_CORRECT);
            } else {
                errorTypeMap.put(finInfo, RETURNEDQUOTA_NOT_CORRECT);
            }
            errorMap.put(finInfo, usedInfo);
            correctMap.put(usedInfo, oldUsedInfo);
        }
        HashMap<String, HashMap<Object, Object>> resultMap = new HashMap<String, HashMap<Object, Object>>();
        resultMap.put("errorTypeMap", errorTypeMap);
        resultMap.put("errorMap", errorMap);
        resultMap.put("correctMap", correctMap);
        return resultMap;
    }

    private Object createNewUsedInfo(Context ctx, FinancingBillInfo finBill) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("entrys.*");
        sic.add("entrys.ShareOrg.*");
        sic.add("entrys.finPro.*");
        CreditLimitInfo creditLimitInfo = CreditLimitFactory.getLocalInstance(ctx).getCreditLimitInfo((IObjectPK)new ObjectUuidPK(finBill.getCreditLimit().getId().toString()), sic);
        if (creditLimitInfo.getCreditUsage().isColligateCredit() && creditLimitInfo.getShareType() == ShareTypeEnum.ASSIGN) {
            CreditLimitUsedCollection usedColl = this.createUsedLimitByFinancingProduct(ctx, finBill);
            return usedColl;
        }
        CreditLimitUsedInfo usedInfo = this.createUsedLimit(ctx, finBill);
        return usedInfo;
    }

    private CreditLimitUsedCollection createUsedLimitByFinancingProduct(Context ctx, FinancingBillInfo finBill) throws EASBizException, BOSException {
        BigDecimal creditLocalAmt = this.calCreditLocalAmt(finBill);
        BOSUuid finBillId = finBill.getId();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("entrys.*");
        sic.add("entrys.ShareOrg.*");
        sic.add("entrys.finPro.*");
        CreditLimitInfo creditLimitInfo = CreditLimitFactory.getLocalInstance(ctx).getCreditLimitInfo((IObjectPK)new ObjectUuidPK(finBill.getCreditLimit().getId().toString()), sic);
        CreditFinancingReduceCollection reCol = this.getCreditFinancingReduceCollection(ctx, finBill.getCompany().getId(), finBill.getCreditLimit().getId(), finBillId);
        CreditLimitUsedCollection usedColl = this.createUsedCollectionByFinPro(ctx, creditLocalAmt, finBillId, creditLimitInfo, finBill, reCol, false);
        return usedColl;
    }

    private CreditLimitUsedInfo createUsedLimit(Context ctx, FinancingBillInfo finBill) throws EASBizException, BOSException {
        BigDecimal creditLocalAmt = this.calCreditLocalAmt(finBill);
        BOSUuid finBillId = finBill.getId();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("entrys.*");
        sic.add("entrys.ShareOrg.*");
        sic.add("entrys.finPro.*");
        CreditLimitInfo creditLimitInfo = CreditLimitFactory.getLocalInstance(ctx).getCreditLimitInfo((IObjectPK)new ObjectUuidPK(finBill.getCreditLimit().getId().toString()), sic);
        CreditLimitUsedInfo usedInfo = this.createUsedInfo(ctx, creditLocalAmt, finBillId, (BillBaseInfo)finBill, creditLimitInfo);
        return usedInfo;
    }

    private CreditLimitUsedCollection createUsedCollectionByFinPro(Context ctx, BigDecimal amount, BOSUuid finBillId, CreditLimitInfo creditLimitInfo, FinancingBillInfo financingBillInfo, CreditFinancingReduceCollection reCol, boolean isRepayment) throws EASBizException, BOSException {
        if (isRepayment) {
            amount = amount.negate();
        }
        CreditLimitUsedCollection col = new CreditLimitUsedCollection();
        BillBaseInfo finBillInfo = (BillBaseInfo)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(finBillId.toString());
        List<Object> redColList = Arrays.asList(reCol.toArray());
        if (isRepayment) {
            Collections.sort(redColList, new ReduceSeqSorter("DESC"));
        } else {
            Collections.sort(redColList, new ReduceSeqSorter());
        }
        int size = redColList.size();
        CreditFinancingReduceInfo infoReduce = null;
        CreditLimitUsedInfo newUsedInfo = null;
        BigDecimal balanceTmp = amount;
        CreditLimitEntryCollection entryEn = creditLimitInfo.getEntrys();
        int entryEnSize = entryEn.size();
        for (int i = 0; i < size; ++i) {
            infoReduce = (CreditFinancingReduceInfo)redColList.get(i);
            for (int j = 0; j < entryEnSize; ++j) {
                newUsedInfo = this.createNewUsedInfo(ctx, amount, finBillId, creditLimitInfo, finBillInfo, infoReduce, isRepayment, balanceTmp, entryEn.get(j));
                if (newUsedInfo == null) continue;
                balanceTmp = balanceTmp.subtract(newUsedInfo.getUsedQuota().abs());
                col.add(newUsedInfo);
            }
        }
        return col;
    }

    public CreditFinancingReduceCollection getCreditFinancingReduceCollection(Context ctx, BOSUuid creditLimitId, BOSUuid financingBillid, BOSUuid companyId) throws BOSException {
        EntityViewInfo evi = this.getQueryView(creditLimitId, financingBillid, companyId);
        return CreditFinancingReduceFactory.getLocalInstance(ctx).getCreditFinancingReduceCollection(evi);
    }

    private EntityViewInfo getQueryView(BOSUuid companyId, BOSUuid creditLimitId, BOSUuid financingBillid) {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.getSelector().add("shareOrg.*");
        evi.getSelector().add("finPro.*");
        evi.getSelector().add("creditEntry.*");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("ShareOrg.id", (Object)companyId));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("creditLimitID", (Object)creditLimitId.toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("billID", (Object)financingBillid.toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isUnion", (Object)Boolean.FALSE));
        String mask = "#0 and #1 and #2 and #3";
        evi.getFilter().setMaskString(mask);
        return evi;
    }

    private CreditLimitUsedInfo createNewUsedInfo(Context ctx, BigDecimal amount, BOSUuid finBillId, CreditLimitInfo creditLimitInfo, BillBaseInfo finBillInfo, CreditFinancingReduceInfo infoReduce, boolean isRepayment, BigDecimal balanceTmp, CreditLimitEntryInfo infoentry) {
        CreditLimitUsedInfo newUsedInfo = null;
        if (this.isSameCompanyAndFinPro(infoentry, infoReduce) && balanceTmp.compareTo(FMConstants.ZERO) > 0 && infoentry.getId().toString().equals(infoReduce.getCreditEntry().getId().toString())) {
            if (balanceTmp.compareTo(infoentry.getBanlance()) >= 0) {
                newUsedInfo = new CreditLimitUsedInfo();
                newUsedInfo.setUsedQuota(infoentry.getBanlance());
            } else {
                newUsedInfo = new CreditLimitUsedInfo();
                newUsedInfo.setUsedQuota(balanceTmp);
            }
            if (newUsedInfo != null) {
                newUsedInfo.setReturnedQuota(FMConstants.ZERO);
                this.commonValue(ctx, creditLimitInfo, finBillInfo, newUsedInfo, finBillId, infoentry);
            }
        }
        return newUsedInfo;
    }

    private void commonValue(Context ctx, CreditLimitInfo creditLimitInfo, BillBaseInfo finBillInfo, CreditLimitUsedInfo newUsedInfo, BOSUuid finBillId, CreditLimitEntryInfo infoentry) {
        newUsedInfo.setFinPro(infoentry.getFinPro());
        newUsedInfo.setCompany(infoentry.getShareOrg());
        newUsedInfo.setBillType(finBillInfo.getBOSType().toString());
        newUsedInfo.setBillNumber(finBillInfo.getNumber());
        newUsedInfo.setBillId(finBillId.toString());
        newUsedInfo.setProperty(creditLimitInfo.getProperty());
        newUsedInfo.setCreditLimit(creditLimitInfo);
        newUsedInfo.setCreateTime(DateHelper.getTimeStampDayBegin());
        newUsedInfo.setCreator((UserInfo)ctx.get((Object)"UserInfo"));
        newUsedInfo.setLastUpdateTime(DateHelper.getTimeStampDayBegin());
        newUsedInfo.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        newUsedInfo.setCurrency(creditLimitInfo.getCurrency());
        newUsedInfo.setCreditUsage(creditLimitInfo.getCreditUsage());
        if (finBillInfo instanceof PayableBillInfo || finBillInfo instanceof LetterOfCreditInfo || finBillInfo instanceof LetterOfGuaranteeInfo || finBillInfo instanceof InnerFinancingBorrowingInInfo || finBillInfo instanceof BillRediscountOutInfo || finBillInfo instanceof CreditAssetsTransferOutInfo) {
            newUsedInfo.setUsingBank(((FinancingBillInfo)finBillInfo).getInstitution());
        }
        if (finBillInfo instanceof PayableBillInfo || finBillInfo instanceof LetterOfCreditInfo || finBillInfo instanceof LetterOfGuaranteeInfo) {
            newUsedInfo.setUsingBank(((FinancingBillInfo)finBillInfo).getInstitution());
        } else if (finBillInfo instanceof LoanInfo) {
            LoanInfo infoLoan = (LoanInfo)finBillInfo;
            if (creditLimitInfo.getIsBankCredit() == LimitIsBankCreditEnum.INNER) {
                newUsedInfo.setUsingCompany(infoLoan.getGroupID());
            } else {
                newUsedInfo.setUsingBank(((FinancingBillInfo)finBillInfo).getInstitution());
            }
        }
        if (finBillInfo instanceof FinancingBillInfo) {
            newUsedInfo.setIssueDate(((FinancingBillInfo)finBillInfo).getIssueDate());
            newUsedInfo.setExpiredDate(((FinancingBillInfo)finBillInfo).getExpiredDate());
        }
    }

    private boolean isSameCompanyAndFinPro(CreditLimitEntryInfo infoentry, CreditFinancingReduceInfo info) {
        boolean isSameCompanyAndFinPro = false;
        if (info.getShareOrg().getId().equals((Object)infoentry.getShareOrg().getId()) && info.getFinPro().getId().equals((Object)infoentry.getFinPro().getId())) {
            isSameCompanyAndFinPro = true;
        }
        return isSameCompanyAndFinPro;
    }

    private CreditLimitUsedInfo createUsedInfo(Context ctx, BigDecimal amount, BOSUuid finBillId, BillBaseInfo finBillInfo, CreditLimitInfo creditLimitInfo) throws EASBizException, BOSException {
        CreditLimitUsedInfo newUsedInfo = new CreditLimitUsedInfo();
        newUsedInfo.setCreditLimit(creditLimitInfo);
        newUsedInfo.setProperty(creditLimitInfo.getProperty());
        newUsedInfo.setBillId(finBillId.toString());
        newUsedInfo.setBillNumber(finBillInfo.getNumber());
        newUsedInfo.setBillType(finBillInfo.getBOSType().toString());
        newUsedInfo.setCompany(finBillInfo.getCompany());
        if (finBillInfo instanceof FinancingBillInfo) {
            newUsedInfo.setIssueDate(((FinancingBillInfo)finBillInfo).getIssueDate());
            newUsedInfo.setExpiredDate(((FinancingBillInfo)finBillInfo).getExpiredDate());
        }
        newUsedInfo.setUsedQuota(amount);
        newUsedInfo.setReturnedQuota(SysConstant.BIGZERO);
        newUsedInfo.setCreateTime(DateHelper.getTimeStampDayBegin());
        newUsedInfo.setCreator((UserInfo)ctx.get((Object)"UserInfo"));
        newUsedInfo.setLastUpdateTime(DateHelper.getTimeStampDayBegin());
        newUsedInfo.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        newUsedInfo.setCurrency(creditLimitInfo.getCurrency());
        newUsedInfo.setCreditUsage(creditLimitInfo.getCreditUsage());
        if (finBillInfo instanceof PayableBillInfo || finBillInfo instanceof LetterOfCreditInfo || finBillInfo instanceof LetterOfGuaranteeInfo || finBillInfo instanceof InnerFinancingBorrowingInInfo || finBillInfo instanceof BillRediscountOutInfo || finBillInfo instanceof CreditAssetsTransferOutInfo) {
            newUsedInfo.setUsingBank(((FinancingBillInfo)finBillInfo).getInstitution());
            newUsedInfo.setFinPro(((FinancingBillInfo)finBillInfo).getType());
        } else if (finBillInfo instanceof LoanInfo) {
            LoanInfo infoLoan = (LoanInfo)finBillInfo;
            if (creditLimitInfo.getIsBankCredit() == LimitIsBankCreditEnum.INNER) {
                newUsedInfo.setUsingCompany(infoLoan.getGroupID());
            } else {
                newUsedInfo.setUsingBank(((FinancingBillInfo)finBillInfo).getInstitution());
            }
            newUsedInfo.setFinPro(infoLoan.getType());
        } else if (finBillInfo instanceof RepaymentInfo) {
            String sourceID = finBillInfo.getSourceBillId();
            ObjectUuidPK sourcePK = new ObjectUuidPK(sourceID);
            BOSUuid id = BOSUuid.read((String)sourceID);
            LetterOfCreditInfo loc = new LetterOfCreditInfo();
            LoanInfo loani = new LoanInfo();
            PayableBillInfo pbi = new PayableBillInfo();
            LetterOfGuaranteeInfo logi = new LetterOfGuaranteeInfo();
            if (loc.getBOSType().equals((Object)id.getType())) {
                loc = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)sourcePK);
                newUsedInfo.setUsingBank(loc.getInstitution());
                newUsedInfo.setFinPro(loc.getType());
            } else if (loani.getBOSType().equals((Object)id.getType())) {
                loani = LoanFactory.getLocalInstance(ctx).getLoanInfo((IObjectPK)sourcePK);
                if (creditLimitInfo.getIsBankCredit() == LimitIsBankCreditEnum.INNER) {
                    newUsedInfo.setUsingCompany(loani.getGroupID());
                } else {
                    newUsedInfo.setUsingBank(loani.getInstitution());
                }
                newUsedInfo.setFinPro(loani.getType());
            } else if (pbi.getBOSType().equals((Object)id.getType())) {
                pbi = PayableBillFactory.getLocalInstance((Context)ctx).getPayableBillInfo((IObjectPK)sourcePK);
                newUsedInfo.setUsingBank(pbi.getInstitution());
                newUsedInfo.setFinPro(pbi.getType());
            } else if (logi.getBOSType().equals((Object)id.getType())) {
                logi = LetterOfGuaranteeFactory.getLocalInstance((Context)ctx).getLetterOfGuaranteeInfo((IObjectPK)sourcePK);
                newUsedInfo.setUsingBank(logi.getInstitution());
                newUsedInfo.setFinPro(logi.getType());
            }
        }
        return newUsedInfo;
    }

    private BigDecimal calCreditLocalAmt(FinancingBillInfo info) {
        BigDecimal retAmt = FMConstants.ZERO;
        if (info instanceof PayableBillInfo) {
            PayableBillInfo commInfo = (PayableBillInfo)info;
            return commInfo.getAmount().subtract(commInfo.getAssureAmount()).multiply(commInfo.getCreditCurExRate());
        }
        retAmt = info.getCreditLocalAmt();
        return retAmt == null ? FMConstants.ZERO : retAmt;
    }

    private CreditLimitUsedInfo getUsedInfo(CreditLimitUsedCollection usedColl, String billId) {
        CreditLimitUsedInfo returnUsedInfo = null;
        for (int i = 0; i < usedColl.size(); ++i) {
            CreditLimitUsedInfo usedInfo = usedColl.get(i);
            if (!billId.equals(usedInfo.getBillId())) continue;
            returnUsedInfo = usedInfo;
            usedColl.remove(usedInfo);
            break;
        }
        return returnUsedInfo;
    }

    private BigDecimal getRepayAmount(RepaymentCollection repayColl, String billId) {
        BigDecimal repayAmount = FMConstants.ZERO;
        for (int i = 0; i < repayColl.size(); ++i) {
            RepaymentInfo repayInfo = repayColl.get(i);
            if (!billId.equals(repayInfo.getSourceBillId())) continue;
            repayAmount = repayAmount.add(repayInfo.getReturnedQuota());
        }
        return repayAmount;
    }

    @Override
    protected Map _repairCreditLimit(Context ctx, Map repairMap) throws BOSException, EASBizException {
        Set entrySet = repairMap.entrySet();
        for (Map.Entry entry : entrySet) {
            CreditLimitInfo creditLimitInfo = (CreditLimitInfo)entry.getKey();
            List usedList = (List)entry.getValue();
            CreditLimitFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(creditLimitInfo.getId().toString()), (CoreBaseInfo)creditLimitInfo);
            if (usedList == null) continue;
            for (int i = 0; i < usedList.size(); ++i) {
                Object usedInfo = usedList.get(i);
                if (usedInfo instanceof CreditLimitUsedInfo) {
                    CreditLimitUsedInfo submitInfo = (CreditLimitUsedInfo)usedInfo;
                    CreditLimitUsedFactory.getLocalInstance(ctx).submit((CoreBaseInfo)submitInfo);
                }
                if (!(usedInfo instanceof CreditLimitUsedCollection)) continue;
                for (int j = 0; j < ((CreditLimitUsedCollection)((Object)usedInfo)).size(); ++j) {
                    CreditLimitUsedInfo submitInfo = ((CreditLimitUsedCollection)((Object)usedInfo)).get(j);
                    CreditLimitUsedFactory.getLocalInstance(ctx).submit((CoreBaseInfo)submitInfo);
                }
            }
        }
        return null;
    }
}

