/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fin.CreditLimitManagerFactory;
import com.kingdee.eas.fm.fin.CreditLimitUsedCollection;
import com.kingdee.eas.fm.fin.DeferReturnCLEntryInfo;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LetterStatusEnum;
import com.kingdee.eas.fm.fin.LimitTypeEnum;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.ReverseBill;
import com.kingdee.eas.fm.fin.app.AbstractDeferReturnCLEntryControllerBean;
import com.kingdee.eas.fm.fin.app.CreditLimitManagerHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import org.apache.log4j.Logger;

public class DeferReturnCLEntryControllerBean
extends AbstractDeferReturnCLEntryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.DeferReturnCLEntryControllerBean");

    @Override
    protected void _recordOneDeferReturnCL(Context ctx, String repaymentBillId, String letterOfCreditBillId) throws BOSException, EASBizException {
        if (null == repaymentBillId || null == letterOfCreditBillId) {
            return;
        }
        this.checkedIsReturnCL(ctx, repaymentBillId, letterOfCreditBillId);
        if (this._exists(ctx, this.existsFilterInfo(repaymentBillId, letterOfCreditBillId))) {
            return;
        }
        SelectorItemCollection sicloc = new SelectorItemCollection();
        sicloc.add("DeferReturnCreditLimitDays");
        LetterOfCreditInfo locInfo = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectStringPK(letterOfCreditBillId), sicloc);
        SelectorItemCollection sicrp = new SelectorItemCollection();
        sicrp.add("bizDate");
        RepaymentInfo rpInfo = RepaymentFactory.getLocalInstance(ctx).getRepaymentInfo((IObjectPK)new ObjectStringPK(repaymentBillId), sicrp);
        if (null == locInfo || null == rpInfo) {
            throw new FinBizException(FinBizException.NOT_EXIST_LOC_OR_REPAYMENT);
        }
        if (locInfo.getDeferReturnCreditLimitDays() <= 0) {
            return;
        }
        int seq = this.getColsByLetterOfCredit(ctx, locInfo.getId().toString()).size();
        DeferReturnCLEntryInfo newInfo = new DeferReturnCLEntryInfo();
        newInfo.setSeq(++seq);
        newInfo.setRepayment(rpInfo);
        newInfo.setParent(locInfo);
        newInfo.setIsReturnedCL(false);
        Date supposeDate = DateTimeUtils.addDay((Date)rpInfo.getBizDate(), (long)locInfo.getDeferReturnCreditLimitDays());
        newInfo.setSupposeCLReturnDate(supposeDate);
        this._addnew(ctx, (IObjectValue)newInfo);
    }

    private FilterInfo existsFilterInfo(String repaymentBillId, String letterOfCreditBillId) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("repayment.id", (Object)repaymentBillId));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)letterOfCreditBillId));
        return filter;
    }

    private void checkedIsReturnCL(Context ctx, String repaymentBillId, String letterOfCreditBillId) throws BOSException, EASBizException, FinBizException {
        FilterInfo filter = this.existsFilterInfo(repaymentBillId, letterOfCreditBillId);
        filter.getFilterItems().add(new FilterItemInfo("isReturnedCL", (Object)Boolean.TRUE));
        if (this._exists(ctx, filter)) {
            throw new FinBizException(FinBizException.LOC_CANNOT_MODIFY_BECAUSE_RETURN_CREDITLIMIT);
        }
    }

    @Override
    protected void _cancelRecordedDeferReturnCL(Context ctx, String repaymentBillId, String letterOfCreditBillId) throws BOSException, EASBizException {
        if (null == repaymentBillId || null == letterOfCreditBillId) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("repayment.id", (Object)repaymentBillId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)letterOfCreditBillId, CompareType.EQUALS));
        filter.setMaskString(" ( #0 and #1 ) ");
        this.delete(ctx, filter);
    }

    @Override
    protected IObjectValue _getValueByRepaymentBill(Context ctx, String repaymentBillId) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("repayment.id", (Object)repaymentBillId, CompareType.EQUALS));
        evi.setFilter(filter);
        return this.getDeferReturnCLEntryCollection(ctx, evi).get(0);
    }

    @Override
    protected void _returnCL(Context ctx, String id) throws BOSException, EASBizException {
        DeferReturnCLEntryInfo returnCLInfo = this.getDeferReturnCLEntryInfo(ctx, (IObjectPK)new ObjectStringPK(id));
        if (null == returnCLInfo || returnCLInfo.isIsReturnedCL()) {
            return;
        }
        SelectorItemCollection sicloc = new SelectorItemCollection();
        sicloc.add("DeferReturnCreditLimitDays");
        sicloc.add("CreditLocalAmt");
        sicloc.add("CreditLimit.*");
        sicloc.add("CreditLimit.CreditUsage.*");
        sicloc.add("IsInCredit");
        sicloc.add("company");
        LetterOfCreditInfo locInfo = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectStringPK(returnCLInfo.getParent().getId().toString()), sicloc);
        SelectorItemCollection sicrp = new SelectorItemCollection();
        sicrp.add("ReturnedQuota");
        sicrp.add("CreditLimit");
        sicrp.add("company");
        sicrp.add("Amount");
        sicrp.add("sourceBillId");
        RepaymentInfo rpInfo = RepaymentFactory.getLocalInstance(ctx).getRepaymentInfo((IObjectPK)new ObjectStringPK(returnCLInfo.getRepayment().getId().toString()), sicrp);
        if (null == locInfo || null == rpInfo) {
            throw new FinBizException(FinBizException.NOT_EXIST_LOC_OR_REPAYMENT);
        }
        FinUtils.returnQuota(ctx, rpInfo, locInfo, true);
        ReverseBill.getInstance(locInfo.getId()).updateReturnedQuota(ctx, ReverseBill.Action_AddNew, rpInfo, locInfo, null);
        returnCLInfo.setIsReturnedCL(true);
        returnCLInfo.setActualCLReturnDate(new Date());
        this.update(ctx, (IObjectPK)new ObjectStringPK(id), (CoreBaseInfo)returnCLInfo);
        LetterOfCreditFactory.getLocalInstance(ctx).autoClose((IObjectPK)new ObjectStringPK(returnCLInfo.getParent().getId().toString()));
    }

    @Override
    protected void _cancleReturnCL(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("parent.LetterStatus");
        DeferReturnCLEntryInfo returnCLInfo = this.getDeferReturnCLEntryInfo(ctx, (IObjectPK)new ObjectStringPK(id), sic);
        if (null == returnCLInfo || !returnCLInfo.isIsReturnedCL()) {
            return;
        }
        SelectorItemCollection sicloc = new SelectorItemCollection();
        sicloc.add("DeferReturnCreditLimitDays");
        sicloc.add("CreditLimit.*");
        sicloc.add("CreditLimit.CreditUsage.*");
        sicloc.add("IsInCredit");
        sicloc.add("company");
        LetterOfCreditInfo locInfo = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectStringPK(returnCLInfo.getParent().getId().toString()), sicloc);
        SelectorItemCollection sicrp = new SelectorItemCollection();
        sicrp.add("ReturnedQuota");
        sicrp.add("CreditLimit");
        sicrp.add("company");
        sicrp.add("Amount");
        sicrp.add("sourceBillId");
        RepaymentInfo rpInfo = RepaymentFactory.getLocalInstance(ctx).getRepaymentInfo((IObjectPK)new ObjectStringPK(returnCLInfo.getRepayment().getId().toString()), sicrp);
        if (null == locInfo || null == rpInfo) {
            throw new FinBizException(FinBizException.NOT_EXIST_LOC_OR_REPAYMENT);
        }
        if (locInfo != null && locInfo.isIsInCredit()) {
            CreditLimitUsedCollection usedCol = null;
            if (locInfo.getCreditLimit() != null) {
                usedCol = CreditLimitManagerHelper.getUsedCol(ctx, rpInfo.getId(), locInfo.getCreditLimit());
            }
            if (locInfo.getCreditLimit() != null && locInfo.getCreditLimit().getCreditUsage().isColligateCredit() && !LimitTypeEnum.BILLPOOL_LIMIT.equals((Object)locInfo.getCreditLimit().getLimitType())) {
                CreditLimitManagerFactory.getLocalInstance(ctx).cancelLimitByFinancingProduct(rpInfo.getId(), locInfo, rpInfo.getReturnedQuota());
            } else {
                CreditLimitManagerFactory.getLocalInstance(ctx).cancelLimit(rpInfo.getId(), locInfo.getCreditLimit().getId());
            }
            ReverseBill.getInstance(locInfo.getId()).updateReturnedQuota(ctx, ReverseBill.Action_Remove, rpInfo, locInfo, usedCol);
        }
        returnCLInfo.setIsReturnedCL(false);
        returnCLInfo.setActualCLReturnDate(null);
        this.update(ctx, (IObjectPK)new ObjectStringPK(id), (CoreBaseInfo)returnCLInfo);
        if (returnCLInfo.getParent().getLetterStatus() == LetterStatusEnum.close) {
            LetterOfCreditFactory.getLocalInstance(ctx).autoOpen((IObjectPK)new ObjectStringPK(returnCLInfo.getParent().getId().toString()));
        }
    }

    @Override
    protected IObjectCollection _getColsByLetterOfCredit(Context ctx, String LetterOfCreditId) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)LetterOfCreditId, CompareType.EQUALS));
        evi.setFilter(filter);
        return this.getDeferReturnCLEntryCollection(ctx, evi);
    }
}

