/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fm.ctl.FeeException;
import com.kingdee.eas.fm.fin.FeeBillBookNotifyBuilder;
import com.kingdee.eas.fm.fin.FeeManageFactory;
import com.kingdee.eas.fm.fin.FeeManageInfo;
import com.kingdee.eas.fm.fin.FeeManageSubsidiaryBookProvider;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.LetterException;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LetterStatusEnum;
import com.kingdee.eas.fm.fin.app.AbstractFeeManageControllerBean;
import com.kingdee.eas.fm.fs.ISubsidiaryLedger;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FeeManageControllerBean
extends AbstractFeeManageControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.FeeManageControllerBean");

    @Override
    protected void _addBatch(Context ctx, IObjectCollection fee) throws BOSException, EASBizException {
        for (int i = 0; i < fee.size(); ++i) {
            FeeManageInfo feeManageInfo = (FeeManageInfo)fee.getObject(i);
            this._addnew(ctx, (IObjectValue)feeManageInfo);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String sql = "select count(*) as total_1 from T_BOT_Relation where FSrcObjectID = ? ";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
        int num = 0;
        try {
            if (rowset.next()) {
                num = rowset.getInt("total_1");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (num > 0) {
            throw new LetterException(LetterException.HASVENCANNOTDEL);
        }
        if (pk != null) {
            SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).cancelBook(pk.toString());
        }
        super._delete(ctx, pk);
        this.deleteBotpRelation(ctx, pk);
    }

    public void deleteBotpRelation(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        Object[] paramList = new Object[]{pk.toString()};
        String sql = "delete from T_BOT_Relation where fdestobjectid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])paramList);
    }

    @Override
    protected void _operateCheck(Context ctx, String id) throws BOSException, EASBizException {
        FeeManageInfo feeManageInfo = FeeManageFactory.getLocalInstance(ctx).getFeeManageInfo((IObjectPK)new ObjectUuidPK(id));
        LetterOfCreditInfo info = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(feeManageInfo.getLetterCreditID()));
        if (info != null && info.getLetterStatus().equals((Object)LetterStatusEnum.close)) {
            throw new LetterException(LetterException.LETTERISCLOSED);
        }
    }

    @Override
    protected void _book(Context ctx, Set idSet) throws BOSException, EASBizException {
        String builderName = FeeBillBookNotifyBuilder.class.getName();
        String billId = null;
        Iterator iter = idSet.iterator();
        IBookNotifyFacade facade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        while (iter.hasNext()) {
            billId = iter.next().toString();
            facade.book(builderName, billId);
        }
    }

    @Override
    protected void _cancelBook(Context ctx, Set idSet) throws BOSException, EASBizException {
        String billId = null;
        IBookNotifyFacade facade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        Iterator iter = idSet.iterator();
        while (iter.hasNext()) {
            billId = iter.next().toString();
            FeeManageInfo info = this.getFeeManageInfo(ctx, (IObjectPK)new ObjectStringPK(billId));
            if (info.isFiVouchered()) continue;
            facade.antiBook(billId);
            FeeBillBookNotifyBuilder.insertCashier(ctx, null, billId);
        }
    }

    @Override
    protected void _ledgerBook(Context ctx, Set idSet) throws BOSException, EASBizException {
    }

    @Override
    protected void _cancelLedgerBook(Context ctx, Set idSet) throws BOSException, EASBizException {
    }

    @Override
    protected void _subsidiaryBook(Context ctx, Set idSet) throws BOSException, EASBizException {
        String billId = null;
        String builderName = FeeManageSubsidiaryBookProvider.class.getName();
        ISubsidiaryLedger facade = SubsidiaryLedgerFactory.getLocalInstance((Context)ctx);
        Iterator iter = idSet.iterator();
        while (iter.hasNext()) {
            billId = iter.next().toString();
            facade.book(billId, builderName);
        }
    }

    protected boolean _deleteSubsidiary(Context ctx, String id) {
        boolean flag = true;
        try {
            String strSelSql = "select * from T_FS_SubsidiaryLedger where fbillid = '" + id + "'";
            if (DbUtil.executeQuery((Context)ctx, (String)strSelSql).size() == 0) {
                return true;
            }
            String strDelSql = "delete T_FS_SubsidiaryLedger where fbillid = '" + id + "'";
            DbUtil.execute((Context)ctx, (String)strDelSql);
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean isInnerAccountNull;
        HashSet<IObjectPK> idSet = new HashSet<IObjectPK>();
        IObjectPK iFeePK = super._addnew(ctx, model);
        FinUtils.addBotRelation(ctx, ((FeeManageInfo)model).getLetterCreditID(), iFeePK.toString());
        boolean bl = isInnerAccountNull = this.getFeeManageInfo(ctx, iFeePK).getInnerAccount() == null;
        if (!isInnerAccountNull) {
            idSet.add(iFeePK);
            this._subsidiaryBook(ctx, idSet);
        }
        return iFeePK;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FeeManageInfo feeOldInfo = this.getFeeManageInfo(ctx, (IObjectPK)new ObjectStringPK(((FeeManageInfo)model).getId().toString()));
        String oldInnerAccPK = null;
        if (feeOldInfo.getInnerAccount() != null) {
            oldInnerAccPK = feeOldInfo.getInnerAccount().getId().toString();
        }
        IObjectPK feePK = super._submit(ctx, model);
        FeeManageInfo feeNewInfo = this.getFeeManageInfo(ctx, feePK);
        String newInnerAccPK = null;
        if (feeNewInfo.getInnerAccount() != null) {
            newInnerAccPK = feeNewInfo.getInnerAccount().getId().toString();
        }
        HashSet<IObjectPK> idSet = new HashSet<IObjectPK>();
        idSet.add(feePK);
        this._againBook(ctx, idSet, oldInnerAccPK, newInnerAccPK);
        return feePK;
    }

    protected void _againBook(Context ctx, Set idSet, String oldInnerId, String newInnerId) throws BOSException, EASBizException {
        boolean isAgain = false;
        Iterator iter = idSet.iterator();
        String billId = null;
        while (iter.hasNext()) {
            billId = iter.next().toString();
        }
        InnerAccountInfo oldInfo = null;
        if (oldInnerId != null) {
            oldInfo = InnerAccountFactory.getLocalInstance((Context)ctx).getInnerAccountInfo((IObjectPK)new ObjectStringPK(oldInnerId));
        }
        InnerAccountInfo newInfo = null;
        if (newInnerId != null) {
            newInfo = InnerAccountFactory.getLocalInstance((Context)ctx).getInnerAccountInfo((IObjectPK)new ObjectStringPK(newInnerId));
        }
        boolean isEditDataInnerNull = true;
        isEditDataInnerNull = oldInfo == null;
        HashSet<String> feeIdSet = new HashSet<String>();
        boolean flag = this._isAgainBook(ctx, oldInnerId, newInnerId);
        boolean isCanDelete = true;
        if (flag) {
            if (oldInfo != null) {
                isCanDelete = this._deleteSubsidiary(ctx, billId);
            }
            if (!isCanDelete) {
                // empty if block
            }
            if (newInfo != null) {
                feeIdSet.add(billId);
                this._subsidiaryBook(ctx, feeIdSet);
                isAgain = true;
            }
        }
        if (isAgain) {
            if (isEditDataInnerNull) {
                // empty if block
            }
        } else if (flag) {
            if (newInfo != null) {
                throw new FeeException(FeeException.BOOKISLOST);
            }
            if (!isEditDataInnerNull) {
                // empty if block
            }
        }
    }

    protected boolean _isAgainBook(Context ctx, String oldId, String newId) throws BOSException, EASBizException {
        boolean flag = false;
        InnerAccountInfo newInfo = null;
        InnerAccountInfo oldInfo = null;
        if (newId != null) {
            newInfo = InnerAccountFactory.getLocalInstance((Context)ctx).getInnerAccountInfo((IObjectPK)new ObjectStringPK(newId));
        }
        if (oldId != null) {
            oldInfo = InnerAccountFactory.getLocalInstance((Context)ctx).getInnerAccountInfo((IObjectPK)new ObjectStringPK(oldId));
        }
        if (oldInfo == null) {
            if (newInfo != null) {
                flag = true;
            }
        } else if (newInfo == null) {
            flag = true;
        } else if (!newInfo.getId().equals((Object)oldInfo.getId())) {
            flag = true;
        }
        return flag;
    }

    @Override
    protected Map _saveBatch(Context ctx, IObjectCollection models) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        for (int i = 0; i < models.size(); ++i) {
            FeeManageInfo feeManageInfo = (FeeManageInfo)models.getObject(i);
            IObjectPK iFeePK = super._addnew(ctx, (IObjectValue)feeManageInfo);
            FinUtils.addBotRelation(ctx, feeManageInfo.getLetterCreditID(), iFeePK.toString());
        }
        return result;
    }
}

