/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fm.fin.FeeManageCollection;
import com.kingdee.eas.fm.fin.FeeManageFactory;
import com.kingdee.eas.fm.fin.FeeManageInfo;
import com.kingdee.eas.fm.fin.IFeeManage;
import com.kingdee.eas.fm.fin.LetterException;
import com.kingdee.eas.fm.fin.app.AbstractFeeManageWebFacadeControllerBean;
import com.kingdee.eas.fm.nt.LetterOfCreditApplyException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.log4j.Logger;

public class FeeManageWebFacadeControllerBean
extends AbstractFeeManageWebFacadeControllerBean {
    public static final String RESOURCE = "com.kingdee.eas.fm.fin.LetterOfCreditWebResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.FeeManageWebFacadeControllerBean");

    @Override
    protected Map _batchDelete(Context ctx, String[] ids) throws BOSException, EASBizException {
        int size = ids.length;
        int error = 0;
        BatchExecuteResult result = new BatchExecuteResult();
        IFeeManage iFeeManage = FeeManageFactory.getLocalInstance(ctx);
        for (int i = 0; i < ids.length; ++i) {
            try {
                this.verifyBeforeDelete(ctx, ids[i]);
                iFeeManage.delete((IObjectPK)new ObjectUuidPK(ids[i]));
                continue;
            }
            catch (Exception e2) {
                LetterException e2;
                if (e2 instanceof LetterException && ((LetterException)((Object)e2)).getSubCode().equals("010")) {
                    FeeManageInfo info = iFeeManage.getFeeManageInfo((IObjectPK)new ObjectUuidPK(ids[i]), this.getSelectors());
                    e2 = new LetterException(LetterException.HASVOUCANTDEL_16, new String[]{info.getBusinessNumber(), info.getFeeName().getName()});
                }
                ++error;
                result.getDetailMsgList().add(((Throwable)((Object)e2)).getMessage());
            }
        }
        result.setError(error);
        if (size == 1 && error == size) {
            result.setSummaryMsg((String)result.getDetailMsgList().get(0));
        } else {
            result.setSummaryMsg(new LetterOfCreditApplyException(LetterOfCreditApplyException.DELETESUMMARYMSG_16, (Object[])new String[]{new Integer(size).toString(), new Integer(size - error).toString(), new Integer(error).toString()}).getMessage());
        }
        return result;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("isCreatorBear"));
        selector.add(new SelectorItemInfo("company.id"));
        selector.add(new SelectorItemInfo("fiVouchered"));
        selector.add(new SelectorItemInfo("businessNumber"));
        selector.add(new SelectorItemInfo("feeName"));
        selector.add(new SelectorItemInfo("feeName.name"));
        return selector;
    }

    @Override
    protected Map _batchSave(Context ctx, IObjectCollection models) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        try {
            IFeeManage iFeeManage = FeeManageFactory.getLocalInstance(ctx);
            iFeeManage.saveBatch((FeeManageCollection)models);
            result.setError(0);
            result.setSummaryMsg(EASResource.getString((String)RESOURCE, (String)"FeeSaveSuccess_91"));
        }
        catch (Exception e) {
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }

    @Override
    @Deprecated
    protected Map _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        FeeManageInfo info = (FeeManageInfo)model;
        try {
            this.verifyBeforeSubmit(ctx, info);
            IFeeManage iFeeManage = FeeManageFactory.getLocalInstance(ctx);
            ObjectUuidPK pk = new ObjectUuidPK(info.getId().toString());
            iFeeManage.update((IObjectPK)pk, (CoreBaseInfo)info);
            result.setError(0);
            result.setSummaryMsg("success");
        }
        catch (Exception e) {
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }

    @Override
    protected Map _edit(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        try {
            this.verifyBeforeEdit(ctx, id);
            result.setError(0);
            result.setSummaryMsg(EASResource.getString((String)RESOURCE, (String)"EditPermissionVerifySuccess_92"));
        }
        catch (Exception e) {
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }

    private void verifyBeforeSubmit(Context ctx, FeeManageInfo info) throws Exception {
        BigDecimal amount = info.getMoneyAmount();
        if (amount == null || amount.compareTo(BigDecimal.ZERO) == 0) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.NOTNULLANDNEQZERO_44);
        }
        BigDecimal exchangeRate = info.getExchangeRate();
        if (exchangeRate == null || exchangeRate.compareTo(BigDecimal.ZERO) <= 0) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.NOTNULLANDLTZERO_45);
        }
    }

    private void verifyBeforeDelete(Context ctx, String id) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        FeeManageInfo info = FeeManageFactory.getLocalInstance(ctx).getFeeManageInfo((IObjectPK)new ObjectUuidPK(id), sic);
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_FeeManager_delete");
        if (!isPermission) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.NO_DELFEE_PERMISSION_42, (Object[])new String[]{info.getCompany().getName()});
        }
    }

    private void verifyBeforeEdit(Context ctx, String id) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        FeeManageInfo info = FeeManageFactory.getLocalInstance(ctx).getFeeManageInfo((IObjectPK)new ObjectUuidPK(id), sic);
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_FeeManager_edit");
        if (!isPermission) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.NO_EDITFEE_PERMISSION_43, (Object[])new String[]{info.getCompany().getName()});
        }
    }
}

