/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.utils.PerfLogRecorder;
import com.kingdee.eas.fm.bond.BondReleasePlanInfo;
import com.kingdee.eas.fm.bond.BondReleaseReportInfo;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.ctl.AssureBillFactory;
import com.kingdee.eas.fm.ctl.AssureBillInfo;
import com.kingdee.eas.fm.ctl.AssureBillManagerFacadeFactory;
import com.kingdee.eas.fm.ctl.BankFactorFactory;
import com.kingdee.eas.fm.ctl.BankFactorInfo;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeFactory;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeInfo;
import com.kingdee.eas.fm.fin.BillTypeEnum;
import com.kingdee.eas.fm.fin.CreditFinancingReduceCollection;
import com.kingdee.eas.fm.fin.CreditFinancingReduceFactory;
import com.kingdee.eas.fm.fin.CreditFinancingReduceInfo;
import com.kingdee.eas.fm.fin.CreditLimitFactory;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.CreditLimitManagerFactory;
import com.kingdee.eas.fm.fin.CreditUsageFactory;
import com.kingdee.eas.fm.fin.CreditUsageInfo;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.GuanTypeBillEnum;
import com.kingdee.eas.fm.fin.GuaranteeDetailCollection;
import com.kingdee.eas.fm.fin.GuaranteeDetailInfo;
import com.kingdee.eas.fm.fin.ICreditFinancingReduce;
import com.kingdee.eas.fm.fin.IWage;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LimitTypeEnum;
import com.kingdee.eas.fm.fin.LoanContractInfo;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.ReverseBill;
import com.kingdee.eas.fm.fin.RevokeStatusEnum;
import com.kingdee.eas.fm.fin.ShareTypeEnum;
import com.kingdee.eas.fm.fin.WageEntryInfo;
import com.kingdee.eas.fm.fin.WageFactory;
import com.kingdee.eas.fm.fin.WageInfo;
import com.kingdee.eas.fm.fin.app.AbstractFinancingBillControllerBean;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.fin.util.ReduceSeqSorter;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.sl.LoanFetchInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public abstract class FinancingBillControllerBean
extends AbstractFinancingBillControllerBean {
    private static String creditLimitBosType = new CreditLimitInfo().getBOSType().toString();
    private static String assureBillBosType = new AssureBillInfo().getBOSType().toString();
    private static String wageBillBosType = new WageInfo().getBOSType().toString();

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        FinancingBillInfo info;
        String pfLogId_verifyGuaranteeWage;
        String pfLogId;
        block28: {
            pfLogId = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"FinancingBillControllerBean._update");
            pfLogId_verifyGuaranteeWage = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"FinancingBillControllerBean._update.verifyGuaranteeWage");
            info = (FinancingBillInfo)model;
            try {
                this.verifyGuaranteeWage(ctx, info);
            }
            catch (EASBizException e) {
                if (BillTypeEnum.LOAN.equals((Object)this.getBillType(info)) && e instanceof FinBizException && (e.getSubCode().equals("115") || e.getSubCode().equals("102"))) break block28;
                throw e;
            }
        }
        PerfLogRecorder.endRecord((String)pfLogId_verifyGuaranteeWage);
        CreditLimitInfo creditLimitNew = info.getCreditLimit();
        BOSUuid creditLimitIdNew = creditLimitNew == null ? null : creditLimitNew.getId();
        FinancingBillInfo finBillInfoBeforeUpdate = FinUtils.getFinBillLocalOld(ctx, info.getId().toString());
        if (!BillTypeEnum.LOANCONTRACT.equals((Object)this.getBillType(info))) {
            String pfLogId_removeCreditBotp = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"FinancingBillControllerBean._update.removeCreditBotp");
            FinancingBillControllerBean.removeCreditBotp(ctx, info);
            PerfLogRecorder.endRecord((String)pfLogId_removeCreditBotp);
            String pfLogId_getFinBillLocalOld = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"FinancingBillControllerBean._update.getFinBillLocalOld");
            PerfLogRecorder.endRecord((String)pfLogId_getFinBillLocalOld);
            if (finBillInfoBeforeUpdate.isIsInCredit() && finBillInfoBeforeUpdate.getCreditLimit() != null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("*");
                sic.add("CreditUsage.*");
                sic.add("finacingProduct.*");
                String pfLogId_getCreditLimitInfo = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"FinancingBillControllerBean._update.getCreditLimitInfo");
                finBillInfoBeforeUpdate.setCreditLimit(CreditLimitFactory.getLocalInstance(ctx).getCreditLimitInfo((IObjectPK)new ObjectUuidPK(finBillInfoBeforeUpdate.getCreditLimit().getId()), sic));
                PerfLogRecorder.endRecord((String)pfLogId_getCreditLimitInfo);
                if (finBillInfoBeforeUpdate.getCreditLimit().getCreditUsage() != null && finBillInfoBeforeUpdate.getCreditLimit().getCreditUsage().isColligateCredit() && finBillInfoBeforeUpdate.getCreditLimit().getShareType() == ShareTypeEnum.ASSIGN && !LimitTypeEnum.BILLPOOL_LIMIT.equals((Object)finBillInfoBeforeUpdate.getCreditLimit().getLimitType())) {
                    String pfLogId_cancelLimitByFinancingProduct = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"FinancingBillControllerBean._update.cancelLimitByFinancingProduct");
                    if (!BillTypeEnum.LETTEROFCREDIT.equals((Object)this.getBillType(info))) {
                        CreditLimitManagerFactory.getLocalInstance(ctx).cancelLimitByFinancingProduct(finBillInfoBeforeUpdate.getId(), finBillInfoBeforeUpdate, finBillInfoBeforeUpdate.getAmount());
                    } else {
                        CreditLimitManagerFactory.getLocalInstance(ctx).cancelLetterOfCreditLimitByFinancingProduct(finBillInfoBeforeUpdate.getId(), finBillInfoBeforeUpdate, finBillInfoBeforeUpdate.getBalance());
                    }
                    PerfLogRecorder.endRecord((String)pfLogId_cancelLimitByFinancingProduct);
                } else {
                    String pfLogId_cancelLimit = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"FinancingBillControllerBean._update.cancelLimit");
                    if (!BillTypeEnum.LETTEROFCREDIT.equals((Object)this.getBillType(info))) {
                        CreditLimitManagerFactory.getLocalInstance(ctx).cancelLimit(finBillInfoBeforeUpdate.getId(), finBillInfoBeforeUpdate.getCreditLimit().getId());
                    } else {
                        CreditLimitManagerFactory.getLocalInstance(ctx).cancelLetterLimit(finBillInfoBeforeUpdate.getId(), finBillInfoBeforeUpdate.getCreditLimit().getId());
                    }
                    PerfLogRecorder.endRecord((String)pfLogId_cancelLimit);
                }
                if (info instanceof PayableBillInfo) {
                    info.setUsedQuota(this.calCreditLocalAmt(info));
                }
            }
            String pfLogId_removeAssureBotp = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"FinancingBillControllerBean._update.removeAssureBotp");
            FinancingBillControllerBean.removeAssureBotp(ctx, info);
            PerfLogRecorder.endRecord((String)pfLogId_removeAssureBotp);
            String pfLogId_removeWageBotp = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"FinancingBillControllerBean._update.removeWageBotp");
            FinancingBillControllerBean.removeWageBotp(ctx, info);
            PerfLogRecorder.endRecord((String)pfLogId_removeWageBotp);
            String pfLogId_cancelAssure = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"FinancingBillControllerBean._update.cancelAssure");
            AssureBillManagerFacadeFactory.getLocalInstance((Context)ctx).cancelAssure(info.getId());
            PerfLogRecorder.endRecord((String)pfLogId_cancelAssure);
        }
        String pfLogId_super_update = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"FinancingBillControllerBean._update.super_update");
        super._update(ctx, pk, model);
        PerfLogRecorder.endRecord((String)pfLogId_super_update);
        if (!BillTypeEnum.LOANCONTRACT.equals((Object)this.getBillType(info))) {
            if (creditLimitIdNew != null) {
                if (!FMHelper.isEmpty((Object)creditLimitIdNew)) {
                    SelectorItemCollection sic;
                    if (info.getCreditLimit() != null && info.getCreditLimit().getCreditUsage() != null) {
                        sic = new SelectorItemCollection();
                        sic.add("colligateCredit");
                        String pfLogId_getCreditUsageInfo = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"FinancingBillControllerBean._update.getCreditUsageInfo");
                        CreditUsageInfo uinfo = CreditUsageFactory.getLocalInstance(ctx).getCreditUsageInfo((IObjectPK)new ObjectUuidPK(info.getCreditLimit().getCreditUsage().getId().toString()));
                        PerfLogRecorder.endRecord((String)pfLogId_getCreditUsageInfo);
                        String pfLogId_getCreditLimit = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"FinancingBillControllerBean._update.getCreditLimit");
                        info.getCreditLimit().setCreditUsage(uinfo);
                        PerfLogRecorder.endRecord((String)pfLogId_getCreditLimit);
                    } else if (info.getCreditLimit() != null && info.getCreditLimit().getCreditUsage() == null) {
                        sic = new SelectorItemCollection();
                        sic.add("*");
                        sic.add("CreditUsage.*");
                        sic.add("finacingProduct.*");
                        String pfLogId_setCreditLimit = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"FinancingBillControllerBean._update.setCreditLimit");
                        info.setCreditLimit(CreditLimitFactory.getLocalInstance(ctx).getCreditLimitInfo((IObjectPK)new ObjectUuidPK(info.getCreditLimit().getId()), sic));
                        PerfLogRecorder.endRecord((String)pfLogId_setCreditLimit);
                    }
                    String pfLogId_getFilterItems = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"FinancingBillControllerBean._update.getFilterItems");
                    BOSUuid companyid = info.getCompany().getId();
                    if (info instanceof PayableBillInfo) {
                        companyid = ((PayableBillInfo)info).getApplyUnit().getId();
                    }
                    if (info.getCreditLimit().getCreditUsage().isColligateCredit() && info.getCreditLimit().getShareType() == ShareTypeEnum.ASSIGN && !LimitTypeEnum.BILLPOOL_LIMIT.equals((Object)info.getCreditLimit().getLimitType())) {
                        ICreditFinancingReduce icfr = CreditFinancingReduceFactory.getLocalInstance(ctx);
                        FilterInfo f = new FilterInfo();
                        f.getFilterItems().add(new FilterItemInfo("billID", (Object)pk.toString()));
                        icfr.delete(f);
                        if (info.getReduceCol() != null && info.getReduceCol().size() > 0) {
                            List<Object> redColList = Arrays.asList(info.getReduceCol().toArray());
                            Collections.sort(redColList, new ReduceSeqSorter());
                            this.reCalAmt(redColList, this.calCreditLocalAmt(info));
                            int size = redColList.size();
                            for (int i = 0; i < size; ++i) {
                                CreditFinancingReduceInfo infoReduce = (CreditFinancingReduceInfo)redColList.get(i);
                                infoReduce.setBillID(BOSUuid.read((String)pk.toString()));
                                infoReduce.setIsUnion(false);
                                icfr.submit(infoReduce);
                            }
                        }
                        PerfLogRecorder.endRecord((String)pfLogId_getFilterItems);
                        String pfLogId_useLimitByFinancingProduct = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"FinancingBillControllerBean._update.useLimitByFinancingProduct");
                        if (!BillTypeEnum.LETTEROFCREDIT.equals((Object)this.getBillType(info))) {
                            CreditLimitManagerFactory.getLocalInstance(ctx).useLimitByFinancingProduct(creditLimitIdNew, this.calCreditLocalAmt(info), companyid, info.getId(), false, info);
                        } else {
                            CreditLimitManagerFactory.getLocalInstance(ctx).useLetterOfCreditLimitByFinancingProduct(creditLimitIdNew, this.calCreditLocalAmt(info), companyid, info.getId(), false, info);
                        }
                        PerfLogRecorder.endRecord((String)pfLogId_useLimitByFinancingProduct);
                    } else {
                        String pfLogId_useLimit = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"FinancingBillControllerBean._update.useLimit");
                        if (!BillTypeEnum.LETTEROFCREDIT.equals((Object)this.getBillType(info))) {
                            CreditLimitManagerFactory.getLocalInstance(ctx).useLimit(creditLimitIdNew, this.calCreditLocalAmt(info), companyid, info.getId(), false);
                        } else {
                            CreditLimitManagerFactory.getLocalInstance(ctx).useLetterLimit(creditLimitIdNew, this.calCreditLocalAmt(info), companyid, info.getId(), false);
                        }
                        PerfLogRecorder.endRecord((String)pfLogId_useLimit);
                    }
                }
                String pfLogId_addCreditBotp = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"FinancingBillControllerBean._update.addCreditBotp");
                FinancingBillControllerBean.addCreditBotp(ctx, info, creditLimitIdNew.toString());
                PerfLogRecorder.endRecord((String)pfLogId_addCreditBotp);
            } else {
                info.setUsedQuota(SysConstant.BIGZERO);
                if (finBillInfoBeforeUpdate.isIsInCredit() && finBillInfoBeforeUpdate.getCreditLimit() != null && finBillInfoBeforeUpdate.getCreditLimit().getCreditUsage() != null && finBillInfoBeforeUpdate.getCreditLimit().getCreditUsage().isColligateCredit() && finBillInfoBeforeUpdate.getCreditLimit().getShareType() == ShareTypeEnum.ASSIGN) {
                    ICreditFinancingReduce icfr = CreditFinancingReduceFactory.getLocalInstance(ctx);
                    FilterInfo f = new FilterInfo();
                    f.getFilterItems().add(new FilterItemInfo("billID", (Object)pk.toString()));
                    String pfLogId_delete = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"FinancingBillControllerBean._update.delete");
                    icfr.delete(f);
                    PerfLogRecorder.endRecord((String)pfLogId_delete);
                }
            }
            String pfLogId_writeAssBalance = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"FinancingBillControllerBean._update.writeAssBalance");
            this.writeAssBalance(ctx, pk, info);
            AssureBillManagerFacadeFactory.getLocalInstance((Context)ctx).processRevoke(info.getId());
            PerfLogRecorder.endRecord((String)pfLogId_writeAssBalance);
            String pfLogId_writeWage = PerfLogRecorder.startRecord((String)Thread.currentThread().getName(), (String)"FinancingBillControllerBean._update.writeWage");
            this.writeWage(ctx, info);
            PerfLogRecorder.endRecord((String)pfLogId_writeWage);
            PerfLogRecorder.endRecord((String)pfLogId);
        }
    }

    private BigDecimal calCreditLocalAmt(FinancingBillInfo info) {
        BigDecimal retAmt = Constants.ZERO;
        if (info instanceof PayableBillInfo) {
            PayableBillInfo commInfo = (PayableBillInfo)info;
            if (commInfo.getCreditLimit() == null) {
                retAmt = commInfo.getAmount().subtract(commInfo.getAssureAmount()).multiply(commInfo.getCreditCurExRate());
                return retAmt.setScale(commInfo.getCreditCurrency().getPrecision(), 4);
            }
            return commInfo.getCreditLocalAmt();
        }
        if (info instanceof LoanInfo) {
            LoanInfo loan = (LoanInfo)info;
            retAmt = loan.isHistoryBill() ? loan.getBalance().setScale(info.getCreditCurrency().getPrecision(), 4) : loan.getCreditLocalAmt();
        } else if (info instanceof LetterOfCreditInfo) {
            LetterOfCreditInfo letterInfo = (LetterOfCreditInfo)info;
            retAmt = letterInfo.getAmount().multiply(letterInfo.getCreditCurExRate()).multiply(letterInfo.getCreditPercentage() == null ? Constants.ZERO : letterInfo.getCreditPercentage()).divide(Constants.ONE_HUNDRED).setScale(letterInfo.getCreditCurrency().getPrecision(), 4);
            return retAmt;
        }
        retAmt = info.getCreditLocalAmt();
        return retAmt == null ? Constants.ZERO : retAmt;
    }

    private void checkRealWage(Context ctx, FinancingBillInfo info) throws EASBizException, BOSException {
        Iterator iter = info.getGuaranteeEntrys().iterator();
        while (iter.hasNext()) {
            GuaranteeDetailInfo guarDetailInfo = (GuaranteeDetailInfo)iter.next();
            if (guarDetailInfo.getBilltype() != GuanTypeBillEnum.wage || guarDetailInfo.getBillId() == null) continue;
            WageInfo wageInfo = WageFactory.getLocalInstance(ctx).getWageInfo((IObjectPK)new ObjectUuidPK(guarDetailInfo.getBillId()));
            BigDecimal hasWageAmt = new BigDecimal(String.valueOf(0));
            Iterator iterator = wageInfo.getEntrys().iterator();
            while (iterator.hasNext()) {
                WageEntryInfo element = (WageEntryInfo)iterator.next();
                if (this.getFinancingBillBalance(ctx, element.getBillid()).compareTo(new BigDecimal(String.valueOf(0))) <= 0) continue;
                hasWageAmt = hasWageAmt.add(element.getRealWage());
            }
            if (hasWageAmt.add(guarDetailInfo.getRealWage()).subtract(guarDetailInfo.getCanWage()).compareTo(new BigDecimal(String.valueOf(1.0E-4))) <= 0) continue;
            throw new FinBizException(FinBizException.REALWAGEMORETHANCANWAGE);
        }
    }

    private BigDecimal getFinancingBillBalance(Context ctx, String financingId) throws EASBizException, BOSException {
        BOSObjectType bosType = BOSUuid.read((String)financingId).getType();
        FinancingBillInfo info = new FinancingBillInfo();
        if (bosType.equals((Object)new PayableBillInfo().getBOSType())) {
            info = PayableBillFactory.getLocalInstance((Context)ctx).getPayableBillInfo((IObjectPK)new ObjectUuidPK(financingId));
        } else if (bosType.equals((Object)LoanInfo.BOSTYPE)) {
            info = LoanFactory.getLocalInstance(ctx).getLoanInfo((IObjectPK)new ObjectUuidPK(financingId));
        } else if (bosType.equals((Object)LetterOfCreditInfo.BOSTYPE)) {
            info = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(financingId));
        } else if (bosType.equals((Object)new LetterOfGuaranteeInfo().getBOSType())) {
            info = LetterOfGuaranteeFactory.getLocalInstance((Context)ctx).getLetterOfGuaranteeInfo((IObjectPK)new ObjectUuidPK(financingId));
        }
        return info.getBalance();
    }

    protected void writeWage(Context ctx, FinancingBillInfo info) throws EASBizException, BOSException {
        DbUtil.execute((Context)ctx, (String)("update T_FIN_Wage set fusedamount=isnull(fusedamount,0)-(select isnull(sum(frealwage),0) from T_FIN_WageEntry where FbillId='" + info.getId().toString() + "' and T_FIN_Wage.fid=T_FIN_WageEntry.fparentid and fisrevoked = 0) where fid in ( select fparentid from T_FIN_WageEntry where fbillid= '" + info.getId().toString() + "')"));
        DbUtil.execute((Context)ctx, (String)("delete from  T_FIN_WageEntry where FbillId='" + info.getId().toString() + "'"));
        IWage iWage = WageFactory.getLocalInstance(ctx);
        Iterator iter = info.getGuaranteeEntrys().iterator();
        while (iter.hasNext()) {
            WageInfo wageInfo;
            GuaranteeDetailInfo element = (GuaranteeDetailInfo)iter.next();
            if (element.getBilltype() != GuanTypeBillEnum.wage || element.getBillId() == null || (wageInfo = WageFactory.getLocalInstance(ctx).getWageInfo((IObjectPK)new ObjectUuidPK(element.getBillId()))) == null) continue;
            WageEntryInfo wageEntryInfo = new WageEntryInfo();
            wageEntryInfo.setParent(wageInfo);
            wageEntryInfo.setType(info.getType());
            wageEntryInfo.setParentBillType(this.getBillType(info));
            wageEntryInfo.setAmount(this.getAmount(info));
            wageEntryInfo.setRealWage(element.getRealWage());
            wageEntryInfo.setRemark(element.getRemark());
            wageEntryInfo.setBillid(info.getId().toString());
            wageEntryInfo.setBillnumber(info.getNumber());
            wageEntryInfo.setIssueDate(info.getIssueDate());
            wageEntryInfo.setExpiredDate(info.getExpiredDate());
            wageEntryInfo.setRevoked(RevokeStatusEnum.revoked.equals((Object)element.getRevokeStatus()));
            wageInfo.getEntrys().add(wageEntryInfo);
            if (!RevokeStatusEnum.revoked.equals((Object)element.getRevokeStatus())) {
                wageInfo.setUsedamount(wageInfo.getUsedamount().add(element.getRealWage()));
            }
            iWage.update((IObjectPK)new ObjectUuidPK(wageInfo.getId().toString()), wageInfo);
            if (RevokeStatusEnum.revoked.equals((Object)element.getRevokeStatus())) continue;
            FinUtils.addBotRelation(ctx, wageInfo.getId().toString(), info.getId().toString());
        }
    }

    private BillTypeEnum getBillType(FinancingBillInfo info) {
        if (info instanceof PayableBillInfo) {
            return BillTypeEnum.PAYABLEBILL;
        }
        if (info instanceof LoanInfo) {
            return BillTypeEnum.LOAN;
        }
        if (info instanceof LetterOfCreditInfo) {
            return BillTypeEnum.LETTEROFCREDIT;
        }
        if (info instanceof LetterOfGuaranteeInfo) {
            return BillTypeEnum.LETTEROFGUARANTEE;
        }
        if (info instanceof LoanContractInfo) {
            return BillTypeEnum.LOANCONTRACT;
        }
        if (info instanceof LoanFetchInfo) {
            return BillTypeEnum.LOANFETCH;
        }
        if (info instanceof BondReleasePlanInfo) {
            return BillTypeEnum.BOND_RELEASE_PLAN;
        }
        if (info instanceof BondReleaseReportInfo) {
            return BillTypeEnum.BOND_RELEASE_REPORT;
        }
        return null;
    }

    protected void updateOnlyModel(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        super._update(ctx, pk, model);
    }

    protected void writeAssBalance(Context ctx, IObjectPK pk, FinancingBillInfo info) throws EASBizException, BOSException {
        if (info.isHistoryBill() && new LoanInfo().getBOSType().toString().equals(info.getId().getType().toString()) && info.getBalance() != null) {
            AssureBillManagerFacadeFactory.getLocalInstance((Context)ctx).useAssure(null, info.getCompany().getId(), info.getBalance(), info.getId());
        } else {
            AssureBillManagerFacadeFactory.getLocalInstance((Context)ctx).useAssure(null, info.getCompany().getId(), this.getAmount(info), info.getId());
        }
        Iterator iter = info.getGuaranteeEntrys().iterator();
        while (iter.hasNext()) {
            AssureBillInfo assBill;
            GuaranteeDetailInfo element = (GuaranteeDetailInfo)iter.next();
            if (element.getBilltype() != GuanTypeBillEnum.AssureBill || element.getBillId() == null || RevokeStatusEnum.revoked.equals((Object)element.getRevokeStatus()) || (assBill = AssureBillFactory.getLocalInstance((Context)ctx).getAssureBillInfo((IObjectPK)new ObjectUuidPK(element.getBillId()))) == null) continue;
            FinancingBillControllerBean.addAssureBillBotp(ctx, pk, assBill.getId().toString());
        }
    }

    private BigDecimal getAmount(FinancingBillInfo info) {
        if (info.getId() != null && info.getId().getType().equals((Object)new PayableBillInfo().getBOSType())) {
            PayableBillInfo commInfo = (PayableBillInfo)info;
            if (commInfo.getAmount() != null && commInfo.getAssureAmount() != null) {
                return commInfo.getAmount().subtract(commInfo.getAssureAmount());
            }
            return commInfo.getAmount();
        }
        if (BillTypeEnum.LOAN.equals((Object)this.getBillType(info))) {
            return info.getBalance();
        }
        return info.getAmount();
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FinancingBillInfo info = (FinancingBillInfo)model;
        if (FMHelper.isEmpty((String)info.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        }
        this.verifyGuaranteeWage(ctx, info);
        if (info.isIsInCredit() && info instanceof PayableBillInfo) {
            info.setUsedQuota(this.calCreditLocalAmt(info));
        }
        IObjectPK pk = super._addnew(ctx, model);
        this.saveCreditLimitReduceSeq(ctx, info, pk);
        if (info.isIsInCredit()) {
            BOSUuid creditLimitId = info.getCreditLimit().getId();
            FinancingBillControllerBean.addCreditBotp(ctx, info, creditLimitId.toString());
        }
        info.setId(BOSUuid.read((String)pk.toString()));
        this.reduceQuantum(ctx, info);
        return pk;
    }

    private void verifyGuaranteeWage(Context ctx, FinancingBillInfo info) throws EASBizException, BOSException {
        GuaranteeDetailCollection gdColl = info.getGuaranteeEntrys();
        for (int i = 0; i < gdColl.size(); ++i) {
            SelectorItemCollection sic;
            GuaranteeDetailInfo gdInfo = gdColl.get(i);
            if (EmptyUtil.isEmpty((String)gdInfo.getBillId()) || gdInfo.getBilltype() == null) continue;
            String id = gdInfo.getBillId();
            if (gdInfo.getBilltype().equals((Object)GuanTypeBillEnum.AssureBill)) {
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("canceled"));
                AssureBillInfo assureInfo = AssureBillFactory.getLocalInstance((Context)ctx).getAssureBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
                if (!assureInfo.isCanceled()) continue;
                throw new FinBizException(FinBizException.ASSURECANCELED);
            }
            if (gdInfo.getBilltype().equals((Object)GuanTypeBillEnum.wage)) {
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("isAntiWage"));
                WageInfo wage = WageFactory.getLocalInstance(ctx).getWageInfo((IObjectPK)new ObjectUuidPK(id), sic);
                if (!wage.isIsAntiWage()) continue;
                throw new FinBizException(FinBizException.WAGECANCEL);
            }
            if (!gdInfo.getBilltype().equals((Object)GuanTypeBillEnum.ReceivableBill) || !BOSUuid.read((String)id).getType().equals((Object)new BankFactorInfo().getBOSType())) continue;
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("isCancel"));
            sic.add(new SelectorItemInfo("isRetrade"));
            sic.add(new SelectorItemInfo("isMortgage"));
            BankFactorInfo factorInfo = BankFactorFactory.getLocalInstance((Context)ctx).getBankFactorInfo((IObjectPK)new ObjectUuidPK(id), sic);
            if (!factorInfo.isIsCancel() && !factorInfo.isIsRetrade() && !factorInfo.isIsMortgage()) continue;
            throw new FinBizException(FinBizException.BANKFACTORCANCEL);
        }
    }

    private void saveCreditLimitReduceSeq(Context ctx, FinancingBillInfo financeInfo, IObjectPK financeInfoPk) throws BOSException, EASBizException {
        ICreditFinancingReduce icfr = CreditFinancingReduceFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)financeInfoPk.toString()));
        icfr.delete(filter);
        if (financeInfo.isIsInCredit() && financeInfo.getCreditLimit().getCreditUsage().isColligateCredit() && financeInfo.getCreditLimit().getShareType() == ShareTypeEnum.ASSIGN && financeInfo.getReduceCol() != null && financeInfo.getReduceCol().size() > 0) {
            List<Object> redColList = Arrays.asList(financeInfo.getReduceCol().toArray());
            Collections.sort(redColList, new ReduceSeqSorter());
            this.reCalAmt(redColList, this.calCreditLocalAmt(financeInfo));
            int size = redColList.size();
            for (int i = 0; i < size; ++i) {
                CreditFinancingReduceInfo infoReduce = (CreditFinancingReduceInfo)redColList.get(i);
                infoReduce.setBillID(BOSUuid.read((String)financeInfoPk.toString()));
                infoReduce.setIsUnion(false);
                icfr.submit(infoReduce);
            }
        }
    }

    private void reCalAmt(List reduceList, BigDecimal amount) {
        BigDecimal balanceTmp = amount;
        BigDecimal balanceBoBeSub = Constants.ZERO;
        for (int i = 0; i < reduceList.size(); ++i) {
            CreditFinancingReduceInfo reduceInfo = (CreditFinancingReduceInfo)reduceList.get(i);
            if (balanceTmp.compareTo(reduceInfo.getAssignAmt()) >= 0) {
                reduceInfo.setUsedAmt(reduceInfo.getAssignAmt());
                reduceInfo.setBalance(Constants.ZERO);
                balanceBoBeSub = reduceInfo.getAssignAmt();
            } else {
                reduceInfo.setUsedAmt(balanceTmp);
                reduceInfo.setBalance(FMHelper.subtract((BigDecimal)reduceInfo.getAssignAmt(), (BigDecimal)balanceTmp));
                balanceBoBeSub = reduceInfo.getUsedAmt();
            }
            balanceTmp = balanceTmp.subtract(balanceBoBeSub);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.returnQuantum(ctx, pk);
        super._delete(ctx, pk);
    }

    protected void reduceQuantum(Context ctx, FinancingBillInfo finBill) throws BOSException, EASBizException {
        if (finBill.isIsInCredit()) {
            BOSUuid creditLimitId = finBill.getCreditLimit().getId();
            BOSUuid companyid = finBill.getCompany().getId();
            if (finBill instanceof PayableBillInfo) {
                companyid = ((PayableBillInfo)finBill).getApplyUnit().getId();
            }
            if (finBill.isIsInCredit() && finBill.getCreditLimit().getCreditUsage().isColligateCredit() && finBill.getCreditLimit().getShareType() == ShareTypeEnum.ASSIGN && !finBill.getCreditLimit().getLimitType().equals((Object)LimitTypeEnum.BILLPOOL_LIMIT)) {
                CreditLimitManagerFactory.getLocalInstance(ctx).useLimitByFinancingProduct(creditLimitId, this.calCreditLocalAmt(finBill), companyid, finBill.getId(), false, finBill);
            } else {
                CreditLimitManagerFactory.getLocalInstance(ctx).useLimit(creditLimitId, this.calCreditLocalAmt(finBill), companyid, finBill.getId(), false);
            }
        }
        this.writeAssBalance(ctx, (IObjectPK)new ObjectUuidPK(finBill.getId()), finBill);
        this.writeWage(ctx, finBill);
    }

    protected void returnQuantum(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FinancingBillInfo finBill = this.getFinancingBillInfo(ctx, pk, this.getSelectors());
        if (finBill.isIsInCredit()) {
            if (finBill.getCreditLimit().getCreditUsage().isColligateCredit() && finBill.getCreditLimit().getShareType() == ShareTypeEnum.ASSIGN && !LimitTypeEnum.BILLPOOL_LIMIT.equals((Object)finBill.getCreditLimit().getLimitType())) {
                BigDecimal amount = Constants.ZERO;
                amount = finBill instanceof LoanInfo ? (((LoanInfo)finBill).isHistoryBill() ? ((LoanInfo)finBill).getBalance() : ((LoanInfo)finBill).getAmount()) : finBill.getAmount();
                CreditLimitManagerFactory.getLocalInstance(ctx).cancelLimitByFinancingProduct(finBill.getId(), finBill, amount);
            } else {
                CreditLimitManagerFactory.getLocalInstance(ctx).cancelLimit(finBill.getId(), finBill.getCreditLimit().getId());
            }
        }
        AssureBillManagerFacadeFactory.getLocalInstance((Context)ctx).cancelAssure(BOSUuid.read((String)pk.toString()));
        FinancingBillInfo info = new FinancingBillInfo();
        info.setId(BOSUuid.read((String)pk.toString()));
        this.writeWage(ctx, info);
    }

    protected SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("company.*");
        sic.add("guaranteeEntrys.*");
        sic.add("IsInCredit");
        sic.add("CreditLimit.*");
        sic.add("CreditLimit.CreditUsage.*");
        return sic;
    }

    protected void modifyQuantum(Context ctx, IObjectPK pk, boolean isReturned) throws BOSException, EASBizException {
        FinancingBillInfo finBill = this.getFinancingBillInfo(ctx, pk, this.getSelectors());
        ReverseBill.newInstance().updateReturnedQuota(ctx, finBill, isReturned);
        this.returnAssure(ctx, finBill, isReturned);
        if (isReturned) {
            FinancingBillInfo info = new FinancingBillInfo();
            info.setId(BOSUuid.read((String)finBill.getId().toString()));
            this.writeWage(ctx, info);
        } else {
            this.writeWage(ctx, finBill);
        }
    }

    protected void returnAssure(Context ctx, FinancingBillInfo repayInfo, boolean isReturned) throws BOSException, EASBizException {
        String finBillId = repayInfo.getId().toString();
        Iterator iter = repayInfo.getGuaranteeEntrys().iterator();
        while (iter.hasNext()) {
            GuaranteeDetailInfo element = (GuaranteeDetailInfo)iter.next();
            if (element.getBilltype() != GuanTypeBillEnum.AssureBill || element.getBillId() == null) continue;
            AssureBillInfo assInfo = AssureBillFactory.getLocalInstance((Context)ctx).getAssureBillInfo((IObjectPK)new ObjectUuidPK(element.getBillId()));
            BigDecimal bizBalanceLocalDelta = repayInfo.getBalance().multiply(element.getExchangeRate()).multiply(element.getScale().divide(new BigDecimal(String.valueOf(100)), 4, 4));
            if (!isReturned) {
                bizBalanceLocalDelta = repayInfo.getAmount().multiply(element.getExchangeRate()).multiply(element.getScale().divide(new BigDecimal(String.valueOf(100)), 4, 4)).negate();
            }
            DbUtil.execute((Context)ctx, (String)"update T_CTL_AssureBillUsed set FReturnedAmount=FReturnedAmount+?,FAssBalance=FAssBalance-? where FFinbillId=? and FAssureBillId=?", (Object[])new Object[]{bizBalanceLocalDelta, bizBalanceLocalDelta, finBillId, assInfo.getId().toString()});
            DbUtil.execute((Context)ctx, (String)"update T_CTL_AssureBill set FBizLocalBalance=FBizLocalBalance-?\n where FId=?", (Object[])new Object[]{bizBalanceLocalDelta.multiply(assInfo.getExRate()), assInfo.getId().toString()});
            this.updateAssureResAmount(ctx, assInfo.getId().toString());
        }
    }

    private void updateAssureResAmount(Context ctx, String assId) throws BOSException {
        DbUtil.execute((Context)ctx, (String)"update T_CTL_AssureBill set FAssureResAmount=(FBizLocalBalance*FAssurePercent*1.00000/100.00000)\n where FId=?", (Object[])new Object[]{assId});
    }

    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        throw new BOSException("not support!");
    }

    protected IObjectPK[] _delete(Context ctx, String oql) throws BOSException, EASBizException {
        throw new BOSException("not support!");
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        int n = arrayPK.length;
        for (int i = 0; i < n; ++i) {
            this._delete(ctx, arrayPK[i]);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FinancingBillInfo finBill = (FinancingBillInfo)model;
        this.verify(ctx, finBill);
        if (finBill.isIsInCredit()) {
            finBill.setUsedQuota(this.calCreditLocalAmt(finBill));
        }
        if (EmptyUtil.isEmpty((Object)finBill.getAmountLocalCur())) {
            int isIndirectRate = 0;
            int precsion = 2;
            if (finBill.getCompany() != null && finBill.getCompany().getBaseCurrency() != null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("number");
                sic.add("baseCurrency.id");
                sic.add("baseCurrency.name");
                sic.add("baseCurrency.number");
                sic.add("baseCurrency.precision");
                sic.add("baseExchangeTable.id");
                CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(finBill.getCompany().getId()), sic);
                CurrencyInfo baseCurr = companyInfo.getBaseCurrency();
                precsion = baseCurr.getPrecision();
                ObjectUuidPK excTablepk = new ObjectUuidPK(companyInfo.getBaseExchangeTable().getId().toString());
                ObjectUuidPK sourceCurrpk = new ObjectUuidPK(finBill.getCurrency().getId());
                ObjectUuidPK destCurrpk = new ObjectUuidPK(baseCurr.getId().toString());
                ExchangeRateInfo exchangeRateInfo = ExchangeRateFactory.getLocalInstance((Context)ctx).getExchangeRateConvertInfo((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, finBill.getBizDate());
                if (exchangeRateInfo != null && exchangeRateInfo.getExchangeAux() != null) {
                    isIndirectRate = exchangeRateInfo.getExchangeAux().getConvertMode().getValue();
                }
            }
            BigDecimal localCurExRate = finBill.getLocalCurExRate();
            BigDecimal amtLocalCur = Constants.ZERO;
            if (amtLocalCur != null && !amtLocalCur.equals(Constants.ZERO)) {
                amtLocalCur = isIndirectRate == 0 ? finBill.getAmount().multiply(localCurExRate).setScale(precsion, 4) : finBill.getAmount().divide(localCurExRate, precsion, 4);
            }
            finBill.setAmountLocalCur(amtLocalCur);
        }
        IObjectPK pk = super._submit(ctx, model);
        return pk;
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASCommonResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"170_BankDraftEditUI", (Locale)ctx.getLocale())));
        }
    }

    protected static void addCreditBotp(Context ctx, FinancingBillInfo finBill, String creditlimitId) throws BOSException {
        String finBillId = finBill.getId().toString();
        FinUtils.addBotRelation(ctx, creditlimitId, finBillId);
    }

    protected static void removeCreditBotp(Context ctx, FinancingBillInfo finBill) throws EASBizException, BOSException {
        IBOTRelation botIntf = BOTRelationFactory.getLocalInstance((Context)ctx);
        botIntf.removeRelationByDestObjId(finBill.getId().toString(), creditLimitBosType);
    }

    protected static void addAssureBillBotp(Context ctx, IObjectPK finBillId, String assureId) throws BOSException {
        FinUtils.addBotRelation(ctx, assureId, finBillId.toString());
    }

    protected static void removeAssureBotp(Context ctx, FinancingBillInfo finBill) throws EASBizException, BOSException {
        IBOTRelation botIntf = BOTRelationFactory.getLocalInstance((Context)ctx);
        botIntf.removeRelationByDestObjId(finBill.getId().toString(), assureBillBosType);
    }

    protected static void removeWageBotp(Context ctx, FinancingBillInfo finBill) throws EASBizException, BOSException {
        IBOTRelation botIntf = BOTRelationFactory.getLocalInstance((Context)ctx);
        botIntf.removeRelationByDestObjId(finBill.getId().toString(), wageBillBosType);
    }

    protected void verify(Context ctx, FinancingBillInfo finBill) throws BOSException, EASBizException {
        CreditUsageInfo uinfo;
        FMVerifyHelper.checkMustMoreThanZero((Context)ctx, (IObjectValue)finBill, (String)"AmountLocalCur");
        FMVerifyHelper.checkMustMoreThanZero((Context)ctx, (IObjectValue)finBill, (String)"LocalCurExRate");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)finBill, (String)"Horizon");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)finBill, (String)"BizDate");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)finBill, (String)"Company");
        if (this.isExpiredDateRequired()) {
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)finBill, (String)"ExpiredDate");
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)finBill, (String)"IssueDate");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)finBill, (String)"Type");
        if (this.isExpiredDateRequired() && !finBill.getExpiredDate().after(finBill.getIssueDate())) {
            throw new FinBizException(FinBizException.EXPIREDMUSTLATERISSUEDATE);
        }
        if (finBill.isUseAssureBill() && finBill.getAssureBill() == null) {
            throw new FinBizException(FinBizException.USEASSUREBILLMUSTHAVEASSUREBILL);
        }
        if (!BillTypeEnum.LOANCONTRACT.equals((Object)this.getBillType(finBill)) && finBill.getCreditLimit() != null && finBill.getCreditLimit().getCreditUsage() != null && finBill.getCreditLimit().getLimitType().equals((Object)LimitTypeEnum.CREDIT_LIMIT) && (uinfo = CreditUsageFactory.getLocalInstance(ctx).getCreditUsageInfo((IObjectPK)new ObjectUuidPK(finBill.getCreditLimit().getCreditUsage().getId().toString()))).isColligateCredit() && finBill.getCreditLimit().getShareType() == ShareTypeEnum.ASSIGN && (finBill.getReduceCol() == null || finBill.getReduceCol().size() == 0)) {
            FinUtils.throwFMCommonException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"4_FinancingBillControllerBean", (Locale)ctx.getLocale()));
        }
    }

    private void checkFinBillType(Context ctx, FinancingBillInfo finBill) throws BOSException, FMException {
        if (finBill.getCreditLimit() == null) {
            return;
        }
        String[] props = new String[]{"*", "CreditUsage.*"};
        FinHelper.fillAndMergeProps(ctx, (CoreBaseInfo)finBill.getCreditLimit(), props);
        if (finBill.getCreditLimit().getCreditUsage().isColligateCredit()) {
            return;
        }
        if (finBill.getCreditLimit().getCreditUsage().getFinacingProduct() == null) {
            return;
        }
        if (finBill.getCreditLimit().getCreditUsage().getFinacingProduct().getId().equals((Object)finBill.getType().getId())) {
            return;
        }
        FinUtils.throwFMCommonException(ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"5_FinancingBillControllerBean", (Locale)ctx.getLocale()));
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FinancingBillInfo finBill = (FinancingBillInfo)model;
        this.verify(ctx, finBill);
        return super._save(ctx, model);
    }

    protected void setEntrysSelector(SelectorItemCollection sic) {
        sic.add(new SelectorItemInfo("GaranteeType.*"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.*"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.guaranteeType.*"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.guaranteeComp.*"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.currency.*"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.guaranteeTypeProperty.*"));
    }

    protected boolean isExpiredDateRequired() {
        return true;
    }

    protected CreditFinancingReduceCollection getReduceCol(Context ctx, IObjectPK pk) throws BOSException {
        if (null == pk) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)pk));
        view.setFilter(filter);
        return CreditFinancingReduceFactory.getLocalInstance(ctx).getCreditFinancingReduceCollection(view);
    }

    protected IObjectPK _saveOther(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._save(ctx, model);
    }

    protected IObjectPK _addnewOther(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._addnew(ctx, model);
        return pk;
    }

    protected void _updateOther(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    protected IObjectPK _submitOther(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._submit(ctx, model);
    }

    protected void _deleteOther(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
    }
}

