/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinancingFeeBillCollection;
import com.kingdee.eas.fm.fin.FinancingFeeBillFactory;
import com.kingdee.eas.fm.fin.FinancingFeeBillInfo;
import com.kingdee.eas.fm.fin.FinancingFeeBillStateEnum;
import com.kingdee.eas.fm.fin.app.AbstractFinancingFeeBillControllerBean;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class FinancingFeeBillControllerBean
extends AbstractFinancingFeeBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.FinancingFeeBillControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FinancingFeeBillInfo info = (FinancingFeeBillInfo)model;
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)info);
        if (FMHelper.isEmpty((String)info.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        this.checkNumberDup(ctx, (IObjectValue)info);
        IObjectPK PK = super._addnew(ctx, model);
        if (!FMHelper.isEmpty((String)info.getSourceBillId())) {
            HashMap<String, String> idMap = new HashMap<String, String>();
            idMap.put(info.getSourceBillId(), info.getId().toString());
            FMHelper.saveBOTRelation((Context)ctx, idMap);
        }
        return PK;
    }

    protected void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FinancingFeeBillInfo dbInfo;
        FinancingFeeBillInfo info = (FinancingFeeBillInfo)model;
        if (!FMHelper.isEmpty((Object)((Object)info.getState())) && !FMHelper.isEmpty((Object)((Object)(dbInfo = (FinancingFeeBillInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(info.getId()))).getState())) && dbInfo.getState().equals((Object)FinancingFeeBillStateEnum.AUDIT)) {
            throw new FinBizException(FinBizException.FINFEESUBMIT);
        }
        info.setState(FinancingFeeBillStateEnum.SAVE);
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FinancingFeeBillInfo dbInfo;
        FinancingFeeBillInfo info = (FinancingFeeBillInfo)model;
        FmMbgHelper.checkBizUnitInfo((Context)ctx, (IObjectValue)info);
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)((FinancingFeeBillInfo)model));
        if (!FMHelper.isEmpty((Object)info.getId()) && !FMHelper.isEmpty((Object)((Object)(dbInfo = (FinancingFeeBillInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(info.getId()))).getState())) && dbInfo.getState().equals((Object)FinancingFeeBillStateEnum.AUDIT)) {
            throw new FinBizException(FinBizException.FINFEESUBMIT);
        }
        info.setState(FinancingFeeBillStateEnum.SUBMIT);
        IObjectPK pk = super._submit(ctx, model);
        FinancingFeeBillInfo bgInfo = this.getFinancingFeeBillInfo(ctx, "select * where id='" + pk.toString() + "'");
        NTHelper.updateFpItem((Context)ctx, (IObjectPK)pk, null);
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)bgInfo);
        return pk;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        FinancingFeeBillInfo info = (FinancingFeeBillInfo)this.getValue(ctx, pk, sic);
        Set descSet = FMHelper.getDestBillIdSet((Context)ctx, (String)info.getId().toString());
        if (info.getState().equals((Object)FinancingFeeBillStateEnum.AUDIT) || descSet.size() > 0) {
            throw new FinBizException(FinBizException.FINFEEBILLDEL);
        }
        if (!FMHelper.isEmpty((String)info.getSourceBillId())) {
            HashMap<String, String> idMap = new HashMap<String, String>();
            idMap.put(info.getSourceBillId(), info.getId().toString());
            FMHelper.saveBOTRelation((Context)ctx, idMap);
        }
        FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)pk);
        super._delete(ctx, pk);
        FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
    }

    @Override
    protected void _antiAudit(Context ctx, IObjectPK[] ids) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < ids.length; ++i) {
            idSet.add(ids[i].toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("state"));
        view.getSelector().add(new SelectorItemInfo("auditDate"));
        FinancingFeeBillCollection colls = FinancingFeeBillFactory.getLocalInstance(ctx).getFinancingFeeBillCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            FinancingFeeBillInfo info = colls.get(i);
            Set descSet = FMHelper.getDestBillIdSet((Context)ctx, (String)info.getId().toString());
            if (!info.getState().equals((Object)FinancingFeeBillStateEnum.AUDIT) || descSet.size() > 0) {
                throw new FinBizException(FinBizException.FINFEEANTIAUDIT);
            }
            info.setAuditor(null);
            info.setAuditDate(null);
            info.setState(FinancingFeeBillStateEnum.SUBMIT);
            FinancingFeeBillFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK[] ids) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < ids.length; ++i) {
            idSet.add(ids[i].toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("state"));
        view.getSelector().add(new SelectorItemInfo("auditDate"));
        FinancingFeeBillCollection colls = FinancingFeeBillFactory.getLocalInstance(ctx).getFinancingFeeBillCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            FinancingFeeBillInfo info = colls.get(i);
            if (!info.getState().equals((Object)FinancingFeeBillStateEnum.SUBMIT)) {
                throw new FinBizException(FinBizException.FINFEEBILLAUDIT);
            }
            UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            info.setAuditor(userInfo);
            info.setAuditDate(new Date());
            info.setState(FinancingFeeBillStateEnum.AUDIT);
            FinancingFeeBillFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        }
    }

    @Override
    protected void _audit4WF(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        ObjectUuidPK[] ids = new ObjectUuidPK[]{new ObjectUuidPK(id)};
        this._audit(ctx, (IObjectPK[])ids);
    }

    @Override
    protected void _antiAudit4WF(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        ObjectUuidPK[] ids = new ObjectUuidPK[]{new ObjectUuidPK(id)};
        this._antiAudit(ctx, (IObjectPK[])ids);
    }
}

