/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fin.LoanInterestInfo;
import com.kingdee.eas.fm.fin.app.AbstractIntReverseInFinFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import org.apache.log4j.Logger;

public class IntReverseInFinFacadeControllerBean
extends AbstractIntReverseInFinFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.IntReverseInFinFacadeControllerBean");

    @Override
    protected void _reverseAfterPreInt(Context ctx, LoanInterestInfo loanint) throws BOSException, EASBizException {
        this.updateLastIntDate(ctx, loanint);
    }

    private void updateLastIntDate(Context ctx, LoanInterestInfo loanint) throws BOSException {
        String sql = "update t_fin_loan set FLastPreIntDate = ? where fid = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{loanint.getEndDate(), loanint.getLoan().getId().toString()});
    }

    @Override
    protected void _reverseAfterRecInt(Context ctx, LoanInterestInfo intBill) throws BOSException, EASBizException {
        this.updateLastSettleDate(ctx, intBill);
    }

    protected void updateLastSettleDate(Context ctx, LoanInterestInfo loanint) throws BOSException {
        if (loanint.getEndDate() == null) {
            String sql = "update t_fin_loan set FLastIntDate = null where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{loanint.getLoan().getId().toString()});
        } else {
            String sql = "update t_fin_loan set FLastIntDate = ? where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{loanint.getEndDate(), loanint.getLoan().getId().toString()});
        }
    }

    @Override
    protected void _reverseAfterDelete(Context ctx, LoanInterestInfo intBill) throws BOSException, EASBizException {
        int type = intBill.getInterestType().getValue();
        if (type == 0) {
            this.casePreInt(ctx, intBill);
        } else if (type == 4) {
            this.caseRecInt(ctx, intBill);
        } else if (type == 2) {
            this.caseRepayInt(ctx, intBill);
        } else {
            this.caseHexiaoInt(ctx, intBill);
        }
    }

    private void caseHexiaoInt(Context ctx, LoanInterestInfo intBill) throws BOSException, EASBizException {
    }

    private void caseRepayInt(Context ctx, LoanInterestInfo intBill) throws BOSException, EASBizException {
        if (intBill.getLastIntDate() == null) {
            String sql = "update t_fin_loan set FLastIntDate = null where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{intBill.getLoan().getId().toString()});
        } else {
            String sql = "update t_fin_loan set FLastIntDate = ? where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{intBill.getLastIntDate(), intBill.getLoan().getId().toString()});
        }
    }

    private void caseRecInt(Context ctx, LoanInterestInfo intBill) throws BOSException, EASBizException {
        if (intBill.getLastIntDate() == null) {
            String sql = "update t_fin_loan set FLastIntDate = null where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{intBill.getLoan().getId().toString()});
        } else {
            String sql = "update t_fin_loan set FLastIntDate = ? where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{intBill.getLastIntDate(), intBill.getLoan().getId().toString()});
        }
    }

    private void casePreInt(Context ctx, LoanInterestInfo intBill) throws BOSException, EASBizException {
        if (intBill.getLastIntDate() == null) {
            String sql = "update t_fin_loan set FLastPreIntDate = null where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{intBill.getLoan().getId().toString()});
        } else {
            String sql = "update t_fin_loan set FLastPreIntDate = ? where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{intBill.getLastIntDate(), intBill.getLoan().getId().toString()});
        }
    }
}

