/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ebservice.CreditDealReceivedDetail;
import com.kingdee.bos.ebservice.CreditDealReceivedQueryResponseBody;
import com.kingdee.bos.ebservice.CreditDealReceivedResponseBody;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.app.service.LetterOfCreditEBGServiceUtil;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.be.app.service.vo.CreditDealReceivedAcceptDetailVO;
import com.kingdee.eas.fm.be.app.service.vo.CreditDealReceivedAcceptVO;
import com.kingdee.eas.fm.be.app.service.vo.DealReceivedAcceptQueryVO;
import com.kingdee.eas.fm.common.FMBooleanEnum;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.CreditLimitEntryInfo;
import com.kingdee.eas.fm.fin.CreditLimitFactory;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.CreditLimitStatusEnum;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.LetOfCreditAcctRecordCollection;
import com.kingdee.eas.fm.fin.LetOfCreditAcctRecordFactory;
import com.kingdee.eas.fm.fin.LetOfCreditAcctRecordInfo;
import com.kingdee.eas.fm.fin.LetterException;
import com.kingdee.eas.fm.fin.LetterOfCreditAcctRecStatusEnum;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LetterOperateTypeEnum;
import com.kingdee.eas.fm.fin.LimitPropertyEnum;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.ShareTypeEnum;
import com.kingdee.eas.fm.fin.app.AbstractLetOfCreditAcctRecordControllerBean;
import com.kingdee.eas.fm.fin.app.CreditLimitManagerHelper;
import com.kingdee.eas.fm.nt.BankReturnStatusEnum;
import com.kingdee.eas.fm.nt.LetterOfCreditReachFactory;
import com.kingdee.eas.fm.nt.LetterOfCreditReachInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LetOfCreditAcctRecordControllerBean
extends AbstractLetOfCreditAcctRecordControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.LetOfCreditAcctRecordControllerBean");
    public static final String RESOURCE = "com.kingdee.eas.fm.fin.FINAutoGenerateResource";

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._addnew(ctx, model);
        LetOfCreditAcctRecordInfo info = (LetOfCreditAcctRecordInfo)model;
        HashMap<String, String> idMap = new HashMap<String, String>();
        idMap.put(info.getBill().getId().toString(), pk.toString());
        FMHelper.saveBOTRelation((Context)ctx, idMap);
        return pk;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LetOfCreditAcctRecordInfo info = this.getLetOfCreditAcctRecordInfo(ctx, pk);
        if (info.getState().equals((Object)FMBooleanEnum.Yes)) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)RESOURCE, (String)"6_LetOfCreditAcctRecordControllerBean", (Locale)ctx.getLocale())});
        }
        super._delete(ctx, pk);
        this.dispose(ctx, info, LetterOperateTypeEnum.DELETE);
    }

    protected void _isReferenced(Context ctx, IObjectPK pk, Connection cn) throws ObjectReferedException {
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._submit(ctx, model);
        LetOfCreditAcctRecordInfo info = (LetOfCreditAcctRecordInfo)model;
        this.dispose(ctx, info, LetterOperateTypeEnum.submit);
        return pk;
    }

    private void dispose(Context ctx, LetOfCreditAcctRecordInfo info, LetterOperateTypeEnum disposerActionEnum) throws BOSException, EASBizException {
        if (info.getBill() == null) {
            return;
        }
        if (info.getBill() instanceof LetterOfCreditInfo) {
            LetterOfCreditReachInfo reachInfo;
            LetterOfCreditInfo desinfo = info.getBill();
            if (info.getReachId() != null && !EmptyUtil.isEmpty((CoreBaseInfo)(reachInfo = LetterOfCreditReachFactory.getLocalInstance((Context)ctx).getLetterOfCreditReachInfo((IObjectPK)new ObjectUuidPK(info.getReachId().toString()))))) {
                if (disposerActionEnum.equals((Object)LetterOperateTypeEnum.DELETE)) {
                    reachInfo.setIsAccept(false);
                    reachInfo.setAccREcord(null);
                } else {
                    reachInfo.setIsAccept(true);
                    reachInfo.setAccREcord(info);
                    HashMap<String, String> idMap = new HashMap<String, String>();
                    idMap.put(reachInfo.getId().toString(), info.getId().toString());
                    FMHelper.saveBOTRelation((Context)ctx, idMap);
                }
                LetterOfCreditReachFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(reachInfo.getId().toString()), (CoreBaseInfo)reachInfo);
            }
        }
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum billOperStateEnum, IObjectValue relationInfo) throws BOSException, EASBizException {
        super._reverseSave(ctx, srcBillPK, srcBillVO, billOperStateEnum, relationInfo);
        BOTRelationInfo relation = (BOTRelationInfo)relationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new RepaymentInfo().getBOSType())) {
            if (BOTBillOperStateEnum.ADDNEW.equals((Object)billOperStateEnum)) {
                String sql = "update T_FIN_LetOfCreditAcctRecord set FState = 1 where FID = ?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{srcBillPK.toString()});
            } else if (BOTBillOperStateEnum.DELETE.equals((Object)billOperStateEnum)) {
                String sql = "update T_FIN_LetOfCreditAcctRecord set FState = 0 where FID = ?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{srcBillPK.toString()});
            }
        }
    }

    @Override
    protected int _getMaxSeqByID(Context ctx, IObjectPK pk) throws BOSException {
        if (pk == null) {
            return 0;
        }
        String sql = "select isnull(max(FSeq),0) seq from T_FIN_LetOfCreditAcctRecord where FBillID = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
        try {
            if (rs.next()) {
                return rs.getInt("seq");
            }
        }
        catch (SQLException e) {
            return 0;
        }
        return 0;
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LetOfCreditAcctRecordInfo info = LetOfCreditAcctRecordFactory.getLocalInstance(ctx).getLetOfCreditAcctRecordInfo(pk);
        if (LetterOfCreditAcctRecStatusEnum.AUDITED.equals((Object)info.getBillState())) {
            throw new FinBizException(FinBizException.ISAUDITED);
        }
        info.setBillState(LetterOfCreditAcctRecStatusEnum.AUDITED);
        LetOfCreditAcctRecordFactory.getLocalInstance(ctx).update(pk, (CoreBaseInfo)info);
    }

    @Override
    protected void _antiAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LetOfCreditAcctRecordInfo info = LetOfCreditAcctRecordFactory.getLocalInstance(ctx).getLetOfCreditAcctRecordInfo(pk);
        if (!LetterOfCreditAcctRecStatusEnum.AUDITED.equals((Object)info.getBillState())) {
            throw new FinBizException(FinBizException.ISNOTAUDITED);
        }
        if (FMBooleanEnum.Yes.equals((Object)info.getState())) {
            throw new FinBizException(FinBizException.ISGENPAYCANTANTIAUDIT);
        }
        info.setBillState(LetterOfCreditAcctRecStatusEnum.SUBMITED);
        LetOfCreditAcctRecordFactory.getLocalInstance(ctx).update(pk, (CoreBaseInfo)info);
    }

    @Override
    protected Map _commitToBe(Context ctx, String[] ids) throws BOSException {
        int size = ids.length;
        int error = 0;
        BatchExecuteResult result = new BatchExecuteResult();
        Set idSet = CASWebUtil.ids2Set((String[])ids);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.setSelector(this.getSelectors());
        LetOfCreditAcctRecordCollection colls = LetOfCreditAcctRecordFactory.getLocalInstance(ctx).getLetOfCreditAcctRecordCollection(ev);
        ArrayList idList = new ArrayList(idSet);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
        LetterOfCreditEBGServiceUtil letterOfCreditEBGServiceUtil = new LetterOfCreditEBGServiceUtil();
        for (int i = 0; i < colls.size(); ++i) {
            LetOfCreditAcctRecordInfo info = colls.get(i);
            try {
                Boolean isLocked = (Boolean)requestMap.get(info.getId().toString());
                this.verifyBeforeCommitToBe(ctx, isLocked, info);
                CreditDealReceivedAcceptVO acceptVO = this.praseVO(ctx, info);
                CreditDealReceivedResponseBody resposeBody = letterOfCreditEBGServiceUtil.dealReceivedAcct(ctx, acceptVO);
                CreditDealReceivedDetail[] resposeList = resposeBody.getDetails();
                this.dealWithResponse(ctx, resposeList, info);
                continue;
            }
            catch (Exception e) {
                ++error;
                result.getDetailMsgList().add(EASResource.getString((String)RESOURCE, (String)"565_LetOfCreditAcctRecordControllerBean", (Object[])new String[]{info.getNumber(), e.getMessage()}));
            }
        }
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{size + ""});
        summary = error == 0 ? summary + EASResource.getString((String)RESOURCE, (String)"566_LetOfCreditAcctRecordControllerBean") : summary + EASResource.getString((String)RESOURCE, (String)"567_LetOfCreditAcctRecordControllerBean", (Object[])new String[]{new Integer(size - error).toString(), new Integer(error).toString()});
        result.setSummaryMsg(summary);
        return result;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("bill.isDirect"));
        sic.add(new SelectorItemInfo("bill.payBankAcct.*"));
        sic.add(new SelectorItemInfo("bill.letterNumber"));
        sic.add(new SelectorItemInfo("bill.IsForward"));
        sic.add(new SelectorItemInfo("reachId"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("billState"));
        sic.add(new SelectorItemInfo("isCommitToBe"));
        return sic;
    }

    private void verifyBeforeCommitToBe(Context ctx, boolean isLocked, LetOfCreditAcctRecordInfo info) throws Exception {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_LetOfCreditAcctRecord_commitToBe");
        if (!isPermission) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"576_LetOfCreditAcctRecordControllerBean", (Object[])new Object[]{info.getCompany().getName()}));
        }
        if (!isLocked) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"568_LetOfCreditAcctRecordControllerBean"));
        }
        LetterOfCreditAcctRecStatusEnum billState = info.getBillState();
        if (!LetterOfCreditAcctRecStatusEnum.AUDITED.equals((Object)billState)) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"569_LetOfCreditAcctRecordControllerBean"));
        }
        if (!info.getBill().isIsDirect()) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"583_LetOfCreditAcctRecordControllerBean"));
        }
        if (!info.isIsCommitToBe() || info.getBankReturnStatus() == null || BankReturnStatusEnum.COMMIT_FAIL.equals((Object)info.getBankReturnStatus())) {
            throw new LetterException(LetterException.COMMITEDCANTCMTAGIN);
        }
    }

    private CreditDealReceivedAcceptVO praseVO(Context ctx, LetOfCreditAcctRecordInfo info) throws EASBizException, BOSException {
        CreditDealReceivedAcceptVO acceptVO = new CreditDealReceivedAcceptVO();
        if (info.getBill().getPayBankAcct() != null) {
            acceptVO.setAccNo(info.getBill().getPayBankAcct().getBankAccountNumber());
        } else {
            acceptVO.setAccNo(null);
        }
        acceptVO.setCurrency(FmBeHelper.getCurrencyISO((Context)ctx, (CurrencyInfo)info.getCurrency()));
        String[] serialNos = beServiceHelper.getSerialNumber((int)1);
        acceptVO.setBatchSeqId(serialNos[0]);
        info.setBatchSeqId(serialNos[0]);
        info.setDetailSeqId(serialNos[0]);
        info.setIsCommitToBe(true);
        SelectorItemCollection LCAsic = new SelectorItemCollection();
        LCAsic.add(new SelectorItemInfo("batchSeqId"));
        LCAsic.add(new SelectorItemInfo("detailSeqId"));
        LCAsic.add(new SelectorItemInfo("isCommitToBe"));
        LetOfCreditAcctRecordFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, LCAsic);
        acceptVO.setTotalCount("1");
        ArrayList<CreditDealReceivedAcceptDetailVO> rejectList = new ArrayList<CreditDealReceivedAcceptDetailVO>();
        CreditDealReceivedAcceptDetailVO acceptDetailVO = new CreditDealReceivedAcceptDetailVO();
        LetOfCreditAcctRecordInfo acctInfo = LetOfCreditAcctRecordFactory.getLocalInstance(ctx).getLetOfCreditAcctRecordInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()), this.getSelectors());
        acceptVO.setBatchBizNo(info.getNumber());
        acceptDetailVO.setDetailSeqId(serialNos[0]);
        acceptDetailVO.setDetailBizNo(info.getNumber());
        acceptDetailVO.setCreditNo(acctInfo.getBill().getLetterNumber());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("number");
        sic.add("branchNo");
        sic.add("applicant");
        sic.add("beneficiary");
        sic.add("claimAmount");
        sic.add("referenceNum");
        sic.add("contractNo");
        LetterOfCreditReachInfo reachInfo = LetterOfCreditReachFactory.getLocalInstance((Context)ctx).getLetterOfCreditReachInfo((IObjectPK)new ObjectUuidPK(acctInfo.getReachId().toString()), sic);
        acceptDetailVO.setBranchNo(reachInfo.getBranchNo());
        acceptDetailVO.setReceivedCreditNumber(reachInfo.getNumber());
        acceptDetailVO.setApplicant(reachInfo.getApplicant());
        acceptDetailVO.setBeneficiary(reachInfo.getBeneficiary());
        acceptDetailVO.setClaimAmount(reachInfo.getClaimAmount().setScale(2, 4).toString());
        acceptDetailVO.setReferenceNum(reachInfo.getReferenceNum());
        acceptDetailVO.setContractNo(reachInfo.getContractNo());
        acceptDetailVO.setAmount(info.getAmount().setScale(2, 4).toString());
        acceptDetailVO.setNote(acctInfo.getDescription());
        acceptDetailVO.setApplyDate(info.getBizDate());
        rejectList.add(acceptDetailVO);
        acceptVO.setDetails(rejectList);
        return acceptVO;
    }

    private void dealWithResponse(Context ctx, CreditDealReceivedDetail[] resposeList, LetOfCreditAcctRecordInfo info) throws Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        if (resposeList != null && resposeList.length > 0) {
            for (int index = 0; index < resposeList.length; ++index) {
                CreditDealReceivedDetail detail = resposeList[index];
                if (info.getDetailSeqId() == null || !info.getDetailSeqId().equals(detail.getDetailSeqId())) continue;
                sic.add(new SelectorItemInfo("bankReturnStatus"));
                sic.add(new SelectorItemInfo("bankReturnMsg"));
                info.setBankReturnStatus(BankReturnStatusEnum.getEnum((String)detail.getEbStatus()));
                info.setBankReturnMsg(detail.getBankStatusMsg());
                LetterOfCreditReachInfo reachInfo = LetterOfCreditReachFactory.getLocalInstance((Context)ctx).getLetterOfCreditReachInfo((IObjectPK)new ObjectUuidPK(info.getReachId().toString()));
                if ("BANK_SUCCESS".equals(detail.getEbStatus())) {
                    sic.add(new SelectorItemInfo("billState"));
                    info.setBillState(LetterOfCreditAcctRecStatusEnum.ACCEPTED);
                    SelectorItemCollection sicReach = new SelectorItemCollection();
                    sicReach.add(new SelectorItemInfo("IsAccept"));
                    reachInfo.setIsAccept(true);
                    this.updatePartial(ctx, (CoreBaseInfo)reachInfo, sicReach);
                }
                this.updatePartial(ctx, (CoreBaseInfo)info, sic);
            }
        } else {
            throw new Exception(EASResource.getString((String)"580_NothingResponseFromBE"));
        }
    }

    @Override
    protected Map _synStatus(Context ctx, String[] ids) throws BOSException {
        int size = ids.length;
        int error = 0;
        BatchExecuteResult result = new BatchExecuteResult();
        Set idSet = CASWebUtil.ids2Set((String[])ids);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.setSelector(this.getSelectors());
        LetOfCreditAcctRecordCollection colls = LetOfCreditAcctRecordFactory.getLocalInstance(ctx).getLetOfCreditAcctRecordCollection(ev);
        ArrayList idList = new ArrayList(idSet);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
        LetterOfCreditEBGServiceUtil letterOfCreditEBGServiceUtil = new LetterOfCreditEBGServiceUtil();
        for (int i = 0; i < colls.size(); ++i) {
            LetOfCreditAcctRecordInfo info = colls.get(i);
            try {
                Boolean isLocked = (Boolean)requestMap.get(info.getId().toString());
                this.verifyBeforeSynStatus(ctx, isLocked, info);
                DealReceivedAcceptQueryVO acceptQueryVO = this.praseAcceptQueryVO(ctx, info);
                CreditDealReceivedQueryResponseBody responseBody = letterOfCreditEBGServiceUtil.dealReceivedAcceptQuery(ctx, acceptQueryVO);
                this.dealWithAcceptQueryResponse(ctx, responseBody, info);
                continue;
            }
            catch (Exception e) {
                ++error;
                result.getDetailMsgList().add(EASResource.getString((String)RESOURCE, (String)"571_LetOfCreditAcctRecordControllerBean", (Object[])new String[]{info.getNumber(), e.getMessage()}));
            }
        }
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{size + ""});
        summary = error == 0 ? summary + EASResource.getString((String)RESOURCE, (String)"572_LetOfCreditAcctRecordControllerBean") : summary + EASResource.getString((String)RESOURCE, (String)"573_LetOfCreditAcctRecordControllerBean", (Object[])new String[]{new Integer(size - error).toString(), new Integer(error).toString()});
        result.setSummaryMsg(summary);
        return result;
    }

    private void verifyBeforeSynStatus(Context ctx, boolean isLocked, LetOfCreditAcctRecordInfo info) throws Exception {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_LetOfCreditAcctRecord_synStatus");
        if (!isPermission) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"577_LetOfCreditAcctRecordControllerBean", (Object[])new Object[]{info.getCompany().getName()}));
        }
        if (!isLocked) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"568_LetOfCreditAcctRecordControllerBean"));
        }
        if (!info.getBill().isIsDirect()) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"584_LetOfCreditAcctRecordControllerBean"));
        }
        if (!info.isIsCommitToBe()) {
            throw new LetterException(LetterException.CMTTOBEBEFORESYNSTATUS_063);
        }
        if (info.getBankReturnStatus() == BankReturnStatusEnum.BANK_FAIL || info.getBankReturnStatus() == BankReturnStatusEnum.BANK_SUCCESS || info.getBankReturnStatus() == BankReturnStatusEnum.BANK_EXCEPTION) {
            throw new LetterException(LetterException.SUCCESSORFAILCANTSYNSTATUS_064);
        }
    }

    private DealReceivedAcceptQueryVO praseAcceptQueryVO(Context ctx, LetOfCreditAcctRecordInfo info) throws EASBizException, BOSException, ParseException {
        DealReceivedAcceptQueryVO acceptQueryVO = new DealReceivedAcceptQueryVO();
        acceptQueryVO.setAccNo(info.getBill().getPayBankAcct().getBankAccountNumber());
        acceptQueryVO.setCurrency(FmBeHelper.getCurrencyISO((Context)ctx, (CurrencyInfo)info.getCurrency()));
        acceptQueryVO.setBatchSeqId(info.getBatchSeqId());
        acceptQueryVO.setBatchBizNo(info.getNumber());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date startDate = sdf.parse("2016-01-01");
        Date endDate = new Date();
        acceptQueryVO.setStartDate(startDate);
        acceptQueryVO.setEndDate(endDate);
        return acceptQueryVO;
    }

    private void dealWithAcceptQueryResponse(Context ctx, CreditDealReceivedQueryResponseBody responseBody, LetOfCreditAcctRecordInfo info) throws Exception {
        CreditDealReceivedDetail[] details = responseBody.getDetails();
        SelectorItemCollection sic = new SelectorItemCollection();
        if (details != null && details.length > 0) {
            for (int index = 0; index < details.length; ++index) {
                CreditDealReceivedDetail detail = details[index];
                if (info.getDetailSeqId() == null || !info.getDetailSeqId().equals(detail.getDetailSeqId())) continue;
                sic.add(new SelectorItemInfo("bankReturnStatus"));
                info.setBankReturnStatus(BankReturnStatusEnum.getEnum((String)detail.getEbStatus()));
                sic.add(new SelectorItemInfo("bankReturnMsg"));
                info.setBankReturnMsg(detail.getBankStatusMsg());
                LetterOfCreditReachInfo reachInfo = LetterOfCreditReachFactory.getLocalInstance((Context)ctx).getLetterOfCreditReachInfo((IObjectPK)new ObjectUuidPK(info.getReachId().toString()));
                if ("BANK_SUCCESS".equals(detail.getEbStatus())) {
                    sic.add(new SelectorItemInfo("billState"));
                    info.setBillState(LetterOfCreditAcctRecStatusEnum.ACCEPTED);
                    SelectorItemCollection sicReach = new SelectorItemCollection();
                    sicReach.add(new SelectorItemInfo("IsAccept"));
                    reachInfo.setIsAccept(true);
                    this.updatePartial(ctx, (CoreBaseInfo)reachInfo, sicReach);
                }
                this.updatePartial(ctx, (CoreBaseInfo)info, sic);
            }
        } else {
            throw new Exception(EASResource.getString((String)"580_NothingResponseFromBE"));
        }
    }

    private void returnQuota(Context ctx, LetterOfCreditReachInfo lcrInfo, LetOfCreditAcctRecordInfo lcarInfo) throws EASBizException, BOSException {
        LetterOfCreditInfo lcInfo;
        String letterOfCreditId = null;
        if (lcrInfo.getCredit() != null && lcrInfo.getCredit().getId() != null) {
            letterOfCreditId = lcrInfo.getCredit().getId().toString();
        }
        if (letterOfCreditId != null && (lcInfo = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(letterOfCreditId))).isIsInCredit() && lcInfo.isIsDirect()) {
            this.updateLetterOfCedit(ctx, lcInfo, lcrInfo.getAmount());
            this.updateReturnedQuota(ctx, lcInfo, lcrInfo.getAmount());
        }
    }

    private void updateLetterOfCedit(Context ctx, LetterOfCreditInfo lcInfo, BigDecimal amount) throws EASBizException, BOSException {
        String sql2 = "update T_FIN_LetterOfCredit set fbalance= fbalance- ? where fid=?";
        DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{amount, lcInfo.getId().toString()});
        LetterOfCreditFactory.getLocalInstance(ctx).autoClose((IObjectPK)new ObjectUuidPK(lcInfo.getId()));
    }

    private void updateReturnedQuota(Context ctx, LetterOfCreditInfo finBillInfo, BigDecimal orgAmount) throws BOSException, EASBizException {
        CreditLimitInfo creditLimitInfo;
        String creditLimitId = finBillInfo.getCreditLimit().toString();
        BigDecimal returnQuota = orgAmount;
        if (finBillInfo.getCreditCurExRate() != null && finBillInfo.getCreditPercentage() != null) {
            BigDecimal temp = FMHelper.multiply((BigDecimal)orgAmount, (BigDecimal)finBillInfo.getCreditCurExRate());
            returnQuota = FMHelper.multiply((BigDecimal)temp, (BigDecimal)finBillInfo.getCreditPercentage());
        }
        if ((creditLimitInfo = CreditLimitFactory.getLocalInstance(ctx).getCreditLimitInfo((IObjectPK)new ObjectUuidPK(creditLimitId))) != null && creditLimitInfo.getProperty().equals((Object)LimitPropertyEnum.REVOLVING_AMOUNT)) {
            if (finBillInfo.getCreditLimit().getCreditUsage().isColligateCredit() && finBillInfo.getCreditLimit().getShareType() == ShareTypeEnum.ASSIGN) {
                String sql = "update T_FIN_CreditLimitUsed set FReturnedQuota= FReturnedQuota+? where FBillId=? and  FFinProID = ? and FCompanyID = ? and fcreditlimitid = ?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{orgAmount, finBillInfo.getId().toString(), "8iAQzQEJEADgAMdfwKgTyMJe16k=", finBillInfo.getCompany().getId().toString(), creditLimitInfo.getId().toString()});
            } else {
                String sql = "update T_FIN_CreditLimitUsed set FReturnedQuota= FReturnedQuota+? where FBillId=?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{returnQuota, finBillInfo.getId().toString()});
            }
            this.updateCreditLimitInfo(ctx, finBillInfo, returnQuota);
        }
    }

    private void updateCreditLimitInfo(Context ctx, FinancingBillInfo finBillInfo, BigDecimal amount) throws BOSException, EASBizException {
        String hsql = "UPDATE T_FIN_CreditLimit SET FBalance=FBalance+?, FUsedAmount=FUsedAmount-? WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)hsql, (Object[])new Object[]{amount, amount, finBillInfo.getCreditLimit().getId().toString()});
        CreditLimitEntryInfo shareEntry = FinUtils.getOrgEntry(ctx, finBillInfo.getCreditLimit(), finBillInfo.getCompany().getId());
        String dsql = "UPDATE T_FIN_CreditLimitEntry SET FBanlance=FBanlance+? WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)dsql, (Object[])new Object[]{amount, shareEntry.getId().toString()});
        CreditLimitStatusEnum creditStatus = CreditLimitManagerHelper.getCreditLimitStatus(ctx, finBillInfo.getCreditLimit().getId().toString());
        String ssql = "UPDATE T_FIN_CreditLimit SET FCreditLimitStat = ? WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)ssql, (Object[])new Object[]{new Integer(creditStatus.getValue()), finBillInfo.getCreditLimit().getId().toString()});
    }
}

