/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fm.common.FMBooleanEnum;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.fin.ILetOfCreditAcctRecord;
import com.kingdee.eas.fm.fin.LetOfCreditAcctRecordFactory;
import com.kingdee.eas.fm.fin.LetOfCreditAcctRecordInfo;
import com.kingdee.eas.fm.fin.LetterException;
import com.kingdee.eas.fm.fin.LetterOfCreditAcctRecStatusEnum;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.app.AbstractLetterOfCreditAcctRecordWebFacadeControllerBean;
import com.kingdee.eas.fm.nt.BankReturnStatusEnum;
import com.kingdee.eas.fm.nt.LetterOfCreditApplyException;
import com.kingdee.eas.fm.nt.LetterOfCreditReachFactory;
import com.kingdee.eas.fm.nt.LetterOfCreditReachInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import java.util.Map;
import org.apache.log4j.Logger;

public class LetterOfCreditAcctRecordWebFacadeControllerBean
extends AbstractLetterOfCreditAcctRecordWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.fin.app.LetterOfCreditAcctRecordWebFacadeControllerBean");
    public static final String RESOURCE = "com.kingdee.eas.fm.fin.FINAutoGenerateResource";

    @Override
    protected Map _batchDelete(Context ctx, String[] ids) throws BOSException, EASBizException {
        int size = ids.length;
        int error = 0;
        BatchExecuteResult result = new BatchExecuteResult();
        ILetOfCreditAcctRecord iLetterOfCreditAcctRecord = LetOfCreditAcctRecordFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("billState"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("bill.letterNumber"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("isCommitToBe"));
        for (int i = 0; i < ids.length; ++i) {
            LetOfCreditAcctRecordInfo info = LetOfCreditAcctRecordFactory.getLocalInstance(ctx).getLetOfCreditAcctRecordInfo((IObjectPK)new ObjectUuidPK(ids[i].trim()), sic);
            try {
                this.verifyBeforeDelete(ctx, info);
                iLetterOfCreditAcctRecord.delete((IObjectPK)new ObjectUuidPK(ids[i].trim()));
                continue;
            }
            catch (Exception e) {
                ++error;
                result.getDetailMsgList().add(EASResource.getString((String)RESOURCE, (String)"555_LetterOfCreditAcctRecordWeb", (Object[])new String[]{info.getBill().getLetterNumber(), info.getAmount().toString(), e.getMessage()}));
            }
        }
        result.setError(error);
        if (size == 1 && error == size) {
            result.setSummaryMsg((String)result.getDetailMsgList().get(0));
        } else {
            result.setSummaryMsg(new LetterOfCreditApplyException(LetterOfCreditApplyException.DELETESUMMARYMSG_16, (Object[])new String[]{new Integer(size).toString(), new Integer(size - error).toString(), new Integer(error).toString()}).getMessage());
        }
        return result;
    }

    @Override
    protected Map _batchAudit(Context ctx, String[] ids) throws BOSException, EASBizException {
        int size = ids.length;
        int error = 0;
        BatchExecuteResult result = new BatchExecuteResult();
        ILetOfCreditAcctRecord iLetterOfCreditAcctRecord = LetOfCreditAcctRecordFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("amount");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("bill.letterNumber");
        for (int i = 0; i < ids.length; ++i) {
            LetOfCreditAcctRecordInfo info = LetOfCreditAcctRecordFactory.getLocalInstance(ctx).getLetOfCreditAcctRecordInfo((IObjectPK)new ObjectUuidPK(ids[i].trim()), sic);
            try {
                this.verifyBeforeAudit(ctx, info);
                iLetterOfCreditAcctRecord.audit((IObjectPK)new ObjectUuidPK(ids[i]));
                continue;
            }
            catch (Exception e) {
                ++error;
                result.getDetailMsgList().add(EASResource.getString((String)RESOURCE, (String)"556_LetterOfCreditAcctRecordWeb", (Object[])new String[]{info.getBill().getLetterNumber(), info.getAmount().toString(), e.getMessage()}));
            }
        }
        result.setError(error);
        if (size == 1 && error == size) {
            result.setSummaryMsg((String)result.getDetailMsgList().get(0));
        } else {
            result.setSummaryMsg(new LetterOfCreditApplyException(LetterOfCreditApplyException.AUDITSUMMARYMSG_17, (Object[])new String[]{new Integer(size).toString(), new Integer(size - error).toString(), new Integer(error).toString()}).getMessage());
        }
        return result;
    }

    @Override
    protected Map _batchUnAudit(Context ctx, String[] ids) throws BOSException, EASBizException {
        int size = ids.length;
        int error = 0;
        BatchExecuteResult result = new BatchExecuteResult();
        ILetOfCreditAcctRecord iLetterOfCreditAcctRecord = LetOfCreditAcctRecordFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("amount");
        sic.add("bill.letterNumber");
        sic.add("isCommitToBe");
        sic.add("bankReturnStatus");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("isCommitToBe");
        sic.add("state");
        for (int i = 0; i < ids.length; ++i) {
            LetOfCreditAcctRecordInfo info = LetOfCreditAcctRecordFactory.getLocalInstance(ctx).getLetOfCreditAcctRecordInfo((IObjectPK)new ObjectUuidPK(ids[i].trim()), sic);
            try {
                this.verifyBeforeUnAudit(ctx, info);
                iLetterOfCreditAcctRecord.antiAudit((IObjectPK)new ObjectUuidPK(ids[i]));
                continue;
            }
            catch (Exception e) {
                ++error;
                result.getDetailMsgList().add(EASResource.getString((String)RESOURCE, (String)"557_LetterOfCreditAcctRecordWeb", (Object[])new String[]{info.getBill().getLetterNumber(), info.getAmount().toString(), e.getMessage()}));
            }
        }
        result.setError(error);
        if (size == 1 && error == size) {
            result.setSummaryMsg((String)result.getDetailMsgList().get(0));
        } else {
            result.setSummaryMsg(new LetterOfCreditApplyException(LetterOfCreditApplyException.UNAUDITSUMMARYMSG_18, (Object[])new String[]{new Integer(size).toString(), new Integer(size - error).toString(), new Integer(error).toString()}).getMessage());
        }
        return result;
    }

    @Override
    @Deprecated
    protected Map _beforeSubmit(Context ctx, LetOfCreditAcctRecordInfo info) throws BOSException {
        BatchExecuteResult result = new BatchExecuteResult();
        try {
            this.verifyBeforeSubmit(ctx, info);
            result.setError(0);
            result.setSummaryMsg("");
        }
        catch (Exception e) {
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }

    @Override
    protected Map _submit(Context ctx, LetOfCreditAcctRecordInfo info) throws BOSException {
        BatchExecuteResult result = new BatchExecuteResult();
        try {
            if (FMHelper.isEmpty((String)info.getNumber())) {
                String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
                info.setNumber(numberSilent);
            }
            this.verifyBeforeSubmit(ctx, info);
            if (!info.getBillState().equals((Object)LetterOfCreditAcctRecStatusEnum.AUDITED)) {
                info.setBillState(LetterOfCreditAcctRecStatusEnum.SUBMITED);
            }
            IObjectPK pk = LetOfCreditAcctRecordFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
            String errorMsg = EASResource.getString((String)RESOURCE, (String)"564_LetterOfCreditAcctRecordWeb");
            result.setSummaryMsg(errorMsg);
            result.setError(0);
            result.put((Object)"id", (Object)pk.toString());
        }
        catch (Exception e) {
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }

    @Override
    protected Map _commitToBe(Context ctx, String[] ids) throws BOSException {
        BatchExecuteResult result = (BatchExecuteResult)LetOfCreditAcctRecordFactory.getLocalInstance(ctx).commitToBe(ids);
        return result;
    }

    @Override
    protected Map _synStatus(Context ctx, String[] ids) throws BOSException {
        BatchExecuteResult result = (BatchExecuteResult)LetOfCreditAcctRecordFactory.getLocalInstance(ctx).synStatus(ids);
        return result;
    }

    @Override
    protected LetOfCreditAcctRecordInfo _createNewModel(Context ctx, String billId) throws BOSException, EASBizException {
        LetterOfCreditReachInfo reachInfo = LetterOfCreditReachFactory.getLocalInstance((Context)ctx).getLetterOfCreditReachInfo((IObjectPK)new ObjectUuidPK(billId), this.getReachSelector());
        LetOfCreditAcctRecordInfo acctRecordInfo = new LetOfCreditAcctRecordInfo();
        acctRecordInfo.setCompany(reachInfo.getCredit().getCompany());
        acctRecordInfo.setBill(reachInfo.getCredit());
        acctRecordInfo.setReachId(billId);
        int seq = LetOfCreditAcctRecordFactory.getLocalInstance(ctx).getMaxSeqByID((IObjectPK)new ObjectUuidPK(reachInfo.getCredit().getId().toString()));
        acctRecordInfo.setSeq(seq + 1);
        acctRecordInfo.setCurrency(reachInfo.getCredit().getCurrency());
        acctRecordInfo.setIsCommitToBe(false);
        return acctRecordInfo;
    }

    @Override
    protected Map _pay(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        try {
            this.verifyBeforePay(ctx, id);
            result.setError(0);
            result.setSummaryMsg(EASResource.getString((String)RESOURCE, (String)"579_PayPermVerify_Success"));
        }
        catch (Exception e) {
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }

    private void verifyBeforeSubmit(Context ctx, LetOfCreditAcctRecordInfo info) throws Exception {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_LetOfCreditAcctRecord_unaudit");
        if (!isPermission) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"575_LetterOfCreditAcctRecordWeb", (Object[])new Object[]{info.getCompany().getName()}));
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        SelectorItemCollection sicLC = new SelectorItemCollection();
        sicLC.add(new SelectorItemInfo("letterNumber"));
        sicLC.add(new SelectorItemInfo("IssueDate"));
        sicLC.add(new SelectorItemInfo("IsDYZ"));
        sicLC.add(new SelectorItemInfo("Balance"));
        LetterOfCreditInfo lcInfo = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(info.getBill().getId()), sicLC);
        boolean isFromCredit = true;
        if (!EmptyUtil.isEmpty((String)info.getReachId())) {
            isFromCredit = false;
        }
        if (info.getNumber() == null) {
            String errorMsg = EASResource.getString((String)RESOURCE, (String)"563_LetterOfCreditAcctRecordWeb");
            throw new Exception(errorMsg);
        }
        if (info.getPayDate().compareTo(info.getBizDate()) < 0) {
            String errorMsg = EASResource.getString((String)RESOURCE, (String)"214_LetOfCreditAcctRecordEditUI");
            throw new Exception(errorMsg);
        }
        if (!lcInfo.isIsDYZ() && info.getAmount().compareTo(lcInfo.getBalance()) > 0) {
            String errorMsg = EASResource.getString((String)RESOURCE, (String)"215_LetOfCreditAcctRecordEditUI");
            throw new Exception(errorMsg);
        }
        if (!isFromCredit) {
            SelectorItemCollection sicReach = new SelectorItemCollection();
            sicReach.add("Amount");
            sicReach.add("ReachDate");
            LetterOfCreditReachInfo reachInfo = LetterOfCreditReachFactory.getLocalInstance((Context)ctx).getLetterOfCreditReachInfo((IObjectPK)new ObjectUuidPK(info.getReachId().toString()), sicReach);
            if (!lcInfo.isIsDYZ() && info.getAmount().compareTo(reachInfo.getAmount()) > 0) {
                String errorMsg = EASResource.getString((String)RESOURCE, (String)"216_LetOfCreditAcctRecordEditUI");
                throw new Exception(errorMsg);
            }
        }
    }

    private void verifyBeforeUnAudit(Context ctx, LetOfCreditAcctRecordInfo info) throws EASBizException, BOSException {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_LetOfCreditAcctRecord_unaudit");
        if (!isPermission) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"561_LetterOfCreditAcctRecordWeb", (Object[])new Object[]{info.getCompany().getName()}));
        }
        if (FMBooleanEnum.Yes.equals((Object)info.getState())) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"604_LetterOfCreditAcctRecordWeb"));
        }
        if (info.isIsCommitToBe() && !"COMMIT_FAIL".equals(info.getBankReturnStatus())) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"562_LetterOfCreditAcctRecordWeb"));
        }
    }

    private void verifyBeforeAudit(Context ctx, LetOfCreditAcctRecordInfo info) throws EASBizException, BOSException {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_LetOfCreditAcctRecord_audit");
        if (!isPermission) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"560_LetterOfCreditAcctRecordWeb", (Object[])new Object[]{info.getCompany().getName()}));
        }
    }

    private void verifyBeforeDelete(Context ctx, LetOfCreditAcctRecordInfo info) throws EASBizException, BOSException {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_LetOfCreditAcctRecord_delete");
        if (!isPermission) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"574_LetterOfCreditAcctRecordWeb", (Object[])new Object[]{info.getCompany().getName()}));
        }
        if (LetterOfCreditAcctRecStatusEnum.AUDITED.equals((Object)info.getBillState())) {
            String errorMsg = EASResource.getString((String)RESOURCE, (String)"355_ModifyLetterListUI");
            throw new BOSException(errorMsg);
        }
        if (info.isIsCommitToBe()) {
            String errorMsg = EASResource.getString((String)RESOURCE, (String)"558_LetterOfCreditAcctRecordWeb");
            throw new BOSException(errorMsg);
        }
    }

    private void verifyBeforePay(Context ctx, String id) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("number"));
        LetOfCreditAcctRecordInfo info = LetOfCreditAcctRecordFactory.getLocalInstance(ctx).getLetOfCreditAcctRecordInfo((IObjectPK)new ObjectUuidPK(id), sic);
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_Repayment_addnew");
        if (!isPermission) {
            throw new LetterOfCreditApplyException(LetterOfCreditApplyException.NO_PAY_PERMISSION_35, (Object[])new String[]{info.getCompany().getName()});
        }
    }

    private SelectorItemCollection getReachSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("number");
        sic.add("id");
        sic.add("billState");
        sic.add("Credit.id");
        sic.add("Credit.number");
        sic.add("Credit.letterNumber");
        sic.add("Credit.company.id");
        sic.add("Credit.company.name");
        sic.add("Credit.IssueDate");
        sic.add("Credit.Currency");
        sic.add("Credit.Balance");
        sic.add("Credit.Amount");
        sic.add("Credit.ntType.name");
        sic.add("Credit.isDirect");
        sic.add("Credit.LetterStatus");
        sic.add("Credit.Currency.id");
        sic.add("Credit.Currency.name");
        sic.add("Credit.Currency.number");
        return sic;
    }

    @Override
    protected Map _edit(Context ctx, String acctRecordId) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("company.id"));
            sic.add(new SelectorItemInfo("company.name"));
            LetOfCreditAcctRecordInfo info = LetOfCreditAcctRecordFactory.getLocalInstance(ctx).getLetOfCreditAcctRecordInfo((IObjectPK)new ObjectUuidPK(acctRecordId), sic);
            boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"fin_LetOfCreditAcctRecord_edit");
            if (!isPermission) {
                throw new BOSException(EASResource.getString((String)RESOURCE, (String)"581_NoAcctRecordEditPermission", (Object[])new Object[]{info.getCompany().getName()}));
            }
            result.setError(0);
            result.setSummaryMsg(EASResource.getString((String)RESOURCE, (String)"582_AcctRecordPermVerifyPassed"));
        }
        catch (Exception e) {
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }

    @Override
    protected Map _modifyBankReturnStatus(Context ctx, String id, int status) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("bankReturnStatus"));
        sic.add(new SelectorItemInfo("reachId"));
        LetOfCreditAcctRecordInfo info = LetOfCreditAcctRecordFactory.getLocalInstance(ctx).getLetOfCreditAcctRecordInfo((IObjectPK)new ObjectUuidPK(id), sic);
        try {
            if (!BankReturnStatusEnum.BANK_EXCEPTION.equals((Object)info.getBankReturnStatus())) {
                throw new LetterException(LetterException.CANTMODIFYBANKRETURNSTATUS_080);
            }
            info.setBankReturnStatus(BankReturnStatusEnum.getEnum((int)status));
            if (status == 3) {
                sic.add(new SelectorItemInfo("billState"));
                info.setBillState(LetterOfCreditAcctRecStatusEnum.ACCEPTED);
                if (info.getReachId() != null) {
                    SelectorItemCollection sicReach = new SelectorItemCollection();
                    sicReach.add(new SelectorItemInfo("IsAccept"));
                    LetterOfCreditReachInfo LCRInfo = LetterOfCreditReachFactory.getLocalInstance((Context)ctx).getLetterOfCreditReachInfo((IObjectPK)new ObjectUuidPK(info.getReachId()));
                    LCRInfo.setIsAccept(true);
                    LetterOfCreditReachFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)LCRInfo, sicReach);
                }
            }
            LetOfCreditAcctRecordFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
            result.setError(0);
            result.setSummaryMsg(EASResource.getString((String)"com.kingdee.eas.fm.fin.LetterOfCreditWebResource", (String)"StatusUpdateSuccess_103"));
        }
        catch (Exception e) {
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
        }
        return result;
    }
}

